/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.translator;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.transform.IrTransformStage;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.ir.cfg.IrCfg;
import com.intellij.rml.dfa.utils.RMLOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/rml/dfa/impl/translator/CfgConsistencyCheckStage;", "Lcom/intellij/rml/dfa/impl/transform/IrTransformStage;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "transform", "Lcom/intellij/rml/dfa/ir/ast/IrTopLevelDecl;", "decl", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "Companion", "intellij.rml.dfa.impl"})
public final class CfgConsistencyCheckStage
implements IrTransformStage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private static final Logger LOG;

    public CfgConsistencyCheckStage() {
        this.name = "CFG consistency check";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public IrTopLevelDecl transform(@NotNull IrTopLevelDecl decl, @NotNull RMLOptions options) {
        Intrinsics.checkNotNullParameter((Object)decl, (String)"decl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!(decl instanceof IrFunctionDecl)) {
            return decl;
        }
        IrCfg cfg2 = ((IrFunctionDecl)decl).getBody();
        for (IrCFGBlock block : cfg2.getBlocks()) {
            if (Intrinsics.areEqual((Object)block, (Object)cfg2.getExitBlock()) || cfg2.getJumps().get(block) != null) continue;
            throw new DfaInternalException("All control flow graph nodes except exit node must have jumps " + ((IrFunctionDecl)decl).getName() + " at " + ((IrFunctionDecl)decl).getLocation());
        }
        return decl;
    }

    static {
        Logger logger = Logger.getInstance((String)CfgConsistencyCheckStage.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/rml/dfa/impl/translator/CfgConsistencyCheckStage$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rml.dfa.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

