/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.settings;

import com.intellij.codeWithMe.ClientId;
import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.configurationStore.XmlSerializerKt;
import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.settings.RemoteSettingInfo;
import com.intellij.ide.settings.SettingsComponentDescriptor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.platform.settings.JsonElementSettingSerializerDescriptor;
import com.intellij.platform.settings.PersistenceStateComponentPropertyTag;
import com.intellij.platform.settings.SettingDescriptor;
import com.intellij.platform.settings.SettingSerializerDescriptor;
import com.intellij.platform.settings.SettingTag;
import com.intellij.serialization.xml.UnifiedImplKt;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.BeanBindingKt;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.JsonDomKt;
import com.intellij.util.xmlb.NestedBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.jetbrains.rd.platform.codeWithMe.settings.LocalXMLValueTag;
import com.jetbrains.rd.platform.codeWithMe.settings.RdInitialSettingsSynchronizer;
import com.jetbrains.rd.platform.codeWithMe.settings.RdInitialSettingsSynchronizerKt;
import com.jetbrains.rd.platform.codeWithMe.settings.RdSettingsStorageService;
import com.jetbrains.rd.platform.codeWithMe.settings.SettingsLogsUtils;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001.B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ,\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J<\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00012\b\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J*\u0010 \u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J>\u0010!\u001a\u00020\u00052\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002J\u001c\u0010&\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010#H\u0002J \u0010(\u001a\u00020)2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u001fH\u0002J&\u0010*\u001a\u0004\u0018\u00010\u0018\"\b\b\u0000\u0010+*\u00020\u0001*\b\u0012\u0004\u0012\u0002H+0,2\u0006\u0010-\u001a\u00020\u001fH\u0002\u00a8\u0006/"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/settings/RdInitialSettingsSynchronizer;", "", "<init>", "()V", "sendInitialSettings", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "settingsService", "Lcom/jetbrains/rd/platform/codeWithMe/settings/RdSettingsStorageService;", "sendInitialSettings$intellij_platform_split", "checkSettingsClass", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "settingsClass", "Ljava/lang/Class;", "stateSpec", "Lcom/intellij/openapi/components/State;", "sendSettingsForComponent", "descriptor", "Lcom/intellij/ide/settings/SettingsComponentDescriptor;", "loadSerializedState", "Lorg/jdom/Element;", "sendSerializedBeanBinding", "rootBinding", "Lcom/intellij/util/xmlb/BeanBinding;", "initialState", "serializedState", "pluginId", "", "sendSerializedElement", "sendInitialValueToModel", "rawJsonElement", "Lkotlinx/serialization/json/JsonElement;", "settingKey", "stateClass", "fixInitialValue", "value", "shouldSendInitialValue", "", "getSerializedState", "T", "Lcom/intellij/configurationStore/StateStorageBase;", "componentName", "IgnorePerClientCheck", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nRdInitialSettingsSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdInitialSettingsSynchronizer.kt\ncom/jetbrains/rd/platform/codeWithMe/settings/RdInitialSettingsSynchronizer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,297:1\n67#2,4:298\n67#2,4:302\n67#2,4:307\n1#3:306\n6624#4:311\n296#5,2:312\n*S KotlinDebug\n*F\n+ 1 RdInitialSettingsSynchronizer.kt\ncom/jetbrains/rd/platform/codeWithMe/settings/RdInitialSettingsSynchronizer\n*L\n93#1:298,4\n119#1:302,4\n137#1:307,4\n178#1:311\n179#1:312,2\n*E\n"})
public final class RdInitialSettingsSynchronizer {
    @NotNull
    public static final RdInitialSettingsSynchronizer INSTANCE = new RdInitialSettingsSynchronizer();

    private RdInitialSettingsSynchronizer() {
    }

    public final void sendInitialSettings$intellij_platform_split(@NotNull Lifetime lifetime, @NotNull ComponentManager componentManager, @NotNull RdSettingsStorageService settingsService) {
        ExtensionPointName extensionPointName;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        Intrinsics.checkNotNullParameter((Object)((Object)settingsService), (String)"settingsService");
        ComponentManager componentManager2 = componentManager;
        if (componentManager2 instanceof Project) {
            extensionPointName = SettingsComponentDescriptor.Companion.getPROJECT_EP_NAME();
        } else if (componentManager2 instanceof Application) {
            extensionPointName = SettingsComponentDescriptor.Companion.getAPPLICATION_EP_NAME();
        } else {
            RdInitialSettingsSynchronizerKt.access$getLogger$p().error("Unsupported component manager type: " + componentManager.getClass().getName());
            return;
        }
        ExtensionPointName epName = extensionPointName;
        ExtensionPoint point = componentManager.getExtensionArea().getExtensionPoint(epName);
        point.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<SettingsComponentDescriptor>(componentManager, settingsService){
            final /* synthetic */ ComponentManager $componentManager;
            final /* synthetic */ RdSettingsStorageService $settingsService;
            {
                this.$componentManager = $componentManager;
                this.$settingsService = $settingsService;
            }

            /*
             * WARNING - void declaration
             */
            public void extensionAdded(SettingsComponentDescriptor extension, PluginDescriptor pluginDescriptor) {
                Object object;
                void $this$runAndLogException$iv;
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                Logger logger = RdInitialSettingsSynchronizerKt.access$getLogger$p();
                ComponentManager componentManager = this.$componentManager;
                RdSettingsStorageService rdSettingsStorageService = this.$settingsService;
                boolean $i$f$runAndLogException = false;
                void var7_7 = $this$runAndLogException$iv;
                try {
                    void $this$runAndLogException_u24lambda_u240$iv = var7_7;
                    boolean bl = false;
                    boolean bl2 = false;
                    ClientId.Companion.withExplicitClientId(ClientId.Companion.getLocalId(), () -> sendInitialSettings.1.extensionAdded$lambda$0$0(componentManager, rdSettingsStorageService, extension));
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
            }

            private static final Unit extensionAdded$lambda$0$0(ComponentManager $componentManager, RdSettingsStorageService $settingsService, SettingsComponentDescriptor $extension) {
                RdInitialSettingsSynchronizer.access$sendSettingsForComponent(RdInitialSettingsSynchronizer.INSTANCE, $componentManager, $settingsService, $extension);
                return Unit.INSTANCE;
            }
        }, true, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
    }

    private final void checkSettingsClass(ComponentManager componentManager, PluginDescriptor pluginDescriptor, Class<?> settingsClass, State stateSpec) {
        Object v1;
        block17: {
            ContainerDescriptor containerDescriptor;
            String noStateLoadedName = "noStateLoaded";
            try {
                settingsClass.getDeclaredMethod(noStateLoadedName, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                RdInitialSettingsSynchronizerKt.access$getLogger$p().error("Settings class " + settingsClass.getName() + " does not override " + noStateLoadedName + " method,synchronization may work incorrectly");
            }
            if (!(pluginDescriptor instanceof IdeaPluginDescriptorImpl)) {
                if (stateSpec.perClient()) {
                    if (pluginDescriptor instanceof IgnorePerClientCheck) {
                        return;
                    }
                    RdInitialSettingsSynchronizerKt.access$getLogger$p().error("Plugin descriptor for " + settingsClass.getName() + " is not a IdeaPluginDescriptorImpl, can't check if " + settingsClass.getName() + " is registered as a per-client service. Descriptor class: " + pluginDescriptor.getClass().getName());
                } else {
                    Logger $this$trace$iv = RdInitialSettingsSynchronizerKt.access$getLogger$p();
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        Logger logger = $this$trace$iv;
                        boolean bl = false;
                        logger.trace("Plugin descriptor for " + settingsClass.getName() + " is not a IdeaPluginDescriptorImpl, skipping the settings service check. Descriptor class: " + pluginDescriptor.getClass().getName());
                    }
                }
                return;
            }
            ComponentManager $i$f$trace = componentManager;
            if ($i$f$trace instanceof Project) {
                containerDescriptor = ((IdeaPluginDescriptorImpl)pluginDescriptor).getProjectContainerDescriptor();
            } else if ($i$f$trace instanceof Application) {
                containerDescriptor = ((IdeaPluginDescriptorImpl)pluginDescriptor).getAppContainerDescriptor();
            } else {
                RdInitialSettingsSynchronizerKt.access$getLogger$p().error("Unsupported component manager type: " + componentManager.getClass().getName());
                return;
            }
            ContainerDescriptor container = containerDescriptor;
            Iterable iterable = container.services;
            for (Object t : iterable) {
                ServiceDescriptor it = (ServiceDescriptor)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.serviceImplementation, (Object)settingsClass.getName()) || Intrinsics.areEqual((Object)it.serviceInterface, (Object)settingsClass.getName()))) continue;
                v1 = t;
                break block17;
            }
            v1 = null;
        }
        ServiceDescriptor serviceDescriptor = v1;
        if (serviceDescriptor == null) {
            if (stateSpec.perClient()) {
                RdInitialSettingsSynchronizerKt.access$getLogger$p().error("Settings class " + settingsClass.getName() + " is marked as per-client (@State(perClient = true)), but not registered as a service in the XML file. It must be declared as a per-clientservice (client=\"all\")");
            } else {
                Logger $this$trace$iv = RdInitialSettingsSynchronizerKt.access$getLogger$p();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Failed to find service descriptor for " + settingsClass.getName() + ", maybe it is marked with @Service");
                }
            }
            return;
        }
        if (stateSpec.perClient() && serviceDescriptor.client != ClientKind.ALL) {
            RdInitialSettingsSynchronizerKt.access$getLogger$p().error("Settings service " + settingsClass.getName() + " is marked as per-client (@State(perClient = true)), but not registered as a per-client service (client=\"all\")");
        }
    }

    private final void sendSettingsForComponent(ComponentManager componentManager, RdSettingsStorageService settingsService, SettingsComponentDescriptor descriptor) {
        if (!ClientId.Companion.isCurrentlyUnderLocalId()) {
            boolean $i$a$-check-RdInitialSettingsSynchronizer$sendSettingsForComponent$22 = false;
            String $i$a$-check-RdInitialSettingsSynchronizer$sendSettingsForComponent$22 = "Sending initial settings values must be called under local clientId";
            throw new IllegalStateException($i$a$-check-RdInitialSettingsSynchronizer$sendSettingsForComponent$22.toString());
        }
        Logger $this$trace$iv = RdInitialSettingsSynchronizerKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Processing settings for " + descriptor.getImplementationClass() + " for " + componentManager.getClass().getSimpleName());
        }
        Class clazz = componentManager.loadClass(descriptor.getImplementationClass(), descriptor.getPluginDescriptor());
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"loadClass(...)");
        Class settingsClass = clazz;
        State stateSpec = StoreUtilKt.getStateSpecOrError((Class)settingsClass);
        this.checkSettingsClass(componentManager, descriptor.getPluginDescriptor(), settingsClass, stateSpec);
        String pluginId = descriptor.getPluginDescriptor().getPluginId().getIdString();
        Class clazz2 = ComponentSerializationUtil.getStateClass((Class)settingsClass);
        Intrinsics.checkNotNullExpressionValue((Object)clazz2, (String)"getStateClass(...)");
        Class stateClass = clazz2;
        PersistentStateComponent service = (PersistentStateComponent)componentManager.getServiceIfCreated(settingsClass);
        Object state = null;
        Element serializedState = null;
        if (service != null) {
            SettingsLogsUtils.INSTANCE.traceForKey$intellij_platform_split(RdInitialSettingsSynchronizerKt.access$getLogger$p(), stateSpec.name(), (Function0<String>)((Function0)() -> RdInitialSettingsSynchronizer.sendSettingsForComponent$lambda$2(stateSpec, settingsClass)));
            state = service.getState();
            serializedState = null;
        } else {
            SettingsLogsUtils.INSTANCE.traceForKey$intellij_platform_split(RdInitialSettingsSynchronizerKt.access$getLogger$p(), stateSpec.name(), (Function0<String>)((Function0)() -> RdInitialSettingsSynchronizer.sendSettingsForComponent$lambda$3(stateSpec)));
            serializedState = this.loadSerializedState(componentManager, stateSpec);
            state = null;
        }
        if (Intrinsics.areEqual((Object)stateClass, Element.class)) {
            Element element = (Element)state;
            if (element == null) {
                element = serializedState;
            }
            Element element2 = element;
            this.sendSerializedElement(stateSpec, settingsService, element2, pluginId);
            return;
        }
        Binding rootBinding = XmlSerializerKt.__platformSerializer().getRootBinding(stateClass);
        if (rootBinding instanceof BeanBinding) {
            this.sendSerializedBeanBinding((BeanBinding)rootBinding, stateSpec, settingsService, state, serializedState, pluginId);
        } else {
            RdInitialSettingsSynchronizerKt.access$getLogger$p().error("Unsupported binding type for settings class " + settingsClass.getName() + ": " + rootBinding.getClass().getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Element loadSerializedState(ComponentManager componentManager, State stateSpec) {
        Object v0;
        StateStorageManager storageManager;
        block3: {
            void $this$firstOrNull$iv;
            Iterable $this$sortedBy$iv;
            storageManager = IComponentStoreKt.getStateStore((ComponentManager)componentManager).getStorageManager();
            Storage[] storageArray = stateSpec.storages();
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Storage it = (Storage)a;
                    boolean bl = false;
                    Comparable comparable = Boolean.valueOf(it.deprecated());
                    it = (Storage)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(it.deprecated()));
                }
            });
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Storage it = (Storage)element$iv;
                boolean bl = false;
                if (!it.roamingType().isRoamable()) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Storage storage = v0;
        if (storage == null) {
            RdInitialSettingsSynchronizerKt.access$getLogger$p().error("Failed to choose a storage for " + stateSpec.name() + " settings component");
            return null;
        }
        StateStorage stateStorage = storageManager.getStateStorage(storage);
        if (!(stateStorage instanceof StateStorageBase)) {
            RdInitialSettingsSynchronizerKt.access$getLogger$p().error("Failed to get serialized state for " + stateSpec.name() + ", expected StateStorageBase, found " + stateStorage.getClass().getName());
            return null;
        }
        return this.getSerializedState((StateStorageBase)stateStorage, stateSpec.name());
    }

    private final void sendSerializedBeanBinding(BeanBinding rootBinding, State stateSpec, RdSettingsStorageService settingsService, Object initialState, Element serializedState, String pluginId) {
        Object object = initialState;
        if (object == null) {
            object = rootBinding.newInstance();
        }
        Object state = object;
        SkipDefaultsSerializationFilter filter = XmlSerializer.getJdomSerializer().getDefaultSerializationFilter();
        Intrinsics.checkNotNull((Object)rootBinding.bindings);
        for (NestedBinding binding : rootBinding.bindings) {
            String optionName = binding.getPropertyName();
            String settingKey = UnifiedImplKt.createSettingKey((String)stateSpec.name(), (String)optionName);
            if (!this.shouldSendInitialValue(settingsService, stateSpec, settingKey)) continue;
            if (serializedState != null) {
                Element it;
                boolean bl = false;
                BeanBindingKt.deserializeNestedBindingInto((Object)state, (Element)it, (NestedBinding)binding);
            }
            boolean isPropertySkipped = BeanBindingKt.isPropertySkipped((SerializationFilter)((SerializationFilter)filter), (NestedBinding)binding, (BeanBinding)rootBinding, (Object)state, (boolean)true);
            JsonElement jsonElement = isPropertySkipped ? null : binding.toJson(state, null);
            this.sendInitialValueToModel(jsonElement, settingKey, pluginId, settingsService, stateSpec, state.getClass());
        }
    }

    private final void sendSerializedElement(State stateSpec, RdSettingsStorageService settingsService, Element serializedState, String pluginId) {
        JsonObject jsonObject;
        if (!this.shouldSendInitialValue(settingsService, stateSpec, stateSpec.name())) {
            return;
        }
        Element element = serializedState;
        if (element != null) {
            Element it = element;
            boolean bl = false;
            jsonObject = JsonDomKt.jdomToJson((Element)it);
        } else {
            jsonObject = null;
        }
        JsonObject jsonElement = jsonObject;
        this.sendInitialValueToModel((JsonElement)jsonElement, stateSpec.name(), pluginId, settingsService, stateSpec, Element.class);
    }

    private final void sendInitialValueToModel(JsonElement rawJsonElement, String settingKey, String pluginId, RdSettingsStorageService settingsService, State stateSpec, Class<?> stateClass) {
        JsonElement jsonElement = this.fixInitialValue(settingKey, rawJsonElement);
        SettingsLogsUtils.INSTANCE.traceForKey$intellij_platform_split(RdInitialSettingsSynchronizerKt.access$getLogger$p(), settingKey, (Function0<String>)((Function0)() -> RdInitialSettingsSynchronizer.sendInitialValueToModel$lambda$0(settingKey, jsonElement)));
        Object[] objectArray = new SettingTag[]{LocalXMLValueTag.INSTANCE, new PersistenceStateComponentPropertyTag(stateSpec.name(), stateClass)};
        SettingDescriptor settingDescriptor = new SettingDescriptor(settingKey, PluginId.Companion.getId(pluginId), (Collection)CollectionsKt.listOf((Object[])objectArray), (SettingSerializerDescriptor)JsonElementSettingSerializerDescriptor.INSTANCE);
        settingsService.setItem(settingDescriptor, jsonElement);
    }

    private final JsonElement fixInitialValue(String settingKey, JsonElement value) {
        JsonElement fixedValue;
        if (Intrinsics.areEqual((Object)settingKey, (Object)"CodeInsightSettings") && value instanceof JsonObject) {
            Map valueMap = MapsKt.toMutableMap((Map)((Map)value));
            valueMap.put("name", JsonElementKt.JsonPrimitive((String)"state"));
            v0 = (JsonElement)new JsonObject(valueMap);
        } else {
            v0 = fixedValue = Intrinsics.areEqual((Object)settingKey, (Object)"CodeInsightSettings") && value == null ? (JsonElement)new JsonObject(MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)JsonElementKt.JsonPrimitive((String)"state")))) : value;
        }
        if (fixedValue != value) {
            SettingsLogsUtils.INSTANCE.traceForKey$intellij_platform_split(RdInitialSettingsSynchronizerKt.access$getLogger$p(), settingKey, (Function0<String>)((Function0)() -> RdInitialSettingsSynchronizer.fixInitialValue$lambda$0(value, fixedValue, settingKey)));
        }
        return fixedValue;
    }

    private final boolean shouldSendInitialValue(RdSettingsStorageService settingsService, State stateSpec, String settingKey) {
        boolean allowedInCwm;
        RemoteSettingInfo settingInfo = settingsService.getRemoteSetting(null, settingKey);
        if (!settingsService.shouldSendInitialValue$intellij_platform_split(settingInfo)) {
            SettingsLogsUtils.INSTANCE.traceForKey$intellij_platform_split(RdInitialSettingsSynchronizerKt.access$getLogger$p(), settingKey, (Function0<String>)((Function0)() -> RdInitialSettingsSynchronizer.shouldSendInitialValue$lambda$0(settingKey)));
            return false;
        }
        RemoteSettingInfo remoteSettingInfo = settingInfo;
        boolean bl = remoteSettingInfo != null ? remoteSettingInfo.getAllowedInCwm() : (allowedInCwm = false);
        if (allowedInCwm != stateSpec.perClient()) {
            RdInitialSettingsSynchronizerKt.access$getLogger$p().error("Setting " + settingKey + " is synchronized as " + (allowedInCwm ? "allowed" : "not allowed") + " in CWM,but marked with @State(perClient = " + stateSpec.perClient() + ")");
        }
        return true;
    }

    private final <T> Element getSerializedState(StateStorageBase<T> $this$getSerializedState, String componentName) {
        return $this$getSerializedState.getSerializedState($this$getSerializedState.getStorageData(), null, componentName, false);
    }

    private static final String sendSettingsForComponent$lambda$2(State $stateSpec, Class $settingsClass) {
        return "Getting state of " + $stateSpec.name() + " from a loaded service " + $settingsClass.getName();
    }

    private static final String sendSettingsForComponent$lambda$3(State $stateSpec) {
        return "Getting serialized state of " + $stateSpec.name() + " from a storage, service is not loaded yet";
    }

    private static final String sendInitialValueToModel$lambda$0(String $settingKey, JsonElement $jsonElement) {
        return "Set initial value for " + $settingKey + ": " + $jsonElement;
    }

    private static final String fixInitialValue$lambda$0(JsonElement $value, JsonElement $fixedValue, String $settingKey) {
        return "Fixed value: " + $value + " => " + $fixedValue + " for " + $settingKey;
    }

    private static final String shouldSendInitialValue$lambda$0(String $settingKey) {
        return "Skipping " + $settingKey + ", because we should not send the initial value for it";
    }

    public static final /* synthetic */ void access$sendSettingsForComponent(RdInitialSettingsSynchronizer $this, ComponentManager componentManager, RdSettingsStorageService settingsService, SettingsComponentDescriptor descriptor) {
        $this.sendSettingsForComponent(componentManager, settingsService, descriptor);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bg\u0018\u00002\u00020\u0001\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0002\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/settings/RdInitialSettingsSynchronizer$IgnorePerClientCheck;", "", "intellij.platform.split"})
    @TestOnly
    public static interface IgnorePerClientCheck {
    }
}

