/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.util;

import com.jetbrains.rd.platform.codeWithMe.util.ItemInfo;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001b\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0014\u001a\u00020\u0004J\u0014\u0010\u0019\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eJ\u0014\u0010\u001b\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eJ\u0006\u0010\u001c\u001a\u00020\u0012J\b\u0010\u001d\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u000bR*\u0010\f\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\rj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/util/SizeBoundedLRUCache;", "T", "", "maxCacheSize", "", "<init>", "(I)V", "linkedHashMap", "Lit/unimi/dsi/fastutil/objects/Object2ObjectLinkedOpenHashMap;", "Lcom/jetbrains/rd/platform/codeWithMe/util/ItemInfo;", "getLinkedHashMap$annotations", "()V", "listeners", "Ljava/util/LinkedHashSet;", "Lcom/jetbrains/rd/platform/codeWithMe/util/SizeBoundedLRUCache$Listener;", "Lkotlin/collections/LinkedHashSet;", "cacheSize", "putOrUpdate", "", "item", "size", "(Ljava/lang/Object;I)V", "contains", "", "(Ljava/lang/Object;)Z", "addListener", "listener", "removeListener", "forceClearCache", "shrinkIfNeeded", "Listener", "intellij.platform.split"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSizeBoundedLRUCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SizeBoundedLRUCache.kt\ncom/jetbrains/rd/platform/codeWithMe/util/SizeBoundedLRUCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1915#2,2:66\n1915#2,2:68\n*S KotlinDebug\n*F\n+ 1 SizeBoundedLRUCache.kt\ncom/jetbrains/rd/platform/codeWithMe/util/SizeBoundedLRUCache\n*L\n38#1:66,2\n57#1:68,2\n*E\n"})
public final class SizeBoundedLRUCache<T> {
    private final int maxCacheSize;
    @NotNull
    private final Object2ObjectLinkedOpenHashMap<T, ItemInfo<T>> linkedHashMap;
    @NotNull
    private final LinkedHashSet<Listener<T>> listeners;
    private int cacheSize;

    public SizeBoundedLRUCache(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        this.linkedHashMap = new Object2ObjectLinkedOpenHashMap();
        this.listeners = new LinkedHashSet();
    }

    private static /* synthetic */ void getLinkedHashMap$annotations() {
    }

    public final void putOrUpdate(T item, int size) {
        ItemInfo<T> info = new ItemInfo<T>(item, size);
        if (this.linkedHashMap.putAndMoveToFirst(item, info) == null) {
            this.cacheSize += size;
        }
        this.shrinkIfNeeded();
    }

    public final boolean contains(T item) {
        return ((Map)this.linkedHashMap).containsKey(item);
    }

    public final int size() {
        return this.linkedHashMap.size();
    }

    public final boolean addListener(@NotNull Listener<T> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        return this.listeners.add(listener);
    }

    public final boolean removeListener(@NotNull Listener<T> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        return this.listeners.remove(listener);
    }

    public final void forceClearCache() {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            Set set = this.linkedHashMap.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
            it.itemsWasRemoved(CollectionsKt.toList((Iterable)set));
        }
        this.cacheSize = 0;
        this.linkedHashMap.clear();
    }

    private final void shrinkIfNeeded() {
        if (this.cacheSize < this.maxCacheSize) {
            return;
        }
        List removedItems = new ArrayList();
        while (this.cacheSize > this.maxCacheSize && !((Map)this.linkedHashMap).isEmpty()) {
            ItemInfo itemInfo = (ItemInfo)this.linkedHashMap.removeLast();
            this.cacheSize -= itemInfo.size;
            removedItems.add(itemInfo.item);
        }
        if (!((Collection)removedItems).isEmpty()) {
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Listener it = (Listener)element$iv;
                boolean bl = false;
                it.itemsWasRemoved(removedItems);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/util/SizeBoundedLRUCache$Listener;", "T", "", "itemsWasRemoved", "", "items", "", "intellij.platform.split"})
    public static interface Listener<T> {
        public void itemsWasRemoved(@NotNull List<? extends T> var1);
    }
}

