/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.ui.VcsLogBookmark;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u001e\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/vcs/log/ui/VcsLogBookmarkProvider;", "Lcom/intellij/ide/bookmark/BookmarkProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getWeight", "", "getProject", "compare", "bookmark1", "Lcom/intellij/ide/bookmark/Bookmark;", "bookmark2", "createBookmark", "map", "", "", "context", "", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogBookmarkProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogBookmarkProvider.kt\ncom/intellij/vcs/log/ui/VcsLogBookmarkProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
public final class VcsLogBookmarkProvider
implements BookmarkProvider {
    @NotNull
    private final Project project;

    public VcsLogBookmarkProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public int getWeight() {
        return 100;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    public int compare(@NotNull Bookmark bookmark1, @NotNull Bookmark bookmark2) {
        Intrinsics.checkNotNullParameter((Object)bookmark1, (String)"bookmark1");
        Intrinsics.checkNotNullParameter((Object)bookmark2, (String)"bookmark2");
        VcsLogBookmark cfr_ignored_0 = (VcsLogBookmark)bookmark1;
        VcsLogBookmark cfr_ignored_1 = (VcsLogBookmark)bookmark2;
        int it = StringUtil.naturalCompare((String)((VcsLogBookmark)bookmark1).getRoot().getPath(), (String)((VcsLogBookmark)bookmark2).getRoot().getPath());
        boolean bl = false;
        if (it != 0) {
            return it;
        }
        it = StringUtil.naturalCompare((String)((VcsLogBookmark)bookmark1).getHash().asString(), (String)((VcsLogBookmark)bookmark2).getHash().asString());
        boolean bl2 = false;
        if (it != 0) {
            return it;
        }
        return 0;
    }

    @Nullable
    public Bookmark createBookmark(@NotNull Map<String, String> map) {
        String string;
        String root;
        block7: {
            block6: {
                String string2;
                block5: {
                    block4: {
                        Intrinsics.checkNotNullParameter(map, (String)"map");
                        string2 = map.get("root");
                        if (string2 == null) break block4;
                        String it = string2;
                        boolean bl = false;
                        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(it);
                        string2 = virtualFile;
                        if (virtualFile != null) break block5;
                    }
                    return null;
                }
                root = string2;
                string = map.get("hash");
                if (string == null) break block6;
                String it = string;
                boolean bl = false;
                Hash hash = HashImpl.build((String)it);
                string = hash;
                if (hash != null) break block7;
            }
            return null;
        }
        String hash = string;
        return new VcsLogBookmark(this, (VirtualFile)root, (Hash)hash);
    }

    @Nullable
    public Bookmark createBookmark(@Nullable Object context) {
        Bookmark bookmark;
        if (context instanceof CommitId) {
            VirtualFile virtualFile = ((CommitId)context).getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            Hash hash = ((CommitId)context).getHash();
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
            bookmark = new VcsLogBookmark(this, virtualFile, hash);
        } else {
            bookmark = null;
        }
        return bookmark;
    }
}

