/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.data.CommitDetailsGetter;
import com.intellij.vcs.log.data.MiniDetailsGetter;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.ui.table.VcsLogCommitSelectionUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.AbstractList;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\u001b\u001a\u00020\u001c2\u0014\u0010\u001d\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00190\u000f0\u001eH\u0016J\u001d\u0010\u001f\u001a\u000b0\u0006j\u0002`\u0007\u00a2\u0006\u0002\b 2\n\u0010!\u001a\u00060\u0006j\u0002`\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0011\u00a8\u0006$"}, d2={"Lcom/intellij/vcs/log/ui/table/CommitSelectionImpl;", "Lcom/intellij/vcs/log/VcsLogCommitSelection;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "visibleGraph", "Lcom/intellij/vcs/log/graph/VisibleGraph;", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "rows", "", "<init>", "(Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/graph/VisibleGraph;[I)V", "getRows", "()[I", "ids", "", "getIds", "()Ljava/util/List;", "commits", "Lcom/intellij/vcs/log/CommitId;", "getCommits", "cachedMetadata", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "getCachedMetadata", "cachedFullDetails", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "getCachedFullDetails", "requestFullDetails", "", "consumer", "Ljava/util/function/Consumer;", "getIdAtRow", "Lorg/jetbrains/annotations/NotNull;", "row", "Lcom/intellij/vcs/log/graph/VcsLogVisibleGraphIndex;", "Companion", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
public final class CommitSelectionImpl
implements VcsLogCommitSelection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsLogData logData;
    @NotNull
    private final VisibleGraph<Integer> visibleGraph;
    @NotNull
    private final int[] rows;

    public CommitSelectionImpl(@NotNull VcsLogData logData, @NotNull VisibleGraph<Integer> visibleGraph, @NotNull int[] rows) {
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter(visibleGraph, (String)"visibleGraph");
        Intrinsics.checkNotNullParameter((Object)rows, (String)"rows");
        this.logData = logData;
        this.visibleGraph = visibleGraph;
        this.rows = rows;
    }

    @NotNull
    public int[] getRows() {
        return this.rows;
    }

    @NotNull
    public List<Integer> getIds() {
        return CommitSelectionImpl.Companion.lazyMap(this.getRows(), (Function1)new Function1<Integer, Integer>((Object)this){

            public final Integer invoke(int p0) {
                return CommitSelectionImpl.access$getIdAtRow((CommitSelectionImpl)this.receiver, p0);
            }
        });
    }

    @NotNull
    public List<CommitId> getCommits() {
        return VcsLogCommitSelectionUtils.lazyMap(this, arg_0 -> CommitSelectionImpl._get_commits_$lambda$0(this, arg_0));
    }

    @NotNull
    public List<VcsCommitMetadata> getCachedMetadata() {
        return VcsLogCommitSelectionUtils.lazyMap(this, (Function1)new Function1<Integer, VcsCommitMetadata>((Object)this.logData.getMiniDetailsGetter()){

            public final VcsCommitMetadata invoke(int p0) {
                return ((MiniDetailsGetter)this.receiver).getCachedDataOrPlaceholder(p0);
            }
        });
    }

    @NotNull
    public List<VcsFullCommitDetails> getCachedFullDetails() {
        return VcsLogCommitSelectionUtils.lazyMap(this, (Function1)new Function1<Integer, VcsFullCommitDetails>((Object)this.logData.getCommitDetailsGetter()){

            public final VcsFullCommitDetails invoke(int p0) {
                return ((CommitDetailsGetter)this.receiver).getCachedDataOrPlaceholder(p0);
            }
        });
    }

    public void requestFullDetails(@NotNull java.util.function.Consumer<? super List<? extends VcsFullCommitDetails>> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.logData.getCommitDetailsGetter().loadCommitsData(this.getIds(), arg_0 -> CommitSelectionImpl.requestFullDetails$lambda$0((Function1)new Function1<Object, Unit>(consumer){

            public final void invoke(Object p0) {
                ((java.util.function.Consumer)this.receiver).accept(p0);
            }
        }, arg_0), (Consumer<? super Throwable>)((Consumer<Throwable>)((Consumer)arg_0 -> CommitSelectionImpl.requestFullDetails$lambda$2(CommitSelectionImpl::requestFullDetails$lambda$1, arg_0))), (ProgressIndicator)null);
    }

    private final int getIdAtRow(int row) {
        Object object = this.visibleGraph.getRowInfo(row).getCommit();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCommit(...)");
        return ((Number)object).intValue();
    }

    private static final CommitId _get_commits_$lambda$0(CommitSelectionImpl this$0, int id) {
        CommitId commitId = this$0.logData.getCommitId(id);
        Intrinsics.checkNotNull((Object)commitId);
        return commitId;
    }

    private static final void requestFullDetails$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit requestFullDetails$lambda$1(Throwable it) {
        return Unit.INSTANCE;
    }

    private static final void requestFullDetails$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ int access$getIdAtRow(CommitSelectionImpl $this, int row) {
        return $this.getIdAtRow(row);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u0006*\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\u0004\u0012\u0002H\u00060\tH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/log/ui/table/CommitSelectionImpl$Companion;", "", "<init>", "()V", "lazyMap", "", "T", "", "transform", "Lkotlin/Function1;", "", "Lcom/intellij/vcs/log/graph/VcsLogVisibleGraphIndex;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> List<T> lazyMap(int[] $this$lazyMap, Function1<? super Integer, ? extends T> transform) {
            return (List)new AbstractList<T>(transform, $this$lazyMap){
                final /* synthetic */ Function1<Integer, T> $transform;
                final /* synthetic */ int[] $this_lazyMap;
                {
                    this.$transform = $transform;
                    this.$this_lazyMap = $receiver;
                }

                public T get(int index) {
                    return (T)this.$transform.invoke((Object)this.$this_lazyMap[index]);
                }

                public int getSize() {
                    return this.$this_lazyMap.length;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

