/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cron;

import com.intellij.cron.CronDocumentationTarget;
import com.intellij.cron.CronProviderSettings;
import com.intellij.cron.InvalidCronExpression;
import com.intellij.lang.Language;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012H&J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H&J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/cron/CronExpressionProvider;", "", "settings", "Lcom/intellij/cron/CronProviderSettings;", "getSettings", "()Lcom/intellij/cron/CronProviderSettings;", "languages", "", "Lcom/intellij/lang/Language;", "getLanguages", "()Ljava/util/Collection;", "supportId", "", "getSupportId", "()Ljava/lang/String;", "isSuitableElement", "", "element", "Lcom/intellij/psi/PsiElement;", "isCronLanguageInjection", "getCronExpression", "getCronExplanation", "cronExpr", "cronCompletionExamples", "", "createDocumentationTarget", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "intellij.cron"})
public interface CronExpressionProvider {
    @NotNull
    default public CronProviderSettings getSettings() {
        return new CronProviderSettings.Default(false, false, false, false, 15, null);
    }

    @NotNull
    public Collection<Language> getLanguages();

    @NotNull
    public String getSupportId();

    public boolean isSuitableElement(@NotNull PsiElement var1);

    default public boolean isCronLanguageInjection(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return true;
    }

    @Nullable
    public String getCronExpression(@NotNull PsiElement var1);

    @Nullable
    public String getCronExplanation(@NotNull String var1, @Nullable PsiElement var2) throws InvalidCronExpression;

    @NotNull
    default public List<String> cronCompletionExamples(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return CollectionsKt.emptyList();
    }

    @Nullable
    default public DocumentationTarget createDocumentationTarget(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return new CronDocumentationTarget(element, this);
    }
}

