/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.ui;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.database.dialects.mssql.localdb.LocalDb;
import com.intellij.database.dialects.mssql.localdb.LocalDbExecOption;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class LocalDbParamEditor
extends ParamEditorBase<ComboBox<LocalDb.LocalDbInstance>> {
    private String myText;
    private volatile boolean myUpdating;

    public LocalDbParamEditor(@NlsContexts.Label @NotNull String label, @NotNull DataInterchange interchange) {
        if (label == null) {
            LocalDbParamEditor.$$$reportNull$$$0(0);
        }
        if (interchange == null) {
            LocalDbParamEditor.$$$reportNull$$$0(1);
        }
        super((JComponent)new ComboBox(), interchange, FieldSize.LARGE, label, new AnAction[0]);
        interchange.addPersistentProperty("LOCAL_DB_INSTANCE");
        ((ComboBox)this.getEditorComponent()).addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            LocalDb.LocalDbInstance inst = (LocalDb.LocalDbInstance)ObjectUtils.tryCast((Object)e.getItem(), LocalDb.LocalDbInstance.class);
            if (inst != null) {
                this.setInstance(inst);
                this.getInterchange().putProperty("LOCAL_DB_INSTANCE", StringUtil.nullize((String)inst.instance));
            }
            this.fireChanged();
        });
        this.getInterchange().addPropertyChangeListener("LOCAL_DB_INSTANCE", evt -> {
            String newVal = StringUtil.notNullize((String)((String)evt.getNewValue()));
            ((ComboBox)this.getEditorComponent()).setSelectedItem(LocalDb.byInstance(newVal));
        }, (Disposable)this);
        PopupHandler.installPopupMenu((JComponent)this.getEditorComponent(), (ActionGroup)new DefaultActionGroup(new AnAction[]{new DumbAwareAction(CommonBundle.message((String)"action.refresh", (Object[])new Object[0]), null, AllIcons.Actions.Refresh){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                LocalDbParamEditor.this.updateInstances();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dialects/mssql/ui/LocalDbParamEditor$1", "actionPerformed"));
            }
        }}), (String)ActionPlaces.getPopupPlace((String)"LOCAL_DB_INSTANCE"));
        this.myText = "";
        ComponentUtil.putClientProperty((JComponent)this.getEditorComponent(), (Key)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
        ((ComboBox)this.getEditorComponent()).setRenderer((ListCellRenderer)new ColoredListCellRenderer<LocalDb.LocalDbInstance>(){
            {
                this.setIconTextGap(0);
                this.setIpad((Insets)JBInsets.emptyInsets());
            }

            protected void customizeCellRenderer(@NotNull JList list, LocalDb.LocalDbInstance value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (index == -1 && LocalDbParamEditor.this.myUpdating) {
                    this.setIcon((Icon)AnimatedIcon.Default.INSTANCE);
                }
                if (value == null) {
                    return;
                }
                this.append(value.instance);
                if (!value.running) {
                    this.append(" (stopped)", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/dialects/mssql/ui/LocalDbParamEditor$2", "customizeCellRenderer"));
            }
        });
        UiNotifyConnector.installOn((Component)this.getEditorComponent(), (Activatable)new Activatable(){

            public void showNotify() {
                LocalDbParamEditor.this.updateInstances();
            }
        });
    }

    private void updateInstances() {
        if (this.myUpdating) {
            return;
        }
        new Task.Backgroundable(this.getInterchange().getProject(), DatabaseBundle.message((String)"progress.title.fetching.localdb.instances", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (LocalDbParamEditor.this.myUpdating) {
                    return;
                }
                LocalDbParamEditor.this.myUpdating = true;
                try {
                    Collection<LocalDb.LocalDbInstance> instances = LocalDb.getInstances(StringUtil.notNullize((String)LocalDbExecOption.getLocalDbExecutable(LocalDbParamEditor.this.getInterchange().getDataSource())), indicator);
                    ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> LocalDbParamEditor.this.setInstances(instances));
                }
                catch (ExecutionException e1) {
                    DbImplUtilCore.invokeLaterIfNeeded(() -> LocalDbParamEditor.this.getInterchange().showError(DatabaseBundle.message((String)"LocalDbParamEditor.failed.to.update.localdb.instances.0", (Object[])new Object[]{e1.getMessage()}), (Object)"localdb"));
                }
                finally {
                    LocalDbParamEditor.this.myUpdating = false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dialects/mssql/ui/LocalDbParamEditor$4", "run"));
            }
        }.queue();
    }

    private void setInstances(@NotNull Collection<LocalDb.LocalDbInstance> instances) {
        if (instances == null) {
            LocalDbParamEditor.$$$reportNull$$$0(2);
        }
        ((ComboBox)this.getEditorComponent()).setModel(new DefaultComboBoxModel<LocalDb.LocalDbInstance>(instances.toArray(new LocalDb.LocalDbInstance[0])));
        LocalDb.LocalDbInstance instance = (LocalDb.LocalDbInstance)ContainerUtil.find(instances, LocalDb.byInstance(this.getInterchange().getProperty("LOCAL_DB_INSTANCE")));
        ((ComboBox)this.getEditorComponent()).setSelectedItem((Object)instance);
    }

    protected abstract void setInstance(LocalDb.LocalDbInstance var1);

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            LocalDbParamEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setText(@NotNull String text) {
        if (text == null) {
            LocalDbParamEditor.$$$reportNull$$$0(4);
        }
        this.myText = text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instances";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/ui/LocalDbParamEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/ui/LocalDbParamEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setInstances";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

