/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptConsumer;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskKt;
import com.intellij.database.util.Version;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010)\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006H\u00c6\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010+\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010,\u001a\u00020\rH\u00c6\u0003J\t\u0010-\u001a\u00020\u000fH\u00c6\u0003J\u000f\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011H\u00c6\u0003Jm\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0012\b\u0002\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011H\u00c6\u0001J\u0014\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u000103H\u00d6\u0083\u0004J\n\u00104\u001a\u000205H\u00d6\u0081\u0004J\n\u00106\u001a\u000207H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u001b\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u00068"}, d2={"Lcom/intellij/database/script/generator/ScriptingAlterTask;", "Lcom/intellij/database/script/generator/ScriptingTask;", "sourceModel", "Lcom/intellij/database/model/basic/BasicModel;", "targetModel", "correspondence", "", "Lcom/intellij/database/model/ElementDelta;", "currentDatabase", "Lcom/intellij/database/model/basic/BasicDatabase;", "currentSchema", "Lcom/intellij/database/model/basic/BasicSchema;", "options", "Lcom/intellij/database/script/generator/ScriptingOptions;", "version", "Lcom/intellij/database/util/Version;", "consumer", "Lcom/intellij/database/script/generator/ScriptConsumer;", "<init>", "(Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/database/model/basic/BasicModel;Ljava/util/Collection;Lcom/intellij/database/model/basic/BasicDatabase;Lcom/intellij/database/model/basic/BasicSchema;Lcom/intellij/database/script/generator/ScriptingOptions;Lcom/intellij/database/util/Version;Lcom/intellij/database/script/generator/ScriptConsumer;)V", "getSourceModel", "()Lcom/intellij/database/model/basic/BasicModel;", "getTargetModel", "getCorrespondence", "()Ljava/util/Collection;", "getCurrentDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "getCurrentSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "getOptions", "()Lcom/intellij/database/script/generator/ScriptingOptions;", "getVersion", "()Lcom/intellij/database/util/Version;", "getConsumer", "()Lcom/intellij/database/script/generator/ScriptConsumer;", "category", "Lcom/intellij/database/script/generator/ScriptCategory;", "getCategory", "()Lcom/intellij/database/script/generator/ScriptCategory;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.database.core.impl"})
public final class ScriptingAlterTask
extends ScriptingTask {
    @NotNull
    private final BasicModel sourceModel;
    @NotNull
    private final BasicModel targetModel;
    @NotNull
    private final Collection<ElementDelta<?>> correspondence;
    @Nullable
    private final BasicDatabase currentDatabase;
    @Nullable
    private final BasicSchema currentSchema;
    @NotNull
    private final ScriptingOptions options;
    @NotNull
    private final Version version;
    @Nullable
    private final ScriptConsumer<?> consumer;
    @NotNull
    private final ScriptCategory category;

    public ScriptingAlterTask(@NotNull BasicModel sourceModel, @NotNull BasicModel targetModel, @NotNull Collection<? extends ElementDelta<?>> correspondence, @Nullable BasicDatabase currentDatabase, @Nullable BasicSchema currentSchema, @NotNull ScriptingOptions options, @NotNull Version version, @Nullable ScriptConsumer<?> consumer) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)sourceModel, (String)"sourceModel");
        Intrinsics.checkNotNullParameter((Object)targetModel, (String)"targetModel");
        Intrinsics.checkNotNullParameter(correspondence, (String)"correspondence");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        super(null);
        this.sourceModel = sourceModel;
        this.targetModel = targetModel;
        this.correspondence = correspondence;
        this.currentDatabase = currentDatabase;
        this.currentSchema = currentSchema;
        this.options = options;
        this.version = version;
        this.consumer = consumer;
        this.category = ScriptCategory.ALTER;
        boolean bl2 = bl = this.getCurrentDatabase() == null || this.sourceModel.contains(this.getCurrentDatabase());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = this.getCurrentSchema() == null || this.sourceModel.contains(this.getCurrentSchema()) && Intrinsics.areEqual((Object)this.getCurrentSchema().getDatabase(), (Object)this.getCurrentDatabase());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public /* synthetic */ ScriptingAlterTask(BasicModel basicModel, BasicModel basicModel2, Collection collection, BasicDatabase basicDatabase, BasicSchema basicSchema, ScriptingOptions scriptingOptions, Version version, ScriptConsumer scriptConsumer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            basicDatabase = basicModel.getRoot().getCurrentDatabase();
        }
        if ((n & 0x10) != 0) {
            BasicDatabase basicDatabase2 = basicDatabase;
            BasicSchema basicSchema2 = basicSchema = basicDatabase2 != null ? ModelFun.getCurrentSchema(basicDatabase2) : null;
        }
        if ((n & 0x20) != 0) {
            scriptingOptions = ScriptingTaskKt.defaultScriptingOptions(basicModel2);
        }
        if ((n & 0x40) != 0) {
            Version version2 = basicModel.getRoot().getServerVersion();
            if (version2 == null) {
                Version version3 = Version.ZERO;
                version2 = version3;
                Intrinsics.checkNotNullExpressionValue((Object)version3, (String)"ZERO");
            }
            version = version2;
        }
        if ((n & 0x80) != 0) {
            scriptConsumer = null;
        }
        this(basicModel, basicModel2, collection, basicDatabase, basicSchema, scriptingOptions, version, scriptConsumer);
    }

    @NotNull
    public final BasicModel getSourceModel() {
        return this.sourceModel;
    }

    @NotNull
    public final BasicModel getTargetModel() {
        return this.targetModel;
    }

    @NotNull
    public final Collection<ElementDelta<?>> getCorrespondence() {
        return this.correspondence;
    }

    @Override
    @Nullable
    public BasicDatabase getCurrentDatabase() {
        return this.currentDatabase;
    }

    @Override
    @Nullable
    public BasicSchema getCurrentSchema() {
        return this.currentSchema;
    }

    @Override
    @NotNull
    public ScriptingOptions getOptions() {
        return this.options;
    }

    @Override
    @NotNull
    public Version getVersion() {
        return this.version;
    }

    @Override
    @Nullable
    public ScriptConsumer<?> getConsumer() {
        return this.consumer;
    }

    @Override
    @NotNull
    public ScriptCategory getCategory() {
        return this.category;
    }

    @NotNull
    public final BasicModel component1() {
        return this.sourceModel;
    }

    @NotNull
    public final BasicModel component2() {
        return this.targetModel;
    }

    @NotNull
    public final Collection<ElementDelta<?>> component3() {
        return this.correspondence;
    }

    @Nullable
    public final BasicDatabase component4() {
        return this.currentDatabase;
    }

    @Nullable
    public final BasicSchema component5() {
        return this.currentSchema;
    }

    @NotNull
    public final ScriptingOptions component6() {
        return this.options;
    }

    @NotNull
    public final Version component7() {
        return this.version;
    }

    @Nullable
    public final ScriptConsumer<?> component8() {
        return this.consumer;
    }

    @NotNull
    public final ScriptingAlterTask copy(@NotNull BasicModel sourceModel, @NotNull BasicModel targetModel, @NotNull Collection<? extends ElementDelta<?>> correspondence, @Nullable BasicDatabase currentDatabase, @Nullable BasicSchema currentSchema, @NotNull ScriptingOptions options, @NotNull Version version, @Nullable ScriptConsumer<?> consumer) {
        Intrinsics.checkNotNullParameter((Object)sourceModel, (String)"sourceModel");
        Intrinsics.checkNotNullParameter((Object)targetModel, (String)"targetModel");
        Intrinsics.checkNotNullParameter(correspondence, (String)"correspondence");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return new ScriptingAlterTask(sourceModel, targetModel, correspondence, currentDatabase, currentSchema, options, version, consumer);
    }

    public static /* synthetic */ ScriptingAlterTask copy$default(ScriptingAlterTask scriptingAlterTask, BasicModel basicModel, BasicModel basicModel2, Collection collection, BasicDatabase basicDatabase, BasicSchema basicSchema, ScriptingOptions scriptingOptions, Version version, ScriptConsumer scriptConsumer, int n, Object object) {
        if ((n & 1) != 0) {
            basicModel = scriptingAlterTask.sourceModel;
        }
        if ((n & 2) != 0) {
            basicModel2 = scriptingAlterTask.targetModel;
        }
        if ((n & 4) != 0) {
            collection = scriptingAlterTask.correspondence;
        }
        if ((n & 8) != 0) {
            basicDatabase = scriptingAlterTask.currentDatabase;
        }
        if ((n & 0x10) != 0) {
            basicSchema = scriptingAlterTask.currentSchema;
        }
        if ((n & 0x20) != 0) {
            scriptingOptions = scriptingAlterTask.options;
        }
        if ((n & 0x40) != 0) {
            version = scriptingAlterTask.version;
        }
        if ((n & 0x80) != 0) {
            scriptConsumer = scriptingAlterTask.consumer;
        }
        return scriptingAlterTask.copy(basicModel, basicModel2, collection, basicDatabase, basicSchema, scriptingOptions, version, scriptConsumer);
    }

    @NotNull
    public String toString() {
        return "ScriptingAlterTask(sourceModel=" + this.sourceModel + ", targetModel=" + this.targetModel + ", correspondence=" + this.correspondence + ", currentDatabase=" + this.currentDatabase + ", currentSchema=" + this.currentSchema + ", options=" + this.options + ", version=" + this.version + ", consumer=" + this.consumer + ")";
    }

    public int hashCode() {
        int result = this.sourceModel.hashCode();
        result = result * 31 + this.targetModel.hashCode();
        result = result * 31 + ((Object)this.correspondence).hashCode();
        result = result * 31 + (this.currentDatabase == null ? 0 : this.currentDatabase.hashCode());
        result = result * 31 + (this.currentSchema == null ? 0 : this.currentSchema.hashCode());
        result = result * 31 + this.options.hashCode();
        result = result * 31 + this.version.hashCode();
        result = result * 31 + (this.consumer == null ? 0 : this.consumer.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ScriptingAlterTask)) {
            return false;
        }
        ScriptingAlterTask scriptingAlterTask = (ScriptingAlterTask)other;
        if (!Intrinsics.areEqual((Object)this.sourceModel, (Object)scriptingAlterTask.sourceModel)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetModel, (Object)scriptingAlterTask.targetModel)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.correspondence, scriptingAlterTask.correspondence)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.currentDatabase, (Object)scriptingAlterTask.currentDatabase)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.currentSchema, (Object)scriptingAlterTask.currentSchema)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.options, (Object)scriptingAlterTask.options)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.version, (Object)scriptingAlterTask.version)) {
            return false;
        }
        return Intrinsics.areEqual(this.consumer, scriptingAlterTask.consumer);
    }
}

