/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.families.Family;
import com.intellij.database.util.common.NumberFun;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a%\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0016\u0010\u0002\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0003\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0004\u001a\u001b\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u0086\u0004\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\b\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\n\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\f\u001a\n\u0010\r\u001a\u00020\f*\u00020\u000e\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0014\"\u000e\u0010\u000f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"phrase", "", "words", "", "([Ljava/lang/String;)Ljava/lang/String;", "concatWithSpace", "that", "toOrderString", "", "orderString", "Lcom/intellij/database/model/ObjectKind;", "toFixedOrderString", "", "positionSafe", "Lcom/intellij/database/model/basic/BasicArrangedElement;", "__0__", "makeTriggerEventString", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "removeHeadingEmptyLines", "", "HeadingEmptyLinesPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "intellij.database.core.impl"})
public final class ScriptingUtilsKt {
    private static final short __0__ = 0;
    private static final Pattern HeadingEmptyLinesPattern = Pattern.compile("^(\\s*\\n)+", 32);

    @Nullable
    public static final String phrase(String ... words) {
        Intrinsics.checkNotNullParameter((Object)words, (String)"words");
        int n = words.length;
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return words[0];
        }
        StringBuilder b = new StringBuilder();
        for (String word : words) {
            if (word == null) continue;
            if (((CharSequence)b).length() > 0) {
                b.append(' ');
            }
            b.append(word);
        }
        return ((CharSequence)b).length() > 0 ? b.toString() : null;
    }

    @Nullable
    public static final String concatWithSpace(@Nullable String $this$concatWithSpace, @Nullable String that) {
        CharSequence charSequence = $this$concatWithSpace;
        boolean y1 = !(charSequence == null || charSequence.length() == 0);
        CharSequence charSequence2 = that;
        boolean y2 = !(charSequence2 == null || charSequence2.length() == 0);
        return y1 && y2 ? $this$concatWithSpace + " " + that : (y1 ? $this$concatWithSpace : (y2 ? that : null));
    }

    @NotNull
    public static final String toOrderString(long $this$toOrderString) {
        if ($this$toOrderString == 0L) {
            return "0";
        }
        if ($this$toOrderString > 0L) {
            char c2;
            String s = String.valueOf($this$toOrderString);
            int n = s.length();
            char c3 = c2 = (char)(65 + (n - 1));
            return c3 + s;
        }
        if ($this$toOrderString == Long.MIN_VALUE) {
            return "[NO_ID]";
        }
        if ($this$toOrderString < 0L) {
            long p = -$this$toOrderString;
            StringBuilder b = new StringBuilder(24);
            b.append(p);
            int n = b.length();
            int i2 = 0;
            int n2 = n - 1;
            if (i2 <= n2) {
                while (true) {
                    char d = b.charAt(i2);
                    char c4 = (char)(90 - (d - 48));
                    b.setCharAt(i2, c4);
                    if (i2 == n2) break;
                    ++i2;
                }
            }
            b.insert(0, '-');
            b.insert(1, (char)(90 - n));
            String string = b.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        return "";
    }

    @NotNull
    public static final String orderString(@NotNull ObjectKind $this$orderString) {
        Intrinsics.checkNotNullParameter((Object)$this$orderString, (String)"<this>");
        int order = $this$orderString.getOrder();
        boolean bl = 1 <= order ? order < 10000 : false;
        if (bl) {
            return NumberFun.toStringWithLeadingZeros((int)order, (int)4);
        }
        return "ZZZZ";
    }

    @NotNull
    public static final String toFixedOrderString(short $this$toFixedOrderString) {
        if ($this$toFixedOrderString < 0) {
            return "-X";
        }
        String s = String.valueOf($this$toFixedOrderString);
        String string = "00000".substring(s.length(), 5);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string + s;
    }

    public static final short positionSafe(@NotNull BasicArrangedElement $this$positionSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$positionSafe, (String)"<this>");
        if ($this$positionSafe.getPosition() != 0) {
            return $this$positionSafe.getPosition();
        }
        Family family = $this$positionSafe.getParentFamily();
        int idx = family != null ? family.indexOf($this$positionSafe) : -1;
        return idx == -1 ? $this$positionSafe.getPosition() : (short)idx;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final String makeTriggerEventString(@NotNull BasicTrigger trigger) {
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        table = trigger.getLikeTable();
        v0 = trigger.getTurn();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getTurn(...)");
        turn = v0;
        v1 = trigger.getEvents();
        Intrinsics.checkNotNullExpressionValue(v1, (String)"getEvents(...)");
        events = v1;
        onUpdate = events.contains(TrigEvent.UPDATE);
        v2 = table;
        tableColumnsCount = v2 != null && (v2 = v2.getColumns()) != null ? v2.size() : 0;
        v3 = trigger.getColNames();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getColNames(...)");
        specificColumns = v3;
        if (!onUpdate) ** GOTO lbl-1000
        var8_7 = tableColumnsCount - 1;
        var9_9 = specificColumns.size();
        v4 = 1 <= var9_9 ? var9_9 <= var8_7 : false;
        if (v4) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        explicitColumns = v5;
        switch (WhenMappings.$EnumSwitchMapping$0[turn.ordinal()]) {
            case 1: 
            case 2: {
                v6 = "before ";
                break;
            }
            case 3: 
            case 4: {
                v6 = "after ";
                break;
            }
            case 5: {
                v6 = "instead of ";
                break;
            }
            default: {
                v6 = ev = null;
            }
        }
        if (events.isEmpty()) {
            return (String)ev + "???";
        }
        var9_10 = new TrigEvent[]{TrigEvent.INSERT, TrigEvent.UPDATE, TrigEvent.DELETE, TrigEvent.TRUNCATE};
        ev = (String)ev + SequencesKt.joinToString$default((Sequence)SequencesKt.filter((Sequence)SequencesKt.sequenceOf((Object[])var9_10), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, makeTriggerEventString$lambda$0(java.util.Set com.intellij.database.model.TrigEvent ), (Lcom/intellij/database/model/TrigEvent;)Ljava/lang/Boolean;)(events)), (CharSequence)" or ", null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, makeTriggerEventString$lambda$1(boolean java.util.List com.intellij.database.model.TrigEvent ), (Lcom/intellij/database/model/TrigEvent;)Ljava/lang/CharSequence;)((boolean)explicitColumns, (List)specificColumns), (int)30, null);
        return ev;
    }

    @NotNull
    public static final CharSequence removeHeadingEmptyLines(@NotNull CharSequence $this$removeHeadingEmptyLines) {
        Intrinsics.checkNotNullParameter((Object)$this$removeHeadingEmptyLines, (String)"<this>");
        Matcher m = HeadingEmptyLinesPattern.matcher($this$removeHeadingEmptyLines);
        if (m.find()) {
            int emptyLength = m.group(0).length();
            return $this$removeHeadingEmptyLines.subSequence(emptyLength, $this$removeHeadingEmptyLines.length());
        }
        return $this$removeHeadingEmptyLines;
    }

    private static final boolean makeTriggerEventString$lambda$0(Set $events, TrigEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $events.contains(it);
    }

    private static final CharSequence makeTriggerEventString$lambda$1(boolean $explicitColumns, List $specificColumns, TrigEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringUtil.toLowerCase((String)it.name()) + (String)(it == TrigEvent.UPDATE && $explicitColumns ? " of " + CollectionsKt.joinToString$default((Iterable)$specificColumns, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) : "");
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrigTurn.values().length];
            try {
                nArray[TrigTurn.BEFORE_STMT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrigTurn.BEFORE_ROW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrigTurn.AFTER_STMT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrigTurn.AFTER_ROW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrigTurn.INSTEAD_OF.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

