/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.annotator;

import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import icons.MavenIcons;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.annotator.MavenDomGutterAnnotatorLogger;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencyManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProject;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0004\u001f !\"B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0015\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001e2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "annotate", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotateDependencyUsages", "dependency", "Lorg/jetbrains/idea/maven/dom/model/MavenDomDependency;", "annotateManagedDependency", "getManagingDependency", "annotateMavenDomPlugin", "plugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "annotateMavenDomPluginInManagement", "annotateMavenDomParent", "mavenDomParent", "Lorg/jetbrains/idea/maven/dom/model/MavenDomParent;", "annotateMavenDomProjectChildren", "model", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "isDependencyManagementSection", "", "generateTooltip", "", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "MyListCellRenderer", "DependencyConverter", "PluginConverter", "MavenProjectConverter", "intellij.maven"})
public final class MavenDomGutterAnnotator
implements Annotator,
DumbAware {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder2) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        if (psiElement instanceof XmlTag) {
            MavenDomGutterAnnotatorLogger.INSTANCE.log((Function0<String>)((Function0)() -> MavenDomGutterAnnotator.annotate$lambda$0(psiElement)));
            DomElement element = DomManager.getDomManager((Project)psiElement.getProject()).getDomElement((XmlTag)psiElement);
            if (element instanceof MavenDomDependency) {
                if (((MavenDomDependency)element).getParentOfType(MavenDomPlugin.class, true) != null) {
                    return;
                }
                if (this.isDependencyManagementSection((MavenDomDependency)element)) {
                    this.annotateDependencyUsages((MavenDomDependency)element, holder2);
                } else {
                    this.annotateManagedDependency((MavenDomDependency)element, holder2);
                }
            } else if (element instanceof MavenDomParent) {
                this.annotateMavenDomParent((MavenDomParent)element, holder2);
            } else if (element instanceof MavenDomProjectModel) {
                this.annotateMavenDomProjectChildren((MavenDomProjectModel)element, holder2);
            } else if (element instanceof MavenDomPlugin) {
                this.annotateMavenDomPlugin((MavenDomPlugin)element, holder2);
            }
        }
    }

    private final void annotateDependencyUsages(MavenDomDependency dependency, AnnotationHolder holder2) {
        XmlTag tag = dependency.getXmlTag();
        if (tag == null) {
            return;
        }
        Set<MavenDomDependency> set = MavenDomProjectProcessorUtils.searchDependencyUsages(dependency);
        Intrinsics.checkNotNullExpressionValue(set, (String)"searchDependencyUsages(...)");
        Set<MavenDomDependency> children = set;
        if (!((Collection)children).isEmpty()) {
            NavigationGutterIconBuilder navigationGutterIconBuilder = NavigationGutterIconBuilder.create((Icon)AllIcons.Gutter.OverridenMethod, DependencyConverter.Companion.getINSTANCE());
            Intrinsics.checkNotNullExpressionValue((Object)navigationGutterIconBuilder, (String)"create(...)");
            NavigationGutterIconBuilder iconBuilder = navigationGutterIconBuilder;
            iconBuilder.setTargets((Collection)children).setPopupTitle(MavenDomBundle.message("navigate.parent.dependency.title", new Object[0])).setCellRenderer(MavenDomGutterAnnotator::annotateDependencyUsages$lambda$0).setTooltipText(MavenDomBundle.message("overriding.dependency.title", new Object[0])).createGutterIcon(holder2, (PsiElement)dependency.getXmlTag());
        }
    }

    private final void annotateManagedDependency(MavenDomDependency dependency, AnnotationHolder holder2) {
        XmlTag tag = dependency.getXmlTag();
        if (tag == null) {
            return;
        }
        MavenDomDependency managingDependency = this.getManagingDependency(dependency);
        if (managingDependency != null) {
            NavigationGutterIconBuilder navigationGutterIconBuilder = NavigationGutterIconBuilder.create((Icon)AllIcons.Gutter.OverridingMethod, DependencyConverter.Companion.getINSTANCE());
            Intrinsics.checkNotNullExpressionValue((Object)navigationGutterIconBuilder, (String)"create(...)");
            NavigationGutterIconBuilder iconBuilder = navigationGutterIconBuilder;
            Object[] objectArray = new MavenDomDependency[]{managingDependency};
            iconBuilder.setTargets(objectArray).setTooltipText(this.generateTooltip(managingDependency)).createGutterIcon(holder2, (PsiElement)tag);
        }
    }

    private final MavenDomDependency getManagingDependency(MavenDomDependency dependency) {
        Project project = dependency.getManager().getProject();
        return MavenDomProjectProcessorUtils.searchManagingDependency(dependency, project);
    }

    private final void annotateMavenDomPlugin(MavenDomPlugin plugin, AnnotationHolder holder2) {
        XmlTag xmlTag = plugin.getArtifactId().getXmlTag();
        if (xmlTag == null) {
            return;
        }
        DomElement plugins = plugin.getParent();
        if (plugins == null) {
            return;
        }
        DomElement parent = plugins.getParent();
        if (parent instanceof MavenDomPluginManagement) {
            this.annotateMavenDomPluginInManagement(plugin, holder2);
            return;
        }
        MavenDomPlugin managingPlugin = MavenDomProjectProcessorUtils.searchManagingPlugin(plugin);
        if (managingPlugin != null) {
            NavigationGutterIconBuilder navigationGutterIconBuilder = NavigationGutterIconBuilder.create((Icon)AllIcons.Gutter.OverridingMethod, PluginConverter.Companion.getINSTANCE());
            Intrinsics.checkNotNullExpressionValue((Object)navigationGutterIconBuilder, (String)"create(...)");
            NavigationGutterIconBuilder iconBuilder = navigationGutterIconBuilder;
            iconBuilder.setTargets((Collection)CollectionsKt.listOf((Object)managingPlugin)).setTooltipText(MavenDomBundle.message("overriden.plugin.title", new Object[0])).createGutterIcon(holder2, (PsiElement)xmlTag);
        }
    }

    private final void annotateMavenDomPluginInManagement(MavenDomPlugin plugin, AnnotationHolder holder2) {
        XmlTag xmlTag = plugin.getArtifactId().getXmlTag();
        if (xmlTag == null) {
            return;
        }
        Collection<MavenDomPlugin> collection = MavenDomProjectProcessorUtils.searchManagedPluginUsages(plugin);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"searchManagedPluginUsages(...)");
        Collection<MavenDomPlugin> children = collection;
        if (!children.isEmpty()) {
            NavigationGutterIconBuilder navigationGutterIconBuilder = NavigationGutterIconBuilder.create((Icon)AllIcons.Gutter.OverridenMethod, PluginConverter.Companion.getINSTANCE());
            Intrinsics.checkNotNullExpressionValue((Object)navigationGutterIconBuilder, (String)"create(...)");
            NavigationGutterIconBuilder iconBuilder = navigationGutterIconBuilder;
            iconBuilder.setTargets(children).setPopupTitle(MavenDomBundle.message("navigate.parent.plugin.title", new Object[0])).setCellRenderer(MavenDomGutterAnnotator::annotateMavenDomPluginInManagement$lambda$0).setTooltipText(MavenDomBundle.message("overriding.plugin.title", new Object[0])).createGutterIcon(holder2, (PsiElement)xmlTag);
        }
    }

    private final void annotateMavenDomParent(MavenDomParent mavenDomParent, AnnotationHolder holder2) {
        MavenDomProjectModel parent = MavenDomProjectProcessorUtils.findParent(mavenDomParent, mavenDomParent.getManager().getProject());
        if (parent != null) {
            Object[] objectArray = new MavenDomProjectModel[]{parent};
            NavigationGutterIconBuilder.create((Icon)MavenIcons.ParentProject, MavenProjectConverter.Companion.getINSTANCE()).setTargets(objectArray).setTooltipText(MavenDomBundle.message("parent.pom.title", new Object[0])).createGutterIcon(holder2, (PsiElement)mavenDomParent.getXmlElement());
        }
    }

    private final void annotateMavenDomProjectChildren(MavenDomProjectModel model, AnnotationHolder holder2) {
        MavenProject mavenProject = MavenDomUtil.findProject(model);
        if (mavenProject != null) {
            Set<MavenDomProjectModel> set = MavenDomProjectProcessorUtils.getChildrenProjects(model);
            Intrinsics.checkNotNullExpressionValue(set, (String)"getChildrenProjects(...)");
            Set<MavenDomProjectModel> children = set;
            if (!((Collection)children).isEmpty()) {
                NavigationGutterIconBuilder.create((Icon)MavenIcons.ChildrenProjects, MavenProjectConverter.Companion.getINSTANCE()).setTargets((Collection)children).setCellRenderer(MavenDomGutterAnnotator::annotateMavenDomProjectChildren$lambda$0).setPopupTitle(MavenDomBundle.message("navigate.children.poms.title", new Object[0])).setTooltipText(MavenDomBundle.message("children.poms.title", new Object[0])).createGutterIcon(holder2, (PsiElement)model.getXmlElement());
            }
        }
    }

    private final boolean isDependencyManagementSection(MavenDomDependency dependency) {
        return dependency.getParentOfType(MavenDomDependencyManagement.class, false) != null;
    }

    private final String generateTooltip(MavenDomDependency dependency) {
        StringBuilder res = new StringBuilder();
        res.append("<dependency>\n");
        res.append("    <groupId>").append(dependency.getGroupId().getStringValue()).append("</groupId>\n");
        res.append("    <artifactId>").append(dependency.getArtifactId().getStringValue()).append("</artifactId>\n");
        if (dependency.getType().getXmlElement() != null) {
            res.append("    <type>").append(dependency.getType().getStringValue()).append("</type>\n");
        }
        if (dependency.getClassifier().getXmlElement() != null) {
            res.append("    <classifier>").append(dependency.getClassifier().getStringValue()).append("</classifier>\n");
        }
        if (dependency.getScope().getXmlElement() != null) {
            res.append("    <scope>").append(dependency.getScope().getStringValue()).append("</scope>\n");
        }
        if (dependency.getOptional().getXmlElement() != null) {
            res.append("    <optional>").append(dependency.getOptional().getStringValue()).append("</optional>\n");
        }
        if (dependency.getVersion().getXmlElement() != null) {
            res.append("    <version>").append(dependency.getVersion().getStringValue()).append("</version>\n");
        }
        res.append("</dependency>");
        String string = StringUtil.escapeXmlEntities((String)res.toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(...)");
        return StringsKt.replace$default((String)string, (String)" ", (String)"&nbsp;", (boolean)false, (int)4, null);
    }

    private static final String annotate$lambda$0(PsiElement $psiElement) {
        return "MavenDomGutterAnnotator.annotate " + ((XmlTag)$psiElement).getName();
    }

    private static final PsiElementListCellRenderer annotateDependencyUsages$lambda$0() {
        return new MyListCellRenderer();
    }

    private static final PsiElementListCellRenderer annotateMavenDomPluginInManagement$lambda$0() {
        return new MyListCellRenderer();
    }

    private static final PsiElementListCellRenderer annotateMavenDomProjectChildren$lambda$0() {
        return new MyListCellRenderer();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator$DependencyConverter;", "", "<init>", "()V", "Companion", "intellij.maven"})
    private static final class DependencyConverter {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final NotNullFunction<MavenDomDependency, Collection<PsiElement>> INSTANCE = DependencyConverter::INSTANCE$lambda$0;

        private static final Collection INSTANCE$lambda$0(MavenDomDependency pointer) {
            return ContainerUtil.createMaybeSingletonList((Object)pointer.getXmlTag());
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator$DependencyConverter$Companion;", "", "<init>", "()V", "INSTANCE", "Lcom/intellij/util/NotNullFunction;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomDependency;", "", "Lcom/intellij/psi/PsiElement;", "getINSTANCE", "()Lcom/intellij/util/NotNullFunction;", "intellij.maven"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final NotNullFunction<MavenDomDependency, Collection<PsiElement>> getINSTANCE() {
                return INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator$MavenProjectConverter;", "", "<init>", "()V", "Companion", "intellij.maven"})
    private static final class MavenProjectConverter {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final NotNullFunction<MavenDomProjectModel, Collection<PsiElement>> INSTANCE = MavenProjectConverter::INSTANCE$lambda$0;

        private static final Collection INSTANCE$lambda$0(MavenDomProjectModel pointer) {
            return ContainerUtil.createMaybeSingletonList((Object)pointer.getXmlTag());
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator$MavenProjectConverter$Companion;", "", "<init>", "()V", "INSTANCE", "Lcom/intellij/util/NotNullFunction;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "", "Lcom/intellij/psi/PsiElement;", "getINSTANCE", "()Lcom/intellij/util/NotNullFunction;", "intellij.maven"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final NotNullFunction<MavenDomProjectModel, Collection<PsiElement>> getINSTANCE() {
                return INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u0006H\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator$MyListCellRenderer;", "Lcom/intellij/ide/util/PsiElementListCellRenderer;", "Lcom/intellij/psi/xml/XmlTag;", "<init>", "()V", "getElementText", "", "tag", "getContainerText", "element", "name", "getIcon", "Ljavax/swing/Icon;", "Lcom/intellij/psi/PsiElement;", "intellij.maven"})
    private static final class MyListCellRenderer
    extends PsiElementListCellRenderer<XmlTag> {
        @Nullable
        public String getElementText(@Nullable XmlTag tag) {
            MavenDomProjectModel model;
            if (tag == null) {
                return null;
            }
            DomElement domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
            if (domElement != null && (model = (MavenDomProjectModel)domElement.getParentOfType(MavenDomProjectModel.class, false)) != null) {
                MavenProject mavenProject;
                MavenProject mavenProject2 = mavenProject = MavenDomUtil.findProject(model);
                if (mavenProject2 != null) {
                    return mavenProject2.getDisplayName();
                }
                String name = model.getName().getStringValue();
                CharSequence charSequence = name;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    return name;
                }
            }
            return tag.getContainingFile().getName();
        }

        @Nullable
        protected String getContainerText(@Nullable XmlTag element, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return null;
        }

        @NotNull
        protected Icon getIcon(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Icon icon = MavenIcons.MavenProject;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MavenProject");
            return icon;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator$PluginConverter;", "", "<init>", "()V", "Companion", "intellij.maven"})
    private static final class PluginConverter {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final NotNullFunction<MavenDomPlugin, Collection<PsiElement>> INSTANCE = PluginConverter::INSTANCE$lambda$0;

        private static final Collection INSTANCE$lambda$0(MavenDomPlugin pointer) {
            return ContainerUtil.createMaybeSingletonList((Object)pointer.getXmlTag());
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator$PluginConverter$Companion;", "", "<init>", "()V", "INSTANCE", "Lcom/intellij/util/NotNullFunction;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "", "Lcom/intellij/psi/PsiElement;", "getINSTANCE", "()Lcom/intellij/util/NotNullFunction;", "intellij.maven"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final NotNullFunction<MavenDomPlugin, Collection<PsiElement>> getINSTANCE() {
                return INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

