/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.structure;

import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import icons.MavenIcons;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.indices.MavenIndexUtils;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.navigator.structure.GroupNode;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.structure.MavenSimpleNode;
import org.jetbrains.idea.maven.navigator.structure.ProjectNode;
import org.jetbrains.idea.maven.navigator.structure.RepositoryNode;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenSettingsCache;
import org.jetbrains.idea.maven.server.MavenIndexUpdateState;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0014J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/maven/navigator/structure/RepositoriesNode;", "Lorg/jetbrains/idea/maven/navigator/structure/GroupNode;", "structure", "Lorg/jetbrains/idea/maven/navigator/structure/MavenProjectsStructure;", "parent", "Lorg/jetbrains/idea/maven/navigator/structure/ProjectNode;", "<init>", "(Lorg/jetbrains/idea/maven/navigator/structure/MavenProjectsStructure;Lorg/jetbrains/idea/maven/navigator/structure/ProjectNode;)V", "myRepositoryNodes", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lorg/jetbrains/idea/maven/navigator/structure/RepositoryNode;", "getName", "", "doGetChildren", "", "Lorg/jetbrains/idea/maven/navigator/structure/MavenSimpleNode;", "updateRepositories", "", "project", "Lcom/intellij/openapi/project/Project;", "updateStatus", "state", "Lorg/jetbrains/idea/maven/server/MavenIndexUpdateState;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nRepositoriesNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositoriesNode.kt\norg/jetbrains/idea/maven/navigator/structure/RepositoriesNode\n+ 2 util.kt\ncom/intellij/util/containers/UtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n264#2,4:49\n1661#3,3:53\n777#3:56\n873#3,2:57\n1915#3,2:59\n*S KotlinDebug\n*F\n+ 1 RepositoriesNode.kt\norg/jetbrains/idea/maven/navigator/structure/RepositoriesNode\n*L\n34#1:49,4\n34#1:53,3\n39#1:56\n39#1:57,2\n42#1:59,2\n*E\n"})
public final class RepositoriesNode
extends GroupNode {
    @NotNull
    private final CopyOnWriteArrayList<RepositoryNode> myRepositoryNodes;

    public RepositoriesNode(@NotNull MavenProjectsStructure structure, @NotNull ProjectNode parent) {
        Intrinsics.checkNotNullParameter((Object)((Object)structure), (String)"structure");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(structure, parent);
        this.myRepositoryNodes = new CopyOnWriteArrayList();
        this.getTemplatePresentation().setIcon(MavenIcons.MavenRepoFolder);
    }

    @NotNull
    public String getName() {
        String string = MavenProjectBundle.message("view.node.repositories", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    protected List<MavenSimpleNode> doGetChildren() {
        return this.myRepositoryNodes;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateRepositories(@NotNull Project project) {
        List list;
        void $this$mapSmart$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path local = MavenSettingsCache.Companion.getInstance(project).getEffectiveUserLocalRepo();
        List<MavenRemoteRepository> list2 = MavenIndexUtils.getRemoteRepositoriesNoResolve(project);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getRemoteRepositoriesNoResolve(...)");
        List<MavenRemoteRepository> remotes = list2;
        this.myRepositoryNodes.clear();
        this.myRepositoryNodes.add(new RepositoryNode(this.myMavenProjectsStructure, this, "local", ((Object)local.toAbsolutePath()).toString(), true));
        Collection collection = remotes;
        CopyOnWriteArrayList<RepositoryNode> copyOnWriteArrayList = this.myRepositoryNodes;
        boolean $i$f$mapSmart = false;
        int size$iv = $this$mapSmart$iv.size();
        switch (size$iv) {
            case 1: {
                MavenRemoteRepository it = (MavenRemoteRepository)CollectionsKt.first((Iterable)((Iterable)$this$mapSmart$iv));
                boolean bl = false;
                RepositoryNode repositoryNode = new RepositoryNode(this.myMavenProjectsStructure, this, it.getId(), it.getUrl(), false);
                list = (List)new SmartList((Object)repositoryNode);
                break;
            }
            case 0: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                void $this$mapTo$iv$iv;
                Iterable iterable = (Iterable)$this$mapSmart$iv;
                Collection destination$iv$iv = new ArrayList(size$iv);
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    MavenRemoteRepository bl = (MavenRemoteRepository)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean $i$a$-mapSmart-RepositoriesNode$updateRepositories$2 = false;
                    collection2.add(new RepositoryNode(this.myMavenProjectsStructure, this, it.getId(), it.getUrl(), false));
                }
                list = (List)destination$iv$iv;
            }
        }
        copyOnWriteArrayList.addAll(list);
        this.childrenChanged();
    }

    /*
     * WARNING - void declaration
     */
    public final void updateStatus(@NotNull MavenIndexUpdateState state) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Iterable $this$filter$iv = this.myRepositoryNodes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RepositoryNode it = (RepositoryNode)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)state.myUrl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nodesToUpdate = (List)destination$iv$iv;
        if (nodesToUpdate.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = nodesToUpdate;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RepositoryNode it = (RepositoryNode)element$iv;
            boolean bl = false;
            it.update();
        }
    }
}

