/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.EscapeSequenceTokenizer;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlIdentifierKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlStringLiteralEscaper;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SqlSpellcheckingStrategy
extends SpellcheckingStrategy
implements DumbAware {
    private static final Tokenizer DEFINITION_TOKENIZER = new MyDefinitionTokenizer();
    private static final Tokenizer STRING_TOKENIZER = new StringTokenizer();

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        IElementType nodeType;
        IElementType iElementType = nodeType = element instanceof LeafPsiElement ? ((LeafPsiElement)element).getElementType() : null;
        if (!this.useTextLevelSpellchecking() && nodeType == SqlTokens.SQL_STRING_TOKEN) {
            Tokenizer tokenizer = STRING_TOKENIZER;
            if (tokenizer == null) {
                SqlSpellcheckingStrategy.$$$reportNull$$$0(0);
            }
            return tokenizer;
        }
        if (nodeType == SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
            Tokenizer tokenizer = TEXT_TOKENIZER;
            if (tokenizer == null) {
                SqlSpellcheckingStrategy.$$$reportNull$$$0(1);
            }
            return tokenizer;
        }
        if (element instanceof SqlAsExpression) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                SqlSpellcheckingStrategy.$$$reportNull$$$0(2);
            }
            return tokenizer;
        }
        if (element instanceof PsiNameIdentifierOwner) {
            Tokenizer tokenizer = DEFINITION_TOKENIZER;
            if (tokenizer == null) {
                SqlSpellcheckingStrategy.$$$reportNull$$$0(3);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            SqlSpellcheckingStrategy.$$$reportNull$$$0(4);
        }
        return tokenizer;
    }

    public boolean useTextLevelSpellchecking() {
        return Registry.is((String)"spellchecker.grazie.enabled", (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlSpellcheckingStrategy", "getTokenizer"));
    }

    private static class MyDefinitionTokenizer
    extends Tokenizer<PsiNameIdentifierOwner> {
        private MyDefinitionTokenizer() {
        }

        public void tokenize(@NotNull PsiNameIdentifierOwner element, @NotNull TokenConsumer consumer) {
            if (element == null) {
                MyDefinitionTokenizer.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                MyDefinitionTokenizer.$$$reportNull$$$0(1);
            }
            for (PsiElement identifier : MyDefinitionTokenizer.tokenize(element)) {
                int start;
                String text;
                if (identifier == null) {
                    return;
                }
                if (identifier.getTextRange().isEmpty()) {
                    return;
                }
                int stop = text.length();
                for (start = StringUtil.startsWithIgnoreCase((String)(text = identifier.getText()), (String)"u&") ? 2 : 0; !(start >= stop || Character.isLetter(text.charAt(start)) && text.charAt(start) != '@'); ++start) {
                }
                while (stop > start && !Character.isLetter(text.charAt(stop - 1))) {
                    --stop;
                }
                if (stop <= start) continue;
                consumer.consumeToken(identifier, text, true, 0, TextRange.from((int)start, (int)(stop - start)), (Splitter)IdentifierSplitter.getInstance());
            }
        }

        @NotNull
        private static Collection<PsiElement> tokenize(@NotNull PsiNameIdentifierOwner element) {
            SqlLanguageDialectEx dialect;
            PsiElement nameIdentifier;
            if (element == null) {
                MyDefinitionTokenizer.$$$reportNull$$$0(2);
            }
            if ((nameIdentifier = element.getNameIdentifier()) instanceof SqlIdentifier) {
                List<PsiElement> list = Collections.singletonList(nameIdentifier);
                if (list == null) {
                    MyDefinitionTokenizer.$$$reportNull$$$0(3);
                }
                return list;
            }
            if (nameIdentifier instanceof SqlReferenceExpression && (dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)nameIdentifier)).isMultiIdReference((SqlReferenceExpression)nameIdentifier)) {
                List list = SqlImplUtil.sqlChildren((PsiElement)((SqlReferenceExpression)nameIdentifier).getIdentifier()).filter(e -> {
                    IElementType type = PsiUtilCore.getElementType((PsiElement)e);
                    return type == SqlTokens.SQL_IDENT || type instanceof SqlIdentifierKeywordTokenType;
                }).toList();
                if (list == null) {
                    MyDefinitionTokenizer.$$$reportNull$$$0(4);
                }
                return list;
            }
            Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)nameIdentifier, SqlIdentifier.class);
            if (collection == null) {
                MyDefinitionTokenizer.$$$reportNull$$$0(5);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/SqlSpellcheckingStrategy$MyDefinitionTokenizer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/SqlSpellcheckingStrategy$MyDefinitionTokenizer";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tokenize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "tokenize";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static class StringTokenizer
    extends EscapeSequenceTokenizer<SqlStringTokenElement> {
        private StringTokenizer() {
        }

        public void tokenize(@NotNull SqlStringTokenElement element, @NotNull TokenConsumer consumer) {
            if (element == null) {
                StringTokenizer.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                StringTokenizer.$$$reportNull$$$0(1);
            }
            if (InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectedPsiFiles(element.getParent()) != null) {
                return;
            }
            String text = element.getText();
            TextRange range = element.getRangeInElement();
            if (!text.contains("\\") || !SqlStringLiteralEscaper.supportsSlashEscapes((SqlStringTokenElement)element, (String)text)) {
                consumer.consumeToken((PsiElement)element, text, false, 0, range, (Splitter)PlainTextSplitter.getInstance());
            } else {
                String relevantText = range.substring(text);
                StringBuilder unescapedText = new StringBuilder();
                int[] offsets = new int[relevantText.length() + 1];
                CodeInsightUtilCore.parseStringCharacters((String)relevantText, (StringBuilder)unescapedText, (int[])offsets);
                StringTokenizer.processTextWithOffsets((PsiElement)element, (TokenConsumer)consumer, (StringBuilder)unescapedText, (int[])offsets, (int)range.getStartOffset());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/SqlSpellcheckingStrategy$StringTokenizer";
            objectArray[2] = "tokenize";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

