/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import java.util.Map;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000e\u000fB#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/textmate/language/preferences/TextMateTextAttributes;", "", "foreground", "", "background", "fontStyle", "Lorg/jetbrains/plugins/textmate/language/preferences/TextMateTextAttributes$FontStyle;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/textmate/language/preferences/TextMateTextAttributes$FontStyle;)V", "getForeground", "()Ljava/lang/String;", "getBackground", "getFontStyle", "()Lorg/jetbrains/plugins/textmate/language/preferences/TextMateTextAttributes$FontStyle;", "FontStyle", "Companion", "intellij.textmate.core"})
public final class TextMateTextAttributes {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String foreground;
    @Nullable
    private final String background;
    @NotNull
    private final FontStyle fontStyle;

    public TextMateTextAttributes(@Nullable String foreground, @Nullable String background, @NotNull FontStyle fontStyle) {
        Intrinsics.checkNotNullParameter((Object)((Object)fontStyle), (String)"fontStyle");
        this.foreground = foreground;
        this.background = background;
        this.fontStyle = fontStyle;
    }

    @Nullable
    public final String getForeground() {
        return this.foreground;
    }

    @Nullable
    public final String getBackground() {
        return this.background;
    }

    @NotNull
    public final FontStyle getFontStyle() {
        return this.fontStyle;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/textmate/language/preferences/TextMateTextAttributes$Companion;", "", "<init>", "()V", "fromPlist", "Lorg/jetbrains/plugins/textmate/language/preferences/TextMateTextAttributes;", "settingsPlist", "Lorg/jetbrains/plugins/textmate/plist/Plist;", "intellij.textmate.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final TextMateTextAttributes fromPlist(@NotNull Plist settingsPlist) {
            Intrinsics.checkNotNullParameter((Object)settingsPlist, (String)"settingsPlist");
            boolean empty = true;
            String foreground = null;
            String background = null;
            FontStyle fontStyle = FontStyle.PLAIN;
            for (Map.Entry<String, PListValue> entry : settingsPlist.entries()) {
                String propertyName = entry.getKey();
                String value = entry.getValue().getString();
                if (StringsKt.equals((String)"foreground", (String)propertyName, (boolean)true)) {
                    foreground = value;
                    empty = false;
                    continue;
                }
                if (StringsKt.equals((String)"fontStyle", (String)propertyName, (boolean)true)) {
                    if (StringsKt.equals((String)"italic", (String)value, (boolean)true)) {
                        fontStyle = FontStyle.ITALIC;
                        empty = false;
                        continue;
                    }
                    if (StringsKt.equals((String)"bold", (String)value, (boolean)true)) {
                        fontStyle = FontStyle.BOLD;
                        empty = false;
                        continue;
                    }
                    if (StringsKt.equals((String)"underline", (String)value, (boolean)true)) {
                        fontStyle = FontStyle.UNDERLINE;
                        empty = false;
                        continue;
                    }
                    fontStyle = FontStyle.PLAIN;
                    empty = false;
                    continue;
                }
                if (!StringsKt.equals((String)"background", (String)propertyName, (boolean)true)) continue;
                background = value;
                empty = false;
            }
            return empty ? null : new TextMateTextAttributes(foreground, background, fontStyle);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/textmate/language/preferences/TextMateTextAttributes$FontStyle;", "", "<init>", "(Ljava/lang/String;I)V", "PLAIN", "ITALIC", "BOLD", "UNDERLINE", "intellij.textmate.core"})
    public static final class FontStyle
    extends Enum<FontStyle> {
        public static final /* enum */ FontStyle PLAIN = new FontStyle();
        public static final /* enum */ FontStyle ITALIC = new FontStyle();
        public static final /* enum */ FontStyle BOLD = new FontStyle();
        public static final /* enum */ FontStyle UNDERLINE = new FontStyle();
        private static final /* synthetic */ FontStyle[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FontStyle[] values() {
            return (FontStyle[])$VALUES.clone();
        }

        public static FontStyle valueOf(String value) {
            return Enum.valueOf(FontStyle.class, value);
        }

        @NotNull
        public static EnumEntries<FontStyle> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fontStyleArray = new FontStyle[]{FontStyle.PLAIN, FontStyle.ITALIC, FontStyle.BOLD, FontStyle.UNDERLINE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

