/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.fix;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.WaitContainerCmd;
import com.github.dockerjava.api.model.WaitResponse;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.MediaType;
import com.github.dockerjava.core.WebTarget;
import com.github.dockerjava.core.exec.AbstrAsyncDockerCmdExec;
import com.github.dockerjava.core.exec.WaitContainerCmdExec;
import com.intellij.docker.agent.WaitContainerCondition;
import com.intellij.docker.agent.fix.HackedWaitContainerCmdExecKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001\u0010B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/agent/fix/HackedWaitContainerCmdExec;", "Lcom/github/dockerjava/core/exec/AbstrAsyncDockerCmdExec;", "Lcom/github/dockerjava/api/command/WaitContainerCmd;", "Lcom/github/dockerjava/api/model/WaitResponse;", "Lcom/github/dockerjava/api/command/WaitContainerCmd$Exec;", "baseResource", "Lcom/github/dockerjava/core/WebTarget;", "dockerClientConfig", "Lcom/github/dockerjava/core/DockerClientConfig;", "<init>", "(Lcom/github/dockerjava/core/WebTarget;Lcom/github/dockerjava/core/DockerClientConfig;)V", "execute0", "Ljava/lang/Void;", "command", "resultCallback", "Lcom/github/dockerjava/api/async/ResultCallback;", "Companion", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nHackedWaitContainerCmdExec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HackedWaitContainerCmdExec.kt\ncom/intellij/docker/agent/fix/HackedWaitContainerCmdExec\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
public final class HackedWaitContainerCmdExec
extends AbstrAsyncDockerCmdExec<WaitContainerCmd, WaitResponse>
implements WaitContainerCmd.Exec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final Logger DOCKER_JAVA_LOGGER;

    public HackedWaitContainerCmdExec(@NotNull WebTarget baseResource, @NotNull DockerClientConfig dockerClientConfig) {
        Intrinsics.checkNotNullParameter((Object)baseResource, (String)"baseResource");
        Intrinsics.checkNotNullParameter((Object)dockerClientConfig, (String)"dockerClientConfig");
        super(baseResource, dockerClientConfig);
    }

    @Nullable
    protected Void execute0(@NotNull WaitContainerCmd command, @NotNull ResultCallback<WaitResponse> resultCallback) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(resultCallback, (String)"resultCallback");
        String containerIdWithOptionalCondition = command.getContainerId();
        if (containerIdWithOptionalCondition == null) {
            boolean bl = false;
            String string = "containerId must be specified";
            throw new IllegalArgumentException(string.toString());
        }
        Pair pair = HackedWaitContainerCmdExecKt.access$decodeContainerIdWithOptionalCondition(containerIdWithOptionalCondition);
        String containerId = (String)pair.component1();
        WaitContainerCondition condition = (WaitContainerCondition)((Object)pair.component2());
        String[] stringArray = new String[]{"/containers/{id}/wait"};
        WebTarget webTarget = this.getBaseResource().path(stringArray).resolveTemplate("id", (Object)containerId);
        if (condition != null) {
            webTarget = webTarget.queryParam("condition", (Object)HackedWaitContainerCmdExecKt.access$toParamValue(condition));
        }
        HackedWaitContainerCmdExec.Companion.trace("POST: {}", webTarget);
        webTarget.request().accept(MediaType.APPLICATION_JSON).post(null, (TypeReference)new TypeReference<WaitResponse>(){}, resultCallback);
        return null;
    }

    static {
        Logger logger = LoggerFactory.getLogger(HackedWaitContainerCmdExec.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        Logger logger2 = LoggerFactory.getLogger(WaitContainerCmdExec.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        DOCKER_JAVA_LOGGER = logger2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/agent/fix/HackedWaitContainerCmdExec$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/slf4j/Logger;", "DOCKER_JAVA_LOGGER", "trace", "", "format", "", "arg", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        private final void trace(String format, Object arg) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(format, arg);
            } else if (DOCKER_JAVA_LOGGER.isTraceEnabled()) {
                LOGGER.info(format, arg);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

