/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/docker/remote/run/target/MovingFileVisitor;", "Ljava/nio/file/FileVisitor;", "Ljava/nio/file/Path;", "sourceDir", "targetDir", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "preVisitDirectory", "Ljava/nio/file/FileVisitResult;", "dir", "attrs", "Ljava/nio/file/attribute/BasicFileAttributes;", "visitFile", "file", "visitFileFailed", "exc", "Ljava/io/IOException;", "postVisitDirectory", "resolve", "relativePath", "Companion", "intellij.clouds.docker.remoteRun"})
@SourceDebugExtension(value={"SMAP\nMovingFileVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MovingFileVisitor.kt\ncom/intellij/docker/remote/run/target/MovingFileVisitor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,96:1\n13#2:97\n*S KotlinDebug\n*F\n+ 1 MovingFileVisitor.kt\ncom/intellij/docker/remote/run/target/MovingFileVisitor\n*L\n94#1:97\n*E\n"})
public final class MovingFileVisitor
implements FileVisitor<Path> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path sourceDir;
    @NotNull
    private final Path targetDir;
    @NotNull
    private static final Logger LOG;

    public MovingFileVisitor(@NotNull Path sourceDir, @NotNull Path targetDir) {
        Intrinsics.checkNotNullParameter((Object)sourceDir, (String)"sourceDir");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        this.sourceDir = sourceDir;
        this.targetDir = targetDir;
    }

    @Override
    @NotNull
    public FileVisitResult preVisitDirectory(@NotNull Path dir, @NotNull BasicFileAttributes attrs) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        Path path = this.sourceDir.relativize(dir);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"relativize(...)");
        Path newDir = this.resolve(path);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(newDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!Files.isDirectory(newDir, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                PathKt.delete$default((Path)newDir, (boolean)false, (int)1, null);
            }
        }
        try {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.move(dir, newDir, copyOptionArray);
            return FileVisitResult.SKIP_SUBTREE;
        }
        catch (DirectoryNotEmptyException e) {
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            if (!Files.exists(newDir, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                PathKt.createDirectories((Path)this.sourceDir);
            }
            return FileVisitResult.CONTINUE;
        }
        catch (IOException e) {
            LOG.error("Failed to move " + dir + " to " + newDir, (Throwable)e);
            return FileVisitResult.SKIP_SUBTREE;
        }
    }

    @Override
    @NotNull
    public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        Path path = this.sourceDir.relativize(file);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"relativize(...)");
        Path newFile = this.resolve(path);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(newFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            PathKt.delete$default((Path)newFile, (boolean)false, (int)1, null);
        }
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.move(file, newFile, copyOptionArray);
        return FileVisitResult.CONTINUE;
    }

    @Override
    @NotNull
    public FileVisitResult visitFileFailed(@NotNull Path file, @NotNull IOException exc) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)exc, (String)"exc");
        if (exc instanceof FileSystemLoopException) {
            LOG.error("Cycle detected: " + file, (Throwable)exc);
        } else {
            LOG.error("Unable to copy: " + file + ": " + exc, (Throwable)exc);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    @NotNull
    public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return FileVisitResult.CONTINUE;
    }

    private final Path resolve(Path relativePath) {
        Path path;
        if (!(!relativePath.isAbsolute())) {
            boolean $i$a$-check-MovingFileVisitor$resolve$22 = false;
            String $i$a$-check-MovingFileVisitor$resolve$22 = "The path is absolute: " + relativePath;
            throw new IllegalStateException($i$a$-check-MovingFileVisitor$resolve$22.toString());
        }
        try {
            path = this.targetDir.resolve(relativePath);
            Intrinsics.checkNotNull((Object)path);
        }
        catch (ProviderMismatchException pme) {
            Path resolved = this.targetDir;
            int n = relativePath.getNameCount();
            for (int i = 0; i < n; ++i) {
                Intrinsics.checkNotNullExpressionValue((Object)resolved.resolve(((Object)relativePath.getName(i)).toString()), (String)"resolve(...)");
            }
            path = resolved;
        }
        return path;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MovingFileVisitor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/remote/run/target/MovingFileVisitor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.clouds.docker.remoteRun"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

