/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.importing;

import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.importing.ImportSpecImpl;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ThreeState;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportSpecBuilder {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private ProgressExecutionMode myProgressExecutionMode;
    @Nullable
    private ExternalProjectRefreshCallback myCallback;
    private boolean isPreviewMode;
    private boolean isActivateBuildToolWindowOnStart;
    private boolean isActivateBuildToolWindowOnFailure;
    @NotNull
    private ThreeState isNavigateToError;
    @Nullable
    private String myVmOptions;
    @Nullable
    private String myArguments;
    private boolean myImportProjectData;
    private boolean mySelectProjectDataToImport;
    private boolean myCreateDirectoriesForEmptyContentRoots;
    @Nullable
    private ProjectResolverPolicy myProjectResolverPolicy;
    @Nullable
    private Runnable myRerunAction;
    @Nullable
    private UserDataHolderBase myUserData;

    public ImportSpecBuilder(@NotNull Project project, @NotNull ProjectSystemId id) {
        if (project == null) {
            ImportSpecBuilder.$$$reportNull$$$0(0);
        }
        if (id == null) {
            ImportSpecBuilder.$$$reportNull$$$0(1);
        }
        this.myProgressExecutionMode = ProgressExecutionMode.IN_BACKGROUND_ASYNC;
        this.myCallback = null;
        this.isPreviewMode = false;
        this.isActivateBuildToolWindowOnStart = false;
        this.isActivateBuildToolWindowOnFailure = true;
        this.isNavigateToError = ThreeState.UNSURE;
        this.myVmOptions = null;
        this.myArguments = null;
        this.myImportProjectData = true;
        this.mySelectProjectDataToImport = false;
        this.myCreateDirectoriesForEmptyContentRoots = false;
        this.myProjectResolverPolicy = null;
        this.myRerunAction = null;
        this.myUserData = null;
        this.myProject = project;
        this.myExternalSystemId = id;
    }

    public ImportSpecBuilder(@NotNull ImportSpec importSpec) {
        if (importSpec == null) {
            ImportSpecBuilder.$$$reportNull$$$0(2);
        }
        this.myProgressExecutionMode = ProgressExecutionMode.IN_BACKGROUND_ASYNC;
        this.myCallback = null;
        this.isPreviewMode = false;
        this.isActivateBuildToolWindowOnStart = false;
        this.isActivateBuildToolWindowOnFailure = true;
        this.isNavigateToError = ThreeState.UNSURE;
        this.myVmOptions = null;
        this.myArguments = null;
        this.myImportProjectData = true;
        this.mySelectProjectDataToImport = false;
        this.myCreateDirectoriesForEmptyContentRoots = false;
        this.myProjectResolverPolicy = null;
        this.myRerunAction = null;
        this.myUserData = null;
        this.myProject = importSpec.getProject();
        this.myExternalSystemId = importSpec.getExternalSystemId();
        this.myProgressExecutionMode = importSpec.getProgressExecutionMode();
        this.myCallback = importSpec.getCallback();
        this.isPreviewMode = importSpec.isPreviewMode();
        this.isActivateBuildToolWindowOnStart = importSpec.isActivateBuildToolWindowOnStart();
        this.isActivateBuildToolWindowOnFailure = importSpec.isActivateBuildToolWindowOnFailure();
        this.isNavigateToError = importSpec.isNavigateToError();
        this.myVmOptions = importSpec.getVmOptions();
        this.myArguments = importSpec.getArguments();
        this.myImportProjectData = importSpec.shouldImportProjectData();
        this.mySelectProjectDataToImport = importSpec.shouldSelectProjectDataToImport();
        this.myCreateDirectoriesForEmptyContentRoots = importSpec.shouldCreateDirectoriesForEmptyContentRoots();
        this.myProjectResolverPolicy = importSpec.getProjectResolverPolicy();
        this.myRerunAction = importSpec.getRerunAction();
        this.myUserData = importSpec.getUserData();
    }

    public ImportSpecBuilder use(@NotNull ProgressExecutionMode executionMode) {
        if (executionMode == null) {
            ImportSpecBuilder.$$$reportNull$$$0(3);
        }
        this.myProgressExecutionMode = executionMode;
        return this;
    }

    @Deprecated(forRemoval=true)
    public ImportSpecBuilder forceWhenUptodate(boolean force) {
        return this;
    }

    @Deprecated
    public ImportSpecBuilder callback(@Nullable ExternalProjectRefreshCallback callback) {
        if (callback != null) {
            this.myImportProjectData = false;
        }
        this.myCallback = callback;
        return this;
    }

    public ImportSpecBuilder withCallback(@NotNull ExternalProjectRefreshCallback callback) {
        if (callback == null) {
            ImportSpecBuilder.$$$reportNull$$$0(4);
        }
        this.myCallback = callback;
        return this;
    }

    public ImportSpecBuilder withCallback(final @NotNull CompletableFuture<Void> future) {
        if (future == null) {
            ImportSpecBuilder.$$$reportNull$$$0(5);
        }
        return this.withCallback(new ExternalProjectRefreshCallback(){

            @Override
            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                future.complete(null);
            }

            @Override
            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(0);
                }
                future.completeExceptionally(new RuntimeException(errorMessage));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/externalSystem/importing/ImportSpecBuilder$1", "onFailure"));
            }
        });
    }

    public ImportSpecBuilder withCallback(final @NotNull Consumer<Boolean> callback) {
        if (callback == null) {
            ImportSpecBuilder.$$$reportNull$$$0(6);
        }
        return this.withCallback(new ExternalProjectRefreshCallback(){

            @Override
            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                callback.accept(true);
            }

            @Override
            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (errorMessage == null) {
                    2.$$$reportNull$$$0(0);
                }
                callback.accept(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/externalSystem/importing/ImportSpecBuilder$2", "onFailure"));
            }
        });
    }

    public ImportSpecBuilder usePreviewMode() {
        return this.withPreviewMode(true);
    }

    @CheckReturnValue
    public ImportSpecBuilder withPreviewMode(boolean isPreviewMode) {
        this.isPreviewMode = isPreviewMode;
        return this;
    }

    @CheckReturnValue
    public ImportSpecBuilder withImportProjectData(boolean importProjectData) {
        this.myImportProjectData = importProjectData;
        return this;
    }

    @CheckReturnValue
    public ImportSpecBuilder withSelectProjectDataToImport(boolean selectProjectDataToImport) {
        this.mySelectProjectDataToImport = selectProjectDataToImport;
        return this;
    }

    public ImportSpecBuilder createDirectoriesForEmptyContentRoots() {
        this.myCreateDirectoriesForEmptyContentRoots = true;
        return this;
    }

    @CheckReturnValue
    public ImportSpecBuilder withActivateToolWindowOnStart(boolean activateToolWindowBeforeRun) {
        this.isActivateBuildToolWindowOnStart = activateToolWindowBeforeRun;
        return this;
    }

    public ImportSpecBuilder activateBuildToolWindowOnStart() {
        return this.withActivateToolWindowOnStart(true);
    }

    @CheckReturnValue
    public ImportSpecBuilder withActivateToolWindowOnFailure(boolean activateToolWindowOnFailure) {
        this.isActivateBuildToolWindowOnFailure = activateToolWindowOnFailure;
        return this;
    }

    public ImportSpecBuilder dontReportRefreshErrors() {
        return this.withActivateToolWindowOnFailure(false);
    }

    public ImportSpecBuilder dontNavigateToError() {
        this.isNavigateToError = ThreeState.NO;
        return this;
    }

    public ImportSpecBuilder navigateToError() {
        this.isNavigateToError = ThreeState.YES;
        return this;
    }

    public ImportSpecBuilder withVmOptions(@Nullable String vmOptions) {
        this.myVmOptions = vmOptions;
        return this;
    }

    public ImportSpecBuilder withArguments(@Nullable String arguments) {
        this.myArguments = arguments;
        return this;
    }

    @ApiStatus.Experimental
    public ImportSpecBuilder projectResolverPolicy(@NotNull ProjectResolverPolicy projectResolverPolicy) {
        if (projectResolverPolicy == null) {
            ImportSpecBuilder.$$$reportNull$$$0(7);
        }
        if (projectResolverPolicy.isPartialDataResolveAllowed()) {
            this.myImportProjectData = false;
        }
        this.myProjectResolverPolicy = projectResolverPolicy;
        return this;
    }

    public ImportSpecBuilder withRerunAction(@Nullable Runnable rerunAction) {
        this.myRerunAction = rerunAction;
        return this;
    }

    public ImportSpecBuilder withUserData(@Nullable UserDataHolderBase userData) {
        this.myUserData = userData;
        return this;
    }

    public ImportSpec build() {
        return new ImportSpecImpl(this.myProject, this.myExternalSystemId, this.myProgressExecutionMode, this.myCallback, this.isPreviewMode, this.myImportProjectData, this.mySelectProjectDataToImport, this.myCreateDirectoriesForEmptyContentRoots, this.isActivateBuildToolWindowOnStart, this.isActivateBuildToolWindowOnFailure, this.isNavigateToError, this.myVmOptions, this.myArguments, this.myProjectResolverPolicy, this.myRerunAction, this.myUserData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpec";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionMode";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectResolverPolicy";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/importing/ImportSpecBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "use";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "withCallback";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "projectResolverPolicy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Deprecated
    @ApiStatus.Internal
    public static final class DefaultProjectRefreshCallback
    implements ExternalProjectRefreshCallback {
        private final Project myProject;

        public DefaultProjectRefreshCallback(ImportSpec spec) {
            this(spec.getProject());
        }

        public DefaultProjectRefreshCallback(@NotNull Project project) {
            if (project == null) {
                DefaultProjectRefreshCallback.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Override
        public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
            if (externalProject == null) {
                return;
            }
            ProjectDataManager.getInstance().importData(externalProject, this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/importing/ImportSpecBuilder$DefaultProjectRefreshCallback", "<init>"));
        }
    }
}

