/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.vitest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.testing.JsTestConfigurationUtil;
import com.intellij.javascript.testing.runScope.JsTestRunScope;
import com.intellij.javascript.testing.vitest.VitestRunConfiguration;
import com.intellij.javascript.testing.vitest.VitestRunSettings;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ0\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\u000b\u0010\"\u001a\u00070\u0005\u00a2\u0006\u0002\b#2\u000b\u0010$\u001a\u00070\u0005\u00a2\u0006\u0002\b%2\u0006\u0010&\u001a\u00020'R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u000e\u0010(\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/javascript/testing/vitest/VitestUtil;", "", "<init>", "()V", "VITEST_PACKAGE_NAME", "", "ANGULAR_CLI_PACKAGE_NAME", "PKG_DESCRIPTOR", "Lcom/intellij/javascript/nodejs/util/NodePackageDescriptor;", "getPKG_DESCRIPTOR", "()Lcom/intellij/javascript/nodejs/util/NodePackageDescriptor;", "ANGULAR_CLI_PKG_DESCRIPTOR", "getANGULAR_CLI_PKG_DESCRIPTOR$intellij_javascript_ultimate", "findContextFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "settings", "Lcom/intellij/javascript/testing/vitest/VitestRunSettings;", "findFile", "path", "writeXml", "", "element", "Lorg/jdom/Element;", "readXml", "checkRunConfiguration", "configuration", "Lcom/intellij/javascript/testing/vitest/VitestRunConfiguration;", "getVitestMainJsFile", "Ljava/nio/file/Path;", "pkg", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "notify", "project", "Lcom/intellij/openapi/project/Project;", "title", "Lcom/intellij/openapi/util/NlsContexts$NotificationTitle;", "content", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "notificationType", "Lcom/intellij/notification/NotificationType;", "TAG__CONFIG_FILE", "TAG__NODE_INTERPRETER", "TAG__NODE_OPTIONS", "TAG__VITEST_PACKAGE", "TAG__WORKING_DIR", "TAG__VITEST_OPTIONS", "intellij.javascript.ultimate"})
@SourceDebugExtension(value={"SMAP\nVitestUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VitestUtil.kt\ncom/intellij/javascript/testing/vitest/VitestUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,115:1\n13#2:116\n*S KotlinDebug\n*F\n+ 1 VitestUtil.kt\ncom/intellij/javascript/testing/vitest/VitestUtil\n*L\n101#1:116\n*E\n"})
public final class VitestUtil {
    @NotNull
    public static final VitestUtil INSTANCE = new VitestUtil();
    @NotNull
    public static final String VITEST_PACKAGE_NAME = "vitest";
    @NotNull
    public static final String ANGULAR_CLI_PACKAGE_NAME = "@angular/cli";
    @NotNull
    private static final NodePackageDescriptor PKG_DESCRIPTOR = new NodePackageDescriptor("vitest");
    @NotNull
    private static final NodePackageDescriptor ANGULAR_CLI_PKG_DESCRIPTOR = new NodePackageDescriptor("@angular/cli");
    @NotNull
    private static final String TAG__CONFIG_FILE = "config";
    @NotNull
    private static final String TAG__NODE_INTERPRETER = "node-interpreter";
    @NotNull
    private static final String TAG__NODE_OPTIONS = "node-options";
    @NotNull
    private static final String TAG__VITEST_PACKAGE = "vitest-package";
    @NotNull
    private static final String TAG__WORKING_DIR = "working-dir";
    @NotNull
    private static final String TAG__VITEST_OPTIONS = "vitest-options";

    private VitestUtil() {
    }

    @NotNull
    public final NodePackageDescriptor getPKG_DESCRIPTOR() {
        return PKG_DESCRIPTOR;
    }

    @NotNull
    public final NodePackageDescriptor getANGULAR_CLI_PKG_DESCRIPTOR$intellij_javascript_ultimate() {
        return ANGULAR_CLI_PKG_DESCRIPTOR;
    }

    @Nullable
    public final VirtualFile findContextFile(@NotNull VitestRunSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        VirtualFile virtualFile = this.findFile(settings.getConfigFilePath());
        if (virtualFile == null) {
            virtualFile = this.findFile(settings.getWorkingDir());
        }
        return virtualFile;
    }

    private final VirtualFile findFile(String path) {
        return FileUtil.isAbsolute((String)path) ? LocalFileSystem.getInstance().findFileByPath(path) : null;
    }

    public final void writeXml(@NotNull Element element, @NotNull VitestRunSettings settings) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (((CharSequence)settings.getConfigFilePath()).length() > 0) {
            JsTestConfigurationUtil.INSTANCE.writeValue(element, TAG__CONFIG_FILE, FileUtil.toSystemIndependentName((String)settings.getConfigFilePath()));
        }
        JsTestConfigurationUtil.INSTANCE.writeValue(element, TAG__NODE_INTERPRETER, settings.getInterpreterRef().getReferenceName());
        JsTestConfigurationUtil.INSTANCE.writeValue(element, TAG__NODE_OPTIONS, settings.getNodeOptions());
        NodePackage nodePackage = settings.getVitestPackage();
        if (nodePackage != null) {
            NodePackage it = nodePackage;
            boolean bl = false;
            JsTestConfigurationUtil.INSTANCE.writeValue(element, TAG__VITEST_PACKAGE, it.getSystemIndependentPath());
        }
        JsTestConfigurationUtil.INSTANCE.writeValue(element, TAG__WORKING_DIR, FileUtil.toSystemIndependentName((String)settings.getWorkingDir()));
        if (((CharSequence)settings.getVitestOptions()).length() > 0) {
            JsTestConfigurationUtil.INSTANCE.writeValue(element, TAG__VITEST_OPTIONS, settings.getVitestOptions());
        }
        settings.getEnvData().writeExternal(element);
        settings.getScope().writeExternal(element);
    }

    @NotNull
    public final VitestRunSettings readXml(@NotNull Element element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        VitestRunSettings.Builder builder = new VitestRunSettings.Builder(null, null, null, null, null, null, null, null, 255, null);
        String string2 = JsTestConfigurationUtil.INSTANCE.readValue(element, TAG__CONFIG_FILE);
        if (string2 == null) {
            string2 = "";
        }
        builder.setConfigFilePath(string2);
        NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.create((String)JsTestConfigurationUtil.INSTANCE.readValue(element, TAG__NODE_INTERPRETER));
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterRef, (String)"create(...)");
        builder.setInterpreterRef(nodeJsInterpreterRef);
        String string3 = JsTestConfigurationUtil.INSTANCE.readValue(element, TAG__NODE_OPTIONS);
        if (string3 == null) {
            string3 = "";
        }
        builder.setNodeOptions(string3);
        String string4 = JDOMExternalizerUtil.readCustomField((Element)element, (String)TAG__VITEST_PACKAGE);
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            builder.setVitestPackage(PKG_DESCRIPTOR.createPackage(it));
        }
        if ((string = JsTestConfigurationUtil.INSTANCE.readValue(element, TAG__WORKING_DIR)) == null) {
            string = "";
        }
        builder.setWorkingDir(string);
        String string5 = JsTestConfigurationUtil.INSTANCE.readValue(element, TAG__VITEST_OPTIONS);
        if (string5 == null) {
            string5 = "";
        }
        builder.setVitestOptions(string5);
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.readExternal((Element)element);
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"readExternal(...)");
        builder.setEnvData(environmentVariablesData);
        builder.setScope(JsTestRunScope.Companion.readExternal(element));
        return builder.build();
    }

    public final void checkRunConfiguration(@NotNull VitestRunConfiguration configuration) throws RuntimeConfigurationException {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        VitestRunSettings settings = configuration.getSettings();
        if (((CharSequence)settings.getConfigFilePath()).length() > 0) {
            JsTestConfigurationUtil.INSTANCE.validatePath(false, "configuration file", settings.getConfigFilePath());
        }
        JsTestConfigurationUtil.INSTANCE.validatePath(true, "working directory", settings.getWorkingDir());
        NodeInterpreterUtil.checkForRunConfiguration((NodeJsInterpreter)settings.getInterpreterRef().resolve(configuration.getProject()));
        configuration.getOrDetectVitestPackage().validateForRunConfiguration(VITEST_PACKAGE_NAME);
        settings.getScope().validateForRunConfiguration(false);
    }

    @NotNull
    public final Path getVitestMainJsFile(@NotNull NodePackage pkg) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        String string = PackageJsonUtil.guessDefaultBinaryNameOfDependency((NodePackage)pkg);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"guessDefaultBinaryNameOfDependency(...)");
        String binaryName = string;
        Path path = NodePackage.findBinFilePath$default((NodePackage)pkg, (String)binaryName, (String)"./vitest.mjs", null, (int)4, null);
        if (path != null) {
            Path it = path;
            boolean bl = false;
            return it;
        }
        Object[] objectArray = new Object[]{pkg.getName()};
        throw new ExecutionException(JavaScriptBundle.message((String)"node.package.cannot.find.bin.file.dialog.message", (Object[])objectArray));
    }

    public final void notify(@NotNull Project project, @NotNull String title, @NotNull String content, @NotNull NotificationType notificationType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)notificationType, (String)"notificationType");
        NotificationGroup vitestNotificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Vitest test runner");
        if (vitestNotificationGroup == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(VitestUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Cannot find \"Vitest test runner\" notification group");
            return;
        }
        vitestNotificationGroup.createNotification(title, content, notificationType).notify(project);
    }
}

