/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InspectionBasedCodeOptimization {
    @NotNull
    private final LocalInspectionTool inspection;
    @NotNull
    private final Class<? extends QuickFix> quickFixClass;
    @NotNull
    private final Condition<? super PsiElement> acceptsCondition;
    @NotNull
    private final Logger LOG;

    public InspectionBasedCodeOptimization(@NotNull LocalInspectionTool inspection, @NotNull Class<? extends QuickFix> quickFixClass, @NotNull Condition<? super PsiElement> acceptsCondition) {
        if (inspection == null) {
            InspectionBasedCodeOptimization.$$$reportNull$$$0(0);
        }
        if (quickFixClass == null) {
            InspectionBasedCodeOptimization.$$$reportNull$$$0(1);
        }
        if (acceptsCondition == null) {
            InspectionBasedCodeOptimization.$$$reportNull$$$0(2);
        }
        this.LOG = Logger.getInstance(this.getClass());
        this.inspection = inspection;
        this.quickFixClass = quickFixClass;
        this.acceptsCondition = acceptsCondition;
    }

    public boolean perform(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement elem) {
        List descriptors;
        if (project == null) {
            InspectionBasedCodeOptimization.$$$reportNull$$$0(3);
        }
        if (file == null) {
            InspectionBasedCodeOptimization.$$$reportNull$$$0(4);
        }
        if (elem == null) {
            InspectionBasedCodeOptimization.$$$reportNull$$$0(5);
        }
        try {
            descriptors = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (List)ReadAction.compute(() -> this.inspection.processFile(file, InspectionManager.getInstance((Project)project))), JavaScriptBundle.message((String)"javascript.intention.code.optimizations.text", (Object[])new Object[0]), true, project);
        }
        catch (ProcessCanceledException pce) {
            return false;
        }
        catch (Exception e) {
            this.LOG.error((Throwable)e);
            return false;
        }
        for (ProblemDescriptor descriptor : descriptors) {
            QuickFix[] fixes;
            PsiElement element = descriptor.getPsiElement();
            if (element == null || !elem.getTextRange().contains(element.getTextRange()) || !this.acceptsCondition.value((Object)element) || (fixes = descriptor.getFixes()) == null) continue;
            for (QuickFix fix2 : fixes) {
                if (!this.quickFixClass.isInstance(fix2)) continue;
                if (fix2.startInWriteAction()) {
                    ApplicationManager.getApplication().runWriteAction(() -> fix2.applyFix(project, (CommonProblemDescriptor)descriptor));
                    continue;
                }
                fix2.applyFix(project, (CommonProblemDescriptor)descriptor);
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptsCondition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/intentions/InspectionBasedCodeOptimization";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

