/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.memberPushDown;

import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.memberPushDown.JSPushDownConflictsUtil;
import com.intellij.lang.javascript.refactoring.memberPushDown.JSPushDownHandler;
import com.intellij.lang.javascript.refactoring.util.ActionScriptRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.javascript.validation.fixes.ImplementMethodsFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.memberPushDown.PushDownUsageViewDescriptor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class JSPushDownProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)JSPushDownProcessor.class.getName());
    private final JSMemberInfo[] myMemberInfos;
    private JSClass mySourceClass;
    private final int myDocCommentPolicy;

    public JSPushDownProcessor(Project project, JSMemberInfo[] memberInfos, JSClass aSourceClass, int docCommentPolicy) {
        super(project);
        this.myMemberInfos = memberInfos;
        this.mySourceClass = aSourceClass;
        this.myDocCommentPolicy = docCommentPolicy;
    }

    @NotNull
    protected String getCommandName() {
        String string = JSPushDownHandler.getRefactoringName();
        if (string == null) {
            JSPushDownProcessor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            JSPushDownProcessor.$$$reportNull$$$0(1);
        }
        return new PushDownUsageViewDescriptor((PsiElement)this.mySourceClass);
    }

    protected UsageInfo @NotNull [] findUsages() {
        Collection subclasses = JSInheritanceUtil.findDirectSubClasses((JSClass)this.mySourceClass, (boolean)false);
        JSClass[] inheritors = subclasses.toArray(JSClass.EMPTY_ARRAY);
        UsageInfo[] usages = new UsageInfo[inheritors.length];
        for (int i = 0; i < inheritors.length; ++i) {
            usages[i] = new UsageInfo(this, (PsiElement)inheritors[i]){

                public PsiElement getElement() {
                    PsiElement element = super.getElement();
                    if (element instanceof XmlTag) {
                        element = XmlBackedJSClassFactory.getInstance().getXmlBackedClass((XmlTag)element);
                    }
                    return element;
                }
            };
        }
        if (usages == null) {
            JSPushDownProcessor.$$$reportNull$$$0(2);
        }
        return usages;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            JSPushDownProcessor.$$$reportNull$$$0(3);
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        ArrayList<JSClass> targetClasses = new ArrayList<JSClass>(usagesIn.length);
        for (UsageInfo usage : usagesIn) {
            targetClasses.add((JSClass)usage.getElement());
        }
        MultiMap<PsiElement, String> conflicts = JSPushDownConflictsUtil.checkConflicts(this.mySourceClass, this.myMemberInfos, targetClasses, JSVisibilityUtil.DEFAULT_OPTIONS);
        return this.showConflicts(conflicts, usagesIn);
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            JSPushDownProcessor.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(elements.length == 1 && elements[0] instanceof JSClass, (Object)elements);
        this.mySourceClass = (JSClass)elements[0];
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            JSPushDownProcessor.$$$reportNull$$$0(5);
        }
        try {
            JSClass firstTargetClass = (JSClass)usages[0].getElement();
            List filesWithUsages = ActionScriptRefactoringUtil.qualifyIncomingReferences((UsageInfo[])JSRefactoringUtil.getUsages((Collection)JSMemberInfo.getStatics((JSMemberInfo[])this.myMemberInfos), (JSClass)firstTargetClass));
            ArrayList postponedFormatters = new ArrayList();
            HashMap<JSAttributeListOwner, Boolean> movedMembers = new HashMap<JSAttributeListOwner, Boolean>(this.myMemberInfos.length);
            for (JSMemberInfo info : this.myMemberInfos) {
                movedMembers.put((JSAttributeListOwner)info.getMember(), info.isToAbstract());
            }
            for (int i = 0; i < usages.length; ++i) {
                UsageInfo usage = usages[i];
                JSClass targetClass = (JSClass)usage.getElement();
                for (JSMemberInfo info : this.myMemberInfos) {
                    JSAttributeListOwner newMember;
                    JSAttributeListOwner member = (JSAttributeListOwner)info.getMember();
                    if (member instanceof JSFunction) {
                        JSFunction method = (JSFunction)member;
                        importsInTargetFile = new ArrayList();
                        namespacesInTargetFile = new ArrayList();
                        ActionScriptRefactoringUtil.fixOutgoingReferences((PsiElement)member, importsInTargetFile, namespacesInTargetFile, movedMembers.keySet(), (JSClass)targetClass, (boolean)true, (boolean)false);
                        ImportUtils.insertImportStatements((PsiElement)targetClass, importsInTargetFile);
                        if (this.mySourceClass.isInterface() && !targetClass.isInterface()) {
                            PsiElement docComment;
                            newMember = (JSAttributeListOwner)targetClass.add((PsiElement)JSPushDownProcessor.buildImplementationMethod(method, targetClass));
                            if ((this.myDocCommentPolicy == 2 || this.myDocCommentPolicy == 1) && (docComment = JSRefactoringUtil.findDocComment((PsiElement)method)) != null) {
                                targetClass.addBefore(docComment.copy(), (PsiElement)newMember);
                            }
                            JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)newMember, (JSAttributeList.AccessType)JSAttributeList.AccessType.PUBLIC);
                        } else {
                            newMember = (JSAttributeListOwner)JSRefactoringUtil.addMemberToTargetClass((JSClass)targetClass, (PsiElement)method.copy());
                            JSRefactoringUtil.handleDocCommentAndFormat((PsiElement)newMember, postponedFormatters);
                        }
                    } else if (member instanceof JSVariable) {
                        importsInTargetFile = new ArrayList();
                        namespacesInTargetFile = new ArrayList();
                        ActionScriptRefactoringUtil.fixOutgoingReferences((PsiElement)member, importsInTargetFile, namespacesInTargetFile, movedMembers.keySet(), (JSClass)targetClass, (boolean)true, (boolean)false);
                        ContainerUtil.addIfNotNull(postponedFormatters, (Object)JSRefactoringUtil.addUseNamespaceDirectives((JSQualifiedNamedElement)targetClass, namespacesInTargetFile));
                        ImportUtils.insertImportStatements((PsiElement)targetClass, importsInTargetFile);
                        PsiElement varStatementCopy = JSRefactoringUtil.addMemberToTargetClass((JSClass)targetClass, (PsiElement)JSRefactoringUtil.getVarStatementCopy((JSVariable)((JSVariable)member)));
                        JSRefactoringUtil.handleDocCommentAndFormat((PsiElement)varStatementCopy, postponedFormatters);
                        newMember = (JSAttributeListOwner)PsiTreeUtil.getChildOfType((PsiElement)varStatementCopy, JSVariable.class);
                    } else {
                        JSClass aClass = (JSClass)member;
                        LOG.assertTrue(Boolean.FALSE.equals(info.getOverrides()));
                        JSRefactoringUtil.addToSupersList((JSClass)targetClass, (String)aClass.getQualifiedName(), (boolean)true);
                        newMember = null;
                    }
                    if (newMember == null) continue;
                    ActionScriptRefactoringUtil.fixOutgoingReferences((PsiElement)newMember, new ArrayList(), new ArrayList(), movedMembers.keySet(), (JSClass)targetClass, (boolean)false, (boolean)false);
                }
                JSRefactoringUtil.postProcess((PsiElement)(i == 0 ? this.mySourceClass : null), (JSQualifiedNamedElement)targetClass, i == 0 ? filesWithUsages : Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), postponedFormatters, (boolean)false, (boolean)true);
            }
            JSRefactoringUtil.addRemovalFormatters((JSClass)this.mySourceClass, movedMembers.keySet(), function -> {
                Boolean isToAbstract = (Boolean)movedMembers.get(function);
                return isToAbstract.booleanValue() ? this.myDocCommentPolicy == 1 : true;
            }, (Condition)Conditions.alwaysTrue(), postponedFormatters);
            for (JSMemberInfo info : this.myMemberInfos) {
                JSAttributeListOwner toDelete;
                JSAttributeListOwner member = (JSAttributeListOwner)info.getMember();
                if (member instanceof JSFunction) {
                    if (info.isToAbstract()) {
                        if (this.myDocCommentPolicy == 1 && (docComment = JSRefactoringUtil.findDocComment((PsiElement)member)) != null) {
                            JSRefactoringUtil.deleteWithNoPostponedFormatting((PsiElement)docComment);
                        }
                        toDelete = null;
                    } else {
                        docComment = JSRefactoringUtil.findDocComment((PsiElement)member);
                        if (docComment != null) {
                            JSRefactoringUtil.deleteWithNoPostponedFormatting((PsiElement)docComment);
                        }
                        toDelete = member;
                    }
                } else if (member instanceof JSVariable) {
                    docComment = JSRefactoringUtil.findDocComment((PsiElement)member);
                    if (docComment != null) {
                        JSRefactoringUtil.deleteWithNoPostponedFormatting((PsiElement)docComment);
                    }
                    toDelete = member;
                } else {
                    JSReferenceList refList = info.isExtendsNotImplements() ? this.mySourceClass.getExtendsList() : this.mySourceClass.getImplementsList();
                    JSRefactoringUtil.removeFromReferenceList((JSReferenceList)refList, (JSClass)((JSClass)member), postponedFormatters);
                    toDelete = null;
                }
                if (toDelete == null) continue;
                JSRefactoringUtil.deleteWithNoPostponedFormatting((PsiElement)toDelete);
            }
            JSRefactoringUtil.format(postponedFormatters);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public static JSFunction buildImplementationMethod(JSFunction method, JSClass targetClass) {
        MultiMap types = MultiMap.createSet();
        for (String type : BaseCreateMembersFix.getFunctionTypes((JSFunction)method)) {
            String resolved = JSImportHandlingUtil.resolveTypeName((String)type, (PsiElement)method);
            if (type.indexOf(46) == -1 && type.equals(resolved)) continue;
            types.putValue((Object)JSResolveUtil.getShortTypeName((String)type, (boolean)false), (Object)resolved);
        }
        ImplementMethodsFix fix2 = new ImplementMethodsFix(targetClass);
        String text = fix2.buildFunctionText(method, (MultiMap<String, String>)types);
        PsiElement element = Objects.requireNonNull(JSChangeUtil.createJSTreeFromTextWithContext((String)text, (PsiElement)method)).getPsi();
        return (JSFunction)element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/memberPushDown/JSPushDownProcessor";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/memberPushDown/JSPushDownProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

