/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotator;
import org.jetbrains.plugins.groovy.annotator.ImplKt;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyStaticTypeCheckVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GrAnnotatorImpl;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nGrAnnotatorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrAnnotatorImpl.kt\norg/jetbrains/plugins/groovy/annotator/GrAnnotatorImpl\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,68:1\n1184#2,3:69\n*S KotlinDebug\n*F\n+ 1 GrAnnotatorImpl.kt\norg/jetbrains/plugins/groovy/annotator/GrAnnotatorImpl\n*L\n43#1:69,3\n*E\n"})
public final class GrAnnotatorImpl
implements Annotator {
    /*
     * WARNING - void declaration
     */
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getCurrentAnnotationSession().getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        if (FileIndexFacade.getInstance((Project)file.getProject()).isInLibrarySource(file.getVirtualFile())) {
            return;
        }
        if (element instanceof GroovyPsiElement && !PsiUtilKt.isFake((GroovyPsiElement)element)) {
            ((GroovyPsiElement)element).accept(new GroovyAnnotator(holder));
            if (CompileStaticUtil.isCompileStatic(element)) {
                ((GroovyPsiElement)element).accept(new GroovyStaticTypeCheckVisitor(holder));
            }
        } else if (element instanceof PsiComment) {
            String text = element.getText();
            Intrinsics.checkNotNull((Object)text);
            if (StringsKt.startsWith$default((String)text, (String)"/*", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)text, (String)"*/", (boolean)false, (int)2, null)) {
                TextRange range = element.getTextRange();
                holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("doc.end.expected", new Object[0])).range(TextRange.create((int)(range.getEndOffset() - 1), (int)range.getEndOffset())).create();
            }
        } else {
            PsiElement parent = element.getParent();
            if (parent instanceof GrMethod && Intrinsics.areEqual((Object)element, (Object)((GrMethod)parent).getNameIdentifierGroovy())) {
                void $this$mapTo$iv;
                Regex regex = ImplKt.getIllegalJvmNameSymbols();
                String string = ((GrMethod)parent).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                Sequence sequence = Regex.findAll$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
                Collection destination$iv = new HashSet();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    MatchResult matchResult = (MatchResult)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(it.getValue());
                }
                HashSet illegalCharacters = (HashSet)destination$iv;
                if (!((Collection)illegalCharacters).isEmpty() && !PsiUtilKt.isFake((GroovyPsiElement)parent)) {
                    String chars = CollectionsKt.joinToString$default((Iterable)illegalCharacters, null, null, null, (int)0, null, GrAnnotatorImpl::annotate$lambda$1, (int)31, null);
                    Object[] objectArray = new Object[]{chars};
                    holder.newAnnotation(HighlightSeverity.WARNING, GroovyBundle.message("illegal.method.name", objectArray)).create();
                }
                if (((GrMethod)parent).getReturnTypeElementGroovy() == null) {
                    GroovyAnnotator.checkMethodReturnType((PsiMethod)parent, element, holder);
                }
            } else if (parent instanceof GrField && Intrinsics.areEqual((Object)element, (Object)((GrField)parent).getNameIdentifierGroovy())) {
                GrAccessorMethod[] grAccessorMethodArray = ((GrField)parent).getGetters();
                Intrinsics.checkNotNullExpressionValue((Object)grAccessorMethodArray, (String)"getGetters(...)");
                for (GrAccessorMethod getter : grAccessorMethodArray) {
                    GroovyAnnotator.checkMethodReturnType(getter, ((GrField)parent).getNameIdentifierGroovy(), holder);
                }
                GrAccessorMethod setter = ((GrField)parent).getSetter();
                if (setter != null) {
                    GroovyAnnotator.checkMethodReturnType(setter, ((GrField)parent).getNameIdentifierGroovy(), holder);
                }
            }
        }
    }

    private static final CharSequence annotate$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it + "'";
    }
}

