/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/MyTemplateListener;", "Lcom/intellij/codeInsight/template/TemplateEditingAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getFile", "()Lcom/intellij/psi/PsiFile;", "templateFinished", "", "template", "Lcom/intellij/codeInsight/template/Template;", "brokenOff", "", "intellij.groovy"})
final class MyTemplateListener
extends TemplateEditingAdapter {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final PsiFile file;

    public MyTemplateListener(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.project = project;
        this.editor = editor;
        this.file = file;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    public void templateFinished(@NotNull Template template, boolean brokenOff) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        PsiDocumentManager.getInstance((Project)this.project).commitDocument(this.editor.getDocument());
        int offset = this.editor.getCaretModel().getOffset();
        GrField grField = (GrField)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)this.file, (int)offset, GrField.class, (boolean)false);
        if (grField == null) {
            return;
        }
        GrField psiField = grField;
        ActionsKt.runWriteAction(() -> MyTemplateListener.templateFinished$lambda$0(this, psiField));
        this.editor.getCaretModel().moveToOffset(psiField.getTextRange().getEndOffset() - 1);
    }

    private static final PsiElement templateFinished$lambda$0(MyTemplateListener this$0, GrField $psiField) {
        return CodeStyleManager.getInstance((Project)this$0.project).reformat((PsiElement)$psiField);
    }
}

