/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.config.viewresolver;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.mvc.config.viewresolver.SpringBootAutoConfigurationViewResolverFactoryBase;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.mvc.views.ViewResolver;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class WebMvcAutoConfigurationViewResolverFactory
extends SpringBootAutoConfigurationViewResolverFactoryBase {
    @NonNls
    private static final Set<String> VIEW_RESOLVER_CLASSES = Collections.singleton("org.springframework.web.servlet.view.InternalResourceViewResolver");
    @NonNls
    private static final String INTERNAL_RESOURCE_VIEW_RESOLVER_BEAN_NAME = "defaultViewResolver";
    private static final Set<String> WEB_MVC_AUTO_CONFIGURATION_CLASSES = Set.of("org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration.WebMvcAutoConfigurationAdapter", "org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration.WebMvcAutoConfigurationAdapter", "org.springframework.boot.webmvc.autoconfigure.WebMvcAutoConfiguration.WebMvcAutoConfigurationAdapter");
    @NonNls
    static final String SPRING_MVC_VIEW_PREFIX = "spring.mvc.view.prefix";
    @NonNls
    static final String SPRING_MVC_VIEW_SUFFIX = "spring.mvc.view.suffix";
    @NonNls
    static final String SPRING_VIEW_PREFIX_PRE14 = "spring.view.prefix";
    @NonNls
    static final String SPRING_VIEW_SUFFIX_PRE14 = "spring.view.suffix";

    WebMvcAutoConfigurationViewResolverFactory() {
    }

    @Override
    @NotNull
    protected String getViewResolverBeanName() {
        return INTERNAL_RESOURCE_VIEW_RESOLVER_BEAN_NAME;
    }

    @Override
    @NotNull
    protected Set<String> getViewResolverClassNames() {
        Set<String> set = VIEW_RESOLVER_CLASSES;
        if (set == null) {
            WebMvcAutoConfigurationViewResolverFactory.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    protected Set<String> getAutoConfigurationClassNames() {
        Set<String> set = WEB_MVC_AUTO_CONFIGURATION_CLASSES;
        if (set == null) {
            WebMvcAutoConfigurationViewResolverFactory.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    protected Set<ViewResolver> createViewResolvers(@Nullable CommonSpringBean bean, CommonSpringModel model) {
        boolean atLeastSB14 = SpringBootLibraryUtil.isAtLeastVersion((Module)model.getModule(), (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_4_0);
        String viewPrefix = (String)ReadAction.compute(() -> WebMvcAutoConfigurationViewResolverFactory.getConfigurationValue(model, SPRING_MVC_VIEW_PREFIX));
        String viewSuffix = (String)ReadAction.compute(() -> WebMvcAutoConfigurationViewResolverFactory.getConfigurationValue(model, SPRING_MVC_VIEW_SUFFIX));
        if (!atLeastSB14) {
            viewPrefix = (String)ObjectUtils.chooseNotNull((Object)viewPrefix, (Object)WebMvcAutoConfigurationViewResolverFactory.getConfigurationValue(model, SPRING_VIEW_PREFIX_PRE14));
            viewSuffix = (String)ObjectUtils.chooseNotNull((Object)viewSuffix, (Object)WebMvcAutoConfigurationViewResolverFactory.getConfigurationValue(model, SPRING_VIEW_SUFFIX_PRE14));
        }
        ViewResolver resolver = this.createURLBasedViewResolver(model.getModule(), "", viewPrefix, viewSuffix);
        Set<ViewResolver> set = Collections.singleton(resolver);
        if (set == null) {
            WebMvcAutoConfigurationViewResolverFactory.$$$reportNull$$$0(2);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/mvc/config/viewresolver/WebMvcAutoConfigurationViewResolverFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewResolverClassNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoConfigurationClassNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewResolvers";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

