/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.plugin.freeze;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.ThreadDump;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtilImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.platform.diagnostic.freezeAnalyzer.FreezeAnalysisResult;
import com.intellij.platform.diagnostic.freezeAnalyzer.FreezeAnalyzer;
import com.intellij.platform.diagnostic.plugin.freeze.FreezeReason;
import com.intellij.platform.diagnostic.plugin.freeze.PluginsFreezesService;
import com.intellij.threadDumpParser.ThreadState;
import com.intellij.util.ApplicationKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0001\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/diagnostic/plugin/freeze/PluginFreezeWatcher;", "", "<init>", "()V", "reason", "Lcom/intellij/platform/diagnostic/plugin/freeze/FreezeReason;", "stackTracePattern", "Lkotlin/text/Regex;", "getFreezeReason", "reset", "", "dumpedThreads", "event", "Lcom/intellij/diagnostic/LogMessage;", "dump", "Lcom/intellij/diagnostic/ThreadDump;", "durationMs", "", "analyzeFreezeCausingPlugin", "Lcom/intellij/openapi/extensions/PluginId;", "threadInfo", "Lcom/intellij/threadDumpParser/ThreadState;", "parseStackTraceElement", "Ljava/lang/StackTraceElement;", "stackTrace", "", "Companion", "intellij.platform.diagnostic.freezes"})
@SourceDebugExtension(value={"SMAP\nPluginFreezeWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginFreezeWatcher.kt\ncom/intellij/platform/diagnostic/plugin/freeze/PluginFreezeWatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,81:1\n1642#2,10:82\n1915#2:92\n1916#2:94\n1652#2:95\n1573#2:96\n1#3:93\n1#3:97\n37#4,2:98\n*S KotlinDebug\n*F\n+ 1 PluginFreezeWatcher.kt\ncom/intellij/platform/diagnostic/plugin/freeze/PluginFreezeWatcher\n*L\n36#1:82,10\n36#1:92\n36#1:94\n36#1:95\n37#1:96\n36#1:93\n62#1:98,2\n*E\n"})
public final class PluginFreezeWatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private volatile FreezeReason reason;
    @NotNull
    private final Regex stackTracePattern = new Regex("at (\\S+)\\.(\\S+)\\(([^:]+):(\\d+)\\)");

    @Nullable
    public final FreezeReason getFreezeReason() {
        return this.reason;
    }

    public final void reset() {
        this.reason = null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FreezeReason dumpedThreads(@NotNull LogMessage event, @NotNull ThreadDump dump, long durationMs) {
        Map.Entry entry;
        Object v3;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        String string = dump.getRawDump();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRawDump(...)");
        FreezeAnalysisResult freezeAnalysisResult = FreezeAnalyzer.INSTANCE.analyzeFreeze(string, null);
        List list = freezeAnalysisResult != null ? freezeAnalysisResult.getThreads() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List freezeCausingThreads = list;
        Iterable $this$mapNotNull$iv = freezeCausingThreads;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PluginId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ThreadState it = (ThreadState)element$iv$iv;
            boolean bl2 = false;
            if (this.analyzeFreezeCausingPlugin(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List pluginIds = (List)destination$iv$iv;
        Iterable $this$groupingBy$iv = pluginIds;
        boolean $i$f$groupingBy = false;
        Iterable iterable2 = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<PluginId, PluginId>($this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            public Iterator<PluginId> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                PluginId it = (PluginId)element;
                boolean bl = false;
                return var2_2;
            }
        })).entrySet();
        Iterator iterator2 = iterable2.iterator();
        if (!iterator2.hasNext()) {
            v3 = null;
        } else {
            Object t = iterator2.next();
            if (!iterator2.hasNext()) {
                v3 = t;
            } else {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                int n = ((Number)it.getValue()).intValue();
                do {
                    Object t2 = iterator2.next();
                    Map.Entry it2 = (Map.Entry)t2;
                    $i$a$-maxByOrNull-PluginFreezeWatcher$dumpedThreads$frozenPlugin$2 = false;
                    int n2 = ((Number)it2.getValue()).intValue();
                    if (n >= n2) continue;
                    t = t2;
                    n = n2;
                } while (iterator2.hasNext());
                v3 = t;
            }
        }
        if ((entry = (Map.Entry)v3) == null || (entry = (PluginId)entry.getKey()) == null) {
            return null;
        }
        Map.Entry frozenPlugin = entry;
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)frozenPlugin);
        if (ideaPluginDescriptor == null) {
            return null;
        }
        IdeaPluginDescriptor pluginDescriptor = ideaPluginDescriptor;
        if (pluginDescriptor.isImplementationDetail() || ApplicationInfoImpl.getShadowInstance().isEssentialPlugin((PluginId)frozenPlugin)) {
            return new FreezeReason((PluginId)frozenPlugin, event, durationMs, false);
        }
        if (pluginDescriptor.isBundled() && !ApplicationKt.getApplication().isInternal() && !ApplicationKt.getApplication().isEAP()) {
            return new FreezeReason((PluginId)frozenPlugin, event, durationMs, false);
        }
        PluginsFreezesService freezeStorageService = PluginsFreezesService.Companion.getInstance();
        if (freezeStorageService.shouldBeIgnored((PluginId)frozenPlugin)) {
            return null;
        }
        freezeStorageService.setLatestFreezeDate((PluginId)frozenPlugin);
        this.reason = new FreezeReason((PluginId)frozenPlugin, event, durationMs, true);
        return this.reason;
    }

    private final PluginId analyzeFreezeCausingPlugin(ThreadState threadInfo) {
        Throwable throwable;
        String string = threadInfo.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)StringsKt.lineSequence((CharSequence)string), arg_0 -> PluginFreezeWatcher.analyzeFreezeCausingPlugin$lambda$0(this, arg_0)));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        StackTraceElement[] stackTraceElements = thisCollection$iv.toArray(new StackTraceElement[0]);
        Throwable $this$analyzeFreezeCausingPlugin_u24lambda_u241 = throwable = new Throwable();
        boolean bl = false;
        $this$analyzeFreezeCausingPlugin_u24lambda_u241.setStackTrace(stackTraceElements);
        return PluginUtilImpl.doFindPluginId((Throwable)throwable);
    }

    private final StackTraceElement parseStackTraceElement(String stackTrace) {
        StackTraceElement stackTraceElement;
        MatchResult matchResult = Regex.find$default((Regex)this.stackTracePattern, (CharSequence)((Object)StringsKt.trim((CharSequence)stackTrace)).toString(), (int)0, (int)2, null);
        if (matchResult != null) {
            MatchResult matchResult2 = matchResult;
            boolean bl = false;
            MatchResult.Destructured destructured = matchResult2.getDestructured();
            String className = (String)destructured.getMatch().getGroupValues().get(1);
            String methodName = (String)destructured.getMatch().getGroupValues().get(2);
            String fileName = (String)destructured.getMatch().getGroupValues().get(3);
            String lineNumber = (String)destructured.getMatch().getGroupValues().get(4);
            stackTraceElement = new StackTraceElement(className, methodName, fileName, Integer.parseInt(lineNumber));
        } else {
            stackTraceElement = null;
        }
        return stackTraceElement;
    }

    private static final StackTraceElement analyzeFreezeCausingPlugin$lambda$0(PluginFreezeWatcher this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.parseStackTraceElement(it);
    }

    @JvmStatic
    @NotNull
    public static final PluginFreezeWatcher getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/diagnostic/plugin/freeze/PluginFreezeWatcher$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/diagnostic/plugin/freeze/PluginFreezeWatcher;", "intellij.platform.diagnostic.freezes"})
    @SourceDebugExtension(value={"SMAP\nPluginFreezeWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginFreezeWatcher.kt\ncom/intellij/platform/diagnostic/plugin/freeze/PluginFreezeWatcher$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,81:1\n42#2,3:82\n*S KotlinDebug\n*F\n+ 1 PluginFreezeWatcher.kt\ncom/intellij/platform/diagnostic/plugin/freeze/PluginFreezeWatcher$Companion\n*L\n25#1:82,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PluginFreezeWatcher getInstance() {
            boolean $i$f$service = false;
            Class<PluginFreezeWatcher> serviceClass$iv = PluginFreezeWatcher.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (PluginFreezeWatcher)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

