/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.DuplicatedUniqueNameStrategy;
import org.jetbrains.kotlin.config.KlibConfigurationKeysKt;
import org.jetbrains.kotlin.library.BaseKotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.loader.KlibLoaderResult;
import org.jetbrains.kotlin.library.loader.KlibLoaderResultKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001c\u0010\u0004\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a8\u0006\r"}, d2={"eliminateLibrariesWithDuplicatedUniqueNames", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderResult;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "reportLoadingProblemsIfAny", "", "allAsErrors", "", "loadFriendLibraries", "", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "friendLibraryPaths", "", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nKlibLoaderExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibLoaderExtensions.kt\norg/jetbrains/kotlin/backend/common/KlibLoaderExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1538#2,3:115\n1541#2,3:125\n1651#2:139\n1915#2:140\n1916#2:142\n1652#2:143\n1220#2,2:144\n1249#2,4:146\n1642#2,10:150\n1915#2:160\n1916#2:162\n1652#2:163\n383#3,7:118\n507#3,7:128\n129#4:135\n158#4,3:136\n1#5:141\n1#5:161\n*S KotlinDebug\n*F\n+ 1 KlibLoaderExtensions.kt\norg/jetbrains/kotlin/backend/common/KlibLoaderExtensionsKt\n*L\n32#1:115,3\n32#1:125,3\n98#1:139\n98#1:140\n98#1:142\n98#1:143\n110#1:144,2\n110#1:146,4\n112#1:150,10\n112#1:160\n112#1:162\n112#1:163\n32#1:118,7\n34#1:128,7\n62#1:135\n62#1:136,3\n98#1:141\n112#1:161\n*E\n"})
public final class KlibLoaderExtensionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KlibLoaderResult eliminateLibrariesWithDuplicatedUniqueNames(@NotNull KlibLoaderResult $this$eliminateLibrariesWithDuplicatedUniqueNames, @NotNull CompilerConfiguration configuration) {
        KlibLoaderResult klibLoaderResult;
        Map librariesByUniqueName;
        Object object;
        void $this$groupByTo$iv;
        Intrinsics.checkNotNullParameter((Object)$this$eliminateLibrariesWithDuplicatedUniqueNames, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if ($this$eliminateLibrariesWithDuplicatedUniqueNames.getLibrariesStdlibFirst().isEmpty()) {
            return $this$eliminateLibrariesWithDuplicatedUniqueNames;
        }
        Iterable iterable = $this$eliminateLibrariesWithDuplicatedUniqueNames.getLibrariesStdlibFirst();
        Map destination$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object t : $this$groupByTo$iv) {
            Object object2;
            void $this$getOrPut$iv$iv;
            KotlinLibrary kotlinLibrary = (KotlinLibrary)t;
            boolean bl = false;
            String key$iv = KotlinLibraryKt.getUniqueName((BaseKotlinLibrary)((BaseKotlinLibrary)kotlinLibrary));
            object = destination$iv;
            String key$iv$iv = key$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
            if (value$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                object2 = answer$iv$iv;
            } else {
                object2 = value$iv$iv;
            }
            List list$iv = (List)object2;
            list$iv.add(t);
        }
        Map $this$filterValues$iv = librariesByUniqueName = destination$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            List it = (List)entry.getValue();
            boolean bl = false;
            if (!(it.size() > 1)) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Map librariesWithDuplicatedUniqueNames = result$iv;
        if (librariesWithDuplicatedUniqueNames.isEmpty()) {
            return $this$eliminateLibrariesWithDuplicatedUniqueNames;
        }
        MessageCollector messageCollector = CommonConfigurationKeysKt.getMessageCollector((CompilerConfiguration)configuration);
        DuplicatedUniqueNameStrategy duplicatedUniqueNameStrategy = KlibConfigurationKeysKt.getDuplicatedUniqueNameStrategy((CompilerConfiguration)configuration);
        if (duplicatedUniqueNameStrategy == null) {
            duplicatedUniqueNameStrategy = DuplicatedUniqueNameStrategy.DENY;
        }
        DuplicatedUniqueNameStrategy duplicatedUniqueNameStrategy2 = duplicatedUniqueNameStrategy;
        for (Map.Entry entry : librariesWithDuplicatedUniqueNames.entrySet()) {
            String string = (String)entry.getKey();
            List libraries = (List)entry.getValue();
            String message = "KLIB loader: The same 'unique_name=" + string + "' found in more than one library: " + CollectionsKt.joinToString$default((Iterable)libraries, null, null, null, (int)0, null, KlibLoaderExtensionsKt::eliminateLibrariesWithDuplicatedUniqueNames$lambda$2, (int)31, null);
            if (duplicatedUniqueNameStrategy2 == DuplicatedUniqueNameStrategy.DENY) {
                MessageCollector.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.ERROR, (String)(message + "\nPlease file an issue to https://kotl.in/issue and meanwhile use CLI parameter -Xklib-duplicated-unique-name-strategy with one of the following values:\n" + DuplicatedUniqueNameStrategy.ALLOW_ALL_WITH_WARNING + ": Use all KLIB dependencies, even when they have same 'unique_name' property.\n" + DuplicatedUniqueNameStrategy.ALLOW_FIRST_WITH_WARNING + ": Use the first KLIB dependency with clashing 'unique_name' property. No order guarantees are given though.\n" + DuplicatedUniqueNameStrategy.DENY + ": Fail a compilation with the error."), null, (int)4, null);
                continue;
            }
            MessageCollector.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.STRONG_WARNING, (String)message, null, (int)4, null);
        }
        if (duplicatedUniqueNameStrategy2 == DuplicatedUniqueNameStrategy.ALLOW_FIRST_WITH_WARNING) {
            Map $this$map$iv = librariesByUniqueName;
            boolean bl = false;
            Map map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry $i$f$getOrPut = item$iv$iv = (Map.Entry)object.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add((KotlinLibrary)CollectionsKt.first((List)((List)it.getValue())));
            }
            List list = $this$eliminateLibrariesWithDuplicatedUniqueNames.getProblematicLibraries();
            List list2 = (List)destination$iv$iv;
            klibLoaderResult = new KlibLoaderResult(list2, list);
        } else {
            klibLoaderResult = $this$eliminateLibrariesWithDuplicatedUniqueNames;
        }
        return klibLoaderResult;
    }

    public static final void reportLoadingProblemsIfAny(@NotNull KlibLoaderResult $this$reportLoadingProblemsIfAny, @NotNull CompilerConfiguration configuration, boolean allAsErrors) {
        Intrinsics.checkNotNullParameter((Object)$this$reportLoadingProblemsIfAny, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        MessageCollector messageCollector = CommonConfigurationKeysKt.getMessageCollector((CompilerConfiguration)configuration);
        KlibLoaderResultKt.reportLoadingProblemsIfAny((KlibLoaderResult)$this$reportLoadingProblemsIfAny, (arg_0, arg_1) -> KlibLoaderExtensionsKt.reportLoadingProblemsIfAny$lambda$0(allAsErrors, messageCollector, arg_0, arg_1));
    }

    public static /* synthetic */ void reportLoadingProblemsIfAny$default(KlibLoaderResult klibLoaderResult, CompilerConfiguration compilerConfiguration, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        KlibLoaderExtensionsKt.reportLoadingProblemsIfAny(klibLoaderResult, compilerConfiguration, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinLibrary> loadFriendLibraries(@NotNull KlibLoaderResult $this$loadFriendLibraries, @NotNull List<String> friendLibraryPaths) {
        void $this$mapNotNullTo$iv$iv;
        void $this$associateByTo$iv$iv;
        void destination$iv;
        String rawPath;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)$this$loadFriendLibraries, (String)"<this>");
        Intrinsics.checkNotNullParameter(friendLibraryPaths, (String)"friendLibraryPaths");
        if (friendLibraryPaths.isEmpty() || $this$loadFriendLibraries.getLibrariesStdlibFirst().isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = friendLibraryPaths;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach22 = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            String string;
            block9: {
                Object element$iv = element$iv$iv;
                boolean bl = false;
                rawPath = (String)element$iv;
                boolean bl2 = false;
                if (((CharSequence)rawPath).length() == 0) {
                    string = null;
                } else {
                    String string2;
                    try {
                        string2 = ((Object)Paths.get(rawPath, new String[0]).toRealPath(new LinkOption[0])).toString();
                    }
                    catch (InvalidPathException invalidPathException) {
                        string = null;
                        break block9;
                    }
                    string = string2;
                }
            }
            if (string == null) continue;
            String it$iv = string;
            boolean bl = false;
            destination$iv.add(it$iv);
        }
        Set canonicalFriendLibraryPaths = (Set)destination$iv;
        if (canonicalFriendLibraryPaths.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$associateBy$iv = $this$loadFriendLibraries.getLibrariesStdlibFirst();
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable $i$f$forEach22 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            rawPath = (KotlinLibrary)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getLibraryFile().getPath(), element$iv$iv);
        }
        Map canonicalLibraryPathsToLibraries = destination$iv$iv;
        Iterable $this$mapNotNull$iv = canonicalFriendLibraryPaths;
        boolean $i$f$mapNotNull = false;
        Iterable capacity$iv22 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            KotlinLibrary it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            if ((KotlinLibrary)canonicalLibraryPathsToLibraries.get(it) == null) continue;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private static final CharSequence eliminateLibrariesWithDuplicatedUniqueNames$lambda$2(KotlinLibrary it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getLibraryFile().getPath();
    }

    private static final Unit reportLoadingProblemsIfAny$lambda$0(boolean $allAsErrors, MessageCollector $messageCollector, KlibLoaderResult.ProblemSeverity defaultSeverity, String message) {
        CompilerMessageSeverity compilerMessageSeverity;
        Intrinsics.checkNotNullParameter((Object)defaultSeverity, (String)"defaultSeverity");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if ($allAsErrors) {
            compilerMessageSeverity = CompilerMessageSeverity.ERROR;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[defaultSeverity.ordinal()]) {
                case 1: {
                    compilerMessageSeverity = CompilerMessageSeverity.INFO;
                    break;
                }
                case 2: {
                    compilerMessageSeverity = CompilerMessageSeverity.STRONG_WARNING;
                    break;
                }
                case 3: {
                    compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        CompilerMessageSeverity compilerMessageSeverity2 = compilerMessageSeverity;
        MessageCollector.report$default((MessageCollector)$messageCollector, (CompilerMessageSeverity)compilerMessageSeverity2, (String)message, null, (int)4, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KlibLoaderResult.ProblemSeverity.values().length];
            try {
                nArray[KlibLoaderResult.ProblemSeverity.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KlibLoaderResult.ProblemSeverity.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KlibLoaderResult.ProblemSeverity.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

