/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.export;

import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.components.DiagramNodeContainer;
import com.intellij.diagram.util.DiagramExportService;
import com.intellij.openapi.graph.EdgeRealizerProvider;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.geom.YPoint;
import com.intellij.openapi.graph.geom.YRectangle;
import com.intellij.openapi.graph.services.GraphEdgeRealizerService;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.uml.core.renderers.UmlNoteContainer;
import com.intellij.uml.export.BaseDiagramExporter;
import com.intellij.uml.export.UtilsKt;
import com.intellij.util.io.URLUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u0006H\u0014J\u0014\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u0006H\u0014J \u0010\b\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u00062\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0014J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0002JA\u0010\r\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u00062\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u001f\u0010\u000e\u001a\u001b\u0012\b\u0012\u00060\u0005j\u0002`\u0006\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u000f\u00a2\u0006\u0002\b\u0010H\u0014J(\u0010\u0011\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u00062\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J(\u0010\u0014\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u00062\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J(\u0010\u0017\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u00062\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J6\u0010\u001a\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001dH\u0014J \u0010 \u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u00062\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0014J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020'H\u0002J \u0010(\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u00062\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0014J\u0014\u0010)\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u0006H\u0014J \u0010*\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u00062\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0014J \u0010+\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u00062\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0014JL\u0010,\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u00062\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u0001002\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0014J$\u00107\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u00062\u0006\u00108\u001a\u0002092\u0006\u00105\u001a\u000206H\u0014J$\u0010:\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u00062\u0006\u0010;\u001a\u00020%2\u0006\u0010<\u001a\u00020=H\u0014J\u0010\u0010>\u001a\u00020=2\u0006\u0010?\u001a\u00020@H\u0014\u00a8\u0006A"}, d2={"Lcom/intellij/uml/export/MxgraphExporter;", "Lcom/intellij/uml/export/BaseDiagramExporter;", "<init>", "()V", "appendGraphHeader", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "appendGraphFooter", "appendNodeLayout", "node", "Lcom/intellij/diagram/DiagramNode;", "adjustNodeDimension", "Ljava/awt/Dimension;", "appendNodeFromRenderedContainer", "appendContainer", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "appendNoteLikeContainer", "noteContainer", "Lcom/intellij/uml/core/renderers/UmlNoteContainer;", "appendLabelWithIconLikeContainer", "labelWithIconContainer", "Lcom/intellij/ui/SimpleColoredComponent;", "appendUmlLikeContainer", "umlNodeContainer", "Lcom/intellij/diagram/components/DiagramNodeContainer;", "appendUmlNodeItem", "elementManager", "Lcom/intellij/diagram/DiagramElementManager;", "", "element", "item", "appendEdgeLayout", "edge", "Lcom/intellij/diagram/DiagramEdge;", "getEdgeRealizerPoints", "", "Lcom/intellij/openapi/graph/geom/YPoint;", "realizer", "Lcom/intellij/openapi/graph/view/EdgeRealizer;", "appendEdge", "appendEdgePaintingMode", "appendEdgeLineColor", "appendEdgeLineStyle", "appendEdgeLabel", "label", "Lcom/intellij/diagram/DiagramRelationshipInfo$Label;", "graphLabel", "Lcom/intellij/openapi/graph/view/EdgeLabel;", "labelInd", "", "vLevel", "Lcom/intellij/uml/export/BaseDiagramExporter$VLevel;", "hLevel", "Lcom/intellij/uml/export/BaseDiagramExporter$HLevel;", "appendEdgeArrowType", "arrow", "Lcom/intellij/openapi/graph/view/Arrow;", "appendYPoint", "point", "extraAttributes", "", "generateUrl", "renderedGraph", "Ljava/io/ByteArrayInputStream;", "intellij.diagram.impl"})
@SourceDebugExtension(value={"SMAP\nMxgraphExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MxgraphExporter.kt\ncom/intellij/uml/export/MxgraphExporter\n+ 2 BaseDiagramExporter.kt\ncom/intellij/uml/export/BaseDiagramExporter\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,322:1\n140#2:323\n140#2:325\n140#2:327\n140#2:330\n1#3:324\n1#3:326\n1#3:328\n1#3:329\n1#3:331\n1586#4:332\n1661#4,3:333\n832#4:336\n862#4,2:337\n*S KotlinDebug\n*F\n+ 1 MxgraphExporter.kt\ncom/intellij/uml/export/MxgraphExporter\n*L\n73#1:323\n82#1:325\n92#1:327\n126#1:330\n73#1:324\n82#1:326\n92#1:328\n126#1:331\n177#1:332\n177#1:333,3\n178#1:336\n178#1:337,2\n*E\n"})
public final class MxgraphExporter
extends BaseDiagramExporter {
    @NotNull
    public static final MxgraphExporter INSTANCE = new MxgraphExporter();

    private MxgraphExporter() {
        DiagramExportService.OutputFormat[] outputFormatArray = new DiagramExportService.OutputFormat[]{DiagramExportService.OutputFormat.MX_GRAPH};
        super(outputFormatArray);
    }

    @Override
    @NotNull
    protected Appendable appendGraphHeader(@NotNull Appendable $this$appendGraphHeader) {
        Intrinsics.checkNotNullParameter((Object)$this$appendGraphHeader, (String)"<this>");
        $this$appendGraphHeader.append("<mxGraphModel dx=\"0\" dy=\"0\" grid=\"1\" gridSize=\"10\" guides=\"1\" tooltips=\"1\" connect=\"1\" arrows=\"1\" fold=\"1\" \n              page=\"0\" pageScale=\"1\" background=\"none\" math=\"0\" shadow=\"0\">\n  <root>\n    <mxCell id=\"0\" />\n    <mxCell id=\"1\" parent=\"0\" />").append('\n');
        return $this$appendGraphHeader;
    }

    @Override
    @NotNull
    protected Appendable appendGraphFooter(@NotNull Appendable $this$appendGraphFooter) {
        Intrinsics.checkNotNullParameter((Object)$this$appendGraphFooter, (String)"<this>");
        $this$appendGraphFooter.append("  </root>\n</mxGraphModel>").append('\n');
        return $this$appendGraphFooter;
    }

    @Override
    @NotNull
    protected Appendable appendNodeLayout(@NotNull Appendable $this$appendNodeLayout, @NotNull DiagramNode<?> node) {
        Intrinsics.checkNotNullParameter((Object)$this$appendNodeLayout, (String)"<this>");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Graph2D graph2D = this.getBuilder().getGraph();
        Node node2 = this.getBuilder().getNode(node);
        Intrinsics.checkNotNull((Object)node2);
        NodeRealizer realizer = graph2D.getRealizer(node2);
        int x = MathKt.roundToInt((double)realizer.getX());
        int y = MathKt.roundToInt((double)realizer.getY());
        Dimension dimension = this.adjustNodeDimension(node);
        this.plus(this.plus(this.plus(this.plus(this.plus(this.plus(this.plus(this.plus(this.plus($this$appendNodeLayout, "<mxGeometry x=\""), x), "\" y=\""), y), "\" width=\""), dimension.width), "\" height=\""), dimension.height), "\" as=\"geometry\" />");
        return $this$appendNodeLayout;
    }

    private final Dimension adjustNodeDimension(DiagramNode<?> node) {
        Graph2D graph2D = this.getBuilder().getGraph();
        Node node2 = this.getBuilder().getNode(node);
        Intrinsics.checkNotNull((Object)node2);
        NodeRealizer realizer = graph2D.getRealizer(node2);
        double h = realizer.getHeight();
        double height = node instanceof DiagramNoteNode ? h : (h < 140.0 ? (node.getIconAsText() != null ? h * 1.25 : h * 1.08) : h);
        return new Dimension(MathKt.roundToInt((double)realizer.getWidth()), MathKt.roundToInt((double)height));
    }

    @Override
    @NotNull
    protected Appendable appendNodeFromRenderedContainer(@NotNull Appendable $this$appendNodeFromRenderedContainer, @NotNull DiagramNode<?> node, @NotNull Function1<? super Appendable, ? extends Appendable> appendContainer) {
        Appendable appendable;
        Appendable appendable2;
        Intrinsics.checkNotNullParameter((Object)$this$appendNodeFromRenderedContainer, (String)"<this>");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter(appendContainer, (String)"appendContainer");
        BaseDiagramExporter baseDiagramExporter = this;
        BaseDiagramExporter baseDiagramExporter2 = this;
        Appendable $this$plus$iv = this.plus($this$appendNodeFromRenderedContainer, "<mxCell id=\"");
        boolean $i$f$plus = false;
        Appendable it$iv = appendable2 = $this$plus$iv;
        boolean bl = false;
        MxgraphExporter mxgraphExporter = this;
        MxgraphExporter mxgraphExporter2 = this;
        boolean bl2 = false;
        INSTANCE.appendNodeId($this$appendNodeFromRenderedContainer, node);
        Unit unit = Unit.INSTANCE;
        Appendable $this$plus$iv2 = mxgraphExporter.plus(appendable2, "\" parent=\"1\" vertex=\"1\" ");
        boolean $i$f$plus2 = false;
        Appendable it$iv2 = appendable = $this$plus$iv2;
        $i$a$-also-BaseDiagramExporter$plus$1$iv = false;
        boolean bl3 = false;
        appendContainer.invoke((Object)$this$appendNodeFromRenderedContainer);
        mxgraphExporter2.plus(appendable, ">\n");
        this.appendNodeLayout($this$appendNodeFromRenderedContainer, node);
        $this$appendNodeFromRenderedContainer.append('\n');
        $this$appendNodeFromRenderedContainer.append("</mxCell>").append('\n');
        return $this$appendNodeFromRenderedContainer;
    }

    @Override
    @NotNull
    protected Appendable appendNoteLikeContainer(@NotNull Appendable $this$appendNoteLikeContainer, @NotNull DiagramNode<?> node, @NotNull UmlNoteContainer noteContainer) {
        Appendable appendable;
        Intrinsics.checkNotNullParameter((Object)$this$appendNoteLikeContainer, (String)"<this>");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)noteContainer, (String)"noteContainer");
        String string = noteContainer.getNoteNode().getNoteText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNoteText(...)");
        String noteText = this.escapeXmlEntities(string);
        BaseDiagramExporter baseDiagramExporter = this;
        Appendable $this$plus$iv = this.plus($this$appendNoteLikeContainer, "value=\"");
        boolean $i$f$plus = false;
        Appendable it$iv = appendable = $this$plus$iv;
        boolean bl = false;
        MxgraphExporter mxgraphExporter = this;
        boolean bl2 = false;
        $this$appendNoteLikeContainer.append(noteText);
        mxgraphExporter.plus(appendable, "\"\n");
        $this$appendNoteLikeContainer.append("style=\"shape=note;size=20;whiteSpace=wrap;html=1;verticalAlign=top;align=left;\"");
        return $this$appendNoteLikeContainer;
    }

    @Override
    @NotNull
    protected Appendable appendLabelWithIconLikeContainer(@NotNull Appendable $this$appendLabelWithIconLikeContainer, @NotNull DiagramNode<?> node, @NotNull SimpleColoredComponent labelWithIconContainer) {
        Appendable appendable;
        Intrinsics.checkNotNullParameter((Object)$this$appendLabelWithIconLikeContainer, (String)"<this>");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)labelWithIconContainer, (String)"labelWithIconContainer");
        String string = labelWithIconContainer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String titleText = this.escapeXmlEntities(string);
        BaseDiagramExporter baseDiagramExporter = this;
        Appendable $this$plus$iv = this.plus($this$appendLabelWithIconLikeContainer, "value=\"");
        boolean $i$f$plus = false;
        Appendable it$iv = appendable = $this$plus$iv;
        boolean bl = false;
        MxgraphExporter mxgraphExporter = this;
        boolean bl2 = false;
        $this$appendLabelWithIconLikeContainer.append(titleText);
        mxgraphExporter.plus(appendable, "\"\n");
        $this$appendLabelWithIconLikeContainer.append("style=\"label;fontStyle=0;strokeColor=default;fillColor=none;align=left;verticalAlign=middle;overflow=hidden;spacingLeft=28;spacingRight=4;rotatable=0;points=[[0,0.5],[1,0.5]];portConstraint=eastwest;");
        Appendable appendable2 = $this$appendLabelWithIconLikeContainer.append("imageWidth=16;imageHeight=16;image=");
        Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(...)");
        this.appendIconAsBase64(appendable2, labelWithIconContainer.getIcon()).append("\"");
        return $this$appendLabelWithIconLikeContainer;
    }

    @Override
    @NotNull
    protected Appendable appendUmlLikeContainer(@NotNull Appendable $this$appendUmlLikeContainer, @NotNull DiagramNode<?> node, @NotNull DiagramNodeContainer umlNodeContainer) {
        Appendable appendable;
        Object object;
        List items;
        Object element;
        DiagramElementManager<?> elementManager;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)$this$appendUmlLikeContainer, (String)"<this>");
                Intrinsics.checkNotNullParameter(node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)((Object)umlNodeContainer), (String)"umlNodeContainer");
                DiagramElementManager<?> diagramElementManager = this.getBuilder().getProvider().getElementManager();
                Intrinsics.checkNotNull(diagramElementManager, (String)"null cannot be cast to non-null type com.intellij.diagram.DiagramElementManager<kotlin.Any>");
                elementManager = diagramElementManager;
                Object obj = node.getIdentifyingElement();
                Intrinsics.checkNotNullExpressionValue(obj, (String)"getIdentifyingElement(...)");
                element = obj;
                Object[] objectArray = DiagramElementManager.getNodeItemsAccordingToCurrentContentSettings(node, this.getBuilder());
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getNodeItemsAccordingToCurrentContentSettings(...)");
                items = ArraysKt.toList((Object[])objectArray);
                object = node.getIconAsText();
                if (object == null) break block4;
                SimpleColoredText it = object;
                boolean bl = false;
                String string = it.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String string2 = "<i>" + INSTANCE.escapeXmlEntities(string) + "</i><br/>";
                object = string2;
                if (string2 != null) break block5;
            }
            object = "";
        }
        Object elementTypeHtml = object;
        Object object2 = new StringBuilder();
        StringBuilder $this$appendUmlLikeContainer_u24lambda_u241 = object2;
        boolean bl = false;
        INSTANCE.plus(INSTANCE.plus((Appendable)$this$appendUmlLikeContainer_u24lambda_u241, "<p style=\"margin:0px;margin-top:4px;text-align:center;\">"), (String)elementTypeHtml);
        Appendable appendable2 = INSTANCE.plus((Appendable)$this$appendUmlLikeContainer_u24lambda_u241, "<b>");
        Object object3 = node.getPresentableTitle();
        if (object3 == null || (object3 = object3.toString()) == null) {
            object3 = "";
        }
        INSTANCE.plus(INSTANCE.plus(appendable2, (String)object3), "</b></p>");
        INSTANCE.plus((Appendable)$this$appendUmlLikeContainer_u24lambda_u241, "<hr size=\"1\"/>");
        CollectionsKt.joinTo$default((Iterable)UtilsKt.split(items, null), (Appendable)$this$appendUmlLikeContainer_u24lambda_u241, (CharSequence)"<hr size=\"1\"/>", null, null, (int)0, null, arg_0 -> MxgraphExporter.appendUmlLikeContainer$lambda$1$0($this$appendUmlLikeContainer_u24lambda_u241, elementManager, element, arg_0), (int)60, null);
        String umlContainerHtml = ((StringBuilder)object2).toString();
        object2 = this;
        Appendable $this$plus$iv = this.plus($this$appendUmlLikeContainer, "value=\"");
        boolean $i$f$plus = false;
        Appendable it$iv = appendable = $this$plus$iv;
        boolean bl2 = false;
        MxgraphExporter mxgraphExporter = this;
        boolean bl3 = false;
        $this$appendUmlLikeContainer.append(INSTANCE.escapeXmlEntities(umlContainerHtml));
        mxgraphExporter.plus(appendable, "\"\n");
        $this$appendUmlLikeContainer.append("style=\"verticalAlign=top;align=left;overflow=fill;fontSize=14;fontFamily=Helvetica;html=1;rounded=0;shadow=0;comic=0;labelBackgroundColor=none;strokeWidth=1;\"");
        return $this$appendUmlLikeContainer;
    }

    @Override
    @NotNull
    protected Appendable appendUmlNodeItem(@NotNull Appendable $this$appendUmlNodeItem, @NotNull DiagramElementManager<Object> elementManager, @Nullable Object element, @Nullable Object item) {
        Object object;
        Object itemText;
        Object object2;
        Object iconText;
        Intrinsics.checkNotNullParameter((Object)$this$appendUmlNodeItem, (String)"<this>");
        Intrinsics.checkNotNullParameter(elementManager, (String)"elementManager");
        Object object3 = elementManager.getItemIconAsText(element, item, this.getBuilder());
        if (object3 == null || (object3 = object3.toString()) == null || (object3 = this.escapeXmlEntities((String)object3)) == null) {
            object3 = iconText = "";
        }
        if ((object2 = elementManager.getItemName(element, item, this.getBuilder())) == null || (object2 = object2.toString()) == null || (object2 = this.escapeXmlEntities((String)object2)) == null) {
            object2 = itemText = "";
        }
        if ((object = elementManager.getItemType(element, item, this.getBuilder())) == null || (object = object.toString()) == null || (object = this.escapeXmlEntities((String)object)) == null) {
            object = "";
        }
        Object typeText = object;
        return this.plus(this.plus(this.plus(this.plus(this.plus($this$appendUmlNodeItem, (String)iconText), " "), (String)itemText), ": "), (String)typeText);
    }

    @Override
    @NotNull
    protected Appendable appendEdgeLayout(@NotNull Appendable $this$appendEdgeLayout, @NotNull DiagramEdge<?> edge) {
        Intrinsics.checkNotNullParameter((Object)$this$appendEdgeLayout, (String)"<this>");
        Intrinsics.checkNotNullParameter(edge, (String)"edge");
        Graph2D graph2D = this.getBuilder().getGraph();
        Intrinsics.checkNotNullExpressionValue((Object)graph2D, (String)"getGraph(...)");
        Graph2D graph = graph2D;
        Edge edge2 = this.getBuilder().getEdge(edge);
        Intrinsics.checkNotNull((Object)edge2);
        Edge graphEdge = edge2;
        EdgeRealizer realizer = graph.getRealizer(graphEdge);
        Rectangle2D.Double sourceBoundingBox = realizer.getSourceRealizer().getBoundingBox();
        Rectangle2D.Double targetBoundingBox = realizer.getTargetRealizer().getBoundingBox();
        Point2D sourcePort = realizer.getSourceIntersection();
        double sourcePortOffsetX = Math.abs((sourcePort.getX() - sourceBoundingBox.x) / sourceBoundingBox.width);
        double sourcePortOffsetY = Math.abs((sourcePort.getY() - sourceBoundingBox.y) / sourceBoundingBox.height);
        Point2D targetPort = realizer.getTargetIntersection();
        double targetPortOffsetX = Math.abs((targetPort.getX() - targetBoundingBox.x) / targetBoundingBox.width);
        double targetPortOffsetY = Math.abs((targetPort.getY() - targetBoundingBox.y) / targetBoundingBox.height);
        $this$appendEdgeLayout.append("exitX=" + MxgraphExporter.appendEdgeLayout$render(sourcePortOffsetX) + ";exitY=" + MxgraphExporter.appendEdgeLayout$render(sourcePortOffsetY) + ";exitDx=0;exitDy=0;");
        $this$appendEdgeLayout.append("entryX=" + MxgraphExporter.appendEdgeLayout$render(targetPortOffsetX) + ";entryY=" + MxgraphExporter.appendEdgeLayout$render(targetPortOffsetY) + ";entryDx=0;entryDy=0;\">\n");
        $this$appendEdgeLayout.append("<mxGeometry width=\"50\" height=\"50\" relative=\"1\" as=\"geometry\">").append('\n');
        Intrinsics.checkNotNull((Object)realizer);
        CollectionsKt.joinTo$default((Iterable)this.getEdgeRealizerPoints(realizer), (Appendable)$this$appendEdgeLayout, (CharSequence)"\n", (CharSequence)"<Array as=\"points\">\n", (CharSequence)"</Array>\n", (int)0, null, arg_0 -> MxgraphExporter.appendEdgeLayout$lambda$0($this$appendEdgeLayout, arg_0), (int)48, null);
        $this$appendEdgeLayout.append("</mxGeometry>").append('\n');
        return $this$appendEdgeLayout;
    }

    /*
     * WARNING - void declaration
     */
    private final List<YPoint> getEdgeRealizerPoints(EdgeRealizer realizer) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)realizer.pointCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(realizer.getPoint((int)it));
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            YPoint it = (YPoint)element$iv$iv;
            boolean bl = false;
            if (realizer.getSourceRealizer().contains(it.getX(), it.getY()) || realizer.getTargetRealizer().contains(it.getX(), it.getY())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    protected Appendable appendEdge(@NotNull Appendable $this$appendEdge, @NotNull DiagramEdge<?> edge) {
        Intrinsics.checkNotNullParameter((Object)$this$appendEdge, (String)"<this>");
        Intrinsics.checkNotNullParameter(edge, (String)"edge");
        Graph2D graph2D = this.getBuilder().getGraph();
        Edge edge2 = this.getBuilder().getEdge(edge);
        Intrinsics.checkNotNull((Object)edge2);
        EdgeRealizer realizer = graph2D.getRealizer(edge2);
        Appendable appendable = $this$appendEdge.append("<mxCell id=\"");
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        this.appendEdgeId(appendable, edge).append("\" edge=\"1\" value=\"\" parent=\"1\" ");
        Appendable appendable2 = $this$appendEdge.append("source=\"");
        Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(...)");
        DiagramNode<?> diagramNode = edge.getSource();
        Intrinsics.checkNotNullExpressionValue(diagramNode, (String)"getSource(...)");
        Appendable appendable3 = this.appendNodeId(appendable2, diagramNode).append("\" target=\"");
        Intrinsics.checkNotNullExpressionValue((Object)appendable3, (String)"append(...)");
        DiagramNode<?> diagramNode2 = edge.getTarget();
        Intrinsics.checkNotNullExpressionValue(diagramNode2, (String)"getTarget(...)");
        Appendable appendable4 = this.appendNodeId(appendable3, diagramNode2);
        appendable4.append("\"").append('\n');
        $this$appendEdge.append("style=\"html=1;");
        this.appendEdgePaintingMode($this$appendEdge).append(";");
        this.appendEdgeLineStyle($this$appendEdge, edge).append(";");
        Arrow arrow = realizer.getSourceArrow();
        Intrinsics.checkNotNullExpressionValue((Object)arrow, (String)"getSourceArrow(...)");
        this.appendEdgeArrowType($this$appendEdge, arrow, BaseDiagramExporter.HLevel.SOURCE).append(";");
        Arrow arrow2 = realizer.getTargetArrow();
        Intrinsics.checkNotNullExpressionValue((Object)arrow2, (String)"getTargetArrow(...)");
        this.appendEdgeArrowType($this$appendEdge, arrow2, BaseDiagramExporter.HLevel.TARGET).append(";");
        this.appendEdgeLineColor($this$appendEdge, edge).append(";");
        this.appendEdgeLayout($this$appendEdge, edge);
        $this$appendEdge.append("</mxCell>").append('\n');
        this.appendEdgeLabels($this$appendEdge, edge);
        return $this$appendEdge;
    }

    @Override
    @NotNull
    protected Appendable appendEdgePaintingMode(@NotNull Appendable $this$appendEdgePaintingMode) {
        Intrinsics.checkNotNullParameter((Object)$this$appendEdgePaintingMode, (String)"<this>");
        String isOrthogonal = GraphLayoutService.getInstance().doesImplyOrthogonalEdgeRouting(this.getBuilder().getPresentationModel().getSettings().getCurrentLayouter()) ? "edgeStyle=orthogonalEdgeStyle" : "";
        EdgeRealizerProvider edgeRealizerProvider = this.getBuilder().getPresentationModel().getSettings().getCurrentEdgeRealizerProvider();
        String curveStyle = Intrinsics.areEqual((Object)edgeRealizerProvider, (Object)GraphEdgeRealizerService.getInstance().getArcEdgeRealizerProvider()) ? "curved=1" : (Intrinsics.areEqual((Object)edgeRealizerProvider, (Object)GraphEdgeRealizerService.getInstance().getBezierEdgeRealizerProvider()) ? "curved=1" : (Intrinsics.areEqual((Object)edgeRealizerProvider, (Object)GraphEdgeRealizerService.getInstance().getSplineEdgeRealizerProvider()) ? "curved=1" : (Intrinsics.areEqual((Object)edgeRealizerProvider, (Object)GraphEdgeRealizerService.getInstance().getQuadCurveEdgeRealizerProvider()) ? "curved=1" : (Intrinsics.areEqual((Object)edgeRealizerProvider, (Object)GraphEdgeRealizerService.getInstance().getStraightPolylineEdgeRealizerProvider()) ? "rounded=0" : (Intrinsics.areEqual((Object)edgeRealizerProvider, (Object)GraphEdgeRealizerService.getInstance().getSmoothedPolylineEdgeRealizerProvider()) ? "rounded=1" : "rounded=0")))));
        return this.plus(this.plus(this.plus($this$appendEdgePaintingMode, curveStyle), ';'), isOrthogonal);
    }

    @Override
    @NotNull
    protected Appendable appendEdgeLineColor(@NotNull Appendable $this$appendEdgeLineColor, @NotNull DiagramEdge<?> edge) {
        Intrinsics.checkNotNullParameter((Object)$this$appendEdgeLineColor, (String)"<this>");
        Intrinsics.checkNotNullParameter(edge, (String)"edge");
        Appendable appendable = this.plus($this$appendEdgeLineColor, "strokeColor=");
        String string = ColorUtil.toHtmlColor((Color)this.resolveEdgeColor(edge));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHtmlColor(...)");
        return this.plus(appendable, string);
    }

    @Override
    @NotNull
    protected Appendable appendEdgeLineStyle(@NotNull Appendable $this$appendEdgeLineStyle, @NotNull DiagramEdge<?> edge) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$appendEdgeLineStyle, (String)"<this>");
        Intrinsics.checkNotNullParameter(edge, (String)"edge");
        EdgeRealizer realizer = this.getBuilder().getGraph().getRealizer(this.getBuilder().getEdge(edge));
        byte by = realizer.getLineType().getLineStyle();
        if (by == LineType.LINE_STYLE) {
            string = "dashed=0";
        } else if (by == LineType.DASHED_STYLE) {
            string = "dashed=1";
        } else if (by == LineType.DOTTED_STYLE) {
            string = "dashed=1;dashPattern=1 1";
        } else if (by == LineType.DASHED_DOTTED_STYLE) {
            string = "dashed=1;dashPattern=1 4";
        } else {
            throw new IllegalStateException(("Unknown line style " + realizer.getLineType().getLineStyle()).toString());
        }
        String renderedEdgeLineStyle = string;
        $this$appendEdgeLineStyle.append(renderedEdgeLineStyle);
        return $this$appendEdgeLineStyle;
    }

    @Override
    @NotNull
    protected Appendable appendEdgeLabel(@NotNull Appendable $this$appendEdgeLabel, @Nullable DiagramRelationshipInfo.Label label, @Nullable EdgeLabel graphLabel, @NotNull DiagramEdge<?> edge, int labelInd, @NotNull BaseDiagramExporter.VLevel vLevel, @NotNull BaseDiagramExporter.HLevel hLevel) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$appendEdgeLabel, (String)"<this>");
                Intrinsics.checkNotNullParameter(edge, (String)"edge");
                Intrinsics.checkNotNullParameter((Object)((Object)vLevel), (String)"vLevel");
                Intrinsics.checkNotNullParameter((Object)((Object)hLevel), (String)"hLevel");
                if (label == null || graphLabel == null) break block2;
                String string = label.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!StringsKt.isBlank((CharSequence)string)) break block3;
            }
            return $this$appendEdgeLabel;
        }
        YRectangle labelPos = graphLabel.getBox();
        String string = label.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String labelText = this.escapeXmlEntities(this.removeHtmlTags(string));
        Appendable appendable = $this$appendEdgeLabel.append("<mxCell id=\"");
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        Appendable appendable2 = this.appendLabelId(appendable, labelInd).append("\" parent=\"");
        Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(...)");
        this.appendEdgeId(appendable2, edge).append("\" ");
        $this$appendEdgeLabel.append("vertex=\"1\" connectable=\"0\" value=\"").append(labelText).append("\" ");
        $this$appendEdgeLabel.append("style=\"edgeLabel;resizable=0;html=1;align=left;verticalAlign=top;strokeColor=default;\">");
        this.plus(this.plus(this.plus(this.plus(this.plus($this$appendEdgeLabel, "<mxGeometry x=\""), MathKt.roundToInt((double)labelPos.getX())), "\" y=\""), MathKt.roundToInt((double)labelPos.getY())), "\" as=\"geometry\" />");
        $this$appendEdgeLabel.append("</mxCell>").append('\n');
        return $this$appendEdgeLabel;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    protected Appendable appendEdgeArrowType(@NotNull Appendable $this$appendEdgeArrowType, @NotNull Arrow arrow, @NotNull BaseDiagramExporter.HLevel hLevel) {
        block18: {
            block16: {
                Intrinsics.checkNotNullParameter((Object)$this$appendEdgeArrowType, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)arrow, (String)"arrow");
                Intrinsics.checkNotNullParameter((Object)hLevel, (String)"hLevel");
                prefix = hLevel == BaseDiagramExporter.HLevel.TARGET ? "end" : "start";
                doNotFill = prefix + "Fill=0";
                size = prefix + "Size";
                var8_7 = arrow.getType();
                if (var8_7 != Arrow.CUSTOM_TYPE) break block16;
                var9_8 = arrow.getCustomName();
                if (var9_8 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var9_8.hashCode()) {
                    case -470453177: {
                        if (var9_8.equals("InnerClassArrow")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 890961996: {
                        if (var9_8.equals("MyWhiteArrow")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 1068565754: {
                        if (var9_8.equals("DeltaSmallArrow")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case -1997901034: {
                        if (var9_8.equals("AngleArrow")) {
                            tmp = 4;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        v0 = "circlePlus;" + doNotFill;
                        break;
                    }
                    case 3: {
                        v0 = "blockThin;" + size + "=12";
                        break;
                    }
                    case 2: {
                        v0 = "block;" + size + "=12;" + doNotFill;
                        break;
                    }
                    case 4: {
                        v0 = "openThin;" + size + "=12";
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        v0 = "classic;" + size + "=12";
                        break;
                    }
                }
                break block18;
            }
            v0 = var8_7 == Arrow.NONE_TYPE ? "none" : (var8_7 == Arrow.STANDARD_TYPE ? "classic;" + size + "=12" : (var8_7 == Arrow.DELTA_TYPE ? "block;" + size + "=12" : (var8_7 == Arrow.WHITE_DELTA_TYPE ? "block;" + size + "=12;" + doNotFill : (var8_7 == Arrow.DIAMOND_TYPE ? "diamondThin" + size + "=12" : (var8_7 == Arrow.WHITE_DIAMOND_TYPE ? "diamondThin;" + size + "=12;" + doNotFill : (var8_7 == Arrow.SHORT_TYPE ? "classic;" + size + "=12" : (var8_7 == Arrow.PLAIN_TYPE ? "open;" + size + "=12" : (var8_7 == Arrow.CONCAVE_TYPE ? "openThin;" + size + "=12" : (var8_7 == Arrow.CONVEX_TYPE ? "open;" + size + "=12" : (var8_7 == Arrow.CIRCLE_TYPE ? "oval" : (var8_7 == Arrow.TRANSPARENT_CIRCLE_TYPE ? "oval;" + doNotFill : (var8_7 == Arrow.DASH_TYPE ? "ERone" : (var8_7 == Arrow.SKEWED_DASH_TYPE ? "dash" : (var8_7 == Arrow.T_SHAPE_TYPE ? "baseDash" : (var8_7 == Arrow.CROWS_FOOT_ONE_MANDATORY_TYPE ? "ERmandOne" : (var8_7 == Arrow.CROWS_FOOT_MANY_MANDATORY_TYPE ? "ERoneToMany" : (var8_7 == Arrow.CROWS_FOOT_ONE_OPTIONAL_TYPE ? "ERzeroToOne" : (var8_7 == Arrow.CROWS_FOOT_MANY_OPTIONAL_TYPE ? "ERzeroToMany" : (var8_7 == Arrow.CROWS_FOOT_ONE_TYPE ? "ERone" : (var8_7 == Arrow.CROWS_FOOT_MANY_TYPE ? "ERmany" : (var8_7 == Arrow.CROWS_FOOT_OPTIONAL_TYPE ? "circle;" + doNotFill : "classic;" + size + "=12")))))))))))))))))))));
        }
        renderedArrowType = v0;
        $this$appendEdgeArrowType.append(prefix).append("Arrow=").append(renderedArrowType);
        return $this$appendEdgeArrowType;
    }

    @Override
    @NotNull
    protected Appendable appendYPoint(@NotNull Appendable $this$appendYPoint, @NotNull YPoint point, @NotNull String extraAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$appendYPoint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)extraAttributes, (String)"extraAttributes");
        return this.plus(this.plus(this.plus(this.plus(this.plus(this.plus(this.plus($this$appendYPoint, "<mxPoint x=\""), MathKt.roundToInt((double)point.getX())), "\" y=\""), MathKt.roundToInt((double)point.getY())), "\" "), extraAttributes), " />");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected String generateUrl(@NotNull ByteArrayInputStream renderedGraph) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)renderedGraph, (String)"renderedGraph");
        byte[] byArray2 = renderedGraph.readAllBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"readAllBytes(...)");
        byte[] byArray3 = byArray2;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Object object = charset;
        String raw = new String(byArray3, (Charset)object);
        object = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            byte[] byArray4;
            ByteArrayOutputStream output = (ByteArrayOutputStream)object;
            boolean bl = false;
            Closeable closeable = new DeflaterOutputStream((OutputStream)output, new Deflater(9, true));
            Throwable throwable2 = null;
            try {
                DeflaterOutputStream compression = (DeflaterOutputStream)closeable;
                boolean bl2 = false;
                byte[] byArray5 = raw.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"getBytes(...)");
                compression.write(byArray5);
                compression.finish();
                byArray4 = output.toByteArray();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            byArray = byArray4;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        byte[] deflated = byArray;
        return "https://app.diagrams.net/?&highlight=0000ff&edit=_blank&layers=1&nav=1&title=exported_from_idea.drawio#R" + URLUtil.encodeURIComponent((String)Base64.getEncoder().encodeToString(deflated));
    }

    private static final CharSequence appendUmlLikeContainer$lambda$1$0$0(StringBuilder $this_buildString, DiagramElementManager $elementManager, Object $element, Object item) {
        INSTANCE.appendUmlNodeItem($this_buildString, $elementManager, $element, item);
        return "";
    }

    private static final CharSequence appendUmlLikeContainer$lambda$1$0(StringBuilder $this_buildString, DiagramElementManager $elementManager, Object $element, List group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        CollectionsKt.joinTo$default((Iterable)group, (Appendable)$this_buildString, (CharSequence)"<br/>", (CharSequence)"<p style=\"margin:0 0 0 4px;line-height:1.6;\">", (CharSequence)"</p>", (int)0, null, arg_0 -> MxgraphExporter.appendUmlLikeContainer$lambda$1$0$0($this_buildString, $elementManager, $element, arg_0), (int)48, null);
        return "";
    }

    private static final String appendEdgeLayout$render(double d) {
        String string = "%.3f";
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{d};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final CharSequence appendEdgeLayout$lambda$0(Appendable $this_appendEdgeLayout, YPoint it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BaseDiagramExporter.appendYPoint$default(INSTANCE, $this_appendEdgeLayout, it, null, 2, null);
        return "";
    }
}

