/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion.logger;

import com.intellij.stats.completion.logger.FileLogger;
import com.intellij.stats.completion.logger.LineStorage;
import com.intellij.stats.completion.network.UtilsKt;
import com.intellij.stats.completion.storage.FilePathProvider;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/stats/completion/logger/LogFileManager;", "Lcom/intellij/stats/completion/logger/FileLogger;", "filePathProvider", "Lcom/intellij/stats/completion/storage/FilePathProvider;", "chunkSizeLimit", "", "<init>", "(Lcom/intellij/stats/completion/storage/FilePathProvider;I)V", "storage", "Lcom/intellij/stats/completion/logger/LineStorage;", "printLines", "", "lines", "", "", "flush", "flushImpl", "saveDataChunk", "Companion", "intellij.statsCollector"})
public final class LogFileManager
implements FileLogger {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final FilePathProvider filePathProvider;
    private final int chunkSizeLimit;
    @NotNull
    private LineStorage storage;
    @Deprecated
    public static final int MAX_CHUNK_SIZE = 30720;

    public LogFileManager(@NotNull FilePathProvider filePathProvider, int chunkSizeLimit) {
        Intrinsics.checkNotNullParameter((Object)filePathProvider, (String)"filePathProvider");
        this.filePathProvider = filePathProvider;
        this.chunkSizeLimit = chunkSizeLimit;
        this.storage = new LineStorage();
    }

    public /* synthetic */ LogFileManager(FilePathProvider filePathProvider, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 30720;
        }
        this(filePathProvider, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printLines(@NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        LogFileManager logFileManager = this;
        synchronized (logFileManager) {
            boolean bl = false;
            for (String line : lines) {
                this.storage.appendLine(line);
            }
            if (this.storage.getSize() > this.chunkSizeLimit) {
                this.flushImpl();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        LogFileManager logFileManager = this;
        synchronized (logFileManager) {
            boolean bl = false;
            if (this.storage.getSize() > 0) {
                this.flushImpl();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void flushImpl() {
        this.saveDataChunk(this.storage);
        this.filePathProvider.cleanupOldFiles();
        this.storage = new LineStorage();
    }

    private final void saveDataChunk(LineStorage storage) {
        UtilsKt.assertNotEDT();
        File dir = this.filePathProvider.getStatsDataDirectory();
        File tmp = new File(dir, "tmp_data.gz");
        storage.dump(tmp);
        tmp.renameTo(this.filePathProvider.getUniqueFile());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/stats/completion/logger/LogFileManager$Companion;", "", "<init>", "()V", "MAX_CHUNK_SIZE", "", "intellij.statsCollector"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

