/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.base.BaseGridHelper;
import com.intellij.database.extractors.JsonUtilKt;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.Version;
import com.intellij.lang.Language;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/redis/RedisGridHelper;", "Lcom/intellij/database/dialects/base/BaseGridHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getCellLanguage", "Lcom/intellij/lang/Language;", "grid", "Lcom/intellij/database/datagrid/CoreGrid;", "Lcom/intellij/database/datagrid/GridRow;", "Lcom/intellij/database/datagrid/GridColumn;", "row", "Lcom/intellij/database/datagrid/ModelIndex;", "column", "isSortingApplicable", "", "intellij.database.dialects.redis"})
@SourceDebugExtension(value={"SMAP\nRedisGridHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisGridHelper.kt\ncom/intellij/database/dialects/redis/RedisGridHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,27:1\n1#2:28\n*E\n"})
public final class RedisGridHelper
extends BaseGridHelper {
    public RedisGridHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Nullable
    public Language getCellLanguage(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        Object value;
        boolean isTextColumn;
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        GridColumn gridColumn = (GridColumn)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(column);
        if (gridColumn == null) {
            return null;
        }
        GridColumn c = gridColumn;
        DbDataSource dbDataSource = DataGridUtilCore.getDatabaseSystem(grid);
        Version version = dbDataSource != null ? dbDataSource.getVersion() : null;
        DomainRegistry domainRegistry = BaseDomainRegistry.get((Dbms)this.getDbms(), (Version)version);
        Intrinsics.checkNotNullExpressionValue((Object)domainRegistry, (String)"get(...)");
        DomainRegistry registry = domainRegistry;
        Domain domain = registry.getDomain((ColumnDescriptor)c);
        if (domain != null) {
            Domain it = domain;
            boolean bl = false;
            v4 = LogicalType.isText((LogicalType)it.getLogicType());
        } else {
            v4 = isTextColumn = Intrinsics.areEqual((Object)c.getTypeName(), (Object)"string");
        }
        if (isTextColumn && (value = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(row, column)) instanceof String && JsonUtilKt.isJsonString((String)((String)value))) {
            return Language.findLanguageByID((String)"JSON5");
        }
        return super.getCellLanguage(grid, row, column);
    }

    public boolean isSortingApplicable() {
        return false;
    }
}

