/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra.introspector;

import com.google.gson.JsonObject;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.base.introspector.NameCache;
import com.intellij.database.dialects.cassandra.generator.producers.CassTableProducersKt;
import com.intellij.database.dialects.cassandra.introspector.CassIntroQueries;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector$CassSchemaRetriever$retrieveColumns$;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector$CassSchemaRetriever$retrieveDefTypes$;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector$applySchemas$lambda$0$;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospectorHelperKt;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospectorKt;
import com.intellij.database.dialects.cassandra.model.CassAggregate;
import com.intellij.database.dialects.cassandra.model.CassArgument;
import com.intellij.database.dialects.cassandra.model.CassDefType;
import com.intellij.database.dialects.cassandra.model.CassDefTypeAttribute;
import com.intellij.database.dialects.cassandra.model.CassFunction;
import com.intellij.database.dialects.cassandra.model.CassIndex;
import com.intellij.database.dialects.cassandra.model.CassKey;
import com.intellij.database.dialects.cassandra.model.CassLikeTable;
import com.intellij.database.dialects.cassandra.model.CassMatView;
import com.intellij.database.dialects.cassandra.model.CassMatViewColumn;
import com.intellij.database.dialects.cassandra.model.CassRole;
import com.intellij.database.dialects.cassandra.model.CassRoot;
import com.intellij.database.dialects.cassandra.model.CassRoutine;
import com.intellij.database.dialects.cassandra.model.CassSchema;
import com.intellij.database.dialects.cassandra.model.CassTable;
import com.intellij.database.dialects.cassandra.model.CassTableColumn;
import com.intellij.database.dialects.cassandra.model.CassTrigger;
import com.intellij.database.dialects.cassandra.model.defaults.CassSchemaPropertyKind;
import com.intellij.database.dialects.cassandra.model.defaults.CassTablePropertyKind;
import com.intellij.database.dialects.cassandra.model.properties.CassKeyColumn;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.query.PreprocessedQuery;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ElementCacheKt;
import com.intellij.database.model.ElementCacheOptimizersKt;
import com.intellij.database.model.ElementChecker;
import com.intellij.database.model.ElementSearchCache;
import com.intellij.database.model.ElementSearcher;
import com.intellij.database.model.ElementSearcherNN;
import com.intellij.database.model.FamilySearcher;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.IndexColumn;
import com.intellij.database.model.properties.Level;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.remote.jdbc.RemoteCassConnection;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.rmi.NoSuchObjectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002'(B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ4\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u00020\u000bR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u001c\u0010\u0010\u001a\u00060\u0011R\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0003H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0014J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0016J \u0010\u001e\u001a\u00020\u00142\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\b\u0010\"\u001a\u0004\u0018\u00010\u001aH\u0002J&\u0010#\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030 2\u0006\u0010%\u001a\u00020\u0018H\u0014J\u0018\u0010&\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0003H\u0002\u00a8\u0006)"}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/cassandra/model/CassRoot;", "Lcom/intellij/database/dialects/cassandra/model/CassSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever;", "schema", "introspectNamespacesInTran", "", "tran", "introspectServerObjectsInner", "hasSelectPrivilege", "", "tableName", "", "retrieveRoles22", "retrieveRoles21", "retrieveAndApplySchemas", "applySchemas", "newSchemas", "", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneSchema;", "currentSchema", "introspectSchemasAuto", "schemas", "whole", "introspectOneSchema", "Factory", "CassSchemaRetriever", "intellij.database.dialects.cassandra"})
@SourceDebugExtension(value={"SMAP\nCassIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CassIntrospector.kt\ncom/intellij/database/dialects/cassandra/introspector/CassIntrospector\n+ 2 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ModelFun.kt\ncom/intellij/database/model/ModelFun\n+ 5 ElementCache.kt\ncom/intellij/database/model/FamilySearcher\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,577:1\n179#2,4:578\n183#2,3:584\n179#2,4:587\n183#2,3:593\n1915#3,2:582\n1915#3,2:591\n1915#3:625\n1916#3:639\n443#4,10:596\n453#4,9:616\n462#4:626\n454#4:627\n455#4,9:630\n464#4,3:640\n456#4:643\n457#4:645\n189#5,10:606\n202#5:644\n1#6:628\n1#6:629\n*S KotlinDebug\n*F\n+ 1 CassIntrospector.kt\ncom/intellij/database/dialects/cassandra/introspector/CassIntrospector\n*L\n90#1:578,4\n90#1:584,3\n105#1:587,4\n105#1:593,3\n91#1:582,2\n106#1:591,2\n123#1:625\n123#1:639\n123#1:596,10\n123#1:616,9\n123#1:626\n123#1:627\n123#1:630,9\n123#1:640,3\n123#1:643\n123#1:645\n123#1:606,10\n123#1:644\n123#1:628\n*E\n"})
public class CassIntrospector
extends BaseSingleDatabaseIntrospector<CassRoot, CassSchema> {
    public CassIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = (BaseIntrospector.Nature)BaseIntrospector.DefaultNature.INSTANCE;
        Dbms dbms = Dbms.CASSANDRA;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"CASSANDRA");
        super(context, nature, dbms, modelFactory);
    }

    @NotNull
    protected BaseNativeIntrospector.AbstractDatabaseRetriever<CassRoot> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull CassRoot database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    protected CassSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull CassSchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new CassSchemaRetriever(transaction, schema);
    }

    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Object object = new int[]{3, 0};
        List schemas = this.getServerVersion().isOrGreater(object) ? (List)this.performQuery(tran, CassIntroQueries.Companion.getQUERIES().getRetrieveSchemas3()) : (List)this.performQuery(tran, CassIntroQueries.Companion.getQUERIES().getRetrieveSchemas2());
        object = new int[]{4};
        if (this.getServerVersion().isOrGreater(object)) {
            object = schemas;
            Intrinsics.checkNotNull((Object)object);
            Collection collection = (Collection)object;
            Object object2 = this.performQuery(tran, CassIntroQueries.Companion.getQUERIES().getRetrieveVirtualSchemas());
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"performQuery(...)");
            schemas = CollectionsKt.plus((Collection)collection, (Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)object2)), CassIntrospector::introspectNamespacesInTran$lambda$0));
        }
        object = schemas;
        Intrinsics.checkNotNull((Object)object);
        this.applySchemas((List<? extends CassIntroQueries.OneSchema>)object, this.getDbConnectionInfo().schemaName);
    }

    protected void introspectServerObjectsInner(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        int[] nArray = new int[]{2, 2};
        if (this.getServerVersion().isOrGreater(nArray)) {
            if (this.hasSelectPrivilege("system_auth.roles")) {
                this.retrieveRoles22(tran);
            }
        } else if (this.hasSelectPrivilege("system_auth.users")) {
            this.retrieveRoles21(tran);
        }
    }

    private final boolean hasSelectPrivilege(String tableName) {
        DatabaseConnectionCore databaseConnectionCore = this.getDbConnection();
        if (databaseConnectionCore == null) {
            return true;
        }
        DatabaseConnectionCore connection = databaseConnectionCore;
        return (Boolean)SmartStatementFactoryService.Companion.getInstance().poweredBy(connection).simple().execute((Object)("select * from " + tableName), CassIntrospector::hasSelectPrivilege$lambda$0).rightOr((Object)false);
    }

    private final void retrieveRoles22(DBTransaction tran) {
        PreprocessedQuery pq = IntrospectionQueryContext.preprocessQuery$default((IntrospectionQueryContext)((IntrospectionQueryContext)this), CassIntroQueries.Companion.getQUERIES().getRetrieveRoles22(), null, null, (int)6, null);
        this.inModel(arg_0 -> CassIntrospector.retrieveRoles22$lambda$0(tran, pq, arg_0));
    }

    private final void retrieveRoles21(DBTransaction tran) {
        PreprocessedQuery pq = IntrospectionQueryContext.preprocessQuery$default((IntrospectionQueryContext)((IntrospectionQueryContext)this), CassIntroQueries.Companion.getQUERIES().getRetrieveRoles21(), null, null, (int)6, null);
        this.inModel(arg_0 -> CassIntrospector.retrieveRoles21$lambda$0(tran, pq, arg_0));
    }

    public void retrieveAndApplySchemas() {
        this.inTransactionUnit(arg_0 -> CassIntrospector.retrieveAndApplySchemas$lambda$0(this, arg_0));
    }

    private final void applySchemas(List<? extends CassIntroQueries.OneSchema> newSchemas, String currentSchema) {
        this.inModel(arg_0 -> CassIntrospector.applySchemas$lambda$0(newSchemas, currentSchema, arg_0));
    }

    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends CassSchema> schemas, boolean whole) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
        for (CassSchema cassSchema : schemas) {
            this.introspectOneSchema(tran, cassSchema);
        }
    }

    private final void introspectOneSchema(DBTransaction tran, CassSchema schema) {
        this.handleErrors("Introspect schema " + schema.getName(), () -> CassIntrospector.introspectOneSchema$lambda$0(this, tran, schema));
    }

    private static final CassIntroQueries.OneSchema3 introspectNamespacesInTran$lambda$0(CassIntroQueries.OneSchema3 it) {
        it.setVirtual(true);
        return it;
    }

    private static final boolean hasSelectPrivilege$lambda$0(ResultsProducer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Unit retrieveRoles22$lambda$0(DBTransaction $tran, PreprocessedQuery $pq, CassRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)root.getRoles();
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingFamily it = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        Object object = $tran.query($pq.query).runOnce();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runOnce(...)");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name2;
            CassIntroQueries.OneRole r = (CassIntroQueries.OneRole)element$iv;
            boolean bl2 = false;
            if (r.name == null) continue;
            BasicModNamedElement basicModNamedElement = root.getRoles().createOrGet(name2);
            CassRole $this$retrieveRoles22_u24lambda_u240_u240_u240_u240 = (CassRole)basicModNamedElement;
            boolean bl3 = false;
            $this$retrieveRoles22_u24lambda_u240_u240_u240_u240.setSuperRole(r.is_superuser);
            $this$retrieveRoles22_u24lambda_u240_u240_u240_u240.setCanLogin(r.can_login);
        }
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        return Unit.INSTANCE;
    }

    private static final Unit retrieveRoles21$lambda$0(DBTransaction $tran, PreprocessedQuery $pq, CassRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)root.getRoles();
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingFamily it = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        Object object = $tran.query($pq.query).runOnce();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runOnce(...)");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name2;
            CassIntroQueries.OneRole r = (CassIntroQueries.OneRole)element$iv;
            boolean bl2 = false;
            if (r.name == null) continue;
            BasicModNamedElement basicModNamedElement = root.getRoles().createOrGet(name2);
            CassRole $this$retrieveRoles21_u24lambda_u240_u240_u240_u240 = (CassRole)basicModNamedElement;
            boolean bl3 = false;
            $this$retrieveRoles21_u24lambda_u240_u240_u240_u240.setSuperRole(r.is_superuser);
            $this$retrieveRoles21_u24lambda_u240_u240_u240_u240.setCanLogin(true);
        }
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        return Unit.INSTANCE;
    }

    private static final Unit retrieveAndApplySchemas$lambda$0(CassIntrospector this$0, DBTransaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.introspectNamespacesInTran(it);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit applySchemas$lambda$0(List $newSchemas, String $currentSchema, CassRoot root) {
        void $this$iv$iv$iv;
        void $this$applySchemasNamed$iv$iv;
        void searchCache$iv$iv;
        void $this$applySchemasNamed$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ModNamingFamily<? extends CassSchema> modNamingFamily = root.getSchemas();
        Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getSchemas(...)");
        ModNamingFamily<? extends CassSchema> modNamingFamily2 = modNamingFamily;
        List scs$iv = $newSchemas;
        boolean $i$f$applySchemasNamed = false;
        void var6_6 = $this$applySchemasNamed$iv;
        ElementSearchCache elementSearchCache = new ElementSearchCache();
        List scs$iv$iv = scs$iv;
        boolean $i$f$applySchemasNamed2 = false;
        FamilySearcher familySearcher = ElementCacheOptimizersKt.byName((ElementChecker)ElementCacheKt.searchElement((ElementSearchCache)searchCache$iv$iv), (Function1)((Function1)new Function1<CassIntroQueries.OneSchema, String>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final String invoke(Object $this$byName) {
                CassIntroQueries.OneSchema p0 = (CassIntroQueries.OneSchema)$this$byName;
                boolean bl = false;
                return p0.getName();
            }
        })).inFamily((Family)$this$applySchemasNamed$iv$iv);
        Function2 filler$iv$iv$iv = applySchemas$lambda$0$$inlined$applySchemasNamed$2.INSTANCE;
        boolean $i$f$orCreateBulk = false;
        ArrayList items$iv$iv$iv = new ArrayList();
        ElementSearcherNN searcher$iv$iv$iv = ElementCacheKt.orCreateElement((ElementSearcher)((ElementSearcher)$this$iv$iv$iv), (Function1)new Function1<D, T>((FamilySearcher)$this$iv$iv$iv, filler$iv$iv$iv, items$iv$iv$iv){
            final /* synthetic */ FamilySearcher this$0;
            final /* synthetic */ Function2 $filler;
            final /* synthetic */ ArrayList $items;
            {
                this.this$0 = $receiver;
                this.$filler = $filler;
                this.$items = $items;
            }

            public final T invoke(D it) {
                BasicElement basicElement = BasicMetaUtils.getMetaObject((Family)this.this$0.getFamily()).newDataObject();
                Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"newDataObject(...)");
                BasicElement basicElement2 = basicElement;
                FamilySearcher familySearcher = this.this$0;
                Function2 function2 = this.$filler;
                ArrayList arrayList = this.$items;
                BasicElement $this$invoke_u24lambda_u240 = basicElement2;
                boolean bl = false;
                familySearcher.fillImpl($this$invoke_u24lambda_u240, it, function2);
                ((Collection)arrayList).add($this$invoke_u24lambda_u240);
                return (T)basicElement2;
            }
        });
        try {
            void $this$applySchemasImpl$iv$iv$iv;
            ElementSearcherNN schemas$iv$iv = searcher$iv$iv$iv;
            boolean bl = false;
            void var17_18 = $this$applySchemasNamed$iv$iv;
            List scs$iv$iv$iv = scs$iv$iv;
            boolean $i$f$applySchemasImpl = false;
            $this$applySchemasImpl$iv$iv$iv.markChildrenAsSyncPending();
            Iterable $this$forEach$iv$iv$iv$iv = scs$iv$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                void s;
                void sc$iv$iv;
                Object element$iv$iv$iv$iv;
                Object sc$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Object t = sc$iv$iv$iv;
                void $this$applySchemasNamed_u24lambda_u240_u240$iv$iv = $this$applySchemasImpl$iv$iv$iv;
                boolean bl3 = false;
                BasicModMateNamespace $this$applySchemasNamed_u24lambda_u240_u240_u240$iv$iv = (BasicModMateNamespace)schemas$iv$iv.find((Object)sc$iv$iv);
                boolean bl4 = false;
                CassIntroQueries.OneSchema oneSchema = (CassIntroQueries.OneSchema)sc$iv$iv;
                CassSchema $this$applySchemas_u24lambda_u240_u240 = (CassSchema)$this$applySchemasNamed_u24lambda_u240_u240_u240$iv$iv;
                boolean bl5 = false;
                void var34_35 = s;
                if (var34_35 instanceof CassIntroQueries.OneSchema2) {
                    string = CassIntrospectorHelperKt.concatClassAndOptions(((CassIntroQueries.OneSchema2)s).strategy_class, ((CassIntroQueries.OneSchema2)s).strategy_options, CassIntrospectorKt.access$getLOG$p());
                } else if (var34_35 instanceof CassIntroQueries.OneSchema3) {
                    if (((CassIntroQueries.OneSchema3)s).replication != null) {
                        String it;
                        boolean bl6 = false;
                        string = CassIntrospectorHelperKt.jsonToCassandraMapLiteral$default(it, CassIntrospectorKt.access$getLOG$p(), null, 4, null);
                    } else {
                        string = null;
                    }
                } else {
                    string = null;
                }
                String replication = string;
                Map prop = new LinkedHashMap();
                Boolean bl7 = s.getDurableWrites();
                if (bl7 != null) {
                    boolean it = bl7;
                    boolean bl8 = false;
                    prop.put(CassSchemaPropertyKind.DURABLE_WRITES, CassTableProducersKt.toLiteral(it));
                }
                if (replication != null) {
                    String it;
                    boolean bl9 = false;
                    prop.put(CassSchemaPropertyKind.REPLICATION, it);
                }
                $this$applySchemas_u24lambda_u240_u240.setProperties(prop);
                $this$applySchemas_u24lambda_u240_u240.setVirtual(s.getVirtual());
                $this$applySchemas_u24lambda_u240_u240.setCurrent(Intrinsics.areEqual((Object)s.getName(), (Object)$currentSchema));
            }
            $this$applySchemasImpl$iv$iv$iv.removeSyncPendingChildren();
            $this$applySchemasImpl$iv$iv$iv.sort();
        }
        finally {
            Family family = $this$iv$iv$iv.getFamily();
            Intrinsics.checkNotNull((Object)family, (String)"null cannot be cast to non-null type com.intellij.database.model.families.Family<T of com.intellij.database.model.FamilySearcher>");
            BaseModel.createBulk((Family)family, (Iterable)items$iv$iv$iv);
        }
        return Unit.INSTANCE;
    }

    private static final Unit introspectOneSchema$lambda$0(CassIntrospector this$0, DBTransaction $tran, CassSchema $schema) {
        CassSchemaRetriever retriever = this$0.createSchemaRetriever($tran, $schema);
        retriever.process();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003:\u0001bB\u0019\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001c\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J$\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00022\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J,\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0002H\u0002Jc\u0010)\u001a\u00020\u0010\"\b\b\u0000\u0010**\u00020+2\u0006\u0010\u0007\u001a\u00020\u00022\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H*0\u001a0\u00192\u000e\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140-2\u001e\u0010.\u001a\u001a\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H*00\u0012\u0004\u0012\u00020\u00100/H\u0002\u00a2\u0006\u0002\u00101J\u001e\u00102\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\f\u00103\u001a\b\u0012\u0004\u0012\u00020400H\u0002J\u001e\u00105\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\f\u00103\u001a\b\u0012\u0004\u0012\u00020+00H\u0002J\u001e\u00106\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\f\u00103\u001a\b\u0012\u0004\u0012\u00020700H\u0002J\u0010\u00108\u001a\u00020\u00132\u0006\u00109\u001a\u00020\u0013H\u0002J\u0010\u0010:\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010;\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J&\u0010<\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\f\u00103\u001a\b\u0012\u0004\u0012\u00020700H\u0002J\u0010\u0010@\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0012\u0010A\u001a\u00020\u000b2\b\u0010B\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010C\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010D\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0018\u0010E\u001a\u00020\u00102\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0002J\u0018\u0010J\u001a\u00020\u00102\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0002J\u001e\u0010O\u001a\u0004\u0018\u00010N2\b\u0010P\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010Q\u001a\u00020\u000bH\u0002J\u0010\u0010Q\u001a\u00020\u00132\u0006\u00109\u001a\u00020\u0013H\u0002J\u0010\u0010R\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u001e\u0010S\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010T2\u0006\u0010U\u001a\u00020\u0013H\u0002J.\u0010V\u001a\u00020\u00102\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020Z2\u0014\u0010[\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010TH\u0002J(\u0010\\\u001a\u0004\u0018\u00010\u00132\u0014\u0010[\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010T2\u0006\u0010W\u001a\u00020XH\u0002J\u0010\u0010]\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0018\u0010^\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020_2\u0006\u0010`\u001a\u00020aH\u0002\u00a8\u0006c"}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/cassandra/model/CassSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/cassandra/model/CassRoot;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/cassandra/model/CassSchema;)V", "isPossibleToIntrospectSchemaIncrementally", "", "tran", "level", "Lcom/intellij/database/model/properties/Level;", "setVersionParameters", "", "parameters", "", "", "", "process", "retrieveTables", "retrieveTables3", "query", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneTable3;", "retrieveMatViews", "processLikeTable", "table", "Lcom/intellij/database/dialects/cassandra/model/CassLikeTable;", "properties", "Lcom/intellij/database/dialects/cassandra/model/defaults/CassTablePropertyKind;", "t", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneLikeTable;", "processLikeTable2", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneLikeTable2;", "processLikeTable3", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneLikeTable3;", "retrieveColumns", "retrieveColumnsInner", "T", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneColumn;", "freeParameters", "", "action", "Lkotlin/Function2;", "", "(Lcom/intellij/database/dialects/cassandra/model/CassSchema;Lcom/intellij/database/remote/jdba/sql/SqlQuery;[Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)V", "processColumns3", "columns", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneColumn3;", "createKey", "processColumns2", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneColumn2;", "unwrapReversed", "s", "retrieveIndices", "retrieveIndices2", "processIndex", "Lcom/intellij/database/dialects/cassandra/model/CassTable;", "index", "Lcom/intellij/database/dialects/cassandra/model/CassIndex;", "retrieveIndices3", "isIndexCustom", "kind", "retrieveTriggers", "retrieveFunctions", "processFunction", "f", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneFunction;", "function", "Lcom/intellij/database/dialects/cassandra/model/CassFunction;", "setReturnType", "routine", "Lcom/intellij/database/dialects/cassandra/model/CassRoutine;", "returnDataType", "Lcom/intellij/database/model/DataType;", "getDataType", "validator", "unwrapFrozen", "retrieveAggregates", "getAggregateInitConditions", "", "keyspace", "processAggregate", "a", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneAggregate;", "aggregate", "Lcom/intellij/database/dialects/cassandra/model/CassAggregate;", "initConditions", "getInitCondition", "retrieveDefTypes", "processDefType", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneDefType;", "objectType", "Lcom/intellij/database/dialects/cassandra/model/CassDefType;", "ColumnSorter", "intellij.database.dialects.cassandra"})
    @SourceDebugExtension(value={"SMAP\nCassIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CassIntrospector.kt\ncom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever\n+ 2 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/NameCache\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,577:1\n179#2,4:578\n183#2,3:584\n179#2,4:589\n183#2,3:596\n355#2:599\n358#2,6:604\n337#2,3:628\n340#2:633\n198#2,5:634\n204#2,5:641\n341#2:646\n337#2,3:679\n340#2:684\n198#2,5:685\n204#2,5:692\n341#2:697\n337#2,3:702\n340#2:707\n198#2,5:708\n204#2,5:715\n341#2:720\n179#2,4:721\n183#2,3:731\n179#2,4:737\n183#2,3:747\n355#2:753\n358#2:756\n359#2,5:759\n1915#3,2:582\n1915#3,2:587\n1915#3:593\n1916#3:595\n1915#3,2:600\n1915#3,2:602\n1915#3:610\n1916#3:617\n1915#3,2:618\n1915#3,2:622\n1586#3:624\n1661#3,3:625\n1915#3,2:639\n1915#3:647\n1916#3:660\n1642#3,10:661\n1915#3:671\n1916#3:673\n1652#3:674\n1586#3:675\n1661#3,3:676\n1915#3,2:690\n1586#3:698\n1661#3,3:699\n1915#3,2:713\n1915#3:725\n1916#3:730\n1915#3:741\n1916#3:746\n1915#3,2:754\n1915#3,2:757\n777#3:767\n873#3,2:768\n1068#3:770\n1586#3:771\n1661#3,3:772\n777#3:775\n873#3,2:776\n1068#3:778\n1586#3:779\n1661#3,3:780\n1#4:594\n1#4:672\n442#5,6:611\n442#5,5:648\n442#5,6:653\n447#5:659\n614#6:620\n614#6:621\n37#7,2:631\n37#7,2:682\n37#7,2:705\n11705#8:726\n12052#8,3:727\n14125#8,3:734\n11705#8:742\n12052#8,3:743\n14125#8,3:750\n14125#8,3:764\n*S KotlinDebug\n*F\n+ 1 CassIntrospector.kt\ncom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever\n*L\n182#1:578,4\n182#1:584,3\n212#1:589,4\n212#1:596,3\n263#1:599\n263#1:604,6\n351#1:628,3\n351#1:633\n351#1:634,5\n351#1:641,5\n351#1:646\n404#1:679,3\n404#1:684\n404#1:685,5\n404#1:692,5\n404#1:697\n432#1:702,3\n432#1:707\n432#1:708,5\n432#1:715,5\n432#1:720\n449#1:721,4\n449#1:731,3\n505#1:737,4\n505#1:747,3\n558#1:753\n558#1:756\n558#1:759,5\n192#1:582,2\n202#1:587,2\n213#1:593\n213#1:595\n264#1:600,2\n265#1:602,2\n284#1:610\n284#1:617\n310#1:618,2\n328#1:622,2\n351#1:624\n351#1:625,3\n352#1:639,2\n366#1:647\n366#1:660\n387#1:661,10\n387#1:671\n387#1:673\n387#1:674\n404#1:675\n404#1:676,3\n405#1:690,2\n432#1:698\n432#1:699,3\n434#1:713,2\n450#1:725\n450#1:730\n506#1:741\n506#1:746\n558#1:754,2\n559#1:757,2\n457#1:767\n457#1:768,2\n457#1:770\n457#1:771\n457#1:772,3\n513#1:775\n513#1:776,2\n513#1:778\n513#1:779\n513#1:780,3\n387#1:672\n286#1:611,6\n370#1:648,5\n375#1:653,6\n370#1:659\n321#1:620\n322#1:621\n351#1:631,2\n404#1:682,2\n432#1:705,2\n452#1:726\n452#1:727,3\n470#1:734,3\n508#1:742\n508#1:743,3\n539#1:750,3\n570#1:764,3\n*E\n"})
    protected final class CassSchemaRetriever
    extends BaseNativeIntrospector.AbstractSchemaRetriever<CassSchema> {
        public CassSchemaRetriever(@NotNull DBTransaction transaction, CassSchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((BaseNativeIntrospector)CassIntrospector.this, transaction, (BasicModSchema)schema);
            this.setVersionParameters(this.getParametersMap());
        }

        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull CassSchema schema, @NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            return false;
        }

        private final void setVersionParameters(Map<String, Object> parameters) {
            BaseIntrospectionFunctions.setMajorMinorVersionParameters((Version)CassIntrospector.this.getServerVersion(), (int)3, (IntRange)new IntRange(0, 11), parameters);
            BaseIntrospectionFunctions.setMajorMinorVersionParameters((Version)CassIntrospector.this.getServerVersion(), (int)4, (int)0, (IntRange)new IntRange(1, 1), parameters);
        }

        public void process() {
            this.prepareParameters();
            this.inSchema(arg_0 -> CassSchemaRetriever.process$lambda$0(this, arg_0));
            int[] nArray = new int[]{3};
            if (CassIntrospector.this.getServerVersion().isOrGreater(nArray)) {
                this.inSchema(arg_0 -> CassSchemaRetriever.process$lambda$1(this, arg_0));
            }
            this.inSchema(arg_0 -> CassSchemaRetriever.process$lambda$2(this, arg_0));
            this.inSchema(arg_0 -> CassSchemaRetriever.process$lambda$3(this, arg_0));
            this.inSchema(arg_0 -> CassSchemaRetriever.process$lambda$4(this, arg_0));
            this.inSchema(arg_0 -> CassSchemaRetriever.process$lambda$5(this, arg_0));
            this.inSchema(arg_0 -> CassSchemaRetriever.process$lambda$6(this, arg_0));
            this.inSchema(arg_0 -> CassSchemaRetriever.process$lambda$7(this, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTables(CassSchema schema) {
            void $this$modifyAndCleanup_u24default$iv;
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
            CassIntrospector.this.reportRetrieving(objectKind);
            ModFamily modFamily = (ModFamily)schema.getTables();
            CassIntrospector cassIntrospector = CassIntrospector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily it = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            if (schema.isVirtual()) {
                int[] nArray = new int[]{4};
                if (cassIntrospector.getServerVersion().isOrGreater(nArray)) {
                    this.retrieveTables3(schema, CassIntroQueries.Companion.getQUERIES().getRetrieveVirtualTables4());
                }
            } else {
                int[] nArray = new int[]{3};
                if (cassIntrospector.getServerVersion().isOrGreater(nArray)) {
                    this.retrieveTables3(schema, CassIntroQueries.Companion.getQUERIES().getRetrieveTables3());
                } else {
                    SqlQuery<List<CassIntroQueries.OneTable2>> sqlQuery = CassIntroQueries.Companion.getQUERIES().getRetrieveTables2();
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNullExpressionValue((Object)schema.getName(), (String)"getName(...)");
                    Object object = this.performQuery(sqlQuery, null, objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"performQuery(...)");
                    Iterable $this$forEach$iv = (Iterable)object;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String name2;
                        CassIntroQueries.OneTable2 t = (CassIntroQueries.OneTable2)element$iv;
                        boolean bl2 = false;
                        if (t.name == null) continue;
                        CassTable table = (CassTable)schema.getTables().createOrGet(name2);
                        Intrinsics.checkNotNull((Object)table);
                        CassLikeTable cassLikeTable = table;
                        Intrinsics.checkNotNull((Object)t);
                        this.processLikeTable2(cassLikeTable, t);
                    }
                }
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        private final void retrieveTables3(CassSchema schema, SqlQuery<List<CassIntroQueries.OneTable3>> query) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)schema.getName(), (String)"getName(...)");
            Iterable $this$forEach$iv = (Iterable)this.performQuery(query, null, objectArray);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String name2;
                CassIntroQueries.OneTable3 t = (CassIntroQueries.OneTable3)element$iv;
                boolean bl = false;
                if (t.name == null) continue;
                CassTable table = (CassTable)schema.getTables().createOrGet(name2);
                Intrinsics.checkNotNull((Object)table);
                this.processLikeTable3(table, t);
            }
        }

        private final void retrieveMatViews(CassSchema schema) {
            ObjectKind objectKind = ObjectKind.MAT_VIEW;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"MAT_VIEW");
            CassIntrospector.this.reportRetrieving(objectKind);
            ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)schema.getMatViews();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily it = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            SqlQuery<List<CassIntroQueries.OneMatView3>> sqlQuery = CassIntroQueries.Companion.getQUERIES().getRetrieveMatViews();
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)schema.getName(), (String)"getName(...)");
            Object object = this.performQuery(sqlQuery, null, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"performQuery(...)");
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                String string2;
                CharSequence charSequence;
                String it2;
                CassMatView cassMatView;
                String name2;
                CassIntroQueries.OneMatView3 mv = (CassIntroQueries.OneMatView3)element$iv;
                boolean bl2 = false;
                if (mv.name == null) continue;
                CassMatView matView = (CassMatView)schema.getMatViews().createOrGet(name2);
                Intrinsics.checkNotNull((Object)matView);
                CassLikeTable cassLikeTable = matView;
                Intrinsics.checkNotNull((Object)mv);
                this.processLikeTable3(cassLikeTable, mv);
                CassMatView cassMatView2 = matView;
                if (mv.where_clause != null) {
                    CharSequence charSequence2;
                    cassMatView = cassMatView2;
                    boolean bl3 = false;
                    charSequence = it2;
                    if (charSequence.length() == 0) {
                        boolean bl4 = false;
                        charSequence2 = null;
                    } else {
                        charSequence2 = charSequence;
                    }
                    string2 = (String)charSequence2;
                    cassMatView2 = cassMatView;
                } else {
                    string2 = null;
                }
                cassMatView2.setWhereClause(string2);
                CassMatView cassMatView3 = matView;
                if (mv.base_table_name != null) {
                    CharSequence charSequence3;
                    cassMatView = cassMatView3;
                    boolean bl5 = false;
                    charSequence = it2;
                    if (charSequence.length() == 0) {
                        boolean bl6 = false;
                        charSequence3 = null;
                    } else {
                        charSequence3 = charSequence;
                    }
                    string = (String)charSequence3;
                    cassMatView3 = cassMatView;
                } else {
                    string = null;
                }
                cassMatView3.setBaseTableName(string);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private final void processLikeTable(CassLikeTable table, Map<CassTablePropertyKind, String> properties, CassIntroQueries.OneLikeTable t) {
            block13: {
                String string;
                Object object;
                CassLikeTable cassLikeTable = table;
                String string2 = t.getComm();
                if (string2 != null) {
                    void it;
                    String string3 = string2;
                    CassLikeTable cassLikeTable2 = cassLikeTable;
                    boolean bl = false;
                    object = ((CharSequence)it).length() == 0 ? null : it;
                    cassLikeTable = cassLikeTable2;
                } else {
                    object = null;
                }
                cassLikeTable.setComment((String)object);
                String string4 = t.getCachingValue();
                if (string4 != null) {
                    String it = string4;
                    boolean bl = false;
                    string = CassIntrospectorHelperKt.jsonToCassandraMapLiteral$default(it, CassIntrospectorKt.access$getLOG$p(), null, 4, null);
                    if (string != null) {
                        it = string;
                        boolean bl2 = false;
                        properties.put(CassTablePropertyKind.CACHING, it);
                    }
                }
                string4 = t.getCompressionValue();
                if (string4 != null) {
                    String it = string4;
                    boolean bl = false;
                    string = CassIntrospectorHelperKt.jsonToCassandraMapLiteral$default(it, CassIntrospectorKt.access$getLOG$p(), null, 4, null);
                    if (string != null) {
                        it = string;
                        boolean bl3 = false;
                        properties.put(CassTablePropertyKind.COMPRESSION, it);
                    }
                }
                Double d = t.getBloomFilterFpChance();
                if (d != null) {
                    double it = ((Number)d).doubleValue();
                    boolean bl = false;
                    properties.put(CassTablePropertyKind.BLOOM_FILTER_FP_CHANCE, CassTableProducersKt.toLiteral(it));
                }
                Integer n = t.getDefaultTimeToLive();
                if (n != null) {
                    int it = ((Number)n).intValue();
                    boolean bl = false;
                    properties.put(CassTablePropertyKind.DEFAULT_TIME_TO_LIVE, CassTableProducersKt.toLiteral(it));
                }
                String string5 = t.getSpeculativeRetry();
                if (string5 != null) {
                    String it = string5;
                    boolean bl = false;
                    properties.put(CassTablePropertyKind.SPECULATIVE_RETRY, it);
                }
                Integer n2 = t.getGcGraceSeconds();
                if (n2 != null) {
                    int it = ((Number)n2).intValue();
                    boolean bl = false;
                    properties.put(CassTablePropertyKind.GC_GRACE_SECONDS, CassTableProducersKt.toLiteral(it));
                }
                Integer n3 = t.getMaxIndexInterval();
                if (n3 != null) {
                    int it = ((Number)n3).intValue();
                    boolean bl = false;
                    properties.put(CassTablePropertyKind.MAX_INDEX_INTERVAL, CassTableProducersKt.toLiteral(it));
                }
                Integer n4 = t.getMemtableFlushPeriodInMs();
                if (n4 != null) {
                    int it = ((Number)n4).intValue();
                    boolean bl = false;
                    properties.put(CassTablePropertyKind.MEMTABLE_FLUSH_PERIOD_IN_MS, CassTableProducersKt.toLiteral(it));
                }
                Integer n5 = t.getMinIndexInterval();
                if (n5 != null) {
                    int it = ((Number)n5).intValue();
                    boolean bl = false;
                    properties.put(CassTablePropertyKind.MIN_INDEX_INTERVAL, CassTableProducersKt.toLiteral(it));
                }
                Double d2 = t.getReadRepairChance();
                if (d2 == null) break block13;
                double it = ((Number)d2).doubleValue();
                boolean bl = false;
                properties.put(CassTablePropertyKind.READ_REPAIR_CHANCE, CassTableProducersKt.toLiteral(it));
            }
        }

        private final void processLikeTable2(CassLikeTable table, CassIntroQueries.OneLikeTable2 t) {
            Map properties = new LinkedHashMap();
            Intrinsics.checkNotNull((Object)t, (String)"null cannot be cast to non-null type com.intellij.database.dialects.cassandra.introspector.CassIntroQueries.OneLikeTable");
            this.processLikeTable(table, properties, t);
            String string = CassIntrospectorHelperKt.concatClassAndOptions(t.getCompactionStrategyClass(), t.getCompactionStrategyOptions(), CassIntrospectorKt.access$getLOG$p());
            if (string != null) {
                String it = string;
                boolean bl = false;
                properties.put(CassTablePropertyKind.COMPACTION, it);
            }
            table.setProperties(properties);
        }

        private final void processLikeTable3(CassLikeTable table, CassIntroQueries.OneLikeTable3 t) {
            Map properties = new LinkedHashMap();
            Intrinsics.checkNotNull((Object)t, (String)"null cannot be cast to non-null type com.intellij.database.dialects.cassandra.introspector.CassIntroQueries.OneLikeTable");
            this.processLikeTable(table, properties, t);
            Boolean bl = t.getCdcValue();
            if (bl != null) {
                boolean it = bl;
                boolean bl2 = false;
                properties.put(CassTablePropertyKind.CDC, CassTableProducersKt.toLiteral(it));
            }
            Double d = t.getCrcCheckChance();
            if (d != null) {
                double it = ((Number)d).doubleValue();
                boolean bl3 = false;
                properties.put(CassTablePropertyKind.CRC_CHECK_CHANCE, CassTableProducersKt.toLiteral(it));
            }
            Double d2 = t.getDclocalReadRepairChance();
            if (d2 != null) {
                double it = ((Number)d2).doubleValue();
                boolean bl4 = false;
                properties.put(CassTablePropertyKind.DCLOCAL_READ_REPAIR_CHANCE, CassTableProducersKt.toLiteral(it));
            }
            String string = t.getCompactionValue();
            if (string != null) {
                String it = string;
                boolean bl5 = false;
                String string2 = CassIntrospectorHelperKt.jsonToCassandraMapLiteral$default(it, CassIntrospectorKt.access$getLOG$p(), null, 4, null);
                if (string2 != null) {
                    it = string2;
                    boolean bl6 = false;
                    properties.put(CassTablePropertyKind.COMPACTION, it);
                }
            }
            String string3 = t.getAdditionalWritePolicy();
            if (string3 != null) {
                String it = string3;
                boolean bl7 = false;
                properties.put(CassTablePropertyKind.ADDITIONAL_WRITE_POLICY, it);
            }
            table.setProperties(properties);
        }

        private final void retrieveColumns(CassSchema schema) {
            boolean bl;
            CassMatView v;
            boolean bl2;
            CassTable t;
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            CassIntrospector.this.reportRetrieving(objectKind);
            CassIntrospector cassIntrospector = CassIntrospector.this;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Function1 it = CassSchemaRetriever$retrieveColumns$$inlined$modifyFamiliesAndCleanup$1.INSTANCE;
            boolean $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32 = false;
            ModNamingFamily<? extends CassTable> modNamingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$forEach$iv = (Iterable)modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (CassTable)element$iv;
                bl2 = false;
                ModPositioningNamingFamily<? extends CassTableColumn> modPositioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getColumns(...)");
                it.invoke(modPositioningNamingFamily);
            }
            ModNamingFamily<? extends CassMatView> modNamingFamily2 = schema.getMatViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getMatViews(...)");
            $this$forEach$iv = (Iterable)modNamingFamily2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                v = (CassMatView)element$iv;
                bl = false;
                ModPositioningNamingFamily<? extends CassMatViewColumn> modPositioningNamingFamily = v.getColumns();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getColumns(...)");
                it.invoke(modPositioningNamingFamily);
            }
            boolean bl3 = false;
            Object[] $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32 = new String[]{schema.getName()};
            Object[] freeParameters = $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32;
            $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32 = new int[2];
            $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32[0] = (String)3;
            $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32[1] = (String)false;
            if (cassIntrospector.getServerVersion().isOrGreater((int[])$i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32)) {
                $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32 = new int[2];
                $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32[0] = (String)4;
                $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32[1] = false;
                if (cassIntrospector.getServerVersion().isOrGreater((int[])$i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32) && schema.isVirtual()) {
                    this.retrieveColumnsInner(schema, CassIntroQueries.Companion.getQUERIES().getRetrieveVirtualColumns4(), freeParameters, (Function2)new Function2<CassLikeTable, List<? extends CassIntroQueries.OneColumn3>, Unit>((Object)this){

                        public final void invoke(CassLikeTable p0, List<CassIntroQueries.OneColumn3> p1) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter(p1, (String)"p1");
                            CassSchemaRetriever.access$processColumns3((CassSchemaRetriever)((Object)this.receiver), p0, p1);
                        }
                    });
                } else {
                    this.retrieveColumnsInner(schema, CassIntroQueries.Companion.getQUERIES().getRetrieveColumns3(), freeParameters, (Function2)new Function2<CassLikeTable, List<? extends CassIntroQueries.OneColumn3>, Unit>((Object)this){

                        public final void invoke(CassLikeTable p0, List<CassIntroQueries.OneColumn3> p1) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter(p1, (String)"p1");
                            CassSchemaRetriever.access$processColumns3((CassSchemaRetriever)((Object)this.receiver), p0, p1);
                        }
                    });
                }
            } else {
                this.retrieveColumnsInner(schema, CassIntroQueries.Companion.getQUERIES().getRetrieveColumns2(), freeParameters, (Function2)new Function2<CassLikeTable, List<? extends CassIntroQueries.OneColumn2>, Unit>((Object)this){

                    public final void invoke(CassLikeTable p0, List<CassIntroQueries.OneColumn2> p1) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter(p1, (String)"p1");
                        CassSchemaRetriever.access$processColumns2((CassSchemaRetriever)((Object)this.receiver), p0, p1);
                    }
                });
            }
            it = CassSchemaRetriever$retrieveColumns$$inlined$modifyFamiliesAndCleanup$2.INSTANCE;
            boolean bl4 = false;
            ModNamingFamily<? extends CassTable> modNamingFamily3 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"getTables(...)");
            $this$forEach$iv = (Iterable)modNamingFamily3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (CassTable)element$iv;
                bl2 = false;
                ModPositioningNamingFamily<? extends CassTableColumn> modPositioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getColumns(...)");
                it.invoke(modPositioningNamingFamily);
            }
            ModNamingFamily<? extends CassMatView> modNamingFamily4 = schema.getMatViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily4, (String)"getMatViews(...)");
            $this$forEach$iv = (Iterable)modNamingFamily4;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                v = (CassMatView)element$iv;
                bl = false;
                ModPositioningNamingFamily<? extends CassMatViewColumn> modPositioningNamingFamily = v.getColumns();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getColumns(...)");
                it.invoke(modPositioningNamingFamily);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final <T extends CassIntroQueries.OneColumn> void retrieveColumnsInner(CassSchema schema, SqlQuery<List<T>> query, Object[] freeParameters, Function2<? super CassLikeTable, ? super List<? extends T>, Unit> action) {
            block5: {
                tableCache = new NameCache();
                columns = new ArrayList<E>();
                $this$forEach$iv = (Iterable)this.performQuery(query, null, Arrays.copyOf(freeParameters, freeParameters.length));
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    c = (CassIntroQueries.OneColumn)element$iv;
                    $i$a$-forEach-CassIntrospector$CassSchemaRetriever$retrieveColumnsInner$1 = false;
                    if (c.getTableName() == null) continue;
                    var14_15 = tableCache;
                    name$iv = tableName;
                    $i$f$get = false;
                    var17_18 = this_$iv;
                    var18_19 = name$iv;
                    create$iv$iv = false;
                    $i$f$get = false;
                    if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                    v0 = this_$iv$iv.getV();
                    Intrinsics.checkNotNull((Object)v0);
                    if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv$iv)) {
                        v1 = this_$iv$iv.getV();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var21_22 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv$iv){
                            final /* synthetic */ boolean $create;
                            final /* synthetic */ String $name;
                            {
                                this.$create = $create;
                                this.$name = $name;
                            }

                            public final T invoke(ModNamingFamily<? extends T> $this$family) {
                                Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                                return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                            }
                        };
                        var22_23 = this_$iv$iv;
                        var23_24 = this_$iv$iv;
                        $i$a$-get-CassIntrospector$CassSchemaRetriever$retrieveColumnsInner$1$1 = false;
                        if ((CassLikeTable)$this$retrieveColumnsInner_u24lambda_u240_u240.getV() != null) {
                            $i$a$-let-CassIntrospector$CassSchemaRetriever$retrieveColumnsInner$1$1$1 = false;
                            action.invoke((Object)v, (Object)columns);
                        }
                        columns.clear();
                        v2 = schema.getTables();
                        Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                        v3 = (CassLikeTable)it.invoke(v2);
                        if (v3 == null) {
                            v4 = schema.getMatViews();
                            Intrinsics.checkNotNullExpressionValue(v4, (String)"getMatViews(...)");
                            v3 = (CassLikeTable)it.invoke(v4);
                        }
                        var23_24.setV((BasicModNamedElement)v3);
                        v1 = this_$iv$iv.getV();
                    }
                    columns.add(c);
                }
                v5 = (CassLikeTable)tableCache.getV();
                if (v5 == null) break block5;
                table = v5;
                $i$a$-let-CassIntrospector$CassSchemaRetriever$retrieveColumnsInner$2 = false;
                action.invoke((Object)table, (Object)columns);
            }
        }

        private final void processColumns3(CassLikeTable table, List<CassIntroQueries.OneColumn3> columns) {
            ColumnSorter columnSorter = new ColumnSorter(columns);
            Iterable $this$forEach$iv = columns;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String name2;
                CassIntroQueries.OneColumn3 c = (CassIntroQueries.OneColumn3)element$iv;
                boolean bl = false;
                if (c.name == null) continue;
                BasicModTableOrViewColumn column = (BasicModTableOrViewColumn)table.getColumns().renewAt(columnSorter.idx(c), name2);
                if (c.type != null) {
                    String type;
                    boolean bl2 = false;
                    DataType dataType = DataTypeFactory.of((String)type);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                    column.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
                }
                if (!(column instanceof CassTableColumn)) continue;
                ((CassTableColumn)column).setStaticColumn(Intrinsics.areEqual((Object)c.kind, (Object)"static"));
            }
            this.createKey(table, columns);
        }

        private final void createKey(CassLikeTable table, List<? extends CassIntroQueries.OneColumn> columns) {
            CassKey k = (CassKey)table.getKeys().createOrGet("primary key");
            Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)columns), CassSchemaRetriever::createKey$lambda$0);
            boolean $i$f$sortedBy = false;
            Sequence partitioningCols = SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    CassIntroQueries.OneColumn it = (CassIntroQueries.OneColumn)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPos());
                    it = (CassIntroQueries.OneColumn)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPos()));
                }
            }), CassSchemaRetriever::createKey$lambda$2);
            Sequence $this$sortedBy$iv2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)columns), CassSchemaRetriever::createKey$lambda$3);
            boolean $i$f$sortedBy2 = false;
            Sequence clusteringCols = SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    CassIntroQueries.OneColumn it = (CassIntroQueries.OneColumn)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPos());
                    it = (CassIntroQueries.OneColumn)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPos()));
                }
            }), CassSchemaRetriever::createKey$lambda$5);
            k.setColumns(SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)partitioningCols, (Sequence)clusteringCols)));
        }

        private final void processColumns2(CassLikeTable table, List<CassIntroQueries.OneColumn2> columns) {
            ColumnSorter columnSorter = new ColumnSorter(columns);
            Iterable $this$forEach$iv = columns;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DataType it;
                String string;
                String name2;
                CassIntroQueries.OneColumn2 c = (CassIntroQueries.OneColumn2)element$iv;
                boolean bl = false;
                if (c.name == null) continue;
                BasicModTableOrViewColumn column = (BasicModTableOrViewColumn)table.getColumns().renewAt(columnSorter.idx(c), name2);
                if (column instanceof CassTableColumn) {
                    ((CassTableColumn)column).setStaticColumn(Intrinsics.areEqual((Object)c.type, (Object)"static"));
                }
                if ((string = c.validator) == null) continue;
                String it2 = string;
                boolean bl2 = false;
                String string2 = this.unwrapReversed(it2);
                string = string2;
                if (string2 == null) {
                    continue;
                }
                String validator = string;
                if (CassSchemaRetriever.getDataType$default(this, validator, false, 2, null) == null) continue;
                boolean bl3 = false;
                column.setStoredType(DasUnresolvedTypeReference.Companion.of(it));
            }
            this.createKey(table, columns);
        }

        private final String unwrapReversed(String s) {
            if (StringsKt.startsWith$default((String)s, (String)"org.apache.cassandra.db.marshal.ReversedType", (boolean)false, (int)2, null)) {
                String string = s.substring(StringsKt.indexOf$default((CharSequence)s, (char)'(', (int)0, (boolean)false, (int)6, null) + 1, StringsKt.lastIndexOf$default((CharSequence)s, (char)')', (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
            return s;
        }

        private final void retrieveIndices(CassSchema schema) {
            ObjectKind objectKind = ObjectKind.INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"INDEX");
            CassIntrospector.this.reportRetrieving(objectKind);
            int[] nArray = new int[]{3};
            if (CassIntrospector.this.getServerVersion().isOrGreater(nArray)) {
                this.retrieveIndices3(schema);
            } else {
                this.retrieveIndices2(schema);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final void retrieveIndices2(CassSchema schema) {
            v0 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(v0, (String)"getTables(...)");
            $this$map$iv = (Iterable)v0;
            $i$f$map = false;
            var4_5 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var9_18 = (CassTable)item$iv$iv;
                var37_16 = destination$iv$iv;
                $i$a$-map-CassIntrospector$CassSchemaRetriever$retrieveIndices2$1 = 0;
                var37_16.add(it.getIndices());
            }
            families$iv = (ModFamily[])((List)destination$iv$iv);
            removeUnaffected$iv = true;
            $i$f$modifyFamiliesAndCleanup = false;
            $this$toTypedArray$iv$iv = families$iv;
            $i$f$toTypedArray = false;
            thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            removeUnaffected$iv$iv = removeUnaffected$iv;
            $i$f$modifyFamiliesAndCleanup = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            $i$a$-modifyFamiliesAndCleanup$default-CassIntrospector$CassSchemaRetriever$retrieveIndices2$2 = false;
            v1 = CassIntroQueries.Companion.getQUERIES().getRetrieveIndices2();
            var13_25 = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)schema.getName(), (String)"getName(...)");
            v2 = this.performQuery(v1, null, var13_25);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"performQuery(...)");
            $this$forEach$iv = (Iterable)v2;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                i = (CassIntroQueries.OneIndex2)element$iv;
                $i$a$-forEach-CassIntrospector$CassSchemaRetriever$retrieveIndices2$2$1 = false;
                fullName = i.name;
                if (fullName == null) continue;
                dot = StringsKt.indexOf$default((CharSequence)fullName, (char)'.', (int)0, (boolean)false, (int)6, null);
                Intrinsics.checkNotNullExpressionValue((Object)fullName.substring(0, dot), (String)"substring(...)");
                Intrinsics.checkNotNullExpressionValue((Object)fullName.substring(dot + 1), (String)"substring(...)");
                if ((CassTable)schema.getTables().get(tableName) == null) continue;
                Intrinsics.checkNotNull((Object)var23_40);
                table = var23_40;
                table.getIndices().createOrGet(indexName);
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
            tableCache = new NameCache();
            indexCache = new NameCache();
            columns = new ArrayList<E>();
            v3 = CassIntroQueries.Companion.getQUERIES().getRetrieveColumns2();
            removeUnaffected$iv$iv = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)schema.getName(), (String)"getName(...)");
            v4 = this.performQuery(v3, null, removeUnaffected$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"performQuery(...)");
            $this$forEach$iv = (Iterable)v4;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                block10: {
                    block9: {
                        c = (CassIntroQueries.OneColumn2)element$iv;
                        $i$a$-forEach-CassIntrospector$CassSchemaRetriever$retrieveIndices2$3 = false;
                        if (c.index_name == null || c.index_name == null || c.getTableName() == null) continue;
                        $i$f$forEach = indexCache;
                        name$iv = indexName;
                        $i$f$get = false;
                        element$iv = this_$iv;
                        i = name$iv;
                        create$iv$iv = false;
                        $i$f$get = false;
                        if (this_$iv$iv.getV() == null) break block9;
                        v5 = this_$iv$iv.getV();
                        Intrinsics.checkNotNull((Object)v5);
                        if (!Intrinsics.areEqual((Object)v5.getName(), (Object)name$iv$iv)) break block9;
                        v6 = this_$iv$iv.getV();
                        break block10;
                    }
                    dot = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv$iv){
                        final /* synthetic */ boolean $create;
                        final /* synthetic */ String $name;
                        {
                            this.$create = $create;
                            this.$name = $name;
                        }

                        public final T invoke(ModNamingFamily<? extends T> $this$family) {
                            Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                            return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                        }
                    };
                    tableName = this_$iv$iv;
                    var22_39 = this_$iv$iv;
                    $i$a$-get-CassIntrospector$CassSchemaRetriever$retrieveIndices2$3$1 = false;
                    table = (CassTable)tableCache.getV();
                    index = (CassIndex)$this$retrieveIndices2_u24lambda_u242_u240.getV();
                    if (table != null && index != null) {
                        CassSchemaRetriever.access$processIndex(this, table, index, columns);
                    }
                    columns.clear();
                    var26_44 = tableCache;
                    name$iv = tableName;
                    $i$f$get = false;
                    var29_47 = this_$iv;
                    var30_48 = name$iv;
                    create$iv$iv = false;
                    $i$f$get = false;
                    if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                    v7 = this_$iv$iv.getV();
                    Intrinsics.checkNotNull((Object)v7);
                    if (Intrinsics.areEqual((Object)v7.getName(), (Object)name$iv$iv)) {
                        v8 = this_$iv$iv.getV();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var33_51 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv$iv){
                            final /* synthetic */ boolean $create;
                            final /* synthetic */ String $name;
                            {
                                this.$create = $create;
                                this.$name = $name;
                            }

                            public final T invoke(ModNamingFamily<? extends T> $this$family) {
                                Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                                return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                            }
                        };
                        var34_52 = this_$iv$iv;
                        var35_53 = this_$iv$iv;
                        $i$a$-get-CassIntrospector$CassSchemaRetriever$retrieveIndices2$3$1$1 = false;
                        v9 = schema.getTables();
                        Intrinsics.checkNotNullExpressionValue(v9, (String)"getTables(...)");
                        var35_53.setV((BasicModNamedElement)((CassTable)it.invoke(v9)));
                        v8 = this_$iv$iv.getV();
                    }
                    var22_39.setV((BasicModNamedElement)((v10 = (ModNamingFamily<? extends CassIndex>)v8) != null && (v10 = v10.getIndices()) != null ? (CassIndex)it.invoke(v10) : null));
                    v6 = this_$iv$iv.getV();
                }
                Intrinsics.checkNotNull((Object)c);
                columns.add(c);
            }
            table = (CassTable)tableCache.getV();
            index = (CassIndex)indexCache.getV();
            if (table != null && index != null) {
                this.processIndex(table, index, columns);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processIndex(CassTable table, CassIndex index, List<CassIntroQueries.OneColumn2> columns) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            CassIntroQueries.OneColumn2 oneColumn2 = (CassIntroQueries.OneColumn2)CollectionsKt.firstOrNull(columns);
            if (oneColumn2 == null) {
                return;
            }
            CassIntroQueries.OneColumn2 firstCol = oneColumn2;
            index.setCustom(this.isIndexCustom(firstCol.index_type));
            Iterable iterable = columns;
            CassIndex cassIndex = index;
            boolean $i$f$mapNotNull = false;
            void var7_8 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                IndexColumn indexColumn;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                CassIntroQueries.OneColumn2 c = (CassIntroQueries.OneColumn2)element$iv$iv;
                boolean bl2 = false;
                if (c.name == null) {
                    indexColumn = null;
                } else {
                    String columnName;
                    String options = c.index_options;
                    String modifier = null;
                    if (options != null) {
                        JsonObject obj = CassIntrospectorHelperKt.parseObject(options, CassIntrospectorKt.access$getLOG$p());
                        JsonObject jsonObject = obj;
                        if ((jsonObject != null ? jsonObject.get("index_keys_and_values") : null) != null) {
                            modifier = "entries";
                        } else {
                            JsonObject jsonObject2 = obj;
                            if ((jsonObject2 != null ? jsonObject2.get("index_keys") : null) != null) {
                                modifier = "keys";
                            } else {
                                Object object = (CassTableColumn)table.getColumns().get(columnName);
                                if (object != null && (object = object.getDasType()) != null && (object = DasTypeUtilsKt.getTypeName((DasType)object)) != null ? StringsKt.startsWith$default((String)object, (String)"frozen<", (boolean)false, (int)2, null) : false) {
                                    modifier = "full";
                                }
                            }
                        }
                    }
                    indexColumn = new IndexColumn(columnName, modifier);
                }
                if (indexColumn == null) continue;
                IndexColumn it$iv$iv = indexColumn;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            cassIndex.setColumns((List)destination$iv$iv);
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveIndices3(CassSchema schema) {
            void families$iv$iv;
            void $this$mapTo$iv$iv;
            ModNamingFamily<? extends CassTable> modNamingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = (Iterable)modNamingFamily;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CassTable cassTable = (CassTable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getIndices());
            }
            ModFamily[] families$iv = (ModFamily[])((List)destination$iv$iv);
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            ModFamily[] thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            SqlQuery<List<CassIntroQueries.OneIndex3>> sqlQuery = CassIntroQueries.Companion.getQUERIES().getRetrieveIndices3();
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)schema.getName(), (String)"getName(...)");
            Object object = this.performQuery(sqlQuery, null, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"performQuery(...)");
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object2;
                JsonObject it;
                JsonObject jsonObject;
                String indexName;
                CassTable cassTable;
                String tableName;
                CassIntroQueries.OneIndex3 i = (CassIntroQueries.OneIndex3)element$iv;
                boolean bl2 = false;
                if (i.table_name == null || i.name == null || (CassTable)schema.getTables().get(tableName) == null) continue;
                Intrinsics.checkNotNull((Object)cassTable);
                CassTable table = cassTable;
                CassIndex index = (CassIndex)table.getIndices().createOrGet(indexName);
                index.setCustom(this.isIndexCustom(i.kind));
                String options = i.options;
                if (options == null) continue;
                JsonObject obj = CassIntrospectorHelperKt.parseObject(options, CassIntrospectorKt.access$getLOG$p());
                Object object3 = obj;
                if (object3 != null && (object3 = object3.get("target")) != null) {
                    it = jsonObject = object3;
                    boolean bl3 = false;
                    object3 = it.isJsonPrimitive() ? jsonObject : null;
                    if (object3 != null && (object3 = object3.getAsString()) != null) {
                        Object object4;
                        String modificator;
                        Object target = object3;
                        boolean bl4 = false;
                        int parenth = StringsKt.indexOf$default((CharSequence)((CharSequence)target), (String)"(", (int)0, (boolean)false, (int)6, null);
                        if (parenth != -1) {
                            String string = ((String)target).substring(0, parenth);
                            v5 = string;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        } else {
                            v5 = modificator = null;
                        }
                        if (modificator != null) {
                            String string = ((String)target).substring(parenth + 1, ((String)target).length() - 1);
                            object4 = string;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        } else {
                            object4 = target;
                        }
                        Object colName = object4;
                        index.setColumns(CollectionsKt.listOf((Object)new IndexColumn((String)colName, StringUtil.toLowerCase((String)modificator))));
                    }
                }
                if ((object2 = obj) != null && (object2 = object2.get("class_name")) != null) {
                    it = jsonObject = object2;
                    boolean bl5 = false;
                    object2 = it.isJsonPrimitive() ? jsonObject : null;
                    if (object2 != null && (object2 = object2.getAsString()) != null) {
                        Object it2 = object2;
                        boolean bl6 = false;
                        index.setClassName((String)it2);
                    }
                }
                index.setOptions(CassIntrospectorHelperKt.jsonToCassandraMapLiteral(options, CassIntrospectorKt.access$getLOG$p(), (Function1<? super String, Boolean>)((Function1)CassSchemaRetriever::retrieveIndices3$lambda$1$0$4)));
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        private final boolean isIndexCustom(String kind) {
            return StringUtil.equalsIgnoreCase((CharSequence)kind, (CharSequence)"custom");
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTriggers(CassSchema schema) {
            void $this$forEach$iv;
            void families$iv$iv;
            void $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.TRIGGER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TRIGGER");
            CassIntrospector.this.reportRetrieving(objectKind);
            ModNamingFamily<? extends CassTable> modNamingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = (Iterable)modNamingFamily;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CassTable cassTable = (CassTable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getTriggers());
            }
            ModFamily[] families$iv = (ModFamily[])((List)destination$iv$iv);
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            ModFamily[] thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            SqlQuery<List<CassIntroQueries.OneTrigger>> sqlQuery = CassIntroQueries.Companion.getQUERIES().getRetrieveTriggers();
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)schema.getName(), (String)"getName(...)");
            Object object = this.performQuery(sqlQuery, null, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"performQuery(...)");
            Iterable iterable2 = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                String triggerName;
                CassTable cassTable;
                String tableName;
                CassIntroQueries.OneTrigger t = (CassIntroQueries.OneTrigger)element$iv;
                boolean bl2 = false;
                if (t.table_name == null || t.name == null || (CassTable)schema.getTables().get(tableName) == null) continue;
                Intrinsics.checkNotNull((Object)cassTable);
                CassTable table = cassTable;
                CassTrigger trigger = (CassTrigger)table.getTriggers().createOrGet(triggerName);
                String string2 = t.options;
                if (string2 == null) continue;
                String it = string2;
                boolean bl3 = false;
                JsonObject jsonObject = CassIntrospectorHelperKt.parseObject(it, CassIntrospectorKt.access$getLOG$p());
                Object object2 = jsonObject != null ? jsonObject.get("class") : null;
                string2 = object2;
                if (object2 == null) continue;
                String it2 = string = string2;
                boolean bl4 = false;
                string2 = it2.isJsonPrimitive() ? string : null;
                if (string2 == null || (string2 = string2.getAsString()) == null) continue;
                String it3 = string2;
                boolean bl5 = false;
                trigger.setClassName(it3);
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveFunctions(CassSchema schema) {
            int[] nArray = new int[]{2, 2};
            if (!CassIntrospector.this.getServerVersion().isOrGreater(nArray)) {
                return;
            }
            ObjectKind objectKind = ObjectKind.ROUTINE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROUTINE");
            CassIntrospector.this.reportRetrieving(objectKind);
            ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)schema.getFunctions();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily functions = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            SqlQuery<List<CassIntroQueries.OneFunction>> sqlQuery = CassIntroQueries.Companion.getQUERIES().getRetrieveFunctions();
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)schema.getName(), (String)"getName(...)");
            Object object = this.performQuery(sqlQuery, null, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"performQuery(...)");
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String name2;
                CassFunction cassFunction;
                List argument_types;
                CassIntroQueries.OneFunction f = (CassIntroQueries.OneFunction)element$iv;
                boolean bl2 = false;
                if (f.name == null) continue;
                if (f.argument_types != null) {
                    void $this$mapTo$iv$iv;
                    String[] $this$map$iv = f.argument_types;
                    boolean $i$f$map = false;
                    String[] stringArray = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        DasType dasType;
                        void argType;
                        void item$iv$iv;
                        void var22_23 = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        if (this.getDataType((String)argType, true) != null) {
                            DataType it;
                            boolean bl4 = false;
                            dasType = DasUnresolvedTypeReference.Companion.of(it);
                        } else {
                            dasType = null;
                        }
                        collection.add(dasType);
                    }
                    v4 = (List)destination$iv$iv;
                } else {
                    v4 = argument_types = null;
                }
                if ((cassFunction = (CassFunction)functions.find(arg_0 -> CassSchemaRetriever.retrieveFunctions$lambda$0$0$2(arg_0 -> CassSchemaRetriever.retrieveFunctions$lambda$0$0$1(name2, argument_types, arg_0), arg_0))) == null) {
                    BasicModElement basicModElement = functions.createNewOne();
                    Intrinsics.checkNotNullExpressionValue((Object)basicModElement, (String)"createNewOne(...)");
                    cassFunction = (CassFunction)basicModElement;
                }
                CassFunction function = cassFunction;
                function.setName(name2);
                Intrinsics.checkNotNull((Object)f);
                this.processFunction(f, function);
                function.resetSyncPending();
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private final void processFunction(CassIntroQueries.OneFunction f, CassFunction function) {
            DataType dataType = this.getDataType(f.return_type, true);
            if (dataType != null) {
                DataType it = dataType;
                boolean bl = false;
                this.setReturnType(function, it);
            }
            if (f.argument_names != null) {
                String[] $this$forEachIndexed$iv = f.argument_names;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (String item$iv : $this$forEachIndexed$iv) {
                    DataType it;
                    String string;
                    void argumentName;
                    int n = index$iv++;
                    String string2 = item$iv;
                    int index = n;
                    boolean bl = false;
                    CassArgument argument = (CassArgument)function.getArguments().renewAt((short)(index + 2), (String)argumentName);
                    if (f.argument_types != null) {
                        string = f.argument_types[index];
                    } else {
                        String[] cfr_ignored_0 = f.argument_types;
                        string = null;
                    }
                    if (this.getDataType(string, true) == null) continue;
                    boolean bl2 = false;
                    argument.setStoredType(DasUnresolvedTypeReference.Companion.of(it));
                }
            }
            function.setCalledOnNullInput(f.called_on_null_input);
            function.setLanguage(f.language);
            String string = f.body;
            if (string == null) {
                return;
            }
            String body2 = string;
            ((BasicModModel)function.getModel()).writeSources(() -> CassSchemaRetriever.processFunction$lambda$2(function, body2));
        }

        private final void setReturnType(CassRoutine routine, DataType returnDataType) {
            CassArgument argument = (CassArgument)routine.getArguments().renewAt((short)1, "");
            argument.setStoredType(DasUnresolvedTypeReference.Companion.of(returnDataType));
            argument.setArgumentDirection(ArgumentDirection.RETURN);
        }

        private final DataType getDataType(String validator, boolean unwrapFrozen) {
            String string;
            if (validator == null) {
                return null;
            }
            int[] nArray = new int[]{3, 0};
            if (CassIntrospector.this.getServerVersion().isOrGreater(nArray)) {
                string = validator;
            } else {
                string = CassIntrospectorHelperKt.parseDataType(validator);
                if (string == null) {
                    return null;
                }
            }
            String specification = string;
            return DataTypeFactory.of((String)(unwrapFrozen ? this.unwrapFrozen(specification) : specification));
        }

        static /* synthetic */ DataType getDataType$default(CassSchemaRetriever cassSchemaRetriever, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return cassSchemaRetriever.getDataType(string, bl);
        }

        private final String unwrapFrozen(String s) {
            if (StringsKt.startsWith$default((String)s, (String)"frozen<", (boolean)false, (int)2, null)) {
                String string = s.substring(7, s.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
            return s;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveAggregates(CassSchema schema) {
            int[] nArray = new int[]{2, 2};
            if (!CassIntrospector.this.getServerVersion().isOrGreater(nArray)) {
                return;
            }
            ObjectKind objectKind = ObjectKind.AGGREGATE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"AGGREGATE");
            CassIntrospector.this.reportRetrieving(objectKind);
            String string = schema.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Map<String, String> initConditions = this.getAggregateInitConditions(string);
            ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)schema.getAggregates();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily aggregates = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            SqlQuery<List<CassIntroQueries.OneAggregate>> sqlQuery = CassIntroQueries.Companion.getQUERIES().getRetrieveAggregate();
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)schema.getName(), (String)"getName(...)");
            Object object = this.performQuery(sqlQuery, null, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"performQuery(...)");
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String name2;
                CassAggregate cassAggregate;
                List argument_types;
                CassIntroQueries.OneAggregate a = (CassIntroQueries.OneAggregate)element$iv;
                boolean bl2 = false;
                if (a.name == null) continue;
                if (a.signature != null) {
                    void $this$mapTo$iv$iv;
                    String[] $this$map$iv = a.signature;
                    boolean $i$f$map = false;
                    String[] stringArray = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void argType;
                        void item$iv$iv;
                        void var23_24 = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        DataType dataType = DataTypeFactory.of((String)this.unwrapFrozen((String)argType));
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                        collection.add(DasUnresolvedTypeReference.Companion.of(dataType));
                    }
                    v5 = (List)destination$iv$iv;
                } else {
                    v5 = argument_types = null;
                }
                if ((cassAggregate = (CassAggregate)aggregates.find(arg_0 -> CassSchemaRetriever.retrieveAggregates$lambda$0$0$2(arg_0 -> CassSchemaRetriever.retrieveAggregates$lambda$0$0$1(name2, argument_types, arg_0), arg_0))) == null) {
                    BasicModElement basicModElement = aggregates.createNewOne();
                    Intrinsics.checkNotNullExpressionValue((Object)basicModElement, (String)"createNewOne(...)");
                    cassAggregate = (CassAggregate)basicModElement;
                }
                CassAggregate aggregate = cassAggregate;
                aggregate.setName(name2);
                Intrinsics.checkNotNull((Object)a);
                this.processAggregate(a, aggregate, initConditions);
                aggregate.resetSyncPending();
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        private final Map<String, String> getAggregateInitConditions(String keyspace) {
            RemoteConnection connection;
            DatabaseConnectionCore databaseConnectionCore = CassIntrospector.this.getDbConnection();
            Object object = connection = databaseConnectionCore != null ? databaseConnectionCore.getRemoteConnection() : null;
            if (connection == null || !(connection instanceof RemoteCassConnection)) {
                return null;
            }
            try {
                return ((RemoteCassConnection)connection).getAggregateInitConditions(keyspace);
            }
            catch (NoSuchObjectException e) {
                CassIntrospectorKt.access$getLOG$p().error((Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processAggregate(CassIntroQueries.OneAggregate a, CassAggregate aggregate, Map<String, String> initConditions) {
            block3: {
                DataType dataType = this.getDataType(a.return_type, true);
                if (dataType != null) {
                    DataType it = dataType;
                    boolean bl = false;
                    this.setReturnType(aggregate, it);
                }
                if (a.signature != null) {
                    String[] $this$forEachIndexed$iv = a.signature;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (String item$iv : $this$forEachIndexed$iv) {
                        void type;
                        int n = index$iv++;
                        String string = item$iv;
                        int index = n;
                        boolean bl = false;
                        CassArgument argument = (CassArgument)aggregate.getArguments().renewAt((short)(index + 2), "");
                        DataType dataType2 = DataTypeFactory.of((String)this.unwrapFrozen((String)type));
                        Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"of(...)");
                        argument.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType2));
                    }
                }
                aggregate.setFinalFunc(a.final_func);
                aggregate.setStateFunc(a.state_func);
                aggregate.setInitCond(this.getInitCondition(initConditions, a));
                DataType dataType3 = this.getDataType(a.state_type, true);
                if (dataType3 == null) break block3;
                DataType it = dataType3;
                boolean bl = false;
                aggregate.setStateStoredType(DasUnresolvedTypeReference.Companion.of(it));
            }
        }

        private final String getInitCondition(Map<String, String> initConditions, CassIntroQueries.OneAggregate a) {
            String string;
            if (initConditions == null) {
                return "???";
            }
            String string2 = a.name;
            if (a.signature != null) {
                string = ArraysKt.joinToString$default((Object[])a.signature, null, null, null, (int)0, null, arg_0 -> CassSchemaRetriever.getInitCondition$lambda$0(this, arg_0), (int)31, null);
            } else {
                String[] cfr_ignored_0 = a.signature;
                string = null;
            }
            String signature = string2 + "(" + string + ")";
            return initConditions.get(signature);
        }

        private final void retrieveDefTypes(CassSchema schema) {
            ObjectKind objectKind = ObjectKind.OBJECT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"OBJECT_TYPE");
            CassIntrospector.this.reportRetrieving(objectKind);
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Function1 it = CassSchemaRetriever$retrieveDefTypes$$inlined$modifyFamiliesAndCleanup$1.INSTANCE;
            boolean $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveDefTypes$32 = false;
            ModNamingFamily<? extends CassDefType> modNamingFamily = schema.getDefTypes();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getDefTypes(...)");
            it.invoke(modNamingFamily);
            ModNamingFamily<? extends CassDefType> modNamingFamily2 = schema.getDefTypes();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getDefTypes(...)");
            Iterable $this$forEach$iv = (Iterable)modNamingFamily2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CassDefType d = (CassDefType)element$iv;
                boolean bl = false;
                ModPositioningNamingFamily<? extends CassDefTypeAttribute> modPositioningNamingFamily = d.getAttributes();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getAttributes(...)");
                it.invoke(modPositioningNamingFamily);
            }
            boolean bl = false;
            SqlQuery<List<CassIntroQueries.OneDefType>> sqlQuery = CassIntroQueries.Companion.getQUERIES().getRetrieveDefTypes();
            Object[] $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveDefTypes$32 = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)schema.getName(), (String)"getName(...)");
            Object object = this.performQuery(sqlQuery, null, $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveDefTypes$32);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"performQuery(...)");
            $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                String name2;
                CassIntroQueries.OneDefType t = (CassIntroQueries.OneDefType)element$iv;
                boolean bl2 = false;
                if (t.name == null) continue;
                CassDefType objectType = (CassDefType)schema.getDefTypes().createOrGet(name2);
                Intrinsics.checkNotNull((Object)t);
                Intrinsics.checkNotNull((Object)objectType);
                this.processDefType(t, objectType);
            }
            it = CassSchemaRetriever$retrieveDefTypes$$inlined$modifyFamiliesAndCleanup$2.INSTANCE;
            boolean bl3 = false;
            ModNamingFamily<? extends CassDefType> modNamingFamily3 = schema.getDefTypes();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"getDefTypes(...)");
            it.invoke(modNamingFamily3);
            ModNamingFamily<? extends CassDefType> modNamingFamily4 = schema.getDefTypes();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily4, (String)"getDefTypes(...)");
            $this$forEach$iv = (Iterable)modNamingFamily4;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CassDefType d = (CassDefType)element$iv;
                boolean bl4 = false;
                ModPositioningNamingFamily<? extends CassDefTypeAttribute> modPositioningNamingFamily = d.getAttributes();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getAttributes(...)");
                it.invoke(modPositioningNamingFamily);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processDefType(CassIntroQueries.OneDefType t, CassDefType objectType) {
            if (t.field_names == null) {
                return;
            }
            String[] fieldNames = t.field_names;
            if (t.field_types == null) {
                return;
            }
            String[] fieldTypes = t.field_types;
            String[] $this$forEachIndexed$iv = fieldNames;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (String item$iv : $this$forEachIndexed$iv) {
                DataType it;
                void objectTypeName;
                int n = index$iv++;
                String string = item$iv;
                int index = n;
                boolean bl = false;
                CassDefTypeAttribute attribute = (CassDefTypeAttribute)objectType.getAttributes().renewAt((short)(index + 1), (String)objectTypeName);
                if (CassSchemaRetriever.getDataType$default(this, fieldTypes[index], false, 2, null) == null) continue;
                boolean bl2 = false;
                attribute.setStoredType(DasUnresolvedTypeReference.Companion.of(it));
            }
        }

        private static final Unit process$lambda$0(CassSchemaRetriever this$0, CassSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveTables(schema);
            return Unit.INSTANCE;
        }

        private static final Unit process$lambda$1(CassSchemaRetriever this$0, CassSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveMatViews(schema);
            return Unit.INSTANCE;
        }

        private static final Unit process$lambda$2(CassSchemaRetriever this$0, CassSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveColumns(schema);
            return Unit.INSTANCE;
        }

        private static final Unit process$lambda$3(CassSchemaRetriever this$0, CassSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveIndices(schema);
            return Unit.INSTANCE;
        }

        private static final Unit process$lambda$4(CassSchemaRetriever this$0, CassSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveTriggers(schema);
            return Unit.INSTANCE;
        }

        private static final Unit process$lambda$5(CassSchemaRetriever this$0, CassSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveFunctions(schema);
            return Unit.INSTANCE;
        }

        private static final Unit process$lambda$6(CassSchemaRetriever this$0, CassSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveAggregates(schema);
            return Unit.INSTANCE;
        }

        private static final Unit process$lambda$7(CassSchemaRetriever this$0, CassSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveDefTypes(schema);
            return Unit.INSTANCE;
        }

        private static final boolean createKey$lambda$0(CassIntroQueries.OneColumn it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getK() == CassIntroQueries.ColumnKind.PARTITIONING && it.getColName() != null;
        }

        private static final CassKeyColumn createKey$lambda$2(CassIntroQueries.OneColumn it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = it.getColName();
            Intrinsics.checkNotNull((Object)string);
            return new CassKeyColumn(string, null);
        }

        private static final boolean createKey$lambda$3(CassIntroQueries.OneColumn it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getK() == CassIntroQueries.ColumnKind.CLUSTERING && it.getColName() != null;
        }

        private static final CassKeyColumn createKey$lambda$5(CassIntroQueries.OneColumn it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = it.getColName();
            Intrinsics.checkNotNull((Object)string);
            return new CassKeyColumn(string, it.getOrder());
        }

        private static final boolean retrieveIndices3$lambda$1$0$4(String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return !Intrinsics.areEqual((Object)key, (Object)"class_name") && !Intrinsics.areEqual((Object)key, (Object)"target");
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean retrieveFunctions$lambda$0$0$1(String $name, List $argument_types, CassFunction it) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $this$sortedBy$iv;
            CassArgument it2;
            void $this$filterTo$iv$iv;
            ModPositioningNamingFamily<? extends CassArgument> modPositioningNamingFamily = ((CassRoutine)it).getArguments();
            Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getArguments(...)");
            Iterable $this$filter$iv = (Iterable)modPositioningNamingFamily;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it2 = (CassArgument)element$iv$iv;
                boolean bl = false;
                if (!(it2.getArgumentDirection() != ArgumentDirection.RETURN)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    CassArgument it = (CassArgument)a;
                    boolean bl = false;
                    Comparable comparable = Short.valueOf(it.getPosition());
                    it = (CassArgument)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Short.valueOf(it.getPosition()));
                }
            });
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (CassArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it2.getStoredType());
            }
            List itArguments = (List)destination$iv$iv;
            return Intrinsics.areEqual((Object)it.getName(), (Object)$name) && ($argument_types == null || Intrinsics.areEqual((Object)itArguments, (Object)$argument_types));
        }

        private static final boolean retrieveFunctions$lambda$0$0$2(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final void processFunction$lambda$2(CassFunction $function, String $body) {
            $function.setSourceText((CompositeText)BaseIntrospectionFunctions.toCompositeText((String)$body, (CompositeText.Kind)CompositeText.Kind.ORIGINAL_TEXT));
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean retrieveAggregates$lambda$0$0$1(String $name, List $argument_types, CassAggregate it) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $this$sortedBy$iv;
            CassArgument it2;
            void $this$filterTo$iv$iv;
            ModPositioningNamingFamily<? extends CassArgument> modPositioningNamingFamily = ((CassRoutine)it).getArguments();
            Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getArguments(...)");
            Iterable $this$filter$iv = (Iterable)modPositioningNamingFamily;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it2 = (CassArgument)element$iv$iv;
                boolean bl = false;
                if (!(it2.getArgumentDirection() != ArgumentDirection.RETURN)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    CassArgument it = (CassArgument)a;
                    boolean bl = false;
                    Comparable comparable = Short.valueOf(it.getPosition());
                    it = (CassArgument)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Short.valueOf(it.getPosition()));
                }
            });
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (CassArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it2.getStoredType());
            }
            List itArguments = (List)destination$iv$iv;
            return Intrinsics.areEqual((Object)((CassRoutine)it).getName(), (Object)$name) && ($argument_types == null || Intrinsics.areEqual((Object)itArguments, (Object)$argument_types));
        }

        private static final boolean retrieveAggregates$lambda$0$0$2(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final CharSequence getInitCondition$lambda$0(CassSchemaRetriever this$0, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return this$0.unwrapFrozen(it);
        }

        public static final /* synthetic */ void access$processColumns3(CassSchemaRetriever $this, CassLikeTable table, List columns) {
            $this.processColumns3(table, columns);
        }

        public static final /* synthetic */ void access$processColumns2(CassSchemaRetriever $this, CassLikeTable table, List columns) {
            $this.processColumns2(table, columns);
        }

        public static final /* synthetic */ void access$processIndex(CassSchemaRetriever $this, CassTable table, CassIndex index, List columns) {
            $this.processIndex(table, index, columns);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever$ColumnSorter;", "", "columns", "", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneColumn;", "<init>", "(Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever;Ljava/util/List;)V", "partitionColsCount", "", "clusteringColsCount", "regularColumnsCount", "idx", "", "c", "intellij.database.dialects.cassandra"})
        @SourceDebugExtension(value={"SMAP\nCassIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CassIntrospector.kt\ncom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever$ColumnSorter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,577:1\n1834#2,4:578\n1834#2,4:582\n*S KotlinDebug\n*F\n+ 1 CassIntrospector.kt\ncom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever$ColumnSorter\n*L\n297#1:578,4\n298#1:582,4\n*E\n"})
        private final class ColumnSorter {
            private final int partitionColsCount;
            private final int clusteringColsCount;
            private int regularColumnsCount;

            public ColumnSorter(List<? extends CassIntroQueries.OneColumn> columns) {
                int n;
                int n2;
                CassIntroQueries.OneColumn it;
                int count$iv;
                int n3;
                Iterable $this$count$iv;
                Intrinsics.checkNotNullParameter(columns, (String)"columns");
                Iterable iterable = columns;
                ColumnSorter columnSorter = this;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n3 = 0;
                } else {
                    count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        it = (CassIntroQueries.OneColumn)element$iv;
                        boolean bl = false;
                        if (!(it.getK() == CassIntroQueries.ColumnKind.PARTITIONING) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n3 = count$iv;
                }
                columnSorter.partitionColsCount = n2 = n3;
                $this$count$iv = columns;
                columnSorter = this;
                $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        it = (CassIntroQueries.OneColumn)element$iv;
                        boolean bl = false;
                        if (!(it.getK() == CassIntroQueries.ColumnKind.CLUSTERING) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                columnSorter.clusteringColsCount = n2 = n;
            }

            public final short idx(@NotNull CassIntroQueries.OneColumn c) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                return (short)(1 + (switch (WhenMappings.$EnumSwitchMapping$0[c.getK().ordinal()]) {
                    case 1 -> c.getPos();
                    case 2 -> c.getPos() + this.partitionColsCount;
                    default -> {
                        int var2_2 = this.regularColumnsCount;
                        this.regularColumnsCount = var2_2 + 1;
                        yield this.partitionColsCount + this.clusteringColsCount + var2_2;
                    }
                }));
            }

            @Metadata(mv={2, 3, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[CassIntroQueries.ColumnKind.values().length];
                    try {
                        nArray[CassIntroQueries.ColumnKind.PARTITIONING.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[CassIntroQueries.ColumnKind.CLUSTERING.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "<init>", "()V", "isSupported", "", "version", "Lcom/intellij/database/util/Version;", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "VERSION", "intellij.database.dialects.cassandra"})
    public static final class Factory
    implements DBIntrospector.Factory {
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{2, 0};
            return version.isOrGreater(nArray);
        }

        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return (DBIntrospector)new CassIntrospector(context, modelFactory);
        }

        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return false;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "<init>", "()V", "intellij.database.dialects.cassandra"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }
}

