/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.dynamo.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.dynamo.DynamoDbms;
import com.intellij.database.dialects.dynamo.introspector.DynamoIntrospectionException;
import com.intellij.database.dialects.dynamo.introspector.DynamoIntrospector$applySchemas$lambda$0$;
import com.intellij.database.dialects.dynamo.model.DynamoIndex;
import com.intellij.database.dialects.dynamo.model.DynamoKey;
import com.intellij.database.dialects.dynamo.model.DynamoRoot;
import com.intellij.database.dialects.dynamo.model.DynamoSchema;
import com.intellij.database.dialects.dynamo.model.DynamoTable;
import com.intellij.database.dialects.dynamo.model.DynamoTableColumn;
import com.intellij.database.dialects.dynamo.model.properties.DynamoIndexProjectionType;
import com.intellij.database.dialects.dynamo.model.properties.DynamoTableClass;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ElementCacheKt;
import com.intellij.database.model.ElementCacheOptimizersKt;
import com.intellij.database.model.ElementChecker;
import com.intellij.database.model.ElementSearchCache;
import com.intellij.database.model.ElementSearcher;
import com.intellij.database.model.ElementSearcherNN;
import com.intellij.database.model.FamilySearcher;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Level;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteDynamoConnection;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Version;
import java.io.Closeable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003!\"#B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0011\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J&\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J6\u0010\u0019\u001a \u0012\u0006\b\u0001\u0012\u00020\u00030\u001aR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0003H\u0014J6\u0010\u001e\u001a \u0012\u0006\b\u0001\u0012\u00020\u00020\u001fR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0002H\u0014\u00a8\u0006$"}, d2={"Lcom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/dynamo/model/DynamoRoot;", "Lcom/intellij/database/dialects/dynamo/model/DynamoSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "createMetaData", "Lcom/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper;", "retrieveAndApplySchemas", "", "introspectNamespacesInTran", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "applySchemas", "newSchemas", "", "", "introspectSchemasAuto", "schemas", "whole", "", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "schema", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "database", "Factory", "DynamoSchemaRetriever", "DynamoDatabaseRetriever", "intellij.database.dialects.dynamo"})
@SourceDebugExtension(value={"SMAP\nDynamoIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamoIntrospector.kt\ncom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector\n+ 2 ModelFun.kt\ncom/intellij/database/model/ModelFun\n+ 3 ElementCache.kt\ncom/intellij/database/model/FamilySearcher\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n443#2,10:233\n453#2,9:253\n462#2:263\n454#2:264\n455#2,9:266\n464#2,3:276\n456#2:279\n457#2:281\n189#3,10:243\n202#3:280\n1915#4:262\n1916#4:275\n1#5:265\n*S KotlinDebug\n*F\n+ 1 DynamoIntrospector.kt\ncom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector\n*L\n94#1:233,10\n94#1:253,9\n94#1:263\n94#1:264\n94#1:266,9\n94#1:276,3\n94#1:279\n94#1:281\n94#1:243,10\n94#1:280\n94#1:262\n94#1:275\n94#1:265\n*E\n"})
public final class DynamoIntrospector
extends BaseSingleDatabaseIntrospector<DynamoRoot, DynamoSchema> {
    public DynamoIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = (BaseIntrospector.Nature)BaseIntrospector.DefaultNature.INSTANCE;
        Dbms dbms = DynamoDbms.DYNAMO;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"DYNAMO");
        super(context, nature, dbms, modelFactory);
    }

    private final DatabaseMetaDataWrapper createMetaData() {
        DatabaseConnectionCore connection;
        DatabaseConnectionCore databaseConnectionCore = connection = this.getDbConnection();
        if (databaseConnectionCore != null) {
            DatabaseMetaDataWrapper databaseMetaDataWrapper;
            DatabaseConnectionCore it = databaseConnectionCore;
            boolean bl = false;
            try {
                RemoteDatabaseMetaData remoteDatabaseMetaData = connection.getRemoteMetaData();
                if (remoteDatabaseMetaData == null) {
                    throw new DynamoIntrospectionException("Connection#getMetaData() returns null. No introspection could be performed", null, 2, null);
                }
                RemoteDatabaseMetaData metaData = remoteDatabaseMetaData;
                databaseMetaDataWrapper = DatabaseMetaDataWrapper.create((DatabaseConnectionCore)connection, (RemoteDatabaseMetaData)metaData).withErrorSink(this.getErrorSink());
                Intrinsics.checkNotNull((Object)databaseMetaDataWrapper);
            }
            catch (SQLException e) {
                throw new DynamoIntrospectionException("Failed to retrieve meta data", e);
            }
            return databaseMetaDataWrapper;
        }
        throw new DynamoIntrospectionException("Failed to get connection", null, 2, null);
    }

    public void retrieveAndApplySchemas() {
        this.inTransactionUnit(arg_0 -> DynamoIntrospector.retrieveAndApplySchemas$lambda$0(this, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Closeable closeable = (Closeable)this.createMetaData().databases();
        Throwable throwable = null;
        try {
            ClosableIt it = (ClosableIt)closeable;
            boolean bl = false;
            List list = it.toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
            this.applySchemas(list);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void applySchemas(List<String> newSchemas) {
        this.inModel(arg_0 -> DynamoIntrospector.applySchemas$lambda$0(newSchemas, arg_0));
    }

    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends DynamoSchema> schemas, boolean whole) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
        for (DynamoSchema dynamoSchema : schemas) {
            this.handleErrors("Introspect schema " + dynamoSchema.getName(), () -> DynamoIntrospector.introspectSchemasAuto$lambda$0(this, tran, dynamoSchema));
        }
    }

    @NotNull
    protected BaseNativeIntrospector.AbstractSchemaRetriever<? extends DynamoSchema> createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull DynamoSchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new DynamoSchemaRetriever(this, transaction, schema);
    }

    @NotNull
    protected BaseNativeIntrospector.AbstractDatabaseRetriever<? extends DynamoRoot> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull DynamoRoot database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return (BaseNativeIntrospector.AbstractDatabaseRetriever)new DynamoDatabaseRetriever(transaction);
    }

    private static final Unit retrieveAndApplySchemas$lambda$0(DynamoIntrospector this$0, DBTransaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.introspectNamespacesInTran(it);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit applySchemas$lambda$0(List $newSchemas, DynamoRoot root) {
        void $this$iv$iv$iv;
        void $this$applySchemasNamed$iv$iv;
        void searchCache$iv$iv;
        void $this$applySchemasNamed$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ModNamingFamily<? extends DynamoSchema> modNamingFamily = root.getSchemas();
        Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getSchemas(...)");
        ModNamingFamily<? extends DynamoSchema> modNamingFamily2 = modNamingFamily;
        List scs$iv = $newSchemas;
        boolean $i$f$applySchemasNamed = false;
        void var5_5 = $this$applySchemasNamed$iv;
        ElementSearchCache elementSearchCache = new ElementSearchCache();
        List scs$iv$iv = scs$iv;
        boolean $i$f$applySchemasNamed2 = false;
        FamilySearcher familySearcher = ElementCacheOptimizersKt.byName((ElementChecker)ElementCacheKt.searchElement((ElementSearchCache)searchCache$iv$iv), (Function1)((Function1)new Function1<String, String>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final String invoke(Object $this$byName) {
                void var2_2;
                String it = (String)$this$byName;
                boolean bl = false;
                return var2_2;
            }
        })).inFamily((Family)$this$applySchemasNamed$iv$iv);
        Function2 filler$iv$iv$iv = applySchemas$lambda$0$$inlined$applySchemasNamed$2.INSTANCE;
        boolean $i$f$orCreateBulk = false;
        ArrayList items$iv$iv$iv = new ArrayList();
        ElementSearcherNN searcher$iv$iv$iv = ElementCacheKt.orCreateElement((ElementSearcher)((ElementSearcher)$this$iv$iv$iv), (Function1)new Function1<D, T>((FamilySearcher)$this$iv$iv$iv, filler$iv$iv$iv, items$iv$iv$iv){
            final /* synthetic */ FamilySearcher this$0;
            final /* synthetic */ Function2 $filler;
            final /* synthetic */ ArrayList $items;
            {
                this.this$0 = $receiver;
                this.$filler = $filler;
                this.$items = $items;
            }

            public final T invoke(D it) {
                BasicElement basicElement = BasicMetaUtils.getMetaObject((Family)this.this$0.getFamily()).newDataObject();
                Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"newDataObject(...)");
                BasicElement basicElement2 = basicElement;
                FamilySearcher familySearcher = this.this$0;
                Function2 function2 = this.$filler;
                ArrayList arrayList = this.$items;
                BasicElement $this$invoke_u24lambda_u240 = basicElement2;
                boolean bl = false;
                familySearcher.fillImpl($this$invoke_u24lambda_u240, it, function2);
                ((Collection)arrayList).add($this$invoke_u24lambda_u240);
                return (T)basicElement2;
            }
        });
        try {
            void $this$applySchemasImpl$iv$iv$iv;
            ElementSearcherNN schemas$iv$iv = searcher$iv$iv$iv;
            boolean bl = false;
            void var16_17 = $this$applySchemasNamed$iv$iv;
            List scs$iv$iv$iv = scs$iv$iv;
            boolean $i$f$applySchemasImpl = false;
            $this$applySchemasImpl$iv$iv$iv.markChildrenAsSyncPending();
            Iterable $this$forEach$iv$iv$iv$iv = scs$iv$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                void sc$iv$iv;
                Object element$iv$iv$iv$iv;
                Object sc$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Object t = sc$iv$iv$iv;
                void $this$applySchemasNamed_u24lambda_u240_u240$iv$iv = $this$applySchemasImpl$iv$iv$iv;
                boolean bl3 = false;
                BasicModMateNamespace $this$applySchemasNamed_u24lambda_u240_u240_u240$iv$iv = (BasicModMateNamespace)schemas$iv$iv.find((Object)sc$iv$iv);
                boolean bl4 = false;
                String string = (String)sc$iv$iv;
                DynamoSchema $this$applySchemas_u24lambda_u240_u241 = (DynamoSchema)$this$applySchemasNamed_u24lambda_u240_u240_u240$iv$iv;
                boolean bl5 = false;
            }
            $this$applySchemasImpl$iv$iv$iv.removeSyncPendingChildren();
            $this$applySchemasImpl$iv$iv$iv.sort();
        }
        finally {
            Family family = $this$iv$iv$iv.getFamily();
            Intrinsics.checkNotNull((Object)family, (String)"null cannot be cast to non-null type com.intellij.database.model.families.Family<T of com.intellij.database.model.FamilySearcher>");
            BaseModel.createBulk((Family)family, (Iterable)items$iv$iv$iv);
        }
        return Unit.INSTANCE;
    }

    private static final Unit introspectSchemasAuto$lambda$0(DynamoIntrospector this$0, DBTransaction $tran, DynamoSchema $schema) {
        BaseNativeIntrospector.AbstractSchemaRetriever<? extends DynamoSchema> retriever = this$0.createSchemaRetriever($tran, $schema);
        retriever.process();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u0018\u0012\u0004\u0012\u0002H\u00010\u0003R\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector$DynamoDatabaseRetriever;", "R", "Lcom/intellij/database/dialects/dynamo/model/DynamoRoot;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/dynamo/model/DynamoSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "<init>", "(Lcom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;)V", "intellij.database.dialects.dynamo"})
    private final class DynamoDatabaseRetriever<R extends DynamoRoot>
    extends BaseSingleDatabaseIntrospector.BaseDatabaseRetriever<R> {
        public DynamoDatabaseRetriever(DBTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            super((BaseSingleDatabaseIntrospector)DynamoIntrospector.this, transaction);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J:\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u001b2 \u0010\u001c\u001a\u001c\u0012\u0004\u0012\u00020\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d\u0018\u00010\u001d2\u0006\u0010 \u001a\u00020\fH\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector$DynamoSchemaRetriever;", "S", "Lcom/intellij/database/dialects/dynamo/model/DynamoSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/dynamo/model/DynamoRoot;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/dynamo/model/DynamoSchema;)V", "isPossibleToIntrospectSchemaIncrementally", "", "level", "Lcom/intellij/database/model/properties/Level;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/dynamo/model/DynamoSchema;Lcom/intellij/database/model/properties/Level;)Z", "process", "", "retrieveTables", "metaData", "Lcom/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper;", "retrieveTableData", "connection", "Lcom/intellij/database/remote/jdbc/RemoteDynamoConnection;", "table", "Lcom/intellij/database/model/basic/BasicModElement;", "applyIndices", "Lcom/intellij/database/dialects/dynamo/model/DynamoTable;", "indexes", "", "", "", "isGlobal", "intellij.database.dialects.dynamo"})
    @SourceDebugExtension(value={"SMAP\nDynamoIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamoIntrospector.kt\ncom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector$DynamoSchemaRetriever\n+ 2 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n196#2,13:233\n196#2,13:246\n196#2,7:259\n204#2,5:267\n196#2,13:272\n1#3:266\n*S KotlinDebug\n*F\n+ 1 DynamoIntrospector.kt\ncom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector$DynamoSchemaRetriever\n*L\n125#1:233,13\n151#1:246,13\n163#1:259,7\n163#1:267,5\n175#1:272,13\n*E\n"})
    private static final class DynamoSchemaRetriever<S extends DynamoSchema>
    extends BaseNativeIntrospector.AbstractSchemaRetriever<S> {
        final /* synthetic */ DynamoIntrospector this$0;

        public DynamoSchemaRetriever(@NotNull DBTransaction tran, S schema) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this.this$0 = this$0;
            super((BaseNativeIntrospector)this$0, tran, (BasicModSchema)schema);
        }

        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull S schema, @NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            return false;
        }

        public void process() {
            DatabaseMetaDataWrapper metaData = this.this$0.createMetaData();
            this.inSchema(arg_0 -> DynamoSchemaRetriever.process$lambda$0(this, metaData, arg_0));
            this.inSchema(arg_0 -> DynamoSchemaRetriever.process$lambda$1(this, arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void retrieveTables(DatabaseMetaDataWrapper metaData) {
            void families$iv;
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
            this.this$0.reportRetrieving(objectKind);
            ModFamily[] modFamilyArray = new ModFamily[1];
            Intrinsics.checkNotNullExpressionValue(((DynamoSchema)this.getSchema()).getTables(), (String)"getTables(...)");
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (void f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            ElementChecker elementChecker = ElementCacheOptimizersKt.byName((ElementChecker)this.searchInSchema(), DynamoSchemaRetriever::retrieveTables$lambda$0$0);
            ModNamingFamily<? extends DynamoTable> modNamingFamily = ((DynamoSchema)this.getSchema()).getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            ElementSearcherNN nameSearcher = elementChecker.inFamily((Family)modNamingFamily).orCreate(DynamoSchemaRetriever::retrieveTables$lambda$0$1);
            Closeable closeable = (Closeable)metaData.tables(new DatabaseMetaDataWrapper.Schema(this.getSchema().getName(), null), null, null);
            Throwable throwable = null;
            try {
                ClosableIt retrievedTables = (ClosableIt)closeable;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)retrievedTables);
                ClosableIt closableIt = retrievedTables;
                while (((Iterator)closableIt).hasNext()) {
                    DatabaseMetaDataWrapper.Table table = (DatabaseMetaDataWrapper.Table)closableIt.next();
                    Intrinsics.checkNotNull((Object)table);
                    nameSearcher.find((Object)table);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            for (void f$iv : families$iv) {
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
        }

        private final void retrieveTableData() {
            RemoteConnection connection;
            DatabaseConnectionCore databaseConnectionCore = this.this$0.getDbConnection();
            Object object = connection = databaseConnectionCore != null ? databaseConnectionCore.getRemoteConnection() : null;
            if (!(connection instanceof RemoteDynamoConnection)) {
                return;
            }
            for (DynamoTable table : ((DynamoSchema)this.getSchema()).getTables()) {
                RemoteDynamoConnection remoteDynamoConnection = (RemoteDynamoConnection)connection;
                Intrinsics.checkNotNull((Object)table);
                this.retrieveTableData(remoteDynamoConnection, table);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTableData(RemoteDynamoConnection connection, BasicModElement table) {
            block16: {
                String sortColumn;
                Object types;
                if (!(table instanceof DynamoTable)) {
                    return;
                }
                Map map = connection.describeTable(((DynamoTable)table).getName());
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                Map desc = map;
                ModFamily[] modFamilyArray = new ModFamily[1];
                Intrinsics.checkNotNullExpressionValue(((DynamoTable)table).getColumns(), (String)"getColumns(...)");
                ModFamily[] families$iv = modFamilyArray;
                boolean removeUnaffected$iv = true;
                boolean bl = false;
                for (ModFamily f$iv : families$iv) {
                    f$iv.markChildrenAsSyncPending();
                }
                boolean bl2 = false;
                Object v = desc.get("ATTRIBUTE_NAMES");
                String[] names = v instanceof String[] ? (String[])v : null;
                Object v2 = desc.get("ATTRIBUTE_TYPES");
                String[] stringArray = types = v2 instanceof String[] ? (String[])v2 : null;
                if (names != null && types != null && names.length == ((String[])types).length) {
                    int n = names.length;
                    for (int i = 0; i < n; ++i) {
                        DynamoTableColumn column = (DynamoTableColumn)((DynamoTable)table).getColumns().createOrGet(names[i]);
                        column.setPosition((short)(i + 1));
                        DataType dataType = DataTypeFactory.of((String)types[i]);
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                        column.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
                    }
                }
                for (ModFamily f$iv : families$iv) {
                    f$iv.removeSyncPendingChildren();
                    f$iv.sort();
                }
                families$iv = new ModFamily[1];
                Intrinsics.checkNotNullExpressionValue(((DynamoTable)table).getKeys(), (String)"getKeys(...)");
                boolean removeUnaffected$iv42 = true;
                boolean bl3 = false;
                for (ModFamily f$iv : families$iv) {
                    f$iv.markChildrenAsSyncPending();
                }
                int n = 0;
                types = desc.get("HASH_KEY");
                String partitionColumn = types instanceof String ? (String)types : null;
                Object i = desc.get("SORT_KEY");
                String string = sortColumn = i instanceof String ? (String)i : null;
                if (partitionColumn != null) {
                    BasicNameReference basicNameReference;
                    DynamoKey key = (DynamoKey)((DynamoTable)table).getKeys().createOrGet("primary key");
                    key.setPartitionColumnRef((BasicReference)BasicNameReference.create((String)partitionColumn));
                    DynamoKey dynamoKey = key;
                    String string2 = sortColumn;
                    if (string2 != null) {
                        void it;
                        String string3 = string2;
                        DynamoKey dynamoKey2 = dynamoKey;
                        boolean bl22 = false;
                        basicNameReference = BasicNameReference.create((String)it);
                        dynamoKey = dynamoKey2;
                    } else {
                        basicNameReference = null;
                    }
                    dynamoKey.setSortColumnRef((BasicReference)basicNameReference);
                }
                for (ModFamily f$iv : families$iv) {
                    f$iv.removeSyncPendingChildren();
                    f$iv.sort();
                }
                Object removeUnaffected$iv42 = desc.get("LOCAL_INDEXES_KEY");
                Map localIndices = removeUnaffected$iv42 instanceof Map ? (Map)removeUnaffected$iv42 : null;
                Object v3 = desc.get("GLOBAL_INDEXES_KEY");
                Map globalIndices = v3 instanceof Map ? (Map)v3 : null;
                ModFamily[] modFamilyArray2 = new ModFamily[1];
                Intrinsics.checkNotNullExpressionValue(((DynamoTable)table).getIndices(), (String)"getIndices(...)");
                ModFamily[] modFamilyArray3 = modFamilyArray2;
                boolean removeUnaffected$iv3 = true;
                boolean $i$f$modifyFamiliesAndCleanup3 = false;
                for (ModFamily f$iv : modFamilyArray3) {
                    f$iv.markChildrenAsSyncPending();
                }
                boolean bl32 = false;
                if (localIndices != null || globalIndices != null) {
                    this.applyIndices((DynamoTable)table, localIndices, false);
                    this.applyIndices((DynamoTable)table, globalIndices, true);
                }
                for (ModFamily f$iv : modFamilyArray3) {
                    f$iv.removeSyncPendingChildren();
                    f$iv.sort();
                }
                Object v4 = desc.get("READ_CAPACITY_UNITS");
                Long l = v4 instanceof Long ? (Long)v4 : null;
                if (l != null) {
                    long it = ((Number)l).longValue();
                    boolean bl4 = false;
                    ((DynamoTable)table).setReadThroughput(it);
                }
                v4 = desc.get("WRITE_CAPACITY_UNITS");
                Long l2 = v4 instanceof Long ? (Long)v4 : null;
                if (l2 != null) {
                    long it = ((Number)l2).longValue();
                    boolean bl5 = false;
                    ((DynamoTable)table).setWriteThroughput(it);
                }
                v4 = desc.get("TABLE_CLASS");
                String string4 = v4 instanceof String ? (String)v4 : null;
                if (string4 == null) break block16;
                String it = string4;
                boolean bl6 = false;
                ((DynamoTable)table).setTableClass(DynamoTableClass.valueOf(it));
            }
        }

        /*
         * Unable to fully structure code
         */
        private final void applyIndices(DynamoTable table, Map<String, ? extends Map<String, ? extends Object>> indexes, boolean isGlobal) {
            if (indexes == null) {
                return;
            }
            for (Map.Entry<String, ? extends Map<String, ? extends Object>> var5_5 : indexes.entrySet()) {
                block14: {
                    block12: {
                        block13: {
                            name = var5_5.getKey();
                            indexDesc = var5_5.getValue();
                            var9_9 = indexDesc.get("HASH_KEY");
                            partitionColumn = var9_9 instanceof String != false ? (String)var9_9 : null;
                            var10_10 = indexDesc.get("SORT_KEY");
                            v0 = sortColumn = var10_10 instanceof String != false ? (String)var10_10 : null;
                            if (partitionColumn == null) continue;
                            index = (DynamoIndex)table.getIndices().createOrGet(name);
                            index.setPartitionColumnRef((BasicReference)BasicNameReference.create((String)partitionColumn));
                            v1 = index;
                            v2 = sortColumn;
                            if (v2 != null) {
                                var12_12 = v2;
                                var14_15 = v1;
                                $i$a$-let-DynamoIntrospector$DynamoSchemaRetriever$applyIndices$1 = false;
                                v3 = BasicNameReference.create((String)it);
                                v1 = var14_15;
                            } else {
                                v3 = null;
                            }
                            v1.setSortColumnRef((BasicReference)v3);
                            var12_12 = indexDesc.get("INDEX_PROJECTION_TYPE");
                            projectionType = var12_12 instanceof String != false ? (String)var12_12 : null;
                            var12_12 = projectionType;
                            if (var12_12 == null) break block12;
                            switch (var12_12.hashCode()) {
                                case 64897: {
                                    if (!var12_12.equals("ALL")) {
                                        ** break;
                                    }
                                    break block13;
                                }
                                case -1634410360: {
                                    if (var12_12.equals("INCLUDE")) break;
                                    ** break;
                                }
                                case 1724531479: {
                                    if (!var12_12.equals("KEYS_ONLY")) ** break;
                                    v4 = DynamoIndexProjectionType.KEYS_ONLY;
                                    break block14;
                                }
                            }
                            v4 = DynamoIndexProjectionType.INCLUDE;
                            break block14;
                        }
                        v4 = DynamoIndexProjectionType.ALL;
                        break block14;
                    }
                    v4 = DynamoIndexProjectionType.KEYS_ONLY;
                }
                index.setProjectionType(v4);
                var13_13 = indexDesc.get("INDEX_PROJECTION_ATTRIBUTES");
                v5 = var13_13 instanceof List != false ? (List)var13_13 : null;
                if (v5 == null) {
                    v5 = CollectionsKt.emptyList();
                }
                index.setProjectedColumnNames(v5);
                index.setGlobal(isGlobal);
                if (isGlobal) {
                    var13_13 = indexDesc.get("READ_CAPACITY_UNITS");
                    v6 = var13_13 instanceof Long != false ? (Long)var13_13 : null;
                    index.setReadThroughput(v6 != null ? v6 : -1L);
                    var13_13 = indexDesc.get("WRITE_CAPACITY_UNITS");
                    v7 = var13_13 instanceof Long != false ? (Long)var13_13 : null;
                    index.setWriteThroughput(v7 != null ? v7 : -1L);
                    continue;
                }
                index.setReadThroughput(0L);
                index.setWriteThroughput(0L);
            }
        }

        private static final Unit process$lambda$0(DynamoSchemaRetriever this$0, DatabaseMetaDataWrapper $metaData, DynamoSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.retrieveTables($metaData);
            return Unit.INSTANCE;
        }

        private static final Unit process$lambda$1(DynamoSchemaRetriever this$0, DynamoSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.retrieveTableData();
            return Unit.INSTANCE;
        }

        private static final String retrieveTables$lambda$0$0(DatabaseMetaDataWrapper.Table $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            String string = $this$byName.name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            return string;
        }

        private static final Unit retrieveTables$lambda$0$1(DynamoTable $this$orCreate, DatabaseMetaDataWrapper.Table it) {
            Intrinsics.checkNotNullParameter((Object)$this$orCreate, (String)"$this$orCreate");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "<init>", "()V", "isSupported", "", "version", "Lcom/intellij/database/util/Version;", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "VERSION", "intellij.database.dialects.dynamo"})
    public static final class Factory
    implements DBIntrospector.Factory {
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return true;
        }

        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return (DBIntrospector)new DynamoIntrospector(context, modelFactory);
        }

        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return false;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "<init>", "()V", "intellij.database.dialects.dynamo"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }
}

