/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.configurationStore;

import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StreamProviderFactory;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.configurationStore.ExternalStorageSpec;
import com.intellij.openapi.externalSystem.configurationStore.ModuleFileSystemExternalSystemStorage;
import com.intellij.openapi.externalSystem.configurationStore.ProjectFileSystemExternalSystemStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ProjectModelElement;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.Function;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JB\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00180\u001b2\u0006\u0010\"\u001a\u00020#H\u0016J\u001a\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00172\b\u0010&\u001a\u0004\u0018\u00010!H\u0016J\u0010\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/openapi/externalSystem/configurationStore/ExternalSystemStreamProviderFactory;", "Lcom/intellij/configurationStore/StreamProviderFactory;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "moduleStorage", "Lcom/intellij/openapi/externalSystem/configurationStore/ModuleFileSystemExternalSystemStorage;", "getModuleStorage", "()Lcom/intellij/openapi/externalSystem/configurationStore/ModuleFileSystemExternalSystemStorage;", "moduleStorage$delegate", "Lkotlin/Lazy;", "fileStorage", "Lcom/intellij/openapi/externalSystem/configurationStore/ProjectFileSystemExternalSystemStorage;", "getFileStorage", "()Lcom/intellij/openapi/externalSystem/configurationStore/ProjectFileSystemExternalSystemStorage;", "fileStorage$delegate", "isReimportOnMissedExternalStorageScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "storageSpecLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "storages", "Ljava/util/HashMap;", "", "Lcom/intellij/openapi/components/Storage;", "Lkotlin/collections/HashMap;", "customizeStorageSpecs", "", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManager;", "stateSpec", "Lcom/intellij/openapi/components/State;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "getOrCreateStorageSpec", "fileSpec", "inProjectStateSpec", "readModuleData", "Lorg/jdom/Element;", "name", "intellij.platform.externalSystem.impl"})
@SourceDebugExtension(value={"SMAP\nExternalSystemStreamProviderFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalSystemStreamProviderFactory.kt\ncom/intellij/openapi/externalSystem/configurationStore/ExternalSystemStreamProviderFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1#2:149\n*E\n"})
public final class ExternalSystemStreamProviderFactory
implements StreamProviderFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy moduleStorage$delegate;
    @NotNull
    private final Lazy fileStorage$delegate;
    @NotNull
    private final AtomicBoolean isReimportOnMissedExternalStorageScheduled;
    @NotNull
    private final ReentrantReadWriteLock storageSpecLock;
    @NotNull
    private final HashMap<String, Storage> storages;

    public ExternalSystemStreamProviderFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.moduleStorage$delegate = LazyKt.lazy(() -> ExternalSystemStreamProviderFactory.moduleStorage_delegate$lambda$0(this));
        this.fileStorage$delegate = LazyKt.lazy(() -> ExternalSystemStreamProviderFactory.fileStorage_delegate$lambda$0(this));
        this.isReimportOnMissedExternalStorageScheduled = new AtomicBoolean(false);
        this.storageSpecLock = new ReentrantReadWriteLock();
        this.storages = new HashMap();
        SimpleMessageBusConnection simpleMessageBusConnection = this.project.getMessageBus().simpleConnect();
        Topic topic = ModuleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        simpleMessageBusConnection.subscribe(topic, (Object)new ModuleListener(){

            public void moduleRemoved(Project project, Module module) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                ModuleFileSystemExternalSystemStorage moduleFileSystemExternalSystemStorage = this.getModuleStorage();
                String string = module.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                moduleFileSystemExternalSystemStorage.remove(string);
            }

            public void modulesRenamed(Project project, List<? extends Module> modules, Function<? super Module, String> oldNameProvider) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(modules, (String)"modules");
                Intrinsics.checkNotNullParameter(oldNameProvider, (String)"oldNameProvider");
                for (Module module : modules) {
                    ModuleFileSystemExternalSystemStorage moduleFileSystemExternalSystemStorage = this.getModuleStorage();
                    Object object = oldNameProvider.fun((Object)module);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fun(...)");
                    String string = (String)object;
                    String string2 = module.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    moduleFileSystemExternalSystemStorage.rename(string, string2);
                }
            }
        });
    }

    @NotNull
    public final ModuleFileSystemExternalSystemStorage getModuleStorage() {
        Lazy lazy = this.moduleStorage$delegate;
        return (ModuleFileSystemExternalSystemStorage)lazy.getValue();
    }

    @NotNull
    public final ProjectFileSystemExternalSystemStorage getFileStorage() {
        Lazy lazy = this.fileStorage$delegate;
        return (ProjectFileSystemExternalSystemStorage)lazy.getValue();
    }

    @Nullable
    public List<Storage> customizeStorageSpecs(@NotNull PersistentStateComponent<?> component, @NotNull StateStorageManager storageManager, @NotNull State stateSpec, @NotNull List<? extends Storage> storages, @NotNull StateStorageOperation operation) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkNotNullParameter(storages, (String)"storages");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        ComponentManager componentManager = storageManager.getComponentManager();
        if (componentManager == null) {
            return null;
        }
        ComponentManager componentManager2 = componentManager;
        Project project = componentManager2 instanceof Project ? (Project)componentManager2 : null;
        if (project == null) {
            Project project2 = ((Module)componentManager2).getProject();
            project = project2;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        }
        Project project3 = project;
        if (storages.size() == 1) {
            Storage storage = (Storage)CollectionsKt.first(storages);
            if (storage instanceof FileStorageAnnotation && Intrinsics.areEqual((Object)storage.value(), (Object)"$PROJECT_FILE$") && !storage.deprecated()) {
                return null;
            }
            if (Intrinsics.areEqual((Object)storage.value(), (Object)"$WORKSPACE_FILE$") || !ProjectUtilCore.isExternalStorageEnabled((Project)project3)) {
                return null;
            }
        }
        if (componentManager2 instanceof Project) {
            String fileSpec;
            Storage storage = (Storage)CollectionsKt.firstOrNull(storages);
            String string = fileSpec = storage != null ? storage.value() : null;
            if (Intrinsics.areEqual((Object)fileSpec, (Object)"libraries") || Intrinsics.areEqual((Object)fileSpec, (Object)"artifacts")) {
                Storage externalStorageSpec = this.getOrCreateStorageSpec(fileSpec + ".xml", stateSpec);
                if (operation == StateStorageOperation.READ) {
                    return CollectionsKt.listOf((Object)externalStorageSpec);
                }
                ArrayList<Storage> result = new ArrayList<Storage>(storages.size() + 1);
                result.add(externalStorageSpec);
                result.addAll((Collection)storages);
                return result;
            }
        }
        if (!(component instanceof ProjectModelElement)) {
            return null;
        }
        boolean externalStorageOnly = stateSpec.externalStorageOnly();
        if (operation == StateStorageOperation.WRITE && ((ProjectModelElement)component).getExternalSource() == null && !externalStorageOnly) {
            return null;
        }
        Storage annotation = null;
        annotation = componentManager2 instanceof Project ? StreamProviderFactory.getOrCreateStorageSpec$default((StreamProviderFactory)this, (String)storages.get(0).value(), null, (int)2, null) : StreamProviderFactory.getOrCreateStorageSpec$default((StreamProviderFactory)this, (String)"$MODULE_FILE$", null, (int)2, null);
        if (externalStorageOnly) {
            return CollectionsKt.listOf((Object)annotation);
        }
        ArrayList<Storage> result = new ArrayList<Storage>(storages.size() + 1);
        result.add(annotation);
        result.addAll((Collection)storages);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Storage getOrCreateStorageSpec(@NotNull String fileSpec, @Nullable State inProjectStateSpec) {
        Storage storage;
        Object object;
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Serializable serializable = this.storageSpecLock.readLock();
        ((ReentrantReadWriteLock.ReadLock)serializable).lock();
        try {
            boolean bl = false;
            object = this.storages.get(fileSpec);
            storage = object;
        }
        finally {
            ((ReentrantReadWriteLock.ReadLock)serializable).unlock();
        }
        if (storage == null) {
            Storage storage2;
            serializable = this.storageSpecLock;
            object = ((ReentrantReadWriteLock)serializable).readLock();
            int n = ((ReentrantReadWriteLock)serializable).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)serializable).getReadHoldCount() : 0;
            for (int j = 0; j < n; ++j) {
                ((ReentrantReadWriteLock.ReadLock)object).unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)serializable).writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                Storage storage3 = this.storages.computeIfAbsent(fileSpec, arg_0 -> ExternalSystemStreamProviderFactory.getOrCreateStorageSpec$lambda$1$1(arg_0 -> ExternalSystemStreamProviderFactory.getOrCreateStorageSpec$lambda$1$0(fileSpec, inProjectStateSpec, arg_0), arg_0));
                storage2 = storage3;
            }
            finally {
                for (int j = 0; j < n; ++j) {
                    ((ReentrantReadWriteLock.ReadLock)object).lock();
                }
                writeLock.unlock();
            }
            Intrinsics.checkNotNullExpressionValue((Object)storage2, (String)"write(...)");
            return storage2;
        }
        return storage;
    }

    @Nullable
    public final Element readModuleData(@NotNull String name) {
        Element result;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.getModuleStorage().getHasSomeData() && this.isReimportOnMissedExternalStorageScheduled.compareAndSet(false, true) && !this.project.isInitialized() && !ExternalSystemUtil.isNewProject(this.project)) {
            StartupManager.getInstance((Project)this.project).runWhenProjectIsInitialized(() -> ExternalSystemStreamProviderFactory.readModuleData$lambda$0(this));
        }
        if ((result = this.getModuleStorage().read(name)) == null) {
            // empty if block
        }
        return result;
    }

    private static final ModuleFileSystemExternalSystemStorage moduleStorage_delegate$lambda$0(ExternalSystemStreamProviderFactory this$0) {
        return new ModuleFileSystemExternalSystemStorage(this$0.project);
    }

    private static final ProjectFileSystemExternalSystemStorage fileStorage_delegate$lambda$0(ExternalSystemStreamProviderFactory this$0) {
        return new ProjectFileSystemExternalSystemStorage(this$0.project);
    }

    private static final Storage getOrCreateStorageSpec$lambda$1$0(String $fileSpec, State $inProjectStateSpec, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Storage)new ExternalStorageSpec($fileSpec, $inProjectStateSpec);
    }

    private static final Storage getOrCreateStorageSpec$lambda$1$1(Function1 $tmp0, Object p0) {
        return (Storage)$tmp0.invoke(p0);
    }

    private static final void readModuleData$lambda$0$0(ExternalSystemStreamProviderFactory this$0, ExternalProjectsManager $externalProjectsManager) {
        if (!ExternalSystemUtil.isNewProject(this$0.project)) {
            $externalProjectsManager.getExternalProjectsWatcher().markDirtyAllExternalProjects();
        }
    }

    private static final void readModuleData$lambda$0(ExternalSystemStreamProviderFactory this$0) {
        ExternalProjectsManager externalProjectsManager = ExternalProjectsManager.getInstance((Project)this$0.project);
        externalProjectsManager.runWhenInitialized(() -> ExternalSystemStreamProviderFactory.readModuleData$lambda$0$0(this$0, externalProjectsManager));
    }
}

