/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.AbstractIdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ModifiableModel;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManagerEx;
import com.intellij.openapi.roots.TestModuleProperties;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal;
import com.intellij.platform.externalSystem.impl.dependencySubstitution.DependencySubstitutionUtil;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.impl.VersionedEntityStorageImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.facet.FacetManagerBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleManagerBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.ModuleRootComponentBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.TestModulePropertiesBridge;
import com.intellij.workspaceModel.ide.legacyBridge.LibraryModifiableModelBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ModifiableFacetModelBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ModifiableModuleModelBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ModifiableRootModelBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ProjectLibraryTableBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ProjectModifiableLibraryTableBridge;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeModifiableModelsProviderImpl
extends AbstractIdeModifiableModelsProvider {
    public static final Logger LOG = Logger.getInstance(IdeModifiableModelsProviderImpl.class);
    public static final Key<IdeModifiableModelsProviderImpl> MODIFIABLE_MODELS_PROVIDER_KEY = Key.create((String)"IdeModelsProvider");
    private LibraryTable.ModifiableModel myLibrariesModel;
    private MutableEntityStorage diff;

    public IdeModifiableModelsProviderImpl(Project project) {
        super(project);
    }

    @Override
    @NotNull
    public LibraryTable.ModifiableModel getModifiableProjectLibrariesModel() {
        if (this.myLibrariesModel != null) {
            LibraryTable.ModifiableModel modifiableModel = this.myLibrariesModel;
            if (modifiableModel == null) {
                IdeModifiableModelsProviderImpl.$$$reportNull$$$0(0);
            }
            return modifiableModel;
        }
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject);
        this.myLibrariesModel = ((ProjectLibraryTableBridge)libraryTable).getModifiableModel(this.getActualStorageBuilder());
        if (this.myLibrariesModel == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(1);
        }
        return this.myLibrariesModel;
    }

    @Override
    protected ModifiableModuleModel doGetModifiableModuleModel() {
        return (ModifiableModuleModel)ReadAction.compute(() -> {
            Module[] modules;
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            ModifiableModuleModel modifiableModel = ((ModuleManagerBridgeImpl)moduleManager).getModifiableModel(this.getActualStorageBuilder());
            for (Module module : modules = modifiableModel.getModules()) {
                this.setIdeModelsProviderForModule(module);
            }
            return modifiableModel;
        });
    }

    @Override
    @NotNull
    protected ModifiableRootModel doGetModifiableRootModel(@NotNull Module module) {
        if (module == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(2);
        }
        RootConfigurationAccessor rootConfigurationAccessor = new RootConfigurationAccessor(){

            @Nullable
            public Library getLibrary(Library library, String libraryName, String libraryLevel) {
                if ("project".equals(libraryLevel)) {
                    return IdeModifiableModelsProviderImpl.this.getModifiableProjectLibrariesModel().getLibraryByName(libraryName);
                }
                return library;
            }
        };
        ModifiableRootModel modifiableRootModel = (ModifiableRootModel)ReadAction.compute(() -> {
            ModuleRootManagerEx rootManager = ModuleRootManagerEx.getInstanceEx((Module)module);
            return ((ModuleRootComponentBridge)rootManager).getModifiableModel(this.getActualStorageBuilder(), rootConfigurationAccessor);
        });
        if (modifiableRootModel == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(3);
        }
        return modifiableRootModel;
    }

    @Override
    protected ModifiableFacetModel doGetModifiableFacetModel(Module module) {
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        return ((FacetManagerBridge)facetManager).createModifiableModel(this.getActualStorageBuilder());
    }

    @Override
    protected Library.ModifiableModel doGetModifiableLibraryModel(Library library) {
        return ((LibraryBridge)library).getModifiableModel(this.getActualStorageBuilder());
    }

    @Override
    @NotNull
    public Module newModule(@NotNull String filePath, String moduleTypeId) {
        if (filePath == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(4);
        }
        Module module = super.newModule(filePath, moduleTypeId);
        this.setIdeModelsProviderForModule(module);
        Module module2 = module;
        if (module2 == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(5);
        }
        return module2;
    }

    @Override
    @NotNull
    public Module newModule(@NotNull ModuleData moduleData) {
        if (moduleData == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(6);
        }
        Module module = super.newModule(moduleData);
        this.setIdeModelsProviderForModule(module);
        Module module2 = module;
        if (module2 == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(7);
        }
        return module2;
    }

    public void commit() {
        LOG.trace("Applying commit for IdeaModifiableModelProvider");
        this.workspaceModelCommit();
    }

    private void workspaceModelCommit() {
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
            ModifiableRootModel[] rootModels;
            LibraryTable.ModifiableModel projectLibrariesModel = this.getModifiableProjectLibrariesModel();
            for (Map.Entry entry2 : this.myModifiableLibraryModels.entrySet()) {
                LibraryEx fromLibraryEx;
                Library library = (Library)entry2.getKey();
                String libraryName = library.getName();
                Library.ModifiableModel modifiableModel = (Library.ModifiableModel)entry2.getValue();
                if (library instanceof LibraryEx && (fromLibraryEx = (LibraryEx)library).isDisposed()) {
                    Disposer.dispose((Disposable)modifiableModel);
                    continue;
                }
                if (library.getTable() != null && libraryName != null && projectLibrariesModel.getLibraryByName(libraryName) == null) {
                    Disposer.dispose((Disposable)modifiableModel);
                    continue;
                }
                if (this.isLibrarySubstituted(library)) {
                    Disposer.dispose((Disposable)modifiableModel);
                    continue;
                }
                ((LibraryModifiableModelBridge)modifiableModel).prepareForCommit();
            }
            ((ProjectModifiableLibraryTableBridge)projectLibrariesModel).prepareForCommit();
            if (this.myModifiableModuleModel != null) {
                Module[] modules;
                for (Module module : modules = this.myModifiableModuleModel.getModules()) {
                    module.putUserData(MODIFIABLE_MODELS_PROVIDER_KEY, null);
                }
                Set<Module> set = Set.of(modules);
                rootModels = (ModifiableRootModel[])this.myModifiableRootModels.entrySet().stream().filter(entry -> existingModules.contains(entry.getKey())).map(Map.Entry::getValue).toArray(ModifiableRootModel[]::new);
                ((ModifiableModuleModelBridge)this.myModifiableModuleModel).prepareForCommit();
            } else {
                rootModels = this.myModifiableRootModels.values().toArray(new ModifiableRootModel[0]);
            }
            for (ModifiableRootModel model : rootModels) {
                assert (!model.isDisposed()) : "Already disposed: " + String.valueOf(model);
            }
            for (ModifiableRootModel model : rootModels) {
                ((ModifiableRootModelBridge)model).prepareForCommit();
            }
            for (Map.Entry entry2 : this.myProductionModulesForTestModules.entrySet()) {
                TestModuleProperties testModuleProperties = TestModuleProperties.getInstance((Module)((Module)entry2.getKey()));
                if (testModuleProperties instanceof TestModulePropertiesBridge) {
                    TestModulePropertiesBridge bridge = (TestModulePropertiesBridge)testModuleProperties;
                    bridge.setProductionModuleNameToBuilder((String)entry2.getValue(), this.myModifiableModuleModel.getActualName((Module)entry2.getKey()), this.getActualStorageBuilder());
                    continue;
                }
                testModuleProperties.setProductionModuleName((String)entry2.getValue());
            }
            for (Map.Entry entry3 : this.myModifiableFacetModels.entrySet()) {
                if (((Module)entry3.getKey()).isDisposed()) continue;
                ((ModifiableFacetModelBridge)entry3.getValue()).prepareForCommit();
            }
            this.myModifiableModels.values().forEach(ModifiableModel::commit);
            WorkspaceModel.getInstance((Project)this.myProject).updateProjectModel("External system: commit model", builder -> {
                MutableEntityStorage storageBuilder = this.getActualStorageBuilder();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Apply builder in ModifiableModels commit. builder: " + String.valueOf(storageBuilder));
                }
                builder.applyChangesFrom(storageBuilder);
                DependencySubstitutionUtil.updateDependencySubstitutions(builder);
                return Unit.INSTANCE;
            });
            for (ModifiableRootModel model : rootModels) {
                ((ModifiableRootModelBridge)model).postCommit();
            }
        });
        this.myUserData.clear();
    }

    @Override
    public void dispose() {
        if (this.myModifiableModuleModel != null) {
            Module[] modules;
            for (Module module : modules = this.myModifiableModuleModel.getModules()) {
                module.putUserData(MODIFIABLE_MODELS_PROVIDER_KEY, null);
            }
        }
        super.dispose();
    }

    @NotNull
    public MutableEntityStorage getActualStorageBuilder() {
        if (this.diff != null) {
            MutableEntityStorage mutableEntityStorage = this.diff;
            if (mutableEntityStorage == null) {
                IdeModifiableModelsProviderImpl.$$$reportNull$$$0(8);
            }
            return mutableEntityStorage;
        }
        VersionedEntityStorageImpl storage = ((WorkspaceModelInternal)WorkspaceModel.getInstance((Project)this.myProject)).getEntityStorage();
        LOG.info("Ide modifiable models provider, create builder from version " + storage.getVersion());
        ImmutableEntityStorage initialStorage = (ImmutableEntityStorage)storage.getCurrent();
        this.diff = MutableEntityStorage.from((ImmutableEntityStorage)initialStorage);
        if (this.diff == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(9);
        }
        return this.diff;
    }

    private void setIdeModelsProviderForModule(@NotNull Module module) {
        if (module == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(10);
        }
        module.putUserData(MODIFIABLE_MODELS_PROVIDER_KEY, (Object)this);
    }

    @ApiStatus.Internal
    public boolean isLibrarySubstituted(@NotNull Library library) {
        if (library == null) {
            IdeModifiableModelsProviderImpl.$$$reportNull$$$0(11);
        }
        if (library instanceof LibraryBridge) {
            LibraryBridge libraryBridge = (LibraryBridge)library;
            return DependencySubstitutionUtil.isLibrarySubstituted(this.getActualStorageBuilder(), libraryBridge.getLibraryId());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 6, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProviderImpl";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleData";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableProjectLibrariesModel";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProviderImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetModifiableRootModel";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "newModule";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualStorageBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doGetModifiableRootModel";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newModule";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setIdeModelsProviderForModule";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isLibrarySubstituted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 6, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

