/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.statistics;

import com.intellij.featureStatistics.fusCollectors.EventsRateThrottle;
import com.intellij.featureStatistics.fusCollectors.ThrowableDescription;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventDataCollector;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemSyncActionsCollector;
import com.intellij.openapi.externalSystem.statistics.Phase;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008b\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0003\n\u0002\b\u0002*\u0001-\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001@B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\"\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u000205H\u0007J\"\u00106\u001a\u0002002\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u00102\u0006\u00107\u001a\u000205H\u0007J\"\u00108\u001a\u0002002\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u00102\u0006\u00109\u001a\u00020\rH\u0007J4\u0010:\u001a\u0002002\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u00102\u0006\u00109\u001a\u00020\r2\u0006\u0010;\u001a\u00020\u00102\b\b\u0002\u0010<\u001a\u00020+H\u0007J\"\u0010=\u001a\u0002002\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u00102\u0006\u0010>\u001a\u00020?H\u0007R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001aR\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010.\u00a8\u0006A"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemSyncActionsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "getGROUP", "()Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "activityIdField", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "importPhaseField", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/openapi/externalSystem/statistics/Phase;", "syncStartedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "getSyncStartedEvent", "()Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "isParallelModelFetch", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "isSyncSuccessful", "isFirstSyncWithIdeCaches", "syncFinishedEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "getSyncFinishedEvent", "()Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "phaseStartedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "errorField", "Lcom/intellij/internal/statistic/eventLog/events/ClassEventField;", "severityField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "errorHashField", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "errorCountField", "tooManyErrorsField", "errorEvent", "phaseFinishedEvent", "getPhaseFinishedEvent", "ourErrorsRateThrottle", "Lcom/intellij/featureStatistics/fusCollectors/EventsRateThrottle;", "tsCacheCapasity", "", "idToStartTS", "com/intellij/openapi/externalSystem/statistics/ExternalSystemSyncActionsCollector$idToStartTS$1", "Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemSyncActionsCollector$idToStartTS$1;", "logSyncStarted", "", "project", "Lcom/intellij/openapi/project/Project;", "activityId", "parallelModelFetchEnabled", "", "logSyncFinished", "success", "logPhaseStarted", "phase", "logPhaseFinished", "durationMs", "errorCount", "logError", "throwable", "", "GradleSyncDetails", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nExternalSystemSyncActionsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalSystemSyncActionsCollector.kt\ncom/intellij/openapi/externalSystem/statistics/ExternalSystemSyncActionsCollector\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,152:1\n37#2,2:153\n261#3,3:155\n*S KotlinDebug\n*F\n+ 1 ExternalSystemSyncActionsCollector.kt\ncom/intellij/openapi/externalSystem/statistics/ExternalSystemSyncActionsCollector\n*L\n149#1:153,2\n38#1:155,3\n*E\n"})
public final class ExternalSystemSyncActionsCollector
extends CounterUsagesCollector {
    @NotNull
    public static final ExternalSystemSyncActionsCollector INSTANCE;
    @NotNull
    private static final EventLogGroup GROUP;
    @NotNull
    private static final LongEventField activityIdField;
    @NotNull
    private static final EnumEventField<Phase> importPhaseField;
    @NotNull
    private static final EventId1<Long> syncStartedEvent;
    @NotNull
    private static final BooleanEventField isParallelModelFetch;
    @NotNull
    private static final BooleanEventField isSyncSuccessful;
    @NotNull
    private static final BooleanEventField isFirstSyncWithIdeCaches;
    @NotNull
    private static final VarargEventId syncFinishedEvent;
    @NotNull
    private static final EventId2<Long, Phase> phaseStartedEvent;
    @NotNull
    private static final ClassEventField errorField;
    @NotNull
    private static final StringEventField severityField;
    @NotNull
    private static final IntEventField errorHashField;
    @NotNull
    private static final IntEventField errorCountField;
    @NotNull
    private static final BooleanEventField tooManyErrorsField;
    @NotNull
    private static final VarargEventId errorEvent;
    @NotNull
    private static final VarargEventId phaseFinishedEvent;
    @NotNull
    private static final EventsRateThrottle ourErrorsRateThrottle;
    private static final int tsCacheCapasity = 100;
    @NotNull
    private static final idToStartTS.1 idToStartTS;

    private ExternalSystemSyncActionsCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public final EventLogGroup getGROUP() {
        return GROUP;
    }

    @NotNull
    public final EventId1<Long> getSyncStartedEvent() {
        return syncStartedEvent;
    }

    @NotNull
    public final VarargEventId getSyncFinishedEvent() {
        return syncFinishedEvent;
    }

    @NotNull
    public final VarargEventId getPhaseFinishedEvent() {
        return phaseFinishedEvent;
    }

    @JvmStatic
    public static final void logSyncStarted(@Nullable Project project, long activityId, boolean parallelModelFetchEnabled) {
        Project project2 = project;
        ((Map)idToStartTS).put(activityId, new GradleSyncDetails(System.currentTimeMillis(), parallelModelFetchEnabled, project2 != null ? (Boolean)project2.getUserData(ExternalSystemDataKeys.NEWLY_OPENED_PROJECT_WITH_IDE_CACHES) : null));
        syncStartedEvent.log(project, (Object)activityId);
    }

    @JvmStatic
    public static final void logSyncFinished(@Nullable Project project, long activityId, boolean success) {
        long nowTS = System.currentTimeMillis();
        syncFinishedEvent.log(project, arg_0 -> ExternalSystemSyncActionsCollector.logSyncFinished$lambda$0(activityId, nowTS, success, arg_0));
    }

    @JvmStatic
    public static final void logPhaseStarted(@Nullable Project project, long activityId, @NotNull Phase phase) {
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        phaseStartedEvent.log(project, (Object)activityId, (Object)phase);
    }

    @JvmStatic
    @JvmOverloads
    public static final void logPhaseFinished(@Nullable Project project, long activityId, @NotNull Phase phase, long durationMs, int errorCount) {
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        EventPair[] eventPairArray = new EventPair[]{activityIdField.with((Object)activityId), importPhaseField.with((Object)phase), EventFields.DurationMs.with((Object)durationMs), new EventPair((EventField)errorCountField, (Object)errorCount)};
        phaseFinishedEvent.log(project, eventPairArray);
    }

    public static /* synthetic */ void logPhaseFinished$default(Project project, long l, Phase phase, long l2, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        ExternalSystemSyncActionsCollector.logPhaseFinished(project, l, phase, l2, n);
    }

    @JvmStatic
    public static final void logError(@Nullable Project project, long activityId, @NotNull Throwable throwable) {
        PluginId pluginId;
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        ThrowableDescription description = new ThrowableDescription(throwable);
        int framesHash = throwable instanceof ExternalSystemException ? ((ExternalSystemException)throwable).getOriginalReason().hashCode() : ((Object)description.getLastFrames(50)).hashCode();
        ArrayList<EventPair> data = new ArrayList<EventPair>();
        data.add(activityIdField.with((Object)activityId));
        data.add(severityField.with((Object)"fatal"));
        PluginId pluginId2 = pluginId = PluginUtil.getInstance().findPluginId(throwable);
        data.add(EventFields.PluginInfo.with((Object)(pluginId2 == null ? PluginInfoDetectorKt.getPlatformPlugin() : PluginInfoDetectorKt.getPluginInfoById((PluginId)pluginId2))));
        data.add(errorField.with((Object)description.getThrowableClass()));
        boolean bl = ourErrorsRateThrottle.tryPass(System.currentTimeMillis()) ? data.add(errorHashField.with((Object)framesHash)) : data.add(tooManyErrorsField.with((Object)true));
        Collection $this$toTypedArray$iv = data;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        EventPair[] eventPairArray = thisCollection$iv.toArray(new EventPair[0]);
        errorEvent.log(project, Arrays.copyOf(eventPairArray, eventPairArray.length));
    }

    @JvmStatic
    @JvmOverloads
    public static final void logPhaseFinished(@Nullable Project project, long activityId, @NotNull Phase phase, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        ExternalSystemSyncActionsCollector.logPhaseFinished$default(project, activityId, phase, durationMs, 0, 16, null);
    }

    private static final Unit logSyncFinished$lambda$0(long $activityId, long $nowTS, boolean $success, EventDataCollector $this$log) {
        Intrinsics.checkNotNullParameter((Object)$this$log, (String)"$this$log");
        $this$log.add((Object)activityIdField.with((Object)$activityId));
        GradleSyncDetails syncDetails = (GradleSyncDetails)idToStartTS.get((Object)$activityId);
        if (syncDetails != null) {
            $this$log.add((Object)EventFields.DurationMs.with((Object)($nowTS - syncDetails.getTimestamp())));
            $this$log.add((Object)isParallelModelFetch.with((Object)syncDetails.getParallelModelFetchEnabled()));
            if (syncDetails.isFirstSyncWithIdeCaches() != null) {
                $this$log.add((Object)isFirstSyncWithIdeCaches.with((Object)syncDetails.isFirstSyncWithIdeCaches()));
            }
        } else {
            $this$log.add((Object)EventFields.DurationMs.with((Object)-1L));
            $this$log.add((Object)isParallelModelFetch.with((Object)false));
        }
        $this$log.add((Object)isSyncSuccessful.with((Object)$success));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$iv;
        INSTANCE = new ExternalSystemSyncActionsCollector();
        GROUP = new EventLogGroup("build.gradle.import", 10, null, 4, null);
        activityIdField = EventFields.Long$default((String)"ide_activity_id", null, (int)2, null);
        Object[] objectArray = EventFields.INSTANCE;
        String name$iv = "phase";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        importPhaseField = new EnumEventField(name$iv, Phase.class, null, transform$iv);
        syncStartedEvent = GROUP.registerEvent("gradle.sync.started", (EventField)activityIdField);
        isParallelModelFetch = EventFields.Boolean((String)"parallel_model_fetch");
        isSyncSuccessful = EventFields.Boolean((String)"sync_successful");
        isFirstSyncWithIdeCaches = EventFields.Boolean((String)"first_sync_with_ide_caches");
        objectArray = new EventField[]{activityIdField, EventFields.DurationMs, isParallelModelFetch, isSyncSuccessful, isFirstSyncWithIdeCaches};
        syncFinishedEvent = GROUP.registerVarargEvent("gradle.sync.finished", (EventField[])objectArray);
        phaseStartedEvent = GROUP.registerEvent("phase.started", (EventField)activityIdField, (EventField)importPhaseField);
        errorField = EventFields.Class((String)"error");
        objectArray = new String[]{"fatal", "warning"};
        severityField = EventFields.String((String)"severity", (List)CollectionsKt.listOf((Object[])objectArray));
        errorHashField = EventFields.Int((String)"error_hash");
        errorCountField = EventFields.Int((String)"error_count");
        tooManyErrorsField = EventFields.Boolean((String)"too_many_errors");
        objectArray = new EventField[]{activityIdField, errorField, severityField, errorHashField, EventFields.PluginInfo, tooManyErrorsField};
        errorEvent = GROUP.registerVarargEvent("error", (EventField[])objectArray);
        objectArray = new EventField[]{activityIdField, importPhaseField, EventFields.DurationMs, errorCountField};
        phaseFinishedEvent = GROUP.registerVarargEvent("phase.finished", (EventField[])objectArray);
        ourErrorsRateThrottle = new EventsRateThrottle(100, 300000L);
        idToStartTS = new LinkedHashMap<Long, GradleSyncDetails>(){

            protected boolean removeEldestEntry(Map.Entry<Long, GradleSyncDetails> eldest) {
                return this.size() > 100;
            }
        };
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0006\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemSyncActionsCollector$GradleSyncDetails;", "", "timestamp", "", "parallelModelFetchEnabled", "", "isFirstSyncWithIdeCaches", "<init>", "(JZLjava/lang/Boolean;)V", "getTimestamp", "()J", "getParallelModelFetchEnabled", "()Z", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "intellij.platform.externalSystem.impl"})
    private static final class GradleSyncDetails {
        private final long timestamp;
        private final boolean parallelModelFetchEnabled;
        @Nullable
        private final Boolean isFirstSyncWithIdeCaches;

        public GradleSyncDetails(long timestamp, boolean parallelModelFetchEnabled, @Nullable Boolean isFirstSyncWithIdeCaches) {
            this.timestamp = timestamp;
            this.parallelModelFetchEnabled = parallelModelFetchEnabled;
            this.isFirstSyncWithIdeCaches = isFirstSyncWithIdeCaches;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final boolean getParallelModelFetchEnabled() {
            return this.parallelModelFetchEnabled;
        }

        @Nullable
        public final Boolean isFirstSyncWithIdeCaches() {
            return this.isFirstSyncWithIdeCaches;
        }
    }
}

