/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.CoroutineSupport;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.SpinningProgressIcon;
import com.intellij.ui.SpinningProgressIconKt;
import com.intellij.ui.icons.IconUtilKt;
import com.intellij.util.concurrency.EdtScheduler;
import com.intellij.util.containers.ContainerUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimatedIcon
implements Icon {
    private static final Logger LOG = Logger.getInstance(AnimatedIcon.class);
    public static final Key<Boolean> ANIMATION_IN_RENDERER_ALLOWED = Key.create((String)"ANIMATION_IN_RENDERER_ALLOWED");
    @ApiStatus.Experimental
    public static final Key<Runnable> REFRESH_DELEGATE = Key.create((String)"REFRESH_DELEGATE");
    final Frame[] frames;
    private final Set<Component> requested;
    private long time;
    private int index;

    public AnimatedIcon(int delay, Icon ... icons) {
        if (icons == null) {
            AnimatedIcon.$$$reportNull$$$0(0);
        }
        this(AnimatedIcon.getFrames(delay, icons));
    }

    public AnimatedIcon(Frame ... frames) {
        if (frames == null) {
            AnimatedIcon.$$$reportNull$$$0(1);
        }
        this.requested = Collections.newSetFromMap(new IdentityHashMap());
        this.frames = frames;
        assert (frames.length > 0) : "empty array";
        for (Frame frame : frames) {
            assert (frame != null) : "null animation frame";
        }
        this.time = System.currentTimeMillis();
    }

    protected AnimatedIcon(@NotNull Function<AnimatedIcon, Frame[]> frameProducer) {
        if (frameProducer == null) {
            AnimatedIcon.$$$reportNull$$$0(2);
        }
        this.requested = Collections.newSetFromMap(new IdentityHashMap());
        this.frames = frameProducer.apply(this);
        this.time = System.currentTimeMillis();
    }

    private static Frame[] getFrames(final int delay, Icon ... icons) {
        if (icons == null) {
            AnimatedIcon.$$$reportNull$$$0(3);
        }
        int length = icons.length;
        assert (length > 0) : "empty array";
        Frame[] frames = new Frame[length];
        for (int i = 0; i < length; ++i) {
            final Icon icon = icons[i];
            assert (icon != null) : "null icon";
            frames[i] = new Frame(){

                @Override
                @NotNull
                public Icon getIcon() {
                    Icon icon2 = icon;
                    if (icon2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return icon2;
                }

                @Override
                public int getDelay() {
                    return delay;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/AnimatedIcon$1", "getIcon"));
                }
            };
        }
        return frames;
    }

    private void updateFrameAt(long current) {
        int next = this.index + 1;
        this.index = next < this.frames.length ? next : 0;
        this.time = current;
    }

    protected Frame[] getFrames() {
        return this.frames;
    }

    @NotNull
    private Icon getUpdatedIcon() {
        int index = this.getCurrentIndex();
        Icon icon = this.getFrames()[index].getIcon();
        if (icon == null) {
            AnimatedIcon.$$$reportNull$$$0(4);
        }
        return icon;
    }

    private int getCurrentIndex() {
        long current = System.currentTimeMillis();
        Frame frame = this.getFrames()[this.index];
        if ((long)frame.getDelay() <= current - this.time) {
            this.updateFrameAt(current);
        }
        return this.index;
    }

    private void requestRefresh(@Nullable Component c) {
        if (c == null || this.requested.contains(c) || !this.canRefresh(c)) {
            return;
        }
        Frame frame = this.getFrames()[this.index];
        int delay = frame.getDelay();
        if (delay > 0) {
            this.requested.add(c);
            EdtScheduler.getInstance().schedule(delay, CoroutineSupport.UiDispatcherKind.RELAX, () -> {
                this.requested.remove(c);
                if (this.canRefresh(c)) {
                    this.doRefresh(c);
                }
            });
        } else {
            this.doRefresh(c);
        }
    }

    @Override
    public final void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon = this.getUpdatedIcon();
        if (EventQueue.isDispatchThread()) {
            CellRendererPane pane = (CellRendererPane)ComponentUtil.getParentOfType(CellRendererPane.class, (Component)c);
            this.requestRefresh(pane == null ? c : this.getRendererOwner(pane.getParent()));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Throwable)new IllegalStateException("Unexpected thread " + Thread.currentThread().getName()));
        }
        icon.paintIcon(c, g, x, y);
    }

    @Override
    public final int getIconWidth() {
        return this.getUpdatedIcon().getIconWidth();
    }

    @Override
    public final int getIconHeight() {
        return this.getUpdatedIcon().getIconHeight();
    }

    protected boolean canRefresh(@NotNull Component component) {
        if (component == null) {
            AnimatedIcon.$$$reportNull$$$0(5);
        }
        return component.isShowing();
    }

    protected void doRefresh(@NotNull Component component) {
        Runnable delegate;
        if (component == null) {
            AnimatedIcon.$$$reportNull$$$0(6);
        }
        Runnable runnable = delegate = component instanceof JComponent ? (Runnable)((JComponent)component).getClientProperty(REFRESH_DELEGATE) : null;
        if (delegate == null) {
            component.repaint();
        } else {
            delegate.run();
        }
    }

    @Nullable
    protected Component getRendererOwner(@Nullable Component component) {
        return ClientProperty.isTrue((Component)component, ANIMATION_IN_RENDERER_ALLOWED) ? component : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icons";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frames";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameProducer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/AnimatedIcon";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/AnimatedIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatedIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFrames";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canRefresh";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doRefresh";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    public static interface Frame {
        @NotNull
        public Icon getIcon();

        public int getDelay();
    }

    @ApiStatus.Internal
    public static final class Fading
    extends AnimatedIcon {
        public Fading(@NotNull Icon icon) {
            if (icon == null) {
                Fading.$$$reportNull$$$0(0);
            }
            this(1000, icon);
        }

        public Fading(final int period, final @NotNull Icon icon) {
            if (icon == null) {
                Fading.$$$reportNull$$$0(1);
            }
            super(50, new Icon(){
                private final long time = System.currentTimeMillis();

                @Override
                public int getIconWidth() {
                    return icon.getIconWidth();
                }

                @Override
                public int getIconHeight() {
                    return icon.getIconHeight();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    assert (period > 0) : "unexpected";
                    long time = (System.currentTimeMillis() - this.time) % (long)period;
                    float alpha = (float)((Math.cos(Math.PI * 2 * (double)time / (double)period) + 1.0) / 2.0);
                    if (alpha > 0.0f) {
                        if (alpha < 1.0f && g instanceof Graphics2D) {
                            Graphics2D g2d = (Graphics2D)g.create();
                            try {
                                g2d.setComposite(AlphaComposite.SrcAtop.derive(alpha));
                                icon.paintIcon(c, g2d, x, y);
                            }
                            finally {
                                g2d.dispose();
                            }
                        } else {
                            icon.paintIcon(c, g, x, y);
                        }
                    }
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/AnimatedIcon$Fading", "<init>"));
        }
    }

    @ApiStatus.Internal
    public static final class Blinking
    extends AnimatedIcon {
        public Blinking(@NotNull Icon icon) {
            if (icon == null) {
                Blinking.$$$reportNull$$$0(0);
            }
            this(1000, icon);
        }

        public Blinking(int delay, @NotNull Icon icon) {
            if (icon == null) {
                Blinking.$$$reportNull$$$0(1);
            }
            super(delay, icon, IconUtilKt.getDisabledIcon((Icon)icon, null));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/AnimatedIcon$Blinking", "<init>"));
        }
    }

    @ApiStatus.Internal
    public static final class FS
    extends AnimatedIcon {
        public static final int DELAY = 50;
        public static final List<Icon> ICONS = List.of(AllIcons.Process.FS.Step_1, AllIcons.Process.FS.Step_2, AllIcons.Process.FS.Step_3, AllIcons.Process.FS.Step_4, AllIcons.Process.FS.Step_5, AllIcons.Process.FS.Step_6, AllIcons.Process.FS.Step_7, AllIcons.Process.FS.Step_8, AllIcons.Process.FS.Step_9, AllIcons.Process.FS.Step_10, AllIcons.Process.FS.Step_11, AllIcons.Process.FS.Step_12, AllIcons.Process.FS.Step_13, AllIcons.Process.FS.Step_14, AllIcons.Process.FS.Step_15, AllIcons.Process.FS.Step_16, AllIcons.Process.FS.Step_17, AllIcons.Process.FS.Step_18);

        public FS() {
            super(50, ICONS.toArray(new Icon[0]));
        }
    }

    public static final class Recording
    extends AnimatedIcon {
        public static final int DELAY = 250;
        public static final List<Icon> ICONS = List.of(AllIcons.Ide.Macro.Recording_1, AllIcons.Ide.Macro.Recording_2, AllIcons.Ide.Macro.Recording_3, AllIcons.Ide.Macro.Recording_4);

        public Recording() {
            super(250, ICONS.toArray(new Icon[0]));
        }
    }

    public static final class Big
    extends AnimatedIcon {
        private static final Icon[] OLD_BIG_ICONS = new Icon[]{AllIcons.Process.Big.Step_1, AllIcons.Process.Big.Step_2, AllIcons.Process.Big.Step_3, AllIcons.Process.Big.Step_4, AllIcons.Process.Big.Step_5, AllIcons.Process.Big.Step_6, AllIcons.Process.Big.Step_7, AllIcons.Process.Big.Step_8};
        private static final Frame[] DEFAULT_BIG_FRAMES = Big.getDefaultBigFrames();
        public static final int DELAY = 125;
        public static final Icon[] ICONS;
        public static final AnimatedIcon INSTANCE;

        public Big() {
            super(DEFAULT_BIG_FRAMES);
        }

        private static Frame[] getDefaultBigFrames() {
            if (Boolean.getBoolean("disable.new.spinning.icon")) {
                return AnimatedIcon.getFrames(125, OLD_BIG_ICONS);
            }
            return SpinningProgressIconKt.bigSpinningProgressIcon().frames;
        }

        static {
            Frame[] array = Big.getDefaultBigFrames();
            Icon[] result = new Icon[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = array[i].getIcon();
            }
            ICONS = result;
            INSTANCE = new Big();
        }
    }

    public static class Default
    extends AnimatedIcon {
        private static final Icon[] OLD_ICONS = new Icon[]{AllIcons.Process.Step_1, AllIcons.Process.Step_2, AllIcons.Process.Step_3, AllIcons.Process.Step_4, AllIcons.Process.Step_5, AllIcons.Process.Step_6, AllIcons.Process.Step_7, AllIcons.Process.Step_8};
        private static final Frame[] DEFAULT_FRAMES = Default.getDefaultFrames();
        public static final int DELAY = 125;
        public static final List<Icon> ICONS = ContainerUtil.map((Object[])Default.getDefaultFrames(), Frame::getIcon);
        public static final AnimatedIcon INSTANCE = new Default();

        private static Frame[] getDefaultFrames() {
            if (Boolean.getBoolean("disable.new.spinning.icon")) {
                return AnimatedIcon.getFrames(125, OLD_ICONS);
            }
            return new SpinningProgressIcon().frames;
        }

        public Default() {
            super(DEFAULT_FRAMES);
        }
    }
}

