/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionElement;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyAccessorStub;
import org.jetbrains.kotlin.psi.stubs.StubUtils;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPropertyAccessorStubImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtPropertyAccessorElementType;", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinPropertyAccessorStubImpl;", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "<init>", "()V", "createStub", "psi", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "serialize", "", "stub", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "psi-impl"})
public final class KtPropertyAccessorElementType
extends KtStubElementType<KotlinPropertyAccessorStubImpl, KtPropertyAccessor> {
    @NotNull
    public static final KtPropertyAccessorElementType INSTANCE = new KtPropertyAccessorElementType();

    private KtPropertyAccessorElementType() {
        super("PROPERTY_ACCESSOR", KtPropertyAccessor.class, KotlinPropertyAccessorStub.class);
    }

    @NotNull
    public KotlinPropertyAccessorStubImpl createStub(@NotNull KtPropertyAccessor psi, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        return new KotlinPropertyAccessorStubImpl(parentStub, psi.isGetter(), psi.hasBody(), psi.hasBlockBody(), KtPsiUtilKt.isLegacyContractPresentPsiCheck(psi), null);
    }

    public void serialize(@NotNull KotlinPropertyAccessorStubImpl stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        dataStream.writeBoolean(stub.isGetter());
        dataStream.writeBoolean(stub.getHasBody());
        dataStream.writeBoolean(stub.getHasNoExpressionBody());
        boolean mayHaveContract = stub.getMayHaveContract();
        dataStream.writeBoolean(mayHaveContract);
        if (mayHaveContract) {
            StubUtils.writeContract$psi_impl(dataStream, stub.getContract());
        }
    }

    @NotNull
    public KotlinPropertyAccessorStubImpl deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        boolean isGetter = dataStream.readBoolean();
        boolean hasBody = dataStream.readBoolean();
        boolean hasNoExpressionBody = dataStream.readBoolean();
        boolean mayHaveContract = dataStream.readBoolean();
        List<KtContractDescriptionElement> contract = mayHaveContract ? StubUtils.readContract$psi_impl(dataStream) : null;
        return new KotlinPropertyAccessorStubImpl(parentStub, isGetter, hasBody, hasNoExpressionBody, mayHaveContract, contract);
    }
}

