/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.BadgeShapeProvider;
import java.awt.geom.Ellipse2D;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ui/BadgeDotProvider;", "Lcom/intellij/ui/BadgeShapeProvider;", "x", "", "y", "radius", "border", "<init>", "(DDDD)V", "getX", "()D", "getY", "getRadius", "createShape", "Ljava/awt/geom/Ellipse2D;", "width", "", "height", "hole", "", "intellij.platform.core.ui"})
@ApiStatus.Internal
@ApiStatus.Experimental
public final class BadgeDotProvider
extends BadgeShapeProvider {
    private final double x;
    private final double y;
    private final double radius;

    public BadgeDotProvider(double x, double y, double radius, double border) {
        super(border, null);
        this.x = x;
        this.y = y;
        this.radius = radius;
    }

    public /* synthetic */ BadgeDotProvider(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = BadgeShapeProvider.Companion.getDouble("IconBadge.dotX", 16.5) / (double)20;
        }
        if ((n & 2) != 0) {
            d2 = BadgeShapeProvider.Companion.getDouble("IconBadge.dotY", 3.5) / (double)20;
        }
        if ((n & 4) != 0) {
            d3 = BadgeShapeProvider.Companion.getDouble("IconBadge.dotRadius", 3.5) / (double)20;
        }
        if ((n & 8) != 0) {
            d4 = BadgeShapeProvider.Companion.getDouble("IconBadge.borderWidth", 1.5) / (double)20;
        }
        this(d, d2, d3, d4);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getRadius() {
        return this.radius;
    }

    @Override
    @Nullable
    public Ellipse2D createShape(int width, int height, boolean hole) {
        int size = RangesKt.coerceAtMost((int)width, (int)height);
        if (size <= 0) {
            return null;
        }
        double radius = (double)size * this.radius;
        if (radius <= 0.0) {
            return null;
        }
        double x = (double)width * this.x;
        if (0.0 > x + radius || x - radius > (double)width) {
            return null;
        }
        double y = (double)height * this.y;
        if (0.0 > y + radius || y - radius > (double)height) {
            return null;
        }
        double border = hole ? (double)size * this.getBorder() : 0.0;
        double r = radius + RangesKt.coerceAtLeast((double)border, (double)0.0);
        return new Ellipse2D.Double(x - r, y - r, r + r, r + r);
    }

    public BadgeDotProvider() {
        this(0.0, 0.0, 0.0, 0.0, 15, null);
    }
}

