/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.datasource;

import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.persistence.database.ConfigDataSourcePropertyPrefix;
import com.intellij.persistence.database.KeyPrefixInfo;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.datasource.DatasourcesKt;
import com.intellij.quarkus.config.datasource.QsDataSourceConfigType;
import com.intellij.util.text.StringKt;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u001c\u0010\u0005\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u001a \u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000e"}, d2={"belongsToQuarkusConfig", "", "Lcom/intellij/lang/properties/psi/Property;", "configType", "Lcom/intellij/quarkus/config/datasource/QsDataSourceConfigType;", "hasQuarkus", "module", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "getPrefixInfo", "Lcom/intellij/persistence/database/KeyPrefixInfo;", "key", "", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQsPropertiesConfigDatasourceLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsPropertiesConfigDatasourceLineMarkerProvider.kt\ncom/intellij/quarkus/config/datasource/QsPropertiesConfigDatasourceLineMarkerProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1807#2,3:147\n296#2,2:150\n296#2,2:152\n1#3:154\n*S KotlinDebug\n*F\n+ 1 QsPropertiesConfigDatasourceLineMarkerProvider.kt\ncom/intellij/quarkus/config/datasource/QsPropertiesConfigDatasourceLineMarkerProviderKt\n*L\n111#1:147,3\n132#1:150,2\n135#1:152,2\n*E\n"})
public final class QsPropertiesConfigDatasourceLineMarkerProviderKt {
    private static final boolean belongsToQuarkusConfig(Property $this$belongsToQuarkusConfig, QsDataSourceConfigType configType) {
        boolean bl;
        Iterable $this$any$iv = configType.getPrefixes();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            Iterator iterator = $this$any$iv.iterator();
            if (iterator.hasNext()) {
                Object element$iv = iterator.next();
                ConfigDataSourcePropertyPrefix it = (ConfigDataSourcePropertyPrefix)element$iv;
                boolean bl2 = false;
                String string = $this$belongsToQuarkusConfig.getKey();
                if (string == null) {
                    return false;
                }
                String keyValue = string;
                return StringsKt.startsWith$default((String)QsConfigUtils.INSTANCE.trimProfile(keyValue), (String)it.getPrefixString(), (boolean)false, (int)2, null);
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean hasQuarkus(@Nullable Module module, @Nullable Project project) {
        Module module2 = module;
        if ((module2 == null || (module2 = module2.getProject()) == null) && (module2 = project) == null) {
            return false;
        }
        Module currentProject = module2;
        if (QuarkusUtils.INSTANCE.hasQuarkusLibrary((Project)currentProject)) {
            return true;
        }
        return QuarkusUtils.INSTANCE.hasQuarkusLibrary(module);
    }

    public static /* synthetic */ boolean hasQuarkus$default(Module module, Project project, int n, Object object) {
        if ((n & 2) != 0) {
            project = null;
        }
        return QsPropertiesConfigDatasourceLineMarkerProviderKt.hasQuarkus(module, project);
    }

    @Nullable
    public static final KeyPrefixInfo getPrefixInfo(@NotNull String key, @NotNull QsDataSourceConfigType configType, @NotNull Module module) {
        Object prefix;
        Pair pair;
        block13: {
            Object object;
            Object configPrefix;
            String trimmedKey;
            block10: {
                Object object2;
                Object it;
                block12: {
                    block11: {
                        Object v3;
                        block9: {
                            Object object3;
                            Object v0;
                            block8: {
                                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                                Intrinsics.checkNotNullParameter((Object)((Object)configType), (String)"configType");
                                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                                trimmedKey = QsConfigUtils.INSTANCE.trimIndex(QsConfigUtils.INSTANCE.trimProfile(key));
                                Iterable $this$firstOrNull$iv = configType.getPrefixes();
                                boolean $i$f$firstOrNull = false;
                                for (Object element$iv : $this$firstOrNull$iv) {
                                    it = (ConfigDataSourcePropertyPrefix)element$iv;
                                    boolean bl = false;
                                    if (!StringsKt.startsWith$default((String)trimmedKey, (String)it.getPrefixString(), (boolean)false, (int)2, null)) continue;
                                    v0 = element$iv;
                                    break block8;
                                }
                                v0 = null;
                            }
                            if ((object3 = (ConfigDataSourcePropertyPrefix)v0) == null || (object3 = object3.getPrefixString()) == null) {
                                return null;
                            }
                            configPrefix = object3;
                            if (!configType.getHasNamedDatasource()) break block10;
                            object2 = DatasourcesKt.getQsKeyTails(module).get((Object)configType);
                            if (object2 == null || (object2 = CollectionsKt.sorted((Iterable)((Iterable)object2))) == null) break block11;
                            Iterable $this$firstOrNull$iv = (Iterable)object2;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                String tail = (String)element$iv;
                                boolean bl = false;
                                if (!StringsKt.endsWith$default((String)trimmedKey, (String)tail, (boolean)false, (int)2, null)) continue;
                                v3 = element$iv;
                                break block9;
                            }
                            v3 = null;
                        }
                        if ((object2 = (String)v3) != null) break block12;
                    }
                    return null;
                }
                Object tail = object2;
                String prefix2 = StringsKt.substringBefore$default((String)key, (String)tail, null, (int)2, null);
                String string = StringsKt.substringAfter$default((String)prefix2, (String)configPrefix, null, (int)2, null);
                it = string;
                boolean bl = false;
                String datasourceName = ((CharSequence)it).length() > 0 ? string : null;
                String string2 = datasourceName;
                pair = TuplesKt.to((Object)prefix2, string2 != null && (string2 = StringsKt.removeSuffix((String)string2, (CharSequence)".")) != null ? StringsKt.removePrefix((String)string2, (CharSequence)".") : null);
                break block13;
            }
            if (Intrinsics.areEqual((Object)trimmedKey, (Object)key)) {
                object = configPrefix;
            } else {
                TextRange textRange = StringKt.findTextRange((String)key, (String)configPrefix);
                Intrinsics.checkNotNull((Object)textRange);
                String string = key.substring(0, textRange.getEndOffset());
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            }
            prefix = object;
            pair = TuplesKt.to((Object)prefix, null);
        }
        Pair pair2 = pair;
        prefix = (String)pair2.component1();
        String datasourceName = (String)pair2.component2();
        return new KeyPrefixInfo((String)prefix, datasourceName);
    }

    public static final /* synthetic */ boolean access$belongsToQuarkusConfig(Property $receiver, QsDataSourceConfigType configType) {
        return QsPropertiesConfigDatasourceLineMarkerProviderKt.belongsToQuarkusConfig($receiver, configType);
    }
}

