/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.completion;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringClassAccessInfoProvider;
import com.intellij.spring.completion.AlreadyAutowiredBeanInfo;
import com.intellij.spring.contexts.model.Direction;
import com.intellij.spring.contexts.model.ModelTraverse;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.actions.generate.autowire.AutowireBeanUtilsKt;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a$\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u001a6\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u000b2\u001c\u0010\f\u001a\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e\u0012\u0004\u0012\u00020\b0\r\u001a\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\t\u001a\u00020\u0003H\u0002\u001a*\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0016\u001a\u00020\u00032\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a8\u0006\u0018"}, d2={"getAccessInfo", "Lcom/intellij/spring/SpringClassAccessInfoProvider$AccessInfo;", "source", "Lcom/intellij/psi/PsiClass;", "target", "module", "Lcom/intellij/openapi/module/Module;", "traverseAutowiringCandidates", "", "injectionTargetClass", "batchSize", "", "processor", "Lkotlin/Function1;", "", "Lcom/intellij/spring/model/SpringBeanPointer;", "collectAutowiredBeans", "", "Lcom/intellij/spring/completion/AlreadyAutowiredBeanInfo;", "beanCanBeInjected", "", "beanPointer", "targetClass", "alreadyAutowiredBeans", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nSpringBeanInjectionCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBeanInjectionCompletionContributor.kt\ncom/intellij/spring/completion/SpringBeanInjectionCompletionContributorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,242:1\n296#2,2:243\n296#2,2:245\n1391#2:247\n1480#2,2:248\n1586#2:250\n1661#2,3:251\n1482#2,3:254\n2792#2,2:257\n1807#2,3:259\n2794#2:262\n1915#2,2:263\n*S KotlinDebug\n*F\n+ 1 SpringBeanInjectionCompletionContributor.kt\ncom/intellij/spring/completion/SpringBeanInjectionCompletionContributorKt\n*L\n162#1:243,2\n213#1:245,2\n218#1:247\n218#1:248,2\n219#1:250\n219#1:251,3\n218#1:254,3\n233#1:257,2\n234#1:259,3\n233#1:262\n197#1:263,2\n*E\n"})
public final class SpringBeanInjectionCompletionContributorKt {
    /*
     * WARNING - void declaration
     */
    private static final SpringClassAccessInfoProvider.AccessInfo getAccessInfo(PsiClass source, PsiClass target, Module module) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            if (module == null) {
                return null;
            }
            Iterable iterable = SpringClassAccessInfoProvider.Companion.getEP_NAME().getExtensionList();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SpringClassAccessInfoProvider it = (SpringClassAccessInfoProvider)element$iv;
                boolean bl = false;
                if (!it.isApplicable(module)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        SpringClassAccessInfoProvider springClassAccessInfoProvider = v0;
        return springClassAccessInfoProvider != null ? springClassAccessInfoProvider.getAccessInfo(source, target) : null;
    }

    public static final void traverseAutowiringCandidates(@NotNull PsiClass injectionTargetClass, int batchSize, @NotNull Function1<? super Collection<? extends SpringBeanPointer<?>>, Unit> processor2) {
        Intrinsics.checkNotNullParameter((Object)injectionTargetClass, (String)"injectionTargetClass");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Set<AlreadyAutowiredBeanInfo> alreadyAutowiredBeans = SpringBeanInjectionCompletionContributorKt.collectAutowiredBeans(injectionTargetClass);
        ArrayList candidates = new ArrayList(batchSize);
        Ref.IntRef itemsCount = new Ref.IntRef();
        CommonSpringModel commonSpringModel = SpringModelUtils.getInstance().getPsiClassSpringModel(injectionTargetClass);
        Intrinsics.checkNotNullExpressionValue((Object)commonSpringModel, (String)"getPsiClassSpringModel(...)");
        CommonSpringModel model = commonSpringModel;
        Processor candidateProcessor = arg_0 -> SpringBeanInjectionCompletionContributorKt.traverseAutowiringCandidates$lambda$0(injectionTargetClass, alreadyAutowiredBeans, candidates, itemsCount, batchSize, processor2, arg_0);
        ModelTraverse.traverseModelBreadthFirst((CommonSpringModel)model, arg_0 -> SpringBeanInjectionCompletionContributorKt.traverseAutowiringCandidates$lambda$1(candidateProcessor, arg_0));
        processor2.invoke(candidates);
    }

    public static /* synthetic */ void traverseAutowiringCandidates$default(PsiClass psiClass, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 100;
        }
        SpringBeanInjectionCompletionContributorKt.traverseAutowiringCandidates(psiClass, n, function1);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<AlreadyAutowiredBeanInfo> collectAutowiredBeans(PsiClass injectionTargetClass) {
        void $this$flatMapTo$iv$iv;
        Object v2;
        CommonSpringModel model;
        block5: {
            void $this$firstOrNull$iv;
            CommonSpringModel commonSpringModel = SpringAutowireUtil.getProcessingSpringModel(injectionTargetClass);
            if (commonSpringModel == null) {
                return SetsKt.emptySet();
            }
            model = commonSpringModel;
            List list = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)injectionTargetClass));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findBeans(...)");
            Iterable iterable = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SpringBeanPointer it = (SpringBeanPointer)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getBeanClass(), (Object)injectionTargetClass)) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        SpringBeanPointer springBeanPointer = v2;
        if (springBeanPointer == null) {
            return SetsKt.emptySet();
        }
        SpringBeanPointer currentBean = springBeanPointer;
        Set<PsiVariable> set = SpringAutowireUtil.getInjectionPoints(currentBean.getSpringBean());
        Intrinsics.checkNotNullExpressionValue(set, (String)"getInjectionPoints(...)");
        Collection injectionPoints = set;
        Iterable $this$flatMap$iv = injectionPoints;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            PsiVariable it = (PsiVariable)element$iv$iv;
            boolean bl = false;
            Set<SpringBeanPointer<?>> set2 = SpringAutowireUtil.getAutowiredBeansFor((PsiModifierListOwner)it, SpringAutowireUtil.getAutowiredType(it.getType()), model);
            Intrinsics.checkNotNullExpressionValue(set2, (String)"getAutowiredBeansFor(...)");
            Iterable $this$map$iv = set2;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void beanPointer;
                SpringBeanPointer springBeanPointer2 = (SpringBeanPointer)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)beanPointer);
                collection.add(new AlreadyAutowiredBeanInfo((SpringBeanPointer)beanPointer, null, 2, null));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final boolean beanCanBeInjected(SpringBeanPointer<?> beanPointer, PsiClass targetClass, Set<AlreadyAutowiredBeanInfo> alreadyAutowiredBeans) {
        boolean bl;
        block9: {
            PsiClass psiClass = beanPointer.getBeanClass();
            if (psiClass == null) {
                return false;
            }
            PsiClass beanClass = psiClass;
            if (Intrinsics.areEqual((Object)beanClass, (Object)targetClass)) {
                return false;
            }
            PsiClassType psiClassType = PsiTypesUtil.getClassType((PsiClass)beanClass);
            Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"getClassType(...)");
            PsiClassType beanType = psiClassType;
            Iterable $this$none$iv = alreadyAutowiredBeans;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    boolean bl2;
                    AlreadyAutowiredBeanInfo it;
                    block8: {
                        it = (AlreadyAutowiredBeanInfo)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv = it.getBeanTypes();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                PsiType type = (PsiType)element$iv2;
                                boolean bl4 = false;
                                if (!type.isAssignableFrom((PsiType)beanType)) continue;
                                bl2 = true;
                                break block8;
                            }
                            bl2 = false;
                        }
                    }
                    if (!(bl2 && Intrinsics.areEqual((Object)it.getBeanPointer().getName(), (Object)beanPointer.getName()))) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean traverseAutowiringCandidates$lambda$1$0(Processor $candidateProcessor, SpringBeanPointer it) {
        if ($candidateProcessor.process((Object)it)) {
            Intrinsics.checkNotNull((Object)it);
            Iterable $this$forEach$iv = AutowireBeanUtilsKt.getBaseClassesAndInterfaces(it);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SpringBeanPointer p0 = (SpringBeanPointer)element$iv;
                boolean bl = false;
                $candidateProcessor.process((Object)p0);
            }
        }
        return true;
    }

    private static final boolean traverseAutowiringCandidates$lambda$1$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean traverseAutowiringCandidates$lambda$0(PsiClass $injectionTargetClass, Set $alreadyAutowiredBeans, ArrayList $candidates, Ref.IntRef $itemsCount, int $batchSize, Function1 $processor, SpringBeanPointer t) {
        if (t.getName() == null) {
            return true;
        }
        Intrinsics.checkNotNull((Object)t);
        if (SpringBeanInjectionCompletionContributorKt.beanCanBeInjected(t, $injectionTargetClass, $alreadyAutowiredBeans)) {
            $candidates.add(t);
        }
        int n = $itemsCount.element;
        $itemsCount.element = n + 1;
        if ($itemsCount.element > $batchSize) {
            $processor.invoke((Object)$candidates);
            $candidates.clear();
            $itemsCount.element = 0;
        }
        return true;
    }

    private static final Direction traverseAutowiringCandidates$lambda$1(Processor $candidateProcessor, CommonSpringModel relatedModel) {
        Intrinsics.checkNotNullParameter((Object)relatedModel, (String)"relatedModel");
        relatedModel.processLocalBeans(arg_0 -> SpringBeanInjectionCompletionContributorKt.traverseAutowiringCandidates$lambda$1$1(arg_0 -> SpringBeanInjectionCompletionContributorKt.traverseAutowiringCandidates$lambda$1$0($candidateProcessor, arg_0), arg_0));
        return Direction.TRAVERSE;
    }

    public static final /* synthetic */ SpringClassAccessInfoProvider.AccessInfo access$getAccessInfo(PsiClass source, PsiClass target, Module module) {
        return SpringBeanInjectionCompletionContributorKt.getAccessInfo(source, target, module);
    }
}

