/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.beans.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.ResolvedConstructorArgs;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.converters.SpringBeanFactoryMethodConverterImpl;
import com.intellij.spring.model.highlighting.xml.SpringConstructorArgResolveUtil;
import com.intellij.spring.model.jam.qualifiers.SpringJamQualifier;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.AbstractDomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanImpl;
import com.intellij.spring.model.xml.beans.Autowire;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.CNamespaceDomElement;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringDomQualifier;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.impl.ResolvedConstructorArgsImpl;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBeanImpl
extends DomSpringBeanImpl
implements SpringBean {
    public static final Function<SpringBean, Collection<SpringPropertyDefinition>> PROPERTIES_GETTER = SpringPropertyUtils::getProperties;
    public static final Function<SpringBean, Collection<ConstructorArg>> CTOR_ARGS_GETTER = SpringBean::getConstructorArgs;

    @Nullable
    public PsiClass getInstantiationClass() {
        PsiMethod factoryMethod;
        GenericAttributeValue<PsiMethod> factoryMethodAttribute = this.getFactoryMethod();
        if (DomUtil.hasXml(factoryMethodAttribute) && (factoryMethod = (PsiMethod)factoryMethodAttribute.getValue()) != null) {
            return SpringBeanFactoryMethodConverterImpl.getFactoryClass((AbstractDomSpringBean)this);
        }
        return PsiTypesUtil.getPsiClass((PsiType)this.getBeanType());
    }

    @NotNull
    public List<PsiMethod> getInstantiationMethods() {
        String factoryMethod;
        GenericAttributeValue<PsiMethod> factoryMethodAttribute = this.getFactoryMethod();
        if (DomUtil.hasXml(factoryMethodAttribute) && (factoryMethod = factoryMethodAttribute.getStringValue()) != null) {
            List list = SpringBeanFactoryMethodConverterImpl.getFactoryMethodCandidates((AbstractDomSpringBean)this, (String)factoryMethod);
            if (list == null) {
                SpringBeanImpl.$$$reportNull$$$0(0);
            }
            return list;
        }
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)this.getBeanType());
        if (beanClass != null) {
            List<PsiMethod> list = Arrays.asList(beanClass.getConstructors());
            if (list == null) {
                SpringBeanImpl.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<PsiMethod> list = Collections.emptyList();
        if (list == null) {
            SpringBeanImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public String getBeanName() {
        if (DomUtil.hasXml((DomElement)this.getId())) {
            return this.getId().getRawText();
        }
        GenericAttributeValue nameAttribute = this.getName();
        if (!DomUtil.hasXml((DomElement)nameAttribute)) {
            return null;
        }
        String name = nameAttribute.getRawText();
        if (name != null) {
            List list = SpringCommonUtils.tokenize((String)name);
            return (String)ContainerUtil.getFirstItem((List)list);
        }
        return null;
    }

    public String @NotNull [] getAliases() {
        String name = this.getName().getRawText();
        if (name != null) {
            List list = SpringCommonUtils.tokenize((String)name);
            String id = this.getId().getStringValue();
            if (id == null && list.size() > 1) {
                list.remove(0);
            }
            String[] stringArray = ArrayUtilRt.toStringArray((Collection)list);
            if (stringArray == null) {
                SpringBeanImpl.$$$reportNull$$$0(3);
            }
            return stringArray;
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            SpringBeanImpl.$$$reportNull$$$0(4);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public void setName(@NotNull String newName) {
        String id;
        if (newName == null) {
            SpringBeanImpl.$$$reportNull$$$0(5);
        }
        if ((id = this.getId().getStringValue()) != null) {
            this.getId().setStringValue(newName);
            return;
        }
        String name = this.getName().getStringValue();
        if (name != null) {
            int first = StringUtil.findFirst((CharSequence)name, (CharFilter)SpringCommonUtils.ourFilter);
            if (first >= 0) {
                String newValue = newName + name.substring(first);
                this.getName().setStringValue(newValue);
            } else {
                this.getName().setStringValue(newName);
            }
            return;
        }
        this.getId().setValue((Object)newName);
    }

    @NotNull
    public abstract GenericAttributeValue<SpringBeanPointer<?>> getFactoryBean();

    @NotNull
    public abstract GenericAttributeValue<PsiMethod> getFactoryMethod();

    @Nullable
    public PsiClass getBeanClass(@Nullable Set<AbstractDomSpringBean> visited, boolean considerFactories) {
        SpringBeanPointer parent;
        if (visited != null && visited.contains((Object)this)) {
            return null;
        }
        PsiClass psiClass = super.getBeanClass(visited, considerFactories);
        if (psiClass != null) {
            return psiClass;
        }
        GenericAttributeValue parentBeanValue = this.getParentBean();
        if (DomUtil.hasXml((DomElement)parentBeanValue) && (parent = (SpringBeanPointer)parentBeanValue.getValue()) != null) {
            if (visited == null) {
                visited = new HashSet<AbstractDomSpringBean>();
            }
            visited.add((AbstractDomSpringBean)this);
            CommonSpringBean bean = parent.getSpringBean();
            if (bean instanceof DomSpringBeanImpl) {
                return ((DomSpringBeanImpl)bean).getBeanClass(visited, considerFactories);
            }
        }
        return null;
    }

    public List<SpringPropertyDefinition> getAllProperties() {
        Set<SpringPropertyDefinition> list = SpringBeanCoreUtils.getMergedSet(this, PROPERTIES_GETTER);
        return list.isEmpty() ? Collections.emptyList() : new ArrayList<SpringPropertyDefinition>(list);
    }

    public SpringPropertyDefinition getProperty(@NotNull String name) {
        if (name == null) {
            SpringBeanImpl.$$$reportNull$$$0(6);
        }
        Ref ref = new Ref();
        SpringBeanCoreUtils.visitParents(this, false, (Processor<? super SpringBean>)((Processor)springBean -> {
            List properties = SpringPropertyUtils.getProperties((CommonSpringBean)springBean);
            for (SpringPropertyDefinition property : properties) {
                if (!name.equals(property.getPropertyName())) continue;
                ref.set((Object)property);
                return false;
            }
            return true;
        }));
        return (SpringPropertyDefinition)ref.get();
    }

    public Set<ConstructorArg> getAllConstructorArgs() {
        return SpringBeanCoreUtils.getMergedSet(this, CTOR_ARGS_GETTER);
    }

    @NotNull
    public ResolvedConstructorArgs getResolvedConstructorArgs() {
        ResolvedConstructorArgs resolvedConstructorArgs = (ResolvedConstructorArgs)CachedValuesManager.getManager((Project)this.getManager().getProject()).getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.createSingleDependency((Object)new ResolvedConstructorArgsImpl(this), (Object)PsiModificationTracker.MODIFICATION_COUNT));
        if (resolvedConstructorArgs == null) {
            SpringBeanImpl.$$$reportNull$$$0(7);
        }
        return resolvedConstructorArgs;
    }

    @NotNull
    public List<CNamespaceDomElement> getCNamespaceConstructorArgDefinitions() {
        List list = DomUtil.getDefinedChildrenOfType((DomElement)this, CNamespaceDomElement.class);
        if (list == null) {
            SpringBeanImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    public boolean isAbstract() {
        GenericAttributeValue abstractAttribute = this.getAbstract();
        if (!DomUtil.hasXml((DomElement)abstractAttribute)) {
            return false;
        }
        Boolean value = (Boolean)abstractAttribute.getValue();
        return value != null && value != false;
    }

    @NotNull
    public Autowire getBeanAutowire() {
        Autowire autowire;
        GenericAttributeValue autowireAttribute = this.getAutowire();
        Autowire autowire2 = autowire = DomUtil.hasXml((DomElement)autowireAttribute) ? (Autowire)autowireAttribute.getValue() : null;
        if (autowire == null) {
            Beans beans = (Beans)this.getParentOfType(Beans.class, false);
            assert (beans != null);
            GenericAttributeValue defaultAutowireAttribute = beans.getDefaultAutowire();
            Autowire autowire3 = autowire = DomUtil.hasXml((DomElement)defaultAutowireAttribute) ? (Autowire)defaultAutowireAttribute.getValue() : null;
            if (autowire == null) {
                Autowire autowire4 = Autowire.DEFAULT;
                if (autowire4 == null) {
                    SpringBeanImpl.$$$reportNull$$$0(9);
                }
                return autowire4;
            }
        }
        if (autowire == Autowire.AUTODETECT) {
            Autowire autowire5 = SpringConstructorArgResolveUtil.hasEmptyConstructor(this) ? Autowire.BY_TYPE : Autowire.CONSTRUCTOR;
            if (autowire5 == null) {
                SpringBeanImpl.$$$reportNull$$$0(10);
            }
            return autowire5;
        }
        Autowire autowire6 = autowire;
        if (autowire6 == null) {
            SpringBeanImpl.$$$reportNull$$$0(11);
        }
        return autowire6;
    }

    @NonNls
    public String toString() {
        String beanName = this.getBeanName();
        return beanName == null ? "Unknown" + ((Object)((Object)this)).hashCode() : beanName;
    }

    @NotNull
    public Collection<SpringQualifier> getSpringQualifiers() {
        PsiClass aClass;
        SpringDomQualifier qualifier = this.getQualifier();
        if (DomUtil.hasXml((DomElement)qualifier)) {
            Set<SpringDomQualifier> set = Collections.singleton(qualifier);
            if (set == null) {
                SpringBeanImpl.$$$reportNull$$$0(12);
            }
            return set;
        }
        Module module = this.getModule();
        if (module != null && (aClass = PsiTypesUtil.getPsiClass((PsiType)this.getBeanType())) != null) {
            Collection collection = SpringJamQualifier.findSpringJamQualifiers((Module)module, (PsiModifierListOwner)aClass);
            if (collection == null) {
                SpringBeanImpl.$$$reportNull$$$0(13);
            }
            return collection;
        }
        Set<SpringQualifier> set = Collections.emptySet();
        if (set == null) {
            SpringBeanImpl.$$$reportNull$$$0(14);
        }
        return set;
    }

    public boolean isPrimary() {
        GenericAttributeValue primaryAttribute = this.getPrimary();
        if (!DomUtil.hasXml((DomElement)primaryAttribute)) {
            return super.isPrimary();
        }
        Boolean primary = (Boolean)primaryAttribute.getValue();
        return primary == null ? super.isPrimary() : primary.booleanValue();
    }

    public SpringBeanScope getSpringScope() {
        return (SpringBeanScope)this.getScope().getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/xml/beans/impl/SpringBeanImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstantiationMethods";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliases";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/xml/beans/impl/SpringBeanImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedConstructorArgs";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCNamespaceConstructorArgDefinitions";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanAutowire";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringQualifiers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

