/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.runtime;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.reference.SoftReference;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.runtime.SpringRuntimeBeanResolver;
import com.intellij.spring.runtime.SpringRuntimeBeanResolverImplKt;
import com.intellij.spring.runtime.SpringRuntimeResource;
import com.intellij.spring.runtime.SpringRuntimeResourceImpl;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.xml.util.PsiElementPointer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.regex.Matcher;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J&\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u00142\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0010\u0010\fR\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/spring/runtime/SpringRuntimeBeanResolverImpl;", "Lcom/intellij/spring/runtime/SpringRuntimeBeanResolver;", "id", "", "type", "name", "factoryMethodName", "resource", "Lcom/intellij/spring/runtime/SpringRuntimeResource;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/spring/runtime/SpringRuntimeResource;)V", "getName", "()Ljava/lang/String;", "name$delegate", "Lkotlin/Lazy;", "className", "getClassName", "className$delegate", "classRef", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/psi/PsiClass;", "beanPointerRef", "Lcom/intellij/spring/model/SpringBeanPointer;", "dropPackagePrefix", "matches", "", "psiClass", "findBeanClass", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findBeanPointer", "Lcom/intellij/xml/util/PsiElementPointer;", "beanClass", "resourceElement", "Lcom/intellij/psi/PsiElement;", "springModel", "Lcom/intellij/spring/CommonSpringModel;", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nSpringRuntimeBeanResolverImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringRuntimeBeanResolverImpl.kt\ncom/intellij/spring/runtime/SpringRuntimeBeanResolverImpl\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,204:1\n106#2:205\n78#2,22:206\n*S KotlinDebug\n*F\n+ 1 SpringRuntimeBeanResolverImpl.kt\ncom/intellij/spring/runtime/SpringRuntimeBeanResolverImpl\n*L\n54#1:205\n54#1:206,22\n*E\n"})
public final class SpringRuntimeBeanResolverImpl
implements SpringRuntimeBeanResolver {
    @NotNull
    private final String id;
    @Nullable
    private final String type;
    @Nullable
    private final String factoryMethodName;
    @Nullable
    private final SpringRuntimeResource resource;
    @NotNull
    private final Lazy name$delegate;
    @NotNull
    private final Lazy className$delegate;
    @Nullable
    private volatile WeakReference<PsiClass> classRef;
    @Nullable
    private volatile WeakReference<SpringBeanPointer<?>> beanPointerRef;

    public SpringRuntimeBeanResolverImpl(@NotNull String id, @Nullable String type, @Nullable String name, @Nullable String factoryMethodName, @Nullable SpringRuntimeResource resource) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        this.type = type;
        this.factoryMethodName = factoryMethodName;
        this.resource = resource;
        this.name$delegate = LazyKt.lazy(() -> SpringRuntimeBeanResolverImpl.name_delegate$lambda$0(name, this));
        this.className$delegate = LazyKt.lazy(() -> SpringRuntimeBeanResolverImpl.className_delegate$lambda$0(this));
    }

    @NotNull
    public String getName() {
        Lazy lazy = this.name$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public String getClassName() {
        Lazy lazy = this.className$delegate;
        return (String)lazy.getValue();
    }

    private final String dropPackagePrefix(String name) {
        String string;
        String string2;
        Matcher matcher = SpringRuntimeBeanResolverImplKt.access$getCLASS_NAME_START_PATTERN$p().matcher(name);
        if (!matcher.find()) {
            return name;
        }
        int nameIndex = matcher.start();
        if (nameIndex < 0 || nameIndex >= name.length() - 1) {
            return name;
        }
        String string3 = name.substring(nameIndex + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String className = string3;
        int subClassNameCandidateIndex = StringUtil.indexOfAny((String)className, (String)".$@");
        if (subClassNameCandidateIndex >= 0) {
            String string4 = className.substring(0, subClassNameCandidateIndex);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        } else {
            string2 = className;
        }
        String subClassNameCandidate = string2;
        String beanClassName = this.getClassName();
        if (!StringsKt.contains$default((CharSequence)beanClassName, (CharSequence)("$" + subClassNameCandidate), (boolean)false, (int)2, null)) {
            return className;
        }
        if ((nameIndex = StringUtil.lastIndexOf((CharSequence)name, (char)'.', (int)0, (int)nameIndex)) >= 0 && nameIndex < name.length() - 1) {
            String string5 = name.substring(nameIndex + 1);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        } else {
            string = name;
        }
        return string;
    }

    public boolean matches(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return Intrinsics.areEqual((Object)StringsKt.replace$default((String)this.getClassName(), (char)'$', (char)'.', (boolean)false, (int)4, null), (Object)psiClass.getQualifiedName());
    }

    @Nullable
    public PsiClass findBeanClass(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        PsiClass psiClass = (PsiClass)SoftReference.dereference((Reference)this.classRef);
        if (psiClass != null && psiClass.isValid() && this.matches(psiClass)) {
            return psiClass;
        }
        psiClass = SpringRuntimeResourceImpl.Companion.findClass$intellij_spring_core(this.getClassName(), project, searchScope);
        this.classRef = new WeakReference<PsiClass>(psiClass);
        return psiClass;
    }

    @NotNull
    public PsiElementPointer findBeanPointer(@Nullable PsiClass beanClass, @Nullable PsiElement resourceElement, @Nullable CommonSpringModel springModel) {
        PsiElementPointer psiElementPointer;
        SpringModel localModel;
        SpringBeanPointer pointer = (SpringBeanPointer)SoftReference.dereference((Reference)this.beanPointerRef);
        if (pointer != null && pointer.isValid() && Intrinsics.areEqual((Object)this.getName(), (Object)pointer.getSpringBean().getBeanName())) {
            return (PsiElementPointer)pointer;
        }
        pointer = null;
        PsiElement psiElement = resourceElement;
        PsiFile beanFile = psiElement != null ? psiElement.getContainingFile() : null;
        PsiClass beanContainingClass = SpringRuntimeBeanResolverImplKt.access$getBeanContainingClass(resourceElement);
        CommonProcessors.FindProcessor findProcessor2 = new CommonProcessors.FindProcessor<SpringBeanPointer<?>>(beanFile, beanContainingClass, this){
            final /* synthetic */ PsiFile $beanFile;
            final /* synthetic */ PsiClass $beanContainingClass;
            final /* synthetic */ SpringRuntimeBeanResolverImpl this$0;
            {
                this.$beanFile = $beanFile;
                this.$beanContainingClass = $beanContainingClass;
                this.this$0 = $receiver;
            }

            protected boolean accept(SpringBeanPointer<?> pointer) {
                Intrinsics.checkNotNullParameter(pointer, (String)"pointer");
                if (this.$beanFile == null) {
                    return true;
                }
                boolean accept = this.$beanFile.getManager().areElementsEquivalent((PsiElement)this.$beanFile, (PsiElement)pointer.getContainingFile());
                if (!accept) {
                    accept = InheritanceUtil.isInheritorOrSelf((PsiClass)this.$beanContainingClass, (PsiClass)SpringRuntimeBeanResolverImplKt.access$getBeanContainingClass(pointer.getPsiElement()), (boolean)true);
                }
                if (SpringRuntimeBeanResolverImpl.access$getFactoryMethodName$p(this.this$0) != null) {
                    CommonSpringBean commonSpringBean = pointer.getSpringBean();
                    CommonModelElement.PsiBase psiBase = commonSpringBean instanceof CommonModelElement.PsiBase ? (CommonModelElement.PsiBase)commonSpringBean : null;
                    PsiElement $this$toUElementOfType$iv = psiBase != null ? psiBase.getPsiElement() : null;
                    boolean $i$f$toUElementOfType = false;
                    UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
                    String pointerMethodName = uMethod != null ? uMethod.getName() : null;
                    accept = Intrinsics.areEqual((Object)SpringRuntimeBeanResolverImpl.access$getFactoryMethodName$p(this.this$0), (Object)pointerMethodName);
                }
                return accept;
            }
        };
        PsiFile localModelConfigFile = beanFile;
        if (!(localModelConfigFile != null || this.resource != null && this.resource.hasDescription() || beanClass == null)) {
            localModelConfigFile = beanClass.getContainingFile();
        }
        if (localModelConfigFile != null && (localModel = SpringManager.getInstance((Project)localModelConfigFile.getProject()).getSpringModelByFile(localModelConfigFile)) != null) {
            localModel.processByName(SpringModelSearchParameters.byName((String)this.getName()), (Processor)findProcessor2);
            pointer = (SpringBeanPointer)findProcessor2.getFoundValue();
        }
        if (pointer == null && springModel != null) {
            springModel.processByName(SpringModelSearchParameters.byName((String)this.getName()), (Processor)findProcessor2);
            pointer = (SpringBeanPointer)findProcessor2.getFoundValue();
        }
        this.beanPointerRef = new WeakReference<SpringBeanPointer>(pointer);
        SpringBeanPointer springBeanPointer = pointer;
        if (springBeanPointer != null) {
            return (PsiElementPointer)springBeanPointer;
        }
        if (this.resource == null || !this.resource.hasDescription() || StringsKt.contains$default((CharSequence)this.resource.getDescription(), (CharSequence)" defined in ", (boolean)false, (int)2, null)) {
            psiElementPointer = () -> SpringRuntimeBeanResolverImpl.findBeanPointer$lambda$0(beanClass);
        } else {
            PsiClass psiClass = beanContainingClass;
            psiElementPointer = (PsiElementPointer)SpringRuntimeBeanResolverImplKt.access$getRuntimeResourcePointer(psiClass != null ? (PsiElement)psiClass : (PsiElement)beanFile);
        }
        return psiElementPointer;
    }

    private static final String name_delegate$lambda$0(String $name, SpringRuntimeBeanResolverImpl this$0) {
        String string = $name;
        if (string != null) {
            return string;
        }
        if (StringsKt.endsWith$default((String)this$0.id, (String)"CONFIGURATION_PROPERTIES", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)this$0.id, (CharSequence)"-", (boolean)false, (int)2, null)) {
            return this$0.id;
        }
        String beanName = this$0.dropPackagePrefix(this$0.id);
        CharSequence charSequence = beanName;
        Regex regex = new Regex("\\$");
        String string2 = ".";
        beanName = regex.replace(charSequence, string2);
        beanName = StringsKt.substringBefore$default((String)beanName, (char)'@', null, (int)2, null);
        String string3 = StringUtil.decapitalize((String)beanName);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"decapitalize(...)");
        return string3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final String className_delegate$lambda$0(SpringRuntimeBeanResolverImpl this$0) {
        String className = this$0.type;
        if (className != null) {
            String $this$trim$iv = className;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (!(((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0)) {
                if (!StringsKt.startsWith$default((String)className, (String)"com.sun.proxy", (boolean)false, (int)2, null)) return SpringRuntimeBeanResolverImplKt.access$cleanClassName(className);
                if (this$0.resource == null) return SpringRuntimeBeanResolverImplKt.access$cleanClassName(className);
                if (!this$0.resource.hasDescription()) return SpringRuntimeBeanResolverImplKt.access$cleanClassName(className);
                if (!this$0.resource.isClassResource()) return SpringRuntimeBeanResolverImplKt.access$cleanClassName(className);
                className = SpringRuntimeBeanResolverImplKt.access$extractClassName(this$0.resource.getPath());
                return SpringRuntimeBeanResolverImplKt.access$cleanClassName(className);
            }
        }
        className = this$0.id;
        return SpringRuntimeBeanResolverImplKt.access$cleanClassName(className);
    }

    private static final PsiElement findBeanPointer$lambda$0(PsiClass $beanClass) {
        return (PsiElement)$beanClass;
    }

    public static final /* synthetic */ String access$getFactoryMethodName$p(SpringRuntimeBeanResolverImpl $this) {
        return $this.factoryMethodName;
    }
}

