/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.common.rpc.messaging;

import com.intellij.codeWithMe.ClientId;
import com.intellij.javascript.debugger.common.rpc.messaging.HostCommand;
import com.intellij.javascript.debugger.common.rpc.messaging.ReverseRequestMessage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0006\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lcom/intellij/javascript/debugger/common/rpc/messaging/HostCommunicator;", "", "clientId", "Lcom/intellij/codeWithMe/ClientId;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "hostToClient", "Lkotlinx/coroutines/channels/Channel;", "Lcom/intellij/javascript/debugger/common/rpc/messaging/ReverseRequestMessage;", "Lcom/intellij/javascript/debugger/common/rpc/messaging/HostCommand$Request;", "clientToHost", "Lcom/intellij/javascript/debugger/common/rpc/messaging/HostCommand$Response;", "<init>", "(Lcom/intellij/codeWithMe/ClientId;Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/channels/Channel;Lkotlinx/coroutines/channels/Channel;)V", "getClientId", "()Lcom/intellij/codeWithMe/ClientId;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "getHostToClient", "()Lkotlinx/coroutines/channels/Channel;", "getClientToHost", "disconnect", "", "intellij.javascript.debugger.common"})
@ApiStatus.Internal
public final class HostCommunicator {
    @NotNull
    private final ClientId clientId;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Channel<ReverseRequestMessage<HostCommand.Request<?>>> hostToClient;
    @NotNull
    private final Channel<ReverseRequestMessage<HostCommand.Response>> clientToHost;

    public HostCommunicator(@NotNull ClientId clientId, @NotNull CoroutineScope scope, @NotNull Channel<ReverseRequestMessage<HostCommand.Request<?>>> hostToClient, @NotNull Channel<ReverseRequestMessage<HostCommand.Response>> clientToHost) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(hostToClient, (String)"hostToClient");
        Intrinsics.checkNotNullParameter(clientToHost, (String)"clientToHost");
        this.clientId = clientId;
        this.scope = scope;
        this.hostToClient = hostToClient;
        this.clientToHost = clientToHost;
    }

    @NotNull
    public final ClientId getClientId() {
        return this.clientId;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @NotNull
    public final Channel<ReverseRequestMessage<HostCommand.Request<?>>> getHostToClient() {
        return this.hostToClient;
    }

    @NotNull
    public final Channel<ReverseRequestMessage<HostCommand.Response>> getClientToHost() {
        return this.clientToHost;
    }

    public final void disconnect() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, (String)("Client " + this.clientId + " disconnected"), null, (int)2, null);
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.hostToClient), null, (int)1, null);
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.clientToHost), null, (int)1, null);
    }
}

