/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface PopupBorder
extends Border {
    public void setActive(boolean var1);

    @ApiStatus.Internal
    public void setPopupUsed();

    @ApiStatus.Internal
    public static final class BaseBorder
    implements PopupBorder {
        private final boolean myVisible;
        private final Color myActiveColor;
        private final Color myPassiveColor;
        private boolean myActive;
        private boolean popupUsed = false;

        private BaseBorder() {
            this(false, null, null);
        }

        private BaseBorder(boolean visible, Color activeColor, Color passiveColor) {
            this.myVisible = visible;
            this.myActiveColor = activeColor;
            this.myPassiveColor = passiveColor;
        }

        @Override
        public void setActive(boolean active) {
            this.myActive = active;
        }

        @Override
        public void setPopupUsed() {
            this.popupUsed = true;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (!this.myVisible) {
                return;
            }
            Color color = this.myActive ? this.myActiveColor : this.myPassiveColor;
            g.setColor(color);
            RectanglePainter2D.DRAW.paint((Graphics2D)g, x, y, width, height, null, LinePainter2D.StrokeType.INSIDE, this.getBorderWidth(), RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.myVisible ? JBUI.insets((int)Math.ceil(this.getBorderWidth())) : JBInsets.emptyInsets();
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        private float getBorderWidth() {
            return this.popupUsed ? JBUI.CurrentTheme.Popup.borderWidth() : 1.0f;
        }
    }

    public static final class Factory {
        private Factory() {
        }

        @NotNull
        public static PopupBorder createEmpty() {
            return new BaseBorder();
        }

        @NotNull
        public static PopupBorder create(boolean active, boolean windowWithShadow) {
            boolean visible = !SystemInfoRt.isMac || !windowWithShadow || UIManager.getBoolean("Popup.paintBorder");
            PopupBorder border = Factory.createPopupBorder(visible);
            border.setActive(active);
            PopupBorder popupBorder = border;
            if (popupBorder == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return popupBorder;
        }

        @ApiStatus.Internal
        @NotNull
        public static PopupBorder createPopupBorder(boolean visible) {
            return new BaseBorder(visible, JBUI.CurrentTheme.Popup.borderColor(true), JBUI.CurrentTheme.Popup.borderColor(false));
        }

        public static PopupBorder createColored(Color color) {
            BaseBorder border = new BaseBorder(true, color, color);
            border.setActive(true);
            return border;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/PopupBorder$Factory", "create"));
        }
    }
}

