/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.refactoring.moveRuleset;

import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.css.refactoring.moveRuleset.CssMoveRulesetDialog;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssMoveRulesetHandler
extends MoveHandlerDelegate {
    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, @Nullable PsiReference reference, Editor editor) {
        if (!(element.getParent() instanceof CssRulesetList)) {
            return false;
        }
        PsiFile containingFile = element.getContainingFile();
        TextRange rangeInHost = InjectedLanguageManager.getInstance((Project)project).injectedToHost((PsiElement)containingFile, containingFile.getTextRange());
        if (rangeInHost.getLength() != containingFile.getTextLength()) {
            return false;
        }
        TextRange selectionRange = TextRange.create((int)editor.getSelectionModel().getSelectionStart(), (int)editor.getSelectionModel().getSelectionEnd());
        List<PsiElement> toMove = CssMoveRulesetHandler.getElementsToMove(element, selectionRange);
        VirtualFile file = containingFile.getVirtualFile();
        if (toMove.isEmpty() || file == null) {
            return false;
        }
        editor.getSelectionModel().setSelection(Math.min(selectionRange.getStartOffset(), toMove.getFirst().getTextRange().getStartOffset()), Math.max(selectionRange.getEndOffset(), toMove.getLast().getTextRange().getEndOffset()));
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiFile psiFile;
            VirtualFile targetFile = (VirtualFile)ContainerUtil.find((Object[])file.getParent().getChildren(), f -> f.getNameWithoutExtension().equals("testTarget"));
            PsiFile psiFile2 = psiFile = targetFile != null ? PsiManager.getInstance((Project)project).findFile(targetFile) : null;
            if (psiFile instanceof StylesheetFile) {
                CssMoveRulesetDialog.moveRulesetListChildren(file, (StylesheetFile)psiFile, toMove, false);
            }
            return true;
        }
        CssMoveRulesetDialog dialog = new CssMoveRulesetDialog(project, file, toMove);
        dialog.show();
        return true;
    }

    @NotNull
    private static List<PsiElement> getElementsToMove(@NotNull PsiElement elementAtCaret, @NotNull TextRange selectionRange) {
        if (elementAtCaret == null) {
            CssMoveRulesetHandler.$$$reportNull$$$0(0);
        }
        if (selectionRange == null) {
            CssMoveRulesetHandler.$$$reportNull$$$0(1);
        }
        SmartList result = new SmartList();
        if (selectionRange.isEmpty()) {
            if (!(elementAtCaret instanceof PsiWhiteSpace)) {
                result.add(elementAtCaret);
            }
        } else {
            PsiElement sibling;
            if (elementAtCaret.getTextRange().intersectsStrict(selectionRange) && !(elementAtCaret instanceof PsiWhiteSpace)) {
                result.addFirst(elementAtCaret);
            }
            for (sibling = elementAtCaret.getPrevSibling(); sibling != null && sibling.getTextRange().intersectsStrict(selectionRange); sibling = sibling.getPrevSibling()) {
                if (sibling instanceof PsiWhiteSpace) continue;
                result.addFirst(sibling);
            }
            for (sibling = elementAtCaret.getNextSibling(); sibling != null && sibling.getTextRange().intersectsStrict(selectionRange); sibling = sibling.getNextSibling()) {
                if (sibling instanceof PsiWhiteSpace) continue;
                result.add(sibling);
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            CssMoveRulesetHandler.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    public boolean supportsLanguage(@NotNull Language language) {
        if (language == null) {
            CssMoveRulesetHandler.$$$reportNull$$$0(3);
        }
        return language == CSSLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAtCaret";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/refactoring/moveRuleset/CssMoveRulesetHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/refactoring/moveRuleset/CssMoveRulesetHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToMove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToMove";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "supportsLanguage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

