/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.prompt.markdown;

import ai.koog.prompt.markdown.TableAlignment;
import ai.koog.prompt.text.TextContentBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 *2\u00020\u0001:\u0003*+,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\tJ\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\t2\b\b\u0002\u0010\u0015\u001a\u00020\tJ\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tJ\u0016\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tJ\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u001f\u0010\u001c\u001a\u00020\u00052\u0017\u0010\u001d\u001a\u0013\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00050\u001e\u00a2\u0006\u0002\b J8\u0010!\u001a\u00020\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#2\u0012\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0#0#2\u000e\b\u0002\u0010%\u001a\b\u0012\u0004\u0012\u00020&0#J#\u0010'\u001a\u00020\u00052\u001b\u0010\u001d\u001a\u0017\u0012\b\u0012\u00060(R\u00020\u0000\u0012\u0004\u0012\u00020\u00050\u001e\u00a2\u0006\u0002\b J#\u0010)\u001a\u00020\u00052\u001b\u0010\u001d\u001a\u0017\u0012\b\u0012\u00060(R\u00020\u0000\u0012\u0004\u0012\u00020\u00050\u001e\u00a2\u0006\u0002\b \u00a8\u0006-"}, d2={"Lai/koog/prompt/markdown/MarkdownContentBuilder;", "Lai/koog/prompt/text/TextContentBuilder;", "<init>", "()V", "header", "", "level", "", "text", "", "h1", "h2", "h3", "h4", "h5", "h6", "bold", "italic", "strikethrough", "code", "codeblock", "language", "link", "url", "image", "alt", "horizontalRule", "blockquote", "line", "block", "Lkotlin/Function1;", "Lai/koog/prompt/markdown/MarkdownContentBuilder$LineContext;", "Lkotlin/ExtensionFunctionType;", "table", "headers", "", "rows", "alignments", "Lai/koog/prompt/markdown/TableAlignment;", "bulleted", "Lai/koog/prompt/markdown/MarkdownContentBuilder$ListContext;", "numbered", "Companion", "LineContext", "ListContext", "prompt-markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdown.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Markdown.kt\nai/koog/prompt/markdown/MarkdownContentBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,519:1\n1#2:520\n1869#3,2:521\n1563#3:523\n1634#3,3:524\n1869#3,2:527\n*S KotlinDebug\n*F\n+ 1 Markdown.kt\nai/koog/prompt/markdown/MarkdownContentBuilder\n*L\n156#1:521,2\n204#1:523\n204#1:524,3\n214#1:527,2\n*E\n"})
public final class MarkdownContentBuilder
extends TextContentBuilder {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final String INDENTATION_ITEM = StringsKt.repeat((CharSequence)" ", (int)2);

    public final void header(int level, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!(1 <= level ? level < 7 : false)) {
            boolean bl = false;
            String string = "Header level must be between 1 and 6";
            throw new IllegalArgumentException(string.toString());
        }
        String prefix = StringsKt.repeat((CharSequence)"#", (int)level);
        this.unaryPlus(prefix + " " + text);
    }

    public final void h1(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.header(1, text);
    }

    public final void h2(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.header(2, text);
    }

    public final void h3(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.header(3, text);
    }

    public final void h4(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.header(4, text);
    }

    public final void h5(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.header(5, text);
    }

    public final void h6(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.header(6, text);
    }

    public final void bold(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.unaryPlus("**" + text + "**");
    }

    public final void italic(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.unaryPlus("*" + text + "*");
    }

    public final void strikethrough(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.unaryPlus("~~" + text + "~~");
    }

    public final void code(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.unaryPlus("`" + code + "`");
    }

    public final void codeblock(@NotNull String code, @NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.unaryPlus("```" + language);
        this.unaryPlus(code);
        this.unaryPlus("```");
    }

    public static /* synthetic */ void codeblock$default(MarkdownContentBuilder markdownContentBuilder, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        markdownContentBuilder.codeblock(string, string2);
    }

    public final void link(@NotNull String text, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.unaryPlus("[" + text + "](" + url + ")");
    }

    public final void image(@NotNull String alt, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)alt, (String)"alt");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.unaryPlus("![" + alt + "](" + url + ")");
    }

    public final void horizontalRule() {
        this.unaryPlus("---");
    }

    public final void blockquote(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String[] stringArray = new String[]{"\n"};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.unaryPlus("> " + it);
        }
    }

    public final void line(@NotNull Function1<? super LineContext, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        LineContext lineContext = new LineContext(null, 1, null);
        block.invoke((Object)lineContext);
        String text = lineContext.getBuilder$prompt_markdown().build();
        if (!StringsKt.isBlank((CharSequence)text)) {
            this.unaryPlus(text);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void table(@NotNull List<String> headers, @NotNull List<? extends List<String>> rows, @NotNull List<? extends TableAlignment> alignments) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        Intrinsics.checkNotNullParameter(alignments, (String)"alignments");
        if (!(!((Collection)headers).isEmpty())) {
            boolean $i$a$-require-MarkdownContentBuilder$table$42 = false;
            String $i$a$-require-MarkdownContentBuilder$table$42 = "Table must have at least one column";
            throw new IllegalArgumentException($i$a$-require-MarkdownContentBuilder$table$42.toString());
        }
        if (!(alignments.size() == headers.size())) {
            boolean $i$a$-require-MarkdownContentBuilder$table$52 = false;
            String $i$a$-require-MarkdownContentBuilder$table$52 = "Number of alignments must match number of columns";
            throw new IllegalArgumentException($i$a$-require-MarkdownContentBuilder$table$52.toString());
        }
        this.unaryPlus("| " + CollectionsKt.joinToString$default((Iterable)headers, (CharSequence)" | ", null, null, (int)0, null, null, (int)62, null) + " |");
        Iterable $this$map$iv = alignments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TableAlignment tableAlignment = (TableAlignment)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                case 1 -> ":---";
                case 2 -> ":---:";
                case 3 -> "---:";
                default -> throw new NoWhenBranchMatchedException();
            });
        }
        List separators = (List)destination$iv$iv;
        this.unaryPlus("| " + CollectionsKt.joinToString$default((Iterable)separators, (CharSequence)" | ", null, null, (int)0, null, null, (int)62, null) + " |");
        Iterable $this$forEach$iv = rows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List row = (List)element$iv;
            boolean bl = false;
            if (!(row.size() == headers.size())) {
                boolean bl2 = false;
                String string = "Row size must match number of columns";
                throw new IllegalArgumentException(string.toString());
            }
            this.unaryPlus("| " + CollectionsKt.joinToString$default((Iterable)row, (CharSequence)" | ", null, null, (int)0, null, null, (int)62, null) + " |");
        }
    }

    public static /* synthetic */ void table$default(MarkdownContentBuilder markdownContentBuilder, List list2, List list3, List list4, int n, Object object) {
        if ((n & 4) != 0) {
            int n2 = list2.size();
            ArrayList<TableAlignment> arrayList = new ArrayList<TableAlignment>(n2);
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                int n5 = n4 = n3++;
                ArrayList<TableAlignment> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(TableAlignment.LEFT);
            }
            list4 = arrayList;
        }
        markdownContentBuilder.table(list2, list3, list4);
    }

    public final void bulleted(@NotNull Function1<? super ListContext, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ListContext context = new ListContext((Function1<? super Integer, String>)((Function1)MarkdownContentBuilder::bulleted$lambda$8));
        block.invoke((Object)context);
    }

    public final void numbered(@NotNull Function1<? super ListContext, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ListContext context = new ListContext((Function1<? super Integer, String>)((Function1)MarkdownContentBuilder::numbered$lambda$9));
        block.invoke((Object)context);
    }

    private static final String bulleted$lambda$8(int it) {
        return "- ";
    }

    private static final String numbered$lambda$9(int it) {
        return it + 1 + ". ";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/koog/prompt/markdown/MarkdownContentBuilder$Companion;", "", "<init>", "()V", "INDENTATION_ITEM", "", "prompt-markdown"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\u0000J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\nJ\u0016\u0010\u000f\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nJ\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lai/koog/prompt/markdown/MarkdownContentBuilder$LineContext;", "", "builder", "Lai/koog/prompt/text/TextContentBuilder;", "<init>", "(Lai/koog/prompt/text/TextContentBuilder;)V", "getBuilder$prompt_markdown", "()Lai/koog/prompt/text/TextContentBuilder;", "space", "text", "", "bold", "italic", "strikethrough", "code", "link", "url", "image", "alt", "prompt-markdown"})
    public static final class LineContext {
        @NotNull
        private final TextContentBuilder builder;

        public LineContext(@NotNull TextContentBuilder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            this.builder = builder;
        }

        public /* synthetic */ LineContext(TextContentBuilder textContentBuilder, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                textContentBuilder = new TextContentBuilder();
            }
            this(textContentBuilder);
        }

        @NotNull
        public final TextContentBuilder getBuilder$prompt_markdown() {
            return this.builder;
        }

        @NotNull
        public final LineContext space() {
            this.builder.text(" ");
            return this;
        }

        @NotNull
        public final LineContext text(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.builder.text(text);
            return this;
        }

        @NotNull
        public final LineContext bold(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.builder.text("**" + text + "**");
            return this;
        }

        @NotNull
        public final LineContext italic(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.builder.text("*" + text + "*");
            return this;
        }

        @NotNull
        public final LineContext strikethrough(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.builder.text("~~" + text + "~~");
            return this;
        }

        @NotNull
        public final LineContext code(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            this.builder.text("`" + code + "`");
            return this;
        }

        @NotNull
        public final LineContext link(@NotNull String text, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.builder.text("[" + text + "](" + url + ")");
            return this;
        }

        @NotNull
        public final LineContext image(@NotNull String alt, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)alt, (String)"alt");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.builder.text("![" + alt + "](" + url + ")");
            return this;
        }

        public LineContext() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B*\u0012!\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bJ\u001f\u0010\u000b\u001a\u00020\f2\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\u0002\b\u0010J'\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\b2\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\u0002\b\u0010R)\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lai/koog/prompt/markdown/MarkdownContentBuilder$ListContext;", "", "bullet", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "counter", "", "<init>", "(Lai/koog/prompt/markdown/MarkdownContentBuilder;Lkotlin/jvm/functions/Function1;)V", "item", "", "text", "block", "Lai/koog/prompt/markdown/MarkdownContentBuilder;", "Lkotlin/ExtensionFunctionType;", "title", "prompt-markdown"})
    public final class ListContext {
        @NotNull
        private final Function1<Integer, String> bullet;
        private int counter;

        public ListContext(Function1<? super Integer, String> bullet) {
            Intrinsics.checkNotNullParameter(bullet, (String)"bullet");
            this.bullet = bullet;
        }

        public final void item(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int n = this.counter;
            this.counter = n + 1;
            String bullet = (String)this.bullet.invoke((Object)n);
            String[] stringArray = new String[]{"\n"};
            Iterator iterator = ((Iterable)StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null)).iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                int index = n2++;
                String line = (String)iterator.next();
                String lineText = index == 0 ? bullet + line : (!StringsKt.isBlank((CharSequence)line) ? StringsKt.repeat((CharSequence)" ", (int)bullet.length()) + line : line);
                MarkdownContentBuilder.this.unaryPlus(lineText);
            }
        }

        public final void item(@NotNull Function1<? super MarkdownContentBuilder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            MarkdownContentBuilder markdownContentBuilder = new MarkdownContentBuilder();
            block.invoke((Object)markdownContentBuilder);
            this.item(markdownContentBuilder.build());
        }

        public final void item(@NotNull String title, @NotNull Function1<? super MarkdownContentBuilder, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            MarkdownContentBuilder markdownContentBuilder = new MarkdownContentBuilder();
            block.invoke((Object)markdownContentBuilder);
            this.item(title + "\n" + markdownContentBuilder.build());
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TableAlignment.values().length];
            try {
                nArray[TableAlignment.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TableAlignment.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TableAlignment.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

