/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection.custom;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.ProblemDescriptorWithReporterName;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.DynamicGroupTool;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ui.CustomInspectionActions;
import com.intellij.profile.codeInspection.ui.InspectionMetaDataDialog;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.Function;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.inspection.custom.CustomRegExpInspectionToolWrapper;
import org.intellij.lang.regexp.inspection.custom.RegExpInspectionConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomRegExpInspection
extends LocalInspectionTool
implements DynamicGroupTool {
    public static final String SHORT_NAME = "CustomRegExpInspection";
    public final List<RegExpInspectionConfiguration> myConfigurations = new SmartList();
    private InspectionProfileImpl mySessionProfile;

    public static CustomRegExpInspection getCustomRegExpInspection(@NotNull InspectionProfile profile) {
        if (profile == null) {
            CustomRegExpInspection.$$$reportNull$$$0(0);
        }
        return (CustomRegExpInspection)CustomInspectionActions.getInspection((InspectionProfile)profile, (String)SHORT_NAME);
    }

    public void initialize(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            CustomRegExpInspection.$$$reportNull$$$0(1);
        }
        super.initialize(context);
        this.mySessionProfile = ((GlobalInspectionContextBase)context).getCurrentProfile();
    }

    public void cleanup(@NotNull Project project) {
        if (project == null) {
            CustomRegExpInspection.$$$reportNull$$$0(2);
        }
        super.cleanup(project);
        this.mySessionProfile = null;
    }

    public boolean runForWholeFile() {
        return true;
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            CustomRegExpInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            CustomRegExpInspection.$$$reportNull$$$0(4);
        }
        if (this.myConfigurations.isEmpty()) {
            return null;
        }
        Document document = file.getViewProvider().getDocument();
        CharSequence text = document.getCharsSequence();
        FindManager findManager = FindManager.getInstance((Project)file.getProject());
        Project project = manager.getProject();
        InspectionProfileImpl profile = this.mySessionProfile != null && !isOnTheFly ? this.mySessionProfile : InspectionProfileManager.getInstance((Project)project).getCurrentProfile();
        SmartList descriptors = new SmartList();
        for (RegExpInspectionConfiguration configuration : this.myConfigurations) {
            String uuid = configuration.getUuid();
            ToolsImpl tools = profile.getToolsOrNull(uuid, project);
            if (tools == null || !tools.isEnabled((PsiElement)file)) continue;
            CustomRegExpInspection.addInspectionToProfile(project, profile, configuration);
            CustomRegExpInspection.register(configuration);
            for (RegExpInspectionConfiguration.InspectionPattern pattern : configuration.getPatterns()) {
                FileType fileType = pattern.fileType();
                if (fileType != null && fileType != UnknownFileType.INSTANCE && file.getFileType() != fileType) continue;
                FindModel model = new FindModel();
                model.setRegularExpressions(true);
                model.setRegExpFlags(pattern.flags);
                model.setStringToFind(pattern.regExp());
                String replacement = pattern.replacement();
                if (replacement != null) {
                    model.setStringToReplace(replacement);
                }
                model.setSearchContext(pattern.searchContext());
                VirtualFile vFile = file.getVirtualFile();
                FindResult result = findManager.findString(text, 0, model, vFile);
                while (result.isStringFound()) {
                    LocalQuickFix[] localQuickFixArray;
                    TextRange range = new TextRange(result.getStartOffset(), result.getEndOffset());
                    PsiElement element = file.findElementAt(result.getStartOffset());
                    assert (element != null);
                    while (!element.getTextRange().contains(range)) {
                        element = element.getParent();
                    }
                    TextRange elementRange = element.getTextRange();
                    int start = result.getStartOffset() - elementRange.getStartOffset();
                    TextRange warningRange = new TextRange(start, result.getEndOffset() - result.getStartOffset() + start);
                    String problemDescriptor = StringUtil.defaultIfEmpty((String)configuration.getProblemDescriptor(), (String)configuration.getName());
                    if (replacement == null) {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    } else {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = new CustomRegExpQuickFix(findManager, model, text, result);
                    }
                    LocalQuickFix[] fix = localQuickFixArray;
                    ProblemDescriptor descriptor = manager.createProblemDescriptor(element, warningRange, problemDescriptor, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, fix);
                    descriptors.add(new ProblemDescriptorWithReporterName((ProblemDescriptorBase)descriptor, uuid));
                    result = findManager.findString(text, result.getEndOffset(), model, vFile);
                }
            }
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    public static void register(@NotNull RegExpInspectionConfiguration configuration) {
        if (configuration == null) {
            CustomRegExpInspection.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            String shortName = configuration.getUuid();
            HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
            if (key != null) {
                if (!CustomRegExpInspection.isMetaDataChanged(configuration, key)) {
                    return;
                }
                HighlightDisplayKey.unregister((String)shortName);
            }
            String suppressId = configuration.getSuppressId();
            String name = configuration.getName();
            if (suppressId == null) {
                HighlightDisplayKey.register((String)shortName, () -> name, (String)SHORT_NAME, null, (Object)configuration);
            } else {
                HighlightDisplayKey.register((String)shortName, () -> name, (String)suppressId, (String)SHORT_NAME, (Object)configuration);
            }
        }, ModalityState.nonModal());
    }

    private static boolean isMetaDataChanged(@NotNull RegExpInspectionConfiguration configuration, @NotNull HighlightDisplayKey key) {
        if (configuration == null) {
            CustomRegExpInspection.$$$reportNull$$$0(6);
        }
        if (key == null) {
            CustomRegExpInspection.$$$reportNull$$$0(7);
        }
        if (StringUtil.isEmpty((String)configuration.getSuppressId()) ? !SHORT_NAME.equals(key.getID()) : !configuration.getSuppressId().equals(key.getID())) {
            return true;
        }
        return !configuration.getName().equals(HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)key));
    }

    public static void addInspectionToProfile(@NotNull Project project, @NotNull InspectionProfileImpl profile, @NotNull RegExpInspectionConfiguration configuration) {
        String shortName;
        InspectionToolWrapper toolWrapper;
        if (project == null) {
            CustomRegExpInspection.$$$reportNull$$$0(8);
        }
        if (profile == null) {
            CustomRegExpInspection.$$$reportNull$$$0(9);
        }
        if (configuration == null) {
            CustomRegExpInspection.$$$reportNull$$$0(10);
        }
        if ((toolWrapper = profile.getInspectionTool(shortName = configuration.getUuid(), project)) != null) {
            return;
        }
        CustomRegExpInspectionToolWrapper wrapped = new CustomRegExpInspectionToolWrapper(configuration);
        profile.addTool(project, (InspectionToolWrapper)wrapped, null);
        profile.setToolEnabled(shortName, true);
    }

    @NotNull
    public List<LocalInspectionToolWrapper> getChildren() {
        List list = ContainerUtil.map(this.myConfigurations, CustomRegExpInspectionToolWrapper::new);
        if (list == null) {
            CustomRegExpInspection.$$$reportNull$$$0(11);
        }
        return list;
    }

    public void addConfiguration(RegExpInspectionConfiguration configuration) {
        if (!this.myConfigurations.contains(configuration)) {
            this.myConfigurations.add(configuration);
        }
    }

    public void updateConfiguration(RegExpInspectionConfiguration configuration) {
        this.myConfigurations.remove(configuration);
        this.myConfigurations.add(configuration);
    }

    public void removeConfigurationWithUuid(String uuid) {
        this.myConfigurations.removeIf(c -> c.getUuid().equals(uuid));
    }

    public List<RegExpInspectionConfiguration> getConfigurations() {
        return this.myConfigurations;
    }

    @NotNull
    public InspectionMetaDataDialog createMetaDataDialog(@NotNull Project project, @NotNull String profileName, @Nullable RegExpInspectionConfiguration configuration) {
        if (project == null) {
            CustomRegExpInspection.$$$reportNull$$$0(12);
        }
        if (profileName == null) {
            CustomRegExpInspection.$$$reportNull$$$0(13);
        }
        Function<String, @NlsContexts.DialogMessage @Nullable String> nameValidator = name -> {
            for (RegExpInspectionConfiguration current : this.myConfigurations) {
                if (configuration != null && configuration.getUuid().equals(current.getUuid()) || !current.getName().equals(name)) continue;
                return RegExpBundle.message("dialog.message.inspection.with.name.exists.warning", name);
            }
            return null;
        };
        if (configuration == null) {
            return new InspectionMetaDataDialog(project, profileName, nameValidator);
        }
        return new InspectionMetaDataDialog(project, profileName, nameValidator, configuration.getName(), configuration.getDescription(), configuration.getProblemDescriptor(), configuration.getSuppressId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/inspection/custom/CustomRegExpInspection";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/inspection/custom/CustomRegExpInspection";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomRegExpInspection";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMetaDataChanged";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addInspectionToProfile";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createMetaDataDialog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }

    private static class CustomRegExpQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final int myStartOffset;
        private final int myEndOffset;
        private final String myReplacement;
        private final String myOriginal;

        private CustomRegExpQuickFix(FindManager findManager, FindModel findModel, CharSequence text, FindResult result) {
            this.myStartOffset = result.getStartOffset();
            this.myEndOffset = result.getEndOffset();
            this.myOriginal = text.subSequence(this.myStartOffset, this.myEndOffset).toString();
            try {
                this.myReplacement = findManager.getStringToReplace(this.myOriginal, findModel, this.myStartOffset, text);
            }
            catch (FindManager.MalformedReplacementStringException e) {
                throw new RuntimeException(e);
            }
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myReplacement});
            if (string == null) {
                CustomRegExpQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = RegExpBundle.message("intention.family.name.replace", new Object[0]);
            if (string == null) {
                CustomRegExpQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiFile file;
            Document document;
            if (project == null) {
                CustomRegExpQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                CustomRegExpQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                CustomRegExpQuickFix.$$$reportNull$$$0(4);
            }
            if (this.myOriginal.equals((document = (file = element.getContainingFile()).getViewProvider().getDocument()).getText(TextRange.create((int)this.myStartOffset, (int)this.myEndOffset)))) {
                document.replaceString(this.myStartOffset, this.myEndOffset, (CharSequence)this.myReplacement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/custom/CustomRegExpInspection$CustomRegExpQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/custom/CustomRegExpInspection$CustomRegExpQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

