/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DdlCodeFileIface;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DatabaseDefinitionHelper;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ExceptionUtil;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001c\u0010\u0013\u001a\u00020\u00112\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rH\u0007J\u0016\u0010\u0015\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\rH\u0007J\u0016\u0010\u0016\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\rH\u0007J\b\u0010\u0017\u001a\u00020\u0007H\u0002J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\b\u0010\u001b\u001a\u00020\u0011H\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\b\u0010\u001d\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/editor/DdlEditorContentLoader;", "", "project", "Lcom/intellij/openapi/project/Project;", "codeFile", "Lcom/intellij/database/editor/DdlCodeFileIface;", "keepUserModifications", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/editor/DdlCodeFileIface;ZLcom/intellij/openapi/diagnostic/Logger;)V", "fnStart", "Lkotlin/Function0;", "Lorg/jetbrains/concurrency/Promise;", "Ljava/lang/Void;", "fnLoad", "", "fnFinish", "setStartFn", "fn", "setLoadFn", "setFinishFn", "maybeCancel", "run", "onStorageReady", "loadContentPromise", "loadContent", "finishPromise", "doFinish", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDdlEditorContentLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DdlEditorContentLoader.kt\ncom/intellij/database/editor/DdlEditorContentLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n742#2,9:232\n37#3,2:241\n1#4:243\n*S KotlinDebug\n*F\n+ 1 DdlEditorContentLoader.kt\ncom/intellij/database/editor/DdlEditorContentLoader\n*L\n110#1:232,9\n110#1:241,2\n*E\n"})
public final class DdlEditorContentLoader {
    @NotNull
    private final Project project;
    @NotNull
    private final DdlCodeFileIface codeFile;
    private final boolean keepUserModifications;
    @NotNull
    private final Logger log;
    @NotNull
    private Function0<? extends Promise<Void>> fnStart;
    @NotNull
    private Function0<Unit> fnLoad;
    @NotNull
    private Function0<Unit> fnFinish;

    public DdlEditorContentLoader(@NotNull Project project, @NotNull DdlCodeFileIface codeFile, boolean keepUserModifications, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)codeFile, (String)"codeFile");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.project = project;
        this.codeFile = codeFile;
        this.keepUserModifications = keepUserModifications;
        this.log = log;
        this.fnStart = () -> DdlEditorContentLoader.fnStart$lambda$0(this);
        this.fnLoad = (Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                DdlEditorContentLoader.access$loadContent((DdlEditorContentLoader)this.receiver);
            }
        };
        this.fnFinish = (Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                DdlEditorContentLoader.access$doFinish((DdlEditorContentLoader)this.receiver);
            }
        };
    }

    @TestOnly
    public final void setStartFn(@NotNull Function0<? extends Promise<Void>> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        this.fnStart = fn;
    }

    @TestOnly
    public final void setLoadFn(@NotNull Function0<Unit> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        this.fnLoad = fn;
    }

    @TestOnly
    public final void setFinishFn(@NotNull Function0<Unit> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        this.fnFinish = fn;
    }

    private final boolean maybeCancel() {
        return this.project.isDisposed() || !this.codeFile.isValid();
    }

    @NotNull
    public final Promise<Void> run() {
        this.codeFile.setBusy(true);
        this.codeFile.setVisualProgress(true);
        Promise promise = ((Promise)this.fnStart.invoke()).onProcessed(arg_0 -> DdlEditorContentLoader.run$lambda$1(arg_0 -> DdlEditorContentLoader.run$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"onProcessed(...)");
        return promise;
    }

    @NotNull
    public final Promise<Void> onStorageReady() {
        if (this.maybeCancel()) {
            return Promises.cancelledPromise();
        }
        Supplier<Promise> supplier = this::loadContentPromise;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        Promise promise = AsyncUtil.runAsync(supplier, p0 -> application.executeOnPooledThread(p0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"runAsync(...)");
        Promise loadPromise = promise;
        Promise promise2 = loadPromise.thenAsync(arg_0 -> DdlEditorContentLoader.onStorageReady$lambda$1(arg_0 -> DdlEditorContentLoader.onStorageReady$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"thenAsync(...)");
        return promise2;
    }

    private final Promise<Void> loadContentPromise() {
        if (this.maybeCancel()) {
            return Promises.cancelledPromise();
        }
        this.fnLoad.invoke();
        return Promises.resolvedPromise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void loadContent() {
        StringBuilder sb = new StringBuilder();
        int objectHash = 0;
        try {
            DbElement element = this.codeFile.getDbElement();
            if (element == null) {
                sb.append("-- invalid target");
            } else {
                objectHash = DatabaseEditorHelper.computeObjectHashCode(element);
                Dbms dbms = DbImplUtilCore.getDbms((DbElement)element);
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
                Dbms dbms2 = dbms;
                if (!DBIntrospectorFactory.hasNativeIntrospector((Dbms)dbms2) && DatabaseDefinitionHelper.isRawDefinitionAvailable((DbElement)element)) {
                    v1 = DatabaseEditorHelper.loadOrGenerateDefinition(element, sb);
                } else {
                    sb.append("-- auto-generated definition\n");
                    v1 = DatabaseDefinitionHelper.generateDefinition((DbElement)element, (StringBuilder)sb);
                }
                if (((CharSequence)sb).length() == 0) {
                    sb.append("-- definition is not available or empty");
                }
            }
        }
        catch (Exception e) {
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            String string = ExceptionUtil.getUserStackTrace((Throwable)e, (Logger)this.log);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserStackTrace(...)");
            String trace = string;
            Object object = trace;
            Regex regex = new Regex("\n");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            for (String s : thisCollection$iv.toArray(new String[0])) {
                sb.append("-- ").append(s).append("\n");
            }
        }
        finally {
            String string = StringUtil.convertLineSeparators((String)sb.toString());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
            String content = string;
            if (!this.codeFile.isModifiedByUser() || !this.keepUserModifications || Intrinsics.areEqual((Object)content, (Object)this.codeFile.getContent())) {
                this.codeFile.setContent(content, objectHash);
            }
        }
    }

    private final Promise<Void> finishPromise() {
        if (this.maybeCancel()) {
            return Promises.cancelledPromise();
        }
        Promise promise = AsyncUtil.runAsync(() -> DdlEditorContentLoader.finishPromise$lambda$0(this), arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"runAsync(...)");
        return promise;
    }

    private final void doFinish() {
        Document document = this.codeFile.getDocument();
        if (document == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)this.project).run(() -> DdlEditorContentLoader.doFinish$lambda$0(this, document));
    }

    private static final Promise fnStart$lambda$0(DdlEditorContentLoader this$0) {
        Promise promise = AsyncUtil.runAsync(this$0::onStorageReady, arg_0 -> ((DataSourceStorage)DataSourceStorage.getProjectStorage((Project)this$0.project)).doWhenInitialized(arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"runAsync(...)");
        return promise;
    }

    private static final Unit run$lambda$0(DdlEditorContentLoader this$0, Void it) {
        this$0.codeFile.setBusy(false);
        this$0.codeFile.setVisualProgress(false);
        return Unit.INSTANCE;
    }

    private static final void run$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Promise onStorageReady$lambda$0(DdlEditorContentLoader this$0, Void it) {
        return this$0.finishPromise();
    }

    private static final Promise onStorageReady$lambda$1(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }

    private static final Promise finishPromise$lambda$0(DdlEditorContentLoader this$0) {
        this$0.fnFinish.invoke();
        return Promises.resolvedPromise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doFinish$lambda$0(DdlEditorContentLoader this$0, Document $document) {
        boolean writable = this$0.codeFile.isWritable();
        try {
            DasNamespace dasNamespace;
            this$0.codeFile.setWritableInner(true);
            $document.setReadOnly(false);
            if ($document.getTextLength() == 0) {
                DocumentReference documentReference = DocumentReferenceManager.getInstance().create($document);
                Intrinsics.checkNotNullExpressionValue((Object)documentReference, (String)"create(...)");
                DocumentReference reference = documentReference;
                UndoManager.getInstance((Project)this$0.project).nonundoableActionPerformed(reference, false);
            }
            PsiFile file = PsiDocumentManager.getInstance((Project)this$0.project).getPsiFile($document);
            DbElement dbElement = this$0.codeFile.getDbElement();
            if (dbElement != null) {
                DbElement it = dbElement;
                boolean bl = false;
                dasNamespace = DbImplUtilCore.getSearchPathObject((DbElement)it);
            } else {
                dasNamespace = null;
            }
            DasNamespace searchPathObject = dasNamespace;
            DatabaseDataKeysCore.SEARCH_PATH_KEY.set((UserDataHolder)file, (Object)ObjectPaths.searchPathOf((DasObject)((DasObject)searchPathObject)));
            FileDocumentManager.getInstance().reloadFromDisk($document, this$0.project);
            boolean reformatOnPaste = CodeInsightSettings.getInstance().REFORMAT_ON_PASTE == 4;
            PsiDocumentManager.getInstance((Project)this$0.project).commitDocument($document);
            if (file != null && reformatOnPaste) {
                CodeStyleManager.getInstance((Project)this$0.project).reformat((PsiElement)file);
            }
            this$0.codeFile.setWritableInner(writable);
            $document.setReadOnly(!writable);
        }
        catch (Throwable throwable) {
            this$0.codeFile.setWritableInner(writable);
            $document.setReadOnly(!writable);
            throw throwable;
        }
    }

    public static final /* synthetic */ void access$loadContent(DdlEditorContentLoader $this) {
        $this.loadContent();
    }

    public static final /* synthetic */ void access$doFinish(DdlEditorContentLoader $this) {
        $this.doFinish();
    }
}

