/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.Dbms;
import com.intellij.database.editor.DatabaseCompositeTableEditorDescriptor;
import com.intellij.database.editor.DatabaseCompositeTableEditorProviderKt;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.TriConsumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001aM\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\"\b\u0002\u0010\u0007\u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f\u0018\u00010\bH\u0000\u00a2\u0006\u0002\u0010\r\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0010"}, d2={"createDataFileDescriptor", "Lcom/intellij/database/editor/OpenDataFileDescriptor;", "element", "Lcom/intellij/database/psi/DbElement;", "columnNames", "", "", "filterCondition", "Lcom/intellij/util/TriConsumer;", "Lcom/intellij/database/util/DdlBuilder;", "", "Lcom/intellij/database/model/DasColumn;", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/psi/DbElement;[Ljava/lang/String;Lcom/intellij/util/TriConsumer;)Lcom/intellij/database/editor/OpenDataFileDescriptor;", "createCompositeFileDescriptor", "Lcom/intellij/database/editor/DatabaseCompositeTableEditorDescriptor;", "intellij.database.impl"})
public final class DbNavigationUtilsKt {
    @Nullable
    public static final OpenDataFileDescriptor createDataFileDescriptor(@NotNull DbElement element, @Nullable String[] columnNames, @Nullable TriConsumer<DdlBuilder, List<DasColumn>, Dbms> filterCondition) {
        OpenDataFileDescriptor openDataFileDescriptor;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (columnNames == null && element.getKind() == ObjectKind.COLUMN) {
            String[] stringArray2 = new String[]{element.getName()};
            stringArray = stringArray2;
        } else {
            stringArray = columnNames;
        }
        String[] columnNamesGuessed = stringArray;
        DbElement dbElement = DbNavigationUtils.adjustForDataNavigation(element);
        Intrinsics.checkNotNullExpressionValue((Object)dbElement, (String)"adjustForDataNavigation(...)");
        DbElement adjusted = dbElement;
        if (DatabaseEditorHelper.isTableDataAvailable(adjusted)) {
            VirtualFile virtualFile = DbImplUtil.findDataVirtualFile((DbElement)adjusted, (boolean)false);
            if (virtualFile != null) {
                VirtualFile virtualFile2 = virtualFile;
                boolean bl = false;
                openDataFileDescriptor = new OpenDataFileDescriptor(element.getProject(), virtualFile2, columnNamesGuessed, null, null, filterCondition);
            } else {
                openDataFileDescriptor = null;
            }
        } else {
            openDataFileDescriptor = null;
        }
        return openDataFileDescriptor;
    }

    public static /* synthetic */ OpenDataFileDescriptor createDataFileDescriptor$default(DbElement dbElement, String[] stringArray, TriConsumer triConsumer, int n, Object object) {
        if ((n & 2) != 0) {
            stringArray = null;
        }
        if ((n & 4) != 0) {
            triConsumer = null;
        }
        return DbNavigationUtilsKt.createDataFileDescriptor(dbElement, stringArray, (TriConsumer<DdlBuilder, List<DasColumn>, Dbms>)triConsumer);
    }

    @Nullable
    public static final DatabaseCompositeTableEditorDescriptor createCompositeFileDescriptor(@NotNull DbElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!DatabaseCompositeTableEditorProviderKt.isCompositeEditorEnabled()) {
            return null;
        }
        OpenDataFileDescriptor openDataFileDescriptor = DbNavigationUtilsKt.createDataFileDescriptor$default(element, null, null, 6, null);
        if (openDataFileDescriptor == null) {
            return null;
        }
        OpenDataFileDescriptor dataDescriptor = openDataFileDescriptor;
        return new DatabaseCompositeTableEditorDescriptor(dataDescriptor);
    }
}

