/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.properties.ApplicationPropertiesAutoCompletionListProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class SpringBootPropertyValueCompletionUtils {
    public static List<Object> getValueCompletionVariants(@NotNull MetaConfigKey key, Module module, String keyText) {
        if (key == null) {
            SpringBootPropertyValueCompletionUtils.$$$reportNull$$$0(0);
        }
        ProcessingContext processingContext = new ProcessingContext();
        if (!key.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL})) {
            processingContext.put(SpringBootHintReferencesProvider.HINT_REFERENCES_CONFIG_KEY_TEXT, (Object)keyText);
        }
        PsiElement dummyValueNode = ApplicationPropertiesAutoCompletionListProvider.Companion.createFakeValueNode(module, "application.properties");
        List<TextRange> valueTextRanges = Collections.singletonList(ElementManipulators.getValueTextRange((PsiElement)dummyValueNode));
        Object[] references = SpringBootHintReferencesProvider.getInstance().getValueReferences(module, key, null, dummyValueNode, valueTextRanges, processingContext);
        PsiReference reference = (PsiReference)ArrayUtil.getFirstElement((Object[])references);
        if (reference == null) {
            return Collections.emptyList();
        }
        if (reference instanceof JavaClassReference) {
            JavaClassReference javaClassReference = (JavaClassReference)reference;
            List names = javaClassReference.getSuperClasses();
            PsiElement context = javaClassReference.getCompletionContext();
            if (!names.isEmpty() && context instanceof PsiPackage) {
                ArrayList<Object> variants = new ArrayList<Object>();
                javaClassReference.processSubclassVariants((PsiPackage)context, ArrayUtilRt.toStringArray((Collection)names), element -> variants.add(element));
                return variants;
            }
        }
        return ContainerUtil.filter((Object[])reference.getVariants(), o -> !(o instanceof PsiNamedElement) || ((PsiNamedElement)o).getName() != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/boot/run/SpringBootPropertyValueCompletionUtils", "getValueCompletionVariants"));
    }
}

