/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import java.io.Closeable;
import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SpringBootJmxConnector
implements Closeable {
    private final String myServiceUrl;
    private final ObjectName myObjectName;
    private JMXConnector myConnector;
    private MBeanServerConnection myConnection;

    SpringBootJmxConnector(String serviceUrl, String objectName) {
        this.myServiceUrl = serviceUrl;
        this.myObjectName = SpringBootJmxConnector.toObjectName(objectName);
    }

    private JMXConnector getJmxConnector() throws IOException {
        return JMXConnectorFactory.connect(new JMXServiceURL(this.myServiceUrl), null);
    }

    protected MBeanServerConnection getJmxConnection() throws IOException {
        if (this.myConnection == null) {
            if (this.myConnector == null) {
                this.myConnector = this.getJmxConnector();
            }
            this.myConnection = this.myConnector.getMBeanServerConnection();
        }
        return this.myConnection;
    }

    protected ObjectName getObjectName() {
        return this.myObjectName;
    }

    @Override
    public void close() {
        if (this.myConnector != null) {
            try {
                this.myConnector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.myConnector = null;
        }
    }

    private static ObjectName toObjectName(String objectName) {
        try {
            return new ObjectName(objectName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid JMX object name '" + objectName + "'");
        }
    }
}

