/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking.core.model;

import com.intellij.internal.ml.DecisionFunction;
import com.intellij.searchEverywhereMl.ranking.core.features.SearchEverywhereElementFeaturesProvider;
import com.intellij.searchEverywhereMl.ranking.core.features.SearchEverywhereFileFeaturesProvider;
import com.intellij.searchEverywhereMl.ranking.core.model.SearchEverywhereRankingModel;
import com.intellij.searchEverywhereMl.ranking.core.model.SimpleSearchEverywhereRankingModel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\f\u001a\u00020\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000fH\u0002J\u001e\u0010\u0012\u001a\u00020\u00072\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/model/ExactMatchSearchEverywhereRankingModel;", "Lcom/intellij/searchEverywhereMl/ranking/core/model/SearchEverywhereRankingModel;", "model", "Lcom/intellij/internal/ml/DecisionFunction;", "<init>", "(Lcom/intellij/internal/ml/DecisionFunction;)V", "MINIMUM_EM_WITH_EXTENSION_VALUE", "", "MINIMUM_EXACT_MATCH_VALUE", "EPSILON", "simpleModel", "Lcom/intellij/searchEverywhereMl/ranking/core/model/SimpleSearchEverywhereRankingModel;", "isExactMatch", "", "features", "", "", "", "predict", "intellij.searchEverywhereMl.ranking.core"})
public final class ExactMatchSearchEverywhereRankingModel
extends SearchEverywhereRankingModel {
    private final double MINIMUM_EM_WITH_EXTENSION_VALUE;
    private final double MINIMUM_EXACT_MATCH_VALUE;
    private final double EPSILON;
    @NotNull
    private final SimpleSearchEverywhereRankingModel simpleModel;

    public ExactMatchSearchEverywhereRankingModel(@NotNull DecisionFunction model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(model);
        this.MINIMUM_EM_WITH_EXTENSION_VALUE = 0.99;
        this.MINIMUM_EXACT_MATCH_VALUE = 0.9;
        this.EPSILON = 1.0E-5;
        this.simpleModel = new SimpleSearchEverywhereRankingModel(model);
    }

    private final boolean isExactMatch(Map<String, ? extends Object> features) {
        Object wordsInQuery = features.getOrDefault(SearchEverywhereElementFeaturesProvider.Companion.getWHOLE_WORDS_IN_QUERY$intellij_searchEverywhereMl_ranking_core().getName(), (Object)0);
        Object wordsInElement = features.getOrDefault(SearchEverywhereElementFeaturesProvider.Companion.getWHOLE_WORDS_IN_ELEMENT$intellij_searchEverywhereMl_ranking_core().getName(), (Object)0);
        Object exactlyMatchedWords = features.getOrDefault(SearchEverywhereElementFeaturesProvider.Companion.getWHOLE_EXACTLY_MATCHED_WORDS$intellij_searchEverywhereMl_ranking_core().getName(), (Object)0);
        Object levenshteinDistance = features.getOrDefault(SearchEverywhereElementFeaturesProvider.Companion.getWHOLE_LEVENSHTEIN_DISTANCE_CASE_INSENSITIVE$intellij_searchEverywhereMl_ranking_core().getName(), (Object)1.0);
        boolean allWordsMatch = Intrinsics.areEqual((Object)wordsInElement, (Object)wordsInQuery) && Intrinsics.areEqual((Object)wordsInElement, (Object)exactlyMatchedWords) && !Intrinsics.areEqual((Object)exactlyMatchedWords, (Object)0);
        return Intrinsics.areEqual((Object)wordsInQuery, (Object)1) ? Intrinsics.areEqual((Object)levenshteinDistance, (Object)0.0) : allWordsMatch;
    }

    @Override
    public double predict(@NotNull Map<String, ? extends Object> features) {
        Intrinsics.checkNotNullParameter(features, (String)"features");
        boolean isExactMatch = this.isExactMatch(features);
        boolean isExtensionMatch = Intrinsics.areEqual((Object)features.getOrDefault(SearchEverywhereFileFeaturesProvider.Fields.INSTANCE.getFILETYPE_MATCHES_QUERY_DATA_KEY().getName(), (Object)false), (Object)true);
        double mlPrediction = this.simpleModel.predict(features);
        boolean isNameAndExtensionMatch = isExactMatch && isExtensionMatch;
        boolean isNameOnlyMatch = isExactMatch && !isExtensionMatch;
        return isNameAndExtensionMatch ? this.MINIMUM_EM_WITH_EXTENSION_VALUE + mlPrediction * (1.0 - this.MINIMUM_EM_WITH_EXTENSION_VALUE) : (isNameOnlyMatch ? this.MINIMUM_EXACT_MATCH_VALUE + mlPrediction * (this.MINIMUM_EM_WITH_EXTENSION_VALUE - this.MINIMUM_EXACT_MATCH_VALUE - this.EPSILON) : 0.0 + mlPrediction * (this.MINIMUM_EXACT_MATCH_VALUE - this.EPSILON));
    }
}

