/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.file.singleFile;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterChangeListener;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterEvent;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.outputs.JupyterOutputListener;
import com.intellij.jupyter.core.jupyter.nbformat.tags.JupyterTagsEventListener;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LocalTimeCounter;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00182\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0018B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/singleFile/JupyterFileSaveChangeListener;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterChangeListener;", "Lcom/intellij/jupyter/core/jupyter/nbformat/outputs/JupyterOutputListener;", "Lcom/intellij/jupyter/core/jupyter/nbformat/tags/JupyterTagsEventListener;", "document", "Lcom/intellij/openapi/editor/impl/DocumentImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/DocumentImpl;)V", "getDocument", "()Lcom/intellij/openapi/editor/impl/DocumentImpl;", "onEvent", "", "event", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterEvent;", "tagsUpdated", "intervalPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "outputUpdated", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "pointer", "executionInfoUpdated", "allOutputsUpdated", "markUnsaved", "Companion", "intellij.jupyter.core"})
public final class JupyterFileSaveChangeListener
implements JupyterChangeListener,
JupyterOutputListener,
JupyterTagsEventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DocumentImpl document;

    public JupyterFileSaveChangeListener(@NotNull DocumentImpl document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.document = document;
    }

    @NotNull
    public final DocumentImpl getDocument() {
        return this.document;
    }

    @Override
    public void onEvent(@NotNull JupyterEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.markUnsaved();
    }

    @Override
    public void tagsUpdated(@NotNull NotebookIntervalPointer intervalPointer) {
        Intrinsics.checkNotNullParameter((Object)intervalPointer, (String)"intervalPointer");
        this.markUnsaved();
    }

    @Override
    public void outputUpdated(@NotNull JupyterNotebook notebook, @NotNull NotebookIntervalPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        this.markUnsaved();
    }

    @Override
    public void executionInfoUpdated(@NotNull JupyterNotebook notebook, @NotNull NotebookIntervalPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        this.markUnsaved();
    }

    @Override
    public void allOutputsUpdated(@NotNull JupyterNotebook notebook) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        this.markUnsaved();
    }

    private final void markUnsaved() {
        if (this.document.isInEventsHandling()) {
            return;
        }
        this.document.setModificationStamp(LocalTimeCounter.currentTime());
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile((Document)this.document);
        if (virtualFile != null && virtualFile.getDetectedLineSeparator() == null) {
            virtualFile.setDetectedLineSeparator("\n");
        }
        ActionsKt.runReadAction(() -> JupyterFileSaveChangeListener.markUnsaved$lambda$0(this));
    }

    private static final Unit markUnsaved$lambda$0(JupyterFileSaveChangeListener this$0) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNull((Object)fileDocumentManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl");
        ((FileDocumentManagerImpl)fileDocumentManager).markDocumentUnsaved((Document)this$0.document, true);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/singleFile/JupyterFileSaveChangeListener$Companion;", "", "<init>", "()V", "setup", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void setup(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor);
            if (backedNotebookVirtualFile == null) {
                return;
            }
            BackedNotebookVirtualFile file = backedNotebookVirtualFile;
            DocumentEx documentEx = editor.getDocument();
            Intrinsics.checkNotNull((Object)documentEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.DocumentImpl");
            DocumentImpl document = (DocumentImpl)documentEx;
            JupyterNotebook notebook = file.getNotebook();
            Disposable disposable = editor.getDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
            Disposable parentDisposable = disposable;
            JupyterFileSaveChangeListener listener2 = new JupyterFileSaveChangeListener(document);
            notebook.getListeners().getChangeListeners().addListener((EventListener)listener2, parentDisposable);
            notebook.getListeners().getOutputListeners().addListener((EventListener)listener2, parentDisposable);
            notebook.getListeners().getTagsListeners().addListener((EventListener)listener2, parentDisposable);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

